/*hssmall.c - A sequence to perform a small angle phase test with
              HS90.

              D.Rice 09/05/08                                       */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,0,0,0};    // phXhssmall
static int table2[4] = {0,0,0,0};    // phRec

#define phXhssmall t1
#define phRec t2

pulsesequence() {

// Set the Maximum Dynamic Table Number

   settablenumber(10);
   setvvarnumber(30);

// Define Variables and Objects and Get Parameter Values

   double duty;

   WMPA hs = gethssmall("hssmallX");
   strncpy(hs.ch,"obs",3);
   putCmd("chXhssmall='obs'\n");

// Dutycycle Protection

   duty = 4.0e-6 + (np/sw)*(hs.pw/(hs.tau));
   duty = duty/(duty + d1 + np/sw + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phXhssmall,4,table1);
   settable(phRec,4,table2);
   setreceiver(phRec);
   obsstepsize(360.0/(PSD*8192));

// Begin Sequence

   txphase(phXhssmall);
   obspwrf(getval("aXhssmall"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);  
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// Apply HSSMALL Cycles

   startacq(5.0e-6);
   rcvroff();
   decblank(); _blank34();
   _hssmall(hs, phXhssmall);
   endacq();
   obsunblank(); decunblank(); _unblank34();
}
