/*hxidctmiss2ds2.c - A sequence to obtain an HX correlation with H
                    detection using MISS (Multiple Intense Solvent
                    Suppression), constant time with X decoupling.

                    D. Rice 7/3/04                               */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[2] = {0,0};           // phH90
static int table2[2] = {0,0};           // phXhx
static int table3[2] = {1,1};           // phHhx
static int table4[2] = {2,2};           // phHspnlm
static int table5[2] = {3,3};           // ph1X90
static int table6[2] = {0,0};           // phHpxy
static int table7[2] = {1,1};           // ph2X90
static int table8[2] = {0,0};           // phHxh
static int table9[2] = {0,0};           // phXxh
static int table10[2] = {3,3};          // ph1H90
static int table11[4] = {0,2,1,3};      // phHrfdr
static int table12[2] = {1,3};          // ph2H90
static int table15[8] = {0,0};          // phHecho
static int table14[2] = {0,2};          // phRec

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define ph1X90 t5
#define phHpxy t6
#define ph2X90 t7
#define phHxh t8
#define phXxh t9
#define ph1H90 t10
#define phHrfdr t11
#define ph2H90 t12
#define phHecho t15
#define phRec t14

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   int decmode = getval("decmode");
   int decmodem = getval("decmodem");

   double tmd2 = getval("tconst") - getval("d2") - getval("pwX90");
   if (tmd2 < 0.0) tmd2 = 0.0;
   
   char CT[MAXSTR];
   
   getstr("CT",CT);   

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"obs",3);
   strncpy(hx.to,"dec",3);
   putCmd("frHX='obs'\n");
   putCmd("toHX='dec'\n");

   MPSEQ spnlm;
   if (decmodem>1) {
      spnlm = getspnl("spnlmH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"obs",3);
      putCmd("chHspnlm ='obs'\n");
   }

   MPSEQ pxy = getpxy("pxyH",0,0.0,0.0,0,1);
   strncpy(pxy.ch,"obs",3);
   putCmd("chHpxy='obs'\n");

   MPSEQ rfdr = getrfdrxy8("rfdrH",0,0.0,0.0,0,1);
   strncpy(rfdr.ch,"obs",3);
   putCmd("chHrfdr='obs'\n");

   CP xh = getcp("XH",0.0,0.0,0,1);
   strncpy(xh.fr,"dec",3);
   strncpy(xh.to,"obs",3);
   putCmd("frXH='dec'\n");
   putCmd("toXH='obs'\n");

   DSEQ dec = getdseq("X");

   double aHecho = getval("aHecho");
   double t1Hechoinit = getval("t1Hecho");
   double pwHecho = getval("pwHecho");
   double t2Hechoinit = getval("t2Hecho");
   double t1Hecho  = t1Hechoinit - pwHecho/2.0;
   if (t1Hecho < 0.0) t1Hecho = 0.0;
   double t2Hecho  = t2Hechoinit - pwHecho/2.0 - getval("rd");
   if (t2Hecho < 0.0) t2Hecho = 0.0;

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("tXH") + t1Hecho + pwHecho + t2Hecho + getval("ad") + getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,2,table1);
   settable(phXhx,2,table2);
   settable(phHhx,2,table3);
   settable(phHspnlm,2,table4);
   settable(ph1X90,2,table5);
   settable(phHpxy,2,table6);
   settable(ph2X90,2,table7);
   settable(phHxh,2,table8);
   settable(phXxh,2,table9);
   settable(ph1H90,2,table10);
   settable(phHrfdr,4,table11);
   settable(ph2H90,2,table12);
   settable(phHecho,8,table15);
   settable(phRec,2,table14);
   setreceiver(phRec);

   if (phase1 == 2){tsadd(ph1X90,1,4);}

// Begin Sequence

// Initial Homospoil Pulse

   status(B);
   hsdelay(getval("hst"));
   status(A); 

   txphase(phH90); decphase(phXhx);
   obspwrf(getval("aH90")); decpwrf(getval("aXhx"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   rgpulse(getval("pwH90"),phH90,0.0,0.0);
   txphase(phHhx);
   _cp_(hx,phHhx,phXhx);
   decphase(ph1X90);
   decpwrf(getval("aX90"));

// X F1 Period with H XiX Decoupling and Constant Time N Evolution

   if (decmodem > 0){ obspwrf(getval("aHspnlm")); xmtron(); if (decmodem > 1){ _mpseqon(spnlm,phHspnlm);}}

   dec3pwrf(getval("aZ90"));
   if (!strcmp(CT,"n")) {
      if (d2 > 0) {
         if (d2 > 2*getval("pwZ90")) {delay(0.5*d2 - getval("pwZ90"));
            dec3rgpulse(2*getval("pwZ90"),0,0.0,0.0);
            delay(0.5*d2 - getval("pwZ90"));
         }
      }
      else {delay(d2);}
      decrgpulse(getval("pwX90"),ph1X90,0.0,0.0);
      decphase(ph2X90);
      decunblank();
      delay(tmd2);
   }
   if (!strcmp(CT,"y")) {
      if (getval("tconst") < ni/sw1) {printf("tconst< tmd2 evol!! abort.\nMay consider setting ni=0.");
         psg_abort(1);
      }
      delay((getval("tconst") + d2)/2.0);
      decrgpulse(2*getval("pwX90"),1,0.0,0.0);
      delay((getval("tconst") - d2)/2.0);
      decrgpulse(getval("pwX90"),ph1X90,0.0,0.0);
      decphase(ph1X90);
   }
   
   if (decmodem > 0){ xmtroff(); if (decmodem > 1){ _mpseqoff(spnlm);}}
   txphase(phHxh);
   obspwrf(getval("aHpxy"));

// Homospoil Delay

   status(B);
   hsdelay(getval("hst"));
   status(A);
   delay(getval("hstconst"));

// Saturation Pulses

   _mpseq(pxy,phHpxy);
   txphase(phHxh);
   delay(d3);

// X to H Cross Polarization

   decrgpulse(getval("pwX90"),ph2X90,0.0,0.0);
   decphase(phXxh);
   _cp_(xh,phXxh,phHxh);

// XY8 Mixing

   obspwrf(getval("aH90"));
   rgpulse(getval("pwH90"),ph1H90,0.0,0.0);

   _mpseq(rfdr,phHrfdr);

   obspwrf(getval("aH90"));
   rgpulse(getval("pwH90"),ph2H90,0.0,0.0);

// Begin X Decoupling

   status(C);
   _dseqon(dec); 
   obsblank(); _blank34();

// H Hahn Echo

   txphase(phHecho);
   obspwrf(aHecho);
   delay(t1Hecho);
   rgpulse(pwHecho,phHecho,0.0,0.0);
   delay(t2Hecho);

// Begin H Acquisition
 
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}
