/*spsmall.c - Single-pulse sequence for testing the small angle
              phase shifter.

              Upgraded for SolidsPack 07/03/10 - D. Rice 

              D.Rice 07/18/05 VNMRJ2.1A-B for the NMR SYSTEM 
	      updated with new .h files D.Rice 10/12/05              

              Based on spsmall.c for INOVA - 02/20/02       */

#include "standard.h"
#include "solidstandard.h"

// Define Values for Phasetables

static int table1[4] = {0,0,0,0};           // phX90
static int table2[4] = {0,0,0,0};           // phRec

#define phX90 t1
#define phRec t2

pulsesequence() {

// Set the Maximum Dynamic Table Number

   setvvarnumber(10);

// Define Variables and Objects and Get Parameter Values

   double duty;

   DSEQ dec = getdseq("H");

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwX90") + getval("ad") + getval("rd") + at;
   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phX90,4,table1);
   settable(phRec,4,table2);
   setreceiver(phRec);

// Set Small-Angle Phase

   double obsstep = 360.0/(PSD*8192);
   int phfX90 = initphase(getval("phfX90"),obsstep);
   obsstepsize(obsstep);

// Begin Sequence

   txphase(phX90); decphase(zero);
   xmtrphase(phfX90);
   obspwrf(getval("aX90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// X Direct Polarization

   rgpulse(getval("pwX90"),phX90,0.0,0.0);

// Begin Acquisition

   _dseqon(dec);
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   _dseqoff(dec);
   obsunblank(); decunblank(); _unblank34();
}

