/*tancpxrefs.c - A sequence to form a constant, linear or tangent ramped CP
              followed by a shaped refocussing pulse, with MPSEQ TPPM or SPINAL
              decoupling.

             Replace the DSEQ module with the MPSEQ module
             D. Rice for UIUC 23/07/08                                      */

#include "standard.h"
#include "solidstandard.h"
#include "pboxpulse.h"

// Define Values for Phasetables

static int table1[8] = {2,2,2,2,2,2,2,2};           // phH90    
static int table2[8] = {0,3,0,3,2,1,2,1};           // phXhx    
static int table3[8] = {1,1,1,1,1,1,1,1};           // phHhx 
static int table4[8] = {2,2,2,2,2,2,2,2};           // phHspnlm  
static int table5[8] = {0,0,1,1,0,0,1,1};           // phXshp1
static int table6[8] = {1,1,1,1,1,1,1,1};           // phHspnl 
static int table7[8] = {0,1,2,3,2,3,0,1};           // phRec 

#define phH90 t1
#define phXhx t2
#define phHhx t3
#define phHspnlm t4
#define phXshp1 t5
#define phHspnl t6
#define phRec t7

pulsesequence() {

// Define Variables and Objects and Get Parameter Values

   double duty;

   int decmode = getval("decmode");
   int decmodem = getval("decmodem");

   CP hx = getcp("HX",0.0,0.0,0,1);
   strncpy(hx.fr,"dec",3);
   strncpy(hx.to,"obs",3);
   putCmd("frHX='dec'\n");
   putCmd("toHX='obs'\n");

   PBOXPULSE shp1 = getpboxpulse("shp1X",0,1); 

   MPSEQ spnlm;
   if (decmodem>1) {
      spnlm = getspnl("spnlmH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

   MPSEQ spnl;
   if (decmode>1) {
      spnl = getspnl("spnlH",0,0.0,0.0,0,1);
      strncpy(spnlm.ch,"dec",3);
      putCmd("chHspnlm ='dec'\n");
   }

// Dutycycle Protection

   duty = 4.0e-6 + getval("pwH90") + getval("tHX") + getval("ad") +
            getval("rd") + at;

   duty = duty/(duty + d1 + 4.0e-6);
   if (duty > 0.1) {
      printf("Duty cycle %.1f%% >10%%. Abort!\n", duty*100);
      psg_abort(1);
   }

// Set Phase Tables

   settable(phH90,4,table1);
   settable(phXhx,4,table2);
   settable(phHhx,4,table3);
   settable(phHspnlm,4,table4);
   settable(phXshp1,4,table5);
   settable(phHspnl,4,table6);
   settable(phRec,4,table7);
   setreceiver(phRec);

// Begin Sequence

   txphase(phXhx); decphase(phH90);
   obspower(tpwr); 
   obspwrf(getval("aXhx")); decpwrf(getval("aH90"));
   obsunblank(); decunblank(); _unblank34();
   delay(d1);
   sp1on(); delay(2.0e-6); sp1off(); delay(2.0e-6);

// H to X Cross Polarization

   decrgpulse(getval("pwH90"),phH90,0.0,0.0);
   decphase(phHhx);
    _cp_(hx,phHhx,phXhx);

// Shaped Refocussing Pulse

    if (decmodem>0){ decpwrf(getval("aHspnlm")); decon(); if (decmodem>1){ _mpseqon(spnlm,phHspnlm);}}
    delay(getval("tau1"));
    _pboxpulse(shp1,phXshp1);
    delay(getval("tau2"));
    if (decmodem>0){ decoff(); if (decmodem>1){ _mpseqoff(spnlm);}} 

// Begin Acquisition

   if (decmode>0){ decpwrf(getval("aHspnl")); decon(); if (decmode>1){ _mpseqon(spnl,phHspnl);}}   
   obsblank(); _blank34();
   delay(getval("rd"));
   startacq(getval("ad"));
   acquire(np, 1/sw);
   endacq();
   if (decmode>0){ decoff(); if (decmode>1){ _mpseqoff(spnl);}}
   obsunblank(); decunblank(); _unblank34();
}

