//
// 7 Cities of Gold Commemorative Edition Cheater.  See the file
// VALUES.CFG for more info!
//
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#define DATAFILE		"7cities.exe"
#define OFF_WEIGHT	0x299bcL			// floats, not implemented

//
// FP val indicates the percentage of 1 piece of food eatten at midnight.
//
float new_food = 0.000001;				// default 0.025
#define OFF_FOOD 0x2920aL

//
// item cost values
//
float new_cost = 0.1;
#define OFF_COST 0x299f4L				// base offset for floats
long off_cost[] = {
	//
	//	offset		default		description
	//
		0L,		//	   4.0		Explorers
		4L,		//	  40.0		Soldiers
		8L,		//	  20.0		Clergy
		16L,		//	   2.0 		Animals
		20L,		//	   2.0		Arms
		24L,		//	   1.0		Food
		32L,		//	   3.0		Horses
	//	36L,		//	   0.2		New World Plants
		40L,		//	   0.1		Old World Plants
		44L,		//	1000.0		Ships
	//	48L,		//	   0.4		Spice
	//	52L,		//	   2.5		Artifacts
		-1L
};


//
// capacity values
//
float new_capacity =	10000.0;
#define OFF_CAPACITY 0x29a2cL			// base offset
long off_capacity[] = {
	//
	//	offset		default		description
	//
  		0L,		//	5000.0		Explorers
		4L,		//    5.0		Soldiers
		8L,		//    5.0		Clergy
		12L,		//    7.5		Natives
		32L,		//  130.0		Horses
  		44L,		// 5000.0		Ships
		-1L
};

FILE *my_fopen( char *path, char *mode );
void my_fseek( FILE *fp, long offset, int whence );
void my_fwrite( void *ptr, int size, int n, FILE *fp );

int main( void )
{
	FILE *fp;
	short i;

	printf( "7 Cities of Gold Commemorative Edition Cheater\n\n" );

	printf( "Modifying %s...\n\n", DATAFILE );
	fp = my_fopen( DATAFILE, "r+b" );

	printf( "Setting food consumption to %f\n", new_food );
	my_fseek( fp, OFF_FOOD, SEEK_SET );
	my_fwrite( &new_food, sizeof( float ), 1, fp );

	printf( "Setting item cost to        %f\n", new_cost );
	for ( i = 0; off_cost[ i ] != -1L; i++ ) {
		my_fseek( fp, OFF_COST + off_cost[ i ], SEEK_SET );
		my_fwrite( &new_cost, sizeof( float ), 1, fp );
	}

	printf( "Setting capacities to       %f\n\n", new_capacity );
	for ( i = 0; off_capacity[ i ] != -1L; i++ ) {
		my_fseek( fp, OFF_CAPACITY + off_capacity[ i ], SEEK_SET );
		my_fwrite( &new_capacity, sizeof( float ), 1, fp );
	}

	fclose( fp );
	printf( "Done!\n" );

	return 0;
}

FILE *my_fopen( char *path, char *mode )
{
	FILE *fp;

	if ( ( fp = fopen( path, mode ) ) == NULL ) {
		printf( "cannot open %s for mode %s\n", path, mode );
		exit( 1 );
	}

	return fp;
}

void my_fseek( FILE *fp, long offset, int whence )
{
	if ( fseek( fp, offset, whence ) ) {
		printf( "seek failure\n" );
		exit( 1 );
	}
}

void my_fwrite( void *ptr, int size, int n, FILE *fp )
{
	if ( fwrite( ptr, size, n, fp ) != n ) {
		printf( "write failure\n" );
		exit( 1 );
	}
}
