/***************************************************************************

  vidhrdw.c

  Functions to emulate the video hardware of the machine.

***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "z80.h"
#include "machine.h"
#include "gfxdecod.h"
#include "vidhrdw.h"
#include "roms.h"
#include "memmap.h"
#include "osdepend.h"

#include <allegro.h>

#define FRAMES_PER_SECOND 60


int             X,
                Y;
int             count1,
                spritenum,
                colour,
                direction;
int             offset_value;
int             i;


void            vh_setcolor(char red, char green, char blue, unsigned short color)
{
    color = 3 * color;
    pal[color++] = red;
    pal[color++] = green;
    pal[color] = blue;
}

 /* to speed up video refresh */
/***************************************************************************

  Initialize the video hardware. Returns 0 if successful.
  This usually involves no more than loading the graphics roms, decoding
  them and store the graphics somewhere.

  In the case of Arcade, since we support several different games, we also
  pick the appropriate palette and lookup table.

***************************************************************************/
int             vh_init(const char *gamename)
{
    char           *tmpstorage;

    if ((tmpstorage = malloc(0x4000)) == 0)
        return 1;

    if (gameemulated == MOONCRST)
    {
        base = 0x9000;
        MAXCHARS = 512;
        MAXSPRITES = 128;
        MAXPALETTES = 16;
    }
    else if (gameemulated == BAGMAN)
    {
        base = 0x9000;
        MAXCHARS = 1024;
        MAXSPRITES = 256;
        MAXPALETTES = 16;
    }
    else if (gameemulated == DKONG)
    {
        base = 0x7400;
        MAXCHARS = 768;
        MAXSPRITES = 128;
        MAXPALETTES = 16;
    }
    else if (gameemulated == FROGGER)
    {
        base = 0xa800;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    else if ((gameemulated == PHOENIX) || (gameemulated == PLEIADS))
    {
        base = 0x4000;
        MAXCHARS = 512;
        MAXSPRITES = 128;
        MAXPALETTES = 16;
    }
    else if ((gameemulated == AMIDAR) ||
             (gameemulated == TURTLES))
    {
        base = 0x9000;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    else if (gameemulated == THEEND)
    {
        base = 0x4800;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    else
    {                           // Galaxian and the rest
        base = 0x5000;
        MAXCHARS = 256;
        MAXSPRITES = 64;
        MAXPALETTES = 16;
    }
    if (readroms(tmpstorage, gamevidinfo[gameemulated].gfxrom, gamename) != 0)
    {

        free(tmpstorage);
        return 1;
    }
    decodechars(tmpstorage);
    decodesprites();

    free(tmpstorage);


    return 0;
}



/***************************************************************************

  Start the video hardware emulation, that is set up a gfx mode, load the
  appropriate palette, and return. Returns 0 if successful.

***************************************************************************/
int             vh_start(void)
{
    int             i;

    osd_create_display(graphicsmode);

    for (i = 0; i < COLOR_CODES; i++)
    {
        vh_setcolor(0, 0, 0, i * 4);
        vh_setcolor(gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 1] * 3],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 1] * 3 + 1],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 1] * 3 + 2],
                    (i * 4) + 1);
        vh_setcolor(gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 2] * 3],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 2] * 3 + 1],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 2] * 3 + 2],
                    (i * 4) + 2);
        vh_setcolor(gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 3] * 3],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 3] * 3 + 1],
                    gamevidinfo[gameemulated].palette[gamevidinfo[gameemulated].colortable[(i * 4) + 3] * 3 + 2],
                    (i * 4) + 3);
    }

    osd_set_palette();

    return 0;
}



/***************************************************************************

  Stop the video hardware emulation.

***************************************************************************/
void            vh_stop(void)
{
    osd_close_display();


}


/***************************************************************************

  Redraw the screen.

***************************************************************************/
void            vh_screenrefresh(void)
{
    int             scan_line = 0;
    int             total_X = 0;
    int             Y_pos = 0;
    int flipx,flipy;

    clear(piccie);

// Draw the characters themselves, shifted into the correct place.
// The are done as sprites so that they can overlay the real sprites.

// Bagman graphics

    if (gameemulated == BAGMAN)
    {
        if ((RAM[BAGMAN_VIDEO_PORT] & 0x01) == 1)
        {

            for (Y = 2; Y < 30; Y++)
            {
                for (X = 0; X < 32; X++)
                {
                    offset_value = RAM[base + (31 - Y) * 32 + X];
                    if ((RAM[base + 0x800 + (31 - Y) * 32 + X] & 0x10) == 0x10)
                        offset_value += 512;

                    if ((RAM[base + 0x800 + (31 - Y) * 32 + X] & 0x20) == 0x20)
                        offset_value += 256;

                    draw_sprite(piccie, chars[offset_value][RAM[base + 0x800 + (31 - Y) * 32 + X] & 0xf], Y * 8, X * 8);
                }
            }
        }
    }
// Phoenix and Pleiads graphics.  Draw the scrolling background characters

    else if ((gameemulated == PHOENIX) || (gameemulated == PLEIADS))
    {
        total_X = 0;
        X = (int) (RAM[base + 0x1800] / 8);
        scan_line = RAM[base + 0x1800] - (8 * X);
        while (total_X < 32)
        {
            for (Y = 0; Y < 32; Y++)
            {
                offset_value = RAM[base + 0x800 + (31 - Y) * 32 + X];
                colour = offset_value >> 5;
                draw_sprite_v_flip(piccie, chars[256 + offset_value][colour],
                                ((Y * 8) % 256), (total_X * 8) - scan_line);
            }
            X++;
            if (X > 31)
                X = 0;
            total_X++;
        }
    }
// Draw the foreground characters

    if (gameemulated != BAGMAN)
    {
        for (Y = 0; Y < 32; Y++)
        {
            for (X = 0; X < 32; X++)
            {
                if ((gameemulated == PHOENIX) || (gameemulated == PLEIADS))
                {
                    offset_value = RAM[base + (31 - Y) * 32 + X];
                    colour = offset_value >> 5;
                    draw_sprite_v_flip(piccie, chars[offset_value][colour],
                                       ((Y * 8) % 256), X * 8);
                }
                else
                {
                    offset_value = RAM[base + (31 - Y) * 32 + X];
                    if (offset_value != 0x36)
                    {
                        if (gameemulated == FROGGER)
                        {
                            Y_pos = (unsigned char) RAM[base + 0x800 + X * 2];
                            Y_pos = (Y_pos << 4 | Y_pos >> 4) & (0xff);
                            Y_pos = (Y * 8 + Y_pos) % 256;
                            draw_sprite(piccie, chars[offset_value][RAM[base + 0x801 + X * 2]],
                                        Y_pos, X * 8);
                        }
                        else
                            draw_sprite(piccie, chars[offset_value][RAM[base + 0x801 + X * 2]],
                                        ((Y * 8 + (unsigned char) RAM[base + 0x800 + X * 2]) % 256), X * 8);
                    }
                }
            }

        }

    }

// Blit the sprites. Since the background is cleared and updated every time
// there's really no need to copy the backgrounds.
// First the alien sprites
// Data format is X, num/orientation, colour, Y

    if (gameemulated == BAGMAN)
    {
        for (count1 = base + 0x820 - 4; count1 >= base + 0x800; count1 -= 4)
        {
            spritenum = RAM[count1];
            colour = RAM[count1 + 1];
            X = RAM[count1 + 2];
            Y = RAM[count1 + 3];
            direction = spritenum >> 6;

            spritenum &= 0x3f;
            spritenum |= (((colour) & 0x20) << 1);
            colour &= 0x0f;

//direction now holds the flipping info 0x80 vertical 0x40 horizontal
//there's only 0x40 possible sprites, besides above 0x40 is only the
//flipping info mentioned above.


            if (X && Y && spritenum)
                switch (direction)
                {
                case (0):
                    draw_sprite(piccie, sprites[spritenum][colour], X + 1, Y - 1);
                    break;
                case (1):
                    draw_sprite_v_flip(piccie, sprites[spritenum][colour], X + 1, Y - 1);
                    break;
                case (2):
                    draw_sprite_h_flip(piccie, sprites[spritenum][colour], X + 1, Y - 1);
                    break;
                default:
                    draw_sprite_vh_flip(piccie, sprites[spritenum][colour], X + 1, Y - 1);
                    break;
                }
        }
    }
    else if (gameemulated == DKONG)
    {
        for (count1 = 0x6900; count1 < 0x6900 + (4*96); count1 += 4)
        {
            X = RAM[count1]-7;
            spritenum = RAM[count1 + 1] & 0x7f;
            colour = RAM[count1 + 2] & 0x7f;
            Y = RAM[count1 + 3] - 8;
            flipx = RAM[count1 + 1] & 0x80;
            flipy = RAM[count1 + 2] & 0x80;

            if (X && Y && spritenum)
                if (!flipx && !flipy)
                    draw_sprite(piccie, sprites[spritenum][colour], X, Y);
                else if (flipx && !flipy)
                    draw_sprite_v_flip(piccie, sprites[spritenum][colour], X, Y);
                else if (!flipx && flipy)
                    draw_sprite_h_flip(piccie, sprites[spritenum][colour], X, Y);
                else if (flipx && flipy)
                    draw_sprite_vh_flip(piccie, sprites[spritenum][colour], X, Y);

        }
    }
    else if ((gameemulated != PHOENIX) && (gameemulated != PLEIADS))
    {
        for (count1 = base + 0x840; count1 < base + 0x860; count1 += 4)
        {
            X = RAM[count1];
            if (gameemulated == FROGGER)
                X = (X << 4 | X >> 4) & (0xff);
            spritenum = RAM[count1 + 1];
            colour = RAM[count1 + 2];
            Y = RAM[count1 + 3];
            direction = spritenum >> 6;

//direction now holds the flipping info 0x80 vertical 0x40 horizontal

            spritenum &= 0x3f;
            if (gameemulated == MOONCRST)
            {
                if (Sprite & 0x40)
                    if ((spritenum > 31) && (spritenum < 48))
                        spritenum = (spritenum & 0x1f) | Sprite;
            }
            else if ((gameemulated == GALAXIAN) || (gameemulated == GALNAMCO) ||
                   (gameemulated == GALAPX) || (gameemulated == SUPGALAX) ||
                   (gameemulated == GALTURBO) || (gameemulated == GALAP1) ||
                     (gameemulated == GALAP4))
            {
                if (spritenum > 49)
                    spritenum = 49;
            }

//there's only 0x40 possible sprites, besides above 0x40 is only the
//flipping info mentioned above.

            if (X && Y && spritenum)
                switch (direction)
                {
                case (0):
                    draw_sprite(piccie, sprites[spritenum][colour], X, Y);
                    break;
                case (1):
                    draw_sprite_v_flip(piccie, sprites[spritenum][colour], X, Y);
                    break;
                case (2):
                    draw_sprite_h_flip(piccie, sprites[spritenum][colour], X, Y);
                    break;
                default:
                    draw_sprite_vh_flip(piccie, sprites[spritenum][colour], X, Y);
                    break;
                }

        }

// Next the players bullets (Not sure how big they should be)
// Data format is ??, X, ??, -Y

        for (count1 = base + 0x860; count1 < base + 0x880; count1 += 4)
        {
            X = RAM[count1 + 1];
            Y = 256 - RAM[count1 + 3];  // Y is inverted
            if (X && Y)
            {
                if (count1 < base + 0x876)
                    vline(piccie, X, Y - 4, Y - 2, 1);  // them - white
                else
                    vline(piccie, X, Y - 4, Y - 2, 7);  // us - yellow

            }
        }
    }
    /* if the test key is pressed, let the user change the dip switches */
    if (osd_key_pressed(OSD_KEY_F9))
    {
        int             d,
                        c;

        for (i = OSD_KEY_F1; i <= OSD_KEY_F6; i++)
        {
            if (osd_key_pressed(i))
            {
                d = 1;
                for (c = OSD_KEY_F1; c < i; c++)
                    d <<= 1;
                dsw1 ^= d;
                while (osd_key_pressed(i)); /* wait for the key to be
                                             * released */
                break;
            }
        }
    }
    osd_update_display();


}
