;*****************************************************************************
;*
;*	Dumplayerx (DumpLib)
;*	Copyright 2000  dec0de12
;*	use MASM (tab4)
;*
;*****************************************************************************

	prRelocate		PROTO	:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
	prCloseHandle	PROTO
	prFreeMem		PROTO

;-----------------------------------------------------------------------------


cMZ_Sign				= 5a4dh				; "MZ"
cMZ_ExeExt				= 3ch				; Offset to Offset to Exe-Extension
cPE_Sign				= 4550h				; "PE",0,0
cPE_DescNum				= 6
cPE_ImageBase			= 34h
cPE_FileAlign			= 3ch
cPE_FirstSecSize		= 100h
cPE_ExportRVA			= 78h				; PE-Offset to RVA Export Descriptor
cPE_ExportSecRVA		= 17ch				; .rdata
cPE_ExportSecFOA		= 184h

;-----------------------------------------------------------------------------


prDumpLib		PROC

		LOCAL	var_hDll_File			:DWORD
		LOCAL	var_hSaveFile			:DWORD
		LOCAL	var_dwDll_FileSize		:DWORD
		LOCAL	var_pMem				:DWORD
		LOCAL	var_pDumpMem			:DWORD
		LOCAL	var_dwDumpSize			:DWORD
		LOCAL	var_dwDllDump_MaxSize	:DWORD
		LOCAL	var_hDll				:DWORD
		LOCAL	var_dwProcID			:DWORD
		LOCAL	var_hProc				:DWORD
		LOCAL	var_dwNewCodeSize		:DWORD
		LOCAL	var_dwNewDataFOA		:DWORD
		LOCAL	var_dwNewDataSize		:DWORD
		LOCAL	var_dwSecNum			:DWORD
		LOCAL	var_dwFirstSecSize		:DWORD
		LOCAL	var_pBaseEntry			:DWORD
		LOCAL	var_pReloc				:DWORD
		LOCAL	var_dwRelocSize			:DWORD
		LOCAL	var_dwExportFunc1RVA	:DWORD
		LOCAL	var_dwExportFunc2RVA	:DWORD
		LOCAL	var_dwExportRVA			:DWORD
		LOCAL	var_dwExportFOA			:DWORD
		LOCAL	var_dwExportSecRVA		:DWORD
		LOCAL	var_dwExportSecFOA		:DWORD
		LOCAL	var_pSection_Mem		:DWORD

		LOCAL	var_dwNumFuncs			:DWORD
		LOCAL	var_dwCodeBlockSize		:DWORD
		LOCAL	var_pNecessaryCode		:DWORD
		LOCAL	var_pMorphCode			:DWORD



;-----------------------------------------------------------------------------

	mov		eax, [var_pMem]
	invoke	prFreeMem
	sub		eax, eax
	mov		[dwBaseF], eax
	mov		[dwBaseM], eax
	mov		[var_hDll_File], eax
	mov		[var_hSaveFile], eax
	mov		[var_hProc], eax
	mov		[var_hDll], eax
	dec		al
	mov		[bChangedName], al
	mov		[bChangedBaseF], al
	mov		[bChangedBaseM], al

	;=============
	; OpenDll File
	;=============

	mov		eax, [hWnd]
	mov		[stOpenFile.hWndOwner], eax
	mov		[stOpenFile.Flags], OFN_FILEMUSTEXIST
	lea		eax, szFilename
	mov		byte ptr [eax], 0
	mov		[stOpenFile.lpstrFile], eax
	invoke	GetOpenFileNameA, offset stOpenFile
	test	eax, eax
	je		@@Ciao

	mov		[bChangedName], -1
	invoke	CreateFileA, offset szFilename, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0
	cmp		eax, -1
	je		@@Error_OpenFile
	mov		[var_hDll_File], eax

	invoke	GetFileSize, eax, 0
	and		eax, 1fffffh
	mov		[var_dwDll_FileSize], eax
	add		eax, eax
	add		eax, 7ffffh
	and		eax, 0ffff000h
	push	eax
	invoke	VirtualAlloc, 0, eax, MEM_COMMIT, PAGE_READWRITE
	mov		[var_pMem], eax
	pop		edx
	test	eax, eax
	je		@@Error_AllocMem

	mov		ebx, [var_dwDll_FileSize]
	add		ebx, 00001fffh
	and		ebx, 0ffff000h
	sub		edx, ebx
	mov		[var_dwDllDump_MaxSize], edx
	add		eax, ebx
	mov		[var_pDumpMem], eax

	invoke	ReadFile, [var_hDll_File], [var_pMem], [var_dwDll_FileSize], offset dwFreeVar, 0
	test	eax, eax
	je		@@Error_ReadFile

	;================================
	; Get Exports & FirstSection Data
	;================================

	mov		esi, [var_pMem]
	mov		edi, [var_pDumpMem]

	mov		eax, [esi][cMZ_ExeExt]
	and		eax, 0fffh
	lea		ecx, [eax][0f8h]

	cmp		dword ptr [esi][eax], cPE_Sign
	jne		@@Error_Structure

	mov		edx, [esi][eax][cPE_FirstSecSize]
	mov		[var_dwFirstSecSize], edx

	mov		edx, [esi][eax][cPE_ImageBase]
	mov		[dwBaseF], edx
	mov		[bChangedBaseF], -1

	lea		edx, [edi][eax][cPE_ImageBase]
	mov		[var_pBaseEntry], edx				; to change it, if no reloc

	sub		edx, edx
	mov		dx, [esi][eax][cPE_DescNum]
	cmp		dx, 6
	je		@@SecNum6
	cmp		dx, 7
	jne		@@Error_Structure

@@SecNum6:
	mov		[var_dwSecNum], edx
	sub		dl, 2
	mov		[esi][eax][cPE_DescNum], dx

	mov		dword ptr [esi][eax][cPE_FileAlign], 1000h

	mov		ebx, [esi][eax][cPE_ExportRVA]
	mov		[var_dwExportRVA], ebx

	mov		ebx, [esi][eax][cPE_ExportSecRVA]
	mov		[var_dwExportSecRVA], ebx

	mov		ebx, [esi][eax][cPE_ExportSecFOA]
	mov		[var_dwExportSecFOA], ebx

	add		ebx, [var_dwExportRVA]
	sub		ebx, [var_dwExportSecRVA]
	mov		[var_dwExportFOA], ebx

	mov		eax, [esi][ebx][cExportProcRVA]
	mov		[var_dwExportFunc1RVA], eax

	mov		eax, [esi][ebx][cExportProcRVA+4]
	mov		[var_dwExportFunc2RVA], eax

	lea		edi, [esi][ebx][cExportSearchOffset]
	lea		esi, tExportSearchBlock
	mov		ecx, cExportSearchBlockSize

@@ProofExport:
	cmpsb
	jne		@@Error_Structure
	loop	@@ProofExport

	;==================
	; Create New Header
	;==================

	mov		esi, [var_pMem]
	mov		edi, [var_pDumpMem]

	mov		ecx, [esi][cMZ_ExeExt]
	and		ecx, 0fffh
	add		ecx, 0f8h

@@TransHead:
	movsb
	loop	@@TransHead
	mov		dword ptr [edi], "doc."
	mov		dword ptr [edi][4], "e"
	mov		eax, [esi][120+12]
	sub		eax, 1000h
	mov		[var_dwNewCodeSize], eax
	mov		dword ptr [edi][8], eax
	mov		dword ptr [edi][12], 01000h
	mov		dword ptr [edi][16], eax
	mov		dword ptr [edi][20], 01000h
	mov		dword ptr [edi][36], 60000020h
	add		esi, 3*40
	add		edi, 40

	push	esi
	mov		ebx, [var_dwSecNum]
	sub		ebx, 3
@@TransHead2:
	mov		ecx, [esi][16]						; FSize
	pushm	esi, edi
	mov		edi, [esi][12]						; RVA
	add		edi, [var_pDumpMem]
	mov		esi, [esi][20]						; FOA
	add		esi, [var_pMem]
	rep		movsb
	popm	edi, esi

	mov		eax, [esi][8]						; VSize (sometimes>FSize)
	add		eax, 000000fffh
	and		eax, 0fffff000h
	mov		[esi][16], eax
	mov		eax, [esi][12]
	mov		[esi][20], eax
	mov		ecx, 10
	rep		movsd
	dec		ebx
	jne		@@TransHead2

	mov		eax, [esi][16-40]
	mov		[var_dwRelocSize], eax
	mov		eax, [esi][20-40]
	add		eax, [var_pDumpMem]
	mov		[var_pReloc], eax

	mov		eax, [esi][16-40]
	add		eax, [esi][20-40]
	mov		[var_dwDumpSize], eax
	cmp		eax, [var_dwDllDump_MaxSize]
	pop		esi
	jae		@@Error_Structure

	mov		eax, [esi][16+40]
	mov		[var_dwNewDataSize], eax
	mov		eax, [esi][20+40]
	mov		[var_dwNewDataFOA], eax


	;=================================
	; Load Dplayerx.dll & Get Base AVA
	;=================================

	invoke	LoadLibrary, offset szFilename
	mov		[var_hDll], eax
	test	eax, eax
	je		@@Error_OpenLib

	invoke	GetProcAddress, [var_hDll], offset szFunc1
	sub		eax, [var_dwExportFunc1RVA]
	push	eax									; Dll Base

	invoke	GetProcAddress, [var_hDll], offset szFunc2
	sub		eax, [var_dwExportFunc2RVA]
	pop		edx									; Dll Base
	cmp		eax, edx
	jne		@@Error_Structure
	mov		[dwBaseM], eax
	mov		[bChangedBaseM], -1

	;=================
	; Dump Code & Data
	;=================

	invoke	GetCurrentProcessId
	mov		[var_dwProcID], eax

	invoke	OpenProcess, PROCESS_ALL_ACCESS, TRUE, eax
	test	eax, eax
	je		@@Error_OpenProc
	mov		[var_hProc], eax

	mov		edx, [dwBaseM]
	add		edx, 1000h
	mov		eax, [var_pDumpMem]
	add		eax, 1000h

	invoke	ReadProcessMemory, [var_hProc], edx, eax, [var_dwNewCodeSize], offset dwFreeVar
	test	eax, eax
	je		@@Error_ReadProc

	mov		edx, [dwBaseF]
	sub		edx, [dwBaseM]
	je		@@NoRelocCode
	cmp		byte ptr [bOptRelocFlag], 0
	je		@@ChangeBase

	invoke	prRelocate, [var_pReloc], [var_dwRelocSize], [var_pDumpMem], 1000h, [var_dwNewCodeSize], edx
	jmp		@@NoRelocCode

@@ChangeBase:
	mov		eax, [dwBaseM]
	mov		edx, [var_pBaseEntry]
	mov		[edx], eax

@@NoRelocCode:
	cmp		byte ptr [bOptDataFlag], 0
	je		@@NoDataDump

	mov		edx, [dwBaseM]
	add		edx, [var_dwNewDataFOA]
	mov		eax, [var_pDumpMem]
	add		eax, [var_dwNewDataFOA]

	invoke	ReadProcessMemory, [var_hProc], edx, eax, [var_dwNewDataSize], offset dwFreeVar
	test	eax, eax
	je		@@Error_ReadProc

@@NoDataDump:
	mov		edx, [dwBaseF]
	cmp		edx, [dwBaseM]
	je		@@SaveDump

	cmp		byte ptr [bOptRelocFlag], 0
	je		@@SaveDump

	invoke	prRelocate, [var_pReloc], [var_dwRelocSize], [var_pDumpMem], [var_dwNewDataFOA], [var_dwNewDataSize], edx

	;=================
	; Dump Code & Data
	;=================

@@SaveDump:
	mov		[stOpenFile.Flags], OFN_PATHMUSTEXIST
	lea		eax, szOFN_FileName
	mov		byte ptr [eax], 0
	mov		[stOpenFile.lpstrFile], eax
	invoke	GetSaveFileNameA, offset stOpenFile
	test	eax, eax
	je		@@Ciao

	invoke	CreateFileA, offset szOFN_FileName, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0
	cmp		eax, -1
	je		@@Error_OpenFile
	mov		[var_hSaveFile], eax
	invoke	WriteFile, eax, [var_pDumpMem], [var_dwDumpSize], offset dwFreeVar, 0
	test	eax, eax
	je		@@Error_WriteFile

;-----------------------------------------------------------------------------

@@Ciao:
	mov		eax, [var_hDll]
	test	eax, eax
	je		@@NoLib
	invoke	FreeLibrary, eax

@@NoLib:
	mov		eax, [var_pMem]
	invoke	prFreeMem
	mov		eax, [var_hDll_File]
	invoke	prCloseHandle
	mov		eax, [var_hSaveFile]
	invoke	prCloseHandle
	mov		eax, [var_hProc]
	invoke	prCloseHandle

	sub		eax, eax
	dec		eax
	mov		[bChangedName], al
	mov		[bChangedBaseF], al
	mov		[bChangedBaseM], al
	mov		[dwThreadStatus], eax			; Thread finished
	inc		eax
	ret

;-----------------------------------------------------------------------------

@@Error_OpenFile:
	lea		eax, szErr_OpenFile
	jmp		@@Error

@@Error_ReadFile:
	lea		eax, szErr_ReadFile
	jmp		@@Error

@@Error_WriteFile:
	lea		eax, szErr_WriteFile
	jmp		@@Error

@@Error_AllocMem:
	lea		eax, szErr_AllocMem
	jmp		@@Error

@@Error_OpenLib:
	lea		eax, szErr_OpenLib
	jmp		@@Error

@@Error_OpenProc:
	lea		eax, szErr_OpenProc
	jmp		@@Error

@@Error_ReadProc:
	lea		eax, szErr_ReadProc
	jmp		@@Error

@@Error_Structure:
	lea		eax, szErr_Structure

@@Error:
	invoke	MessageBox, [hWnd], eax, offset szWinTitle, MB_ICONERROR
	mov		dword ptr [szFilename], "-"
	sub		eax, eax
	mov		[dwBaseF], eax
	mov		[dwBaseM], eax
	jmp		@@Ciao

prDumpLib		ENDP

;-----------------------------------------------------------------------------


prCloseHandle	PROC

	test	eax, eax
	je		@@NoHandle
	invoke	CloseHandle, eax
@@NoHandle:
	ret

prCloseHandle	ENDP

;------

prFreeMem		PROC

	test	eax, eax
	je		@@NoMemPtr
	invoke	VirtualFree, eax, 0, MEM_RELEASE
@@NoMemPtr:
	ret

prFreeMem		ENDP

;-----------------------------------------------------------------------------


	include	Relocate.inc

;-----------------------------------------------------------------------------
