
;-----------------------------------------------------------------------------
;	m2m	= mov	mem, mem
;-----------------------------------------------------------------------------

m2m		MACRO	arg1, arg2
	push	arg2
	pop		arg1
		ENDM


;-----------------------------------------------------------------------------
;	pushm/popm <register>
;-----------------------------------------------------------------------------

pushm	MACRO	arglist: vararg
			FOR	arg, <arglist>
				push	arg
			ENDM
		ENDM

popm	MACRO	arglist: vararg
			FOR	arg, <arglist>
				pop		arg
			ENDM
		ENDM


;-----------------------------------------------------------------------------
;	RETURN eax
;-----------------------------------------------------------------------------

RETURN	MACRO	arg
	IFNB	<arg>
		mov	eax, arg
	ENDIF
		ret
	ENDM


;-----------------------------------------------------------------------------
;	LRETURN eax + leave
;-----------------------------------------------------------------------------

LRETURN	MACRO	arg 
	IFNB	<arg>
		mov	eax, arg
	ENDIF
		leave
		ret
	ENDM


;-----------------------------------------------------------------------------
;	FATAL	Error+Exit
;-----------------------------------------------------------------------------

FATAL	MACRO	msg
		LOCAL	@@msg
		.DATA
	@@msg	db	msg, 0
		.CODE
		INVOKE	MessageBox, hWnd, ADDR @@msg, ADDR @@msg, MB_OK
		INVOKE	ExitProcess, 0
	ENDM


;-----------------------------------------------------------------------------
