diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/defs.qc eweapon/defs.qc
--- v101qc/defs.qc	Thu Jul 25 01:51:22 1996
+++ eweapon/defs.qc	Wed Aug 28 19:44:26 1996
@@ -691,3 +691,6 @@
 float(entity targ, entity inflictor) CanDamage;
 
 
+// Added by Jepler@inetnebr.com for easy extra weapons
+.void()	extra_fire;
+.void() extra_set_current_ammo;
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/impulses eweapon/impulses
--- v101qc/impulses	Wed Dec 31 18:00:00 1969
+++ eweapon/impulses	Thu Aug 29 07:47:14 1996
@@ -0,0 +1,7 @@
+EW_TemplateImpulse 0
+EW_LBoltImpulse 0
+EW_FlameImpulse 0
+***
+EW_TemplatePrecache
+EW_LBoltPrecache
+EW_FlamePrecache
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/mkimpulse.c eweapon/mkimpulse.c
--- v101qc/mkimpulse.c	Wed Dec 31 18:00:00 1969
+++ eweapon/mkimpulse.c	Wed Aug 28 19:49:38 1996
@@ -0,0 +1,76 @@
+#include <stdio.h>
+
+iprolog() {
+	printf(
+		"/*\n"
+		"============\n"
+		"ImpulseCommands\n"
+		"\n"
+		"============\n"
+		"*/\n"
+		"void() ImpulseCommands =\n"
+		"{\n"
+		"\tif (self.impulse >= 1 && self.impulse <= 8)\n"
+		"\t\tW_ChangeWeapon ();\n"
+		"\n"
+		"\tif (self.impulse == 9)\n"
+		"\t\tCheatCommand ();\n"
+		"\tif (self.impulse == 10)\n"
+		"\t\tCycleWeaponCommand ();\n"
+		"\tif (self.impulse == 11)\n"
+		"\t\tServerflagsCommand ();\n"
+	);
+}
+
+iepilog() {
+	printf(
+		"\tif (self.impulse == 255)\n"
+		"\t\tQuadCheat ();\n"
+		"\t\t\n"
+		"\tself.impulse = 0;\n"
+		"};\n"
+	);
+}
+
+pprolog() { printf(
+		"\n"
+		"/*\n"
+		"============\n"
+		"EW_Precache\n"
+		"\n"
+		"============\n"
+		"*/\n"
+		"void() EW_Precache = {\n"
+	);
+}
+pepilog() { printf("};\n"); }
+
+main() {
+	char f[64];
+	int i, j=12;
+	iprolog();
+	while(1) {
+		if(scanf("%s %i", f, &i)!=2) break;
+		if(i<2) { // 0 or 1 means a single impulse
+			printf("\tif (self.impulse == %d) %s();\n",j,f);
+			j++;
+		} else {
+			printf("\tif (self.impulse >= %d && self.impulse <= %d)\n\t\t%s(self.impulse-%d);\n",j,j+i-1,f,j-1);
+			j+=i;
+		}
+		if(j>255) {
+			fprintf(stderr,"Maximum impulses exceeded!\n");
+			return 1;
+		}
+	}
+	iepilog();
+
+	pprolog();
+	while(1) {
+		if(scanf("%s", f)!=1) break;
+		printf("\t%s();\n", f);
+	}
+	pepilog();
+		
+	return 0;
+}
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/progs.src eweapon/progs.src
--- v101qc/progs.src	Wed Jul 31 21:15:26 1996
+++ eweapon/progs.src	Thu Aug 29 07:47:29 1996
@@ -7,6 +7,10 @@
 combat.qc
 items.qc
 weapons.qc
+w-templa.qc
+w-lbolt.qc
+w-flame.qc
+w-extra.qc
 world.qc
 client.qc
 player.qc
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/w-extra.qc eweapon/w-extra.qc
--- v101qc/w-extra.qc	Wed Dec 31 18:00:00 1969
+++ eweapon/w-extra.qc	Thu Aug 29 07:47:20 1996
@@ -0,0 +1,37 @@
+/*
+============
+ImpulseCommands
+
+============
+*/
+void() ImpulseCommands =
+{
+	if (self.impulse >= 1 && self.impulse <= 8)
+		W_ChangeWeapon ();
+
+	if (self.impulse == 9)
+		CheatCommand ();
+	if (self.impulse == 10)
+		CycleWeaponCommand ();
+	if (self.impulse == 11)
+		ServerflagsCommand ();
+	if (self.impulse == 12) EW_TemplateImpulse();
+	if (self.impulse == 13) EW_LBoltImpulse();
+	if (self.impulse == 14) EW_FlameImpulse();
+	if (self.impulse == 255)
+		QuadCheat ();
+		
+	self.impulse = 0;
+};
+
+/*
+============
+EW_Precache
+
+============
+*/
+void() EW_Precache = {
+	EW_TemplatePrecache();
+	EW_LBoltPrecache();
+	EW_FlamePrecache();
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/w-flame.qc eweapon/w-flame.qc
--- v101qc/w-flame.qc	Wed Dec 31 18:00:00 1969
+++ eweapon/w-flame.qc	Wed Aug 28 20:34:34 1996
@@ -0,0 +1,116 @@
+vector(vector a, vector b) SUB_rv = {
+	local vector r;
+	r_x=a_x + (b_x - a_x) * random();
+	r_y=a_y + (b_y - a_y) * random();
+	r_z=a_z + (b_z - a_z) * random();
+	return r;
+};
+
+
+void() EW_FlameBurn = {
+	self.cnt = self.cnt - 1;
+	if(self.cnt == 0) { remove(self); return; }
+	if(self.owner.health < 0) { remove(self); return; }
+	self.nextthink = time + 0.1;
+	self.origin = self.owner.origin + SUB_rv(self.owner.mins, self.owner.maxs) * 0.5;
+};
+
+void() EW_FlameTouch = {
+	local float q;
+	local vector v;
+	if (other == self.owner)
+		return;
+
+	if (other.solid == SOLID_TRIGGER)
+		return;	// trigger field, do nothing
+	if (other.solid == SOLID_NOT)
+		return;	// do nothing
+
+	if (pointcontents(self.origin) == CONTENT_SKY)
+	{
+		remove(self);
+		return;
+	}
+	
+
+// hit something that bleeds
+	if (other.takedamage)
+	{
+		spawn_touchblood (12);
+		T_Damage (other, self, self.owner, 12);
+		
+		q=5; while(q) {
+			if(random() > 0.00) // 0.66
+				setmodel(self, "progs/smoke.spr");
+			else if(random() > 0.5)
+				setmodel(self, "progs/flame.mdl");
+			else	
+				setmodel(self, "progs/lavaball.mdl");
+			self.owner = other;
+			self.touch = SUB_Null;
+			self.solid = SOLID_NOT;
+			self.think = EW_FlameBurn;
+			self.nextthink = time + 0.1;
+			self.cnt = 30;
+			self.avelocity = SUB_rv('-900 -900 -900', '900 900 900');
+			q = q - 1;
+			if(q) self=spawn();
+		}
+	}
+	else
+	{
+		self.velocity = '0 0 0';
+		self.nextthink = time + 1;
+		self.avelocity = SUB_rv('-900 -900 -900', '900 900 900');
+		self.think = SUB_Remove;
+		self.solid = SOLID_NOT;
+		self.touch = SUB_Null;
+	}
+
+};
+
+void() EW_FlameFire = {
+	local vector dir;
+	if(self.ammo_nails == 0 && self.ammo_cells == 0) {
+			self.weapon=W_BestWeapon();
+			W_SetCurrentAmmo ();
+			return;
+		}
+	else if ((random()*(self.ammo_nails+self.ammo_cells))>self.ammo_cells)
+		self.ammo_nails = self.ammo_nails - 1;
+	else
+		self.ammo_cells = self.ammo_cells - 1;
+
+	
+	dir = aim(self, 1000);
+	launch_spike(self.origin, dir);
+	newmis.touch = EW_FlameTouch;
+	newmis.velocity = normalize(newmis.velocity) * 600;
+	newmis.flags = EF_DIMLIGHT;
+	if(random() > 0.5)
+		setmodel(newmis, "progs/flame.mdl");
+	else	
+		setmodel(newmis, "progs/lavaball.mdl");
+	sound(self, CHAN_WEAPON, "misc/menu2.wav", 1, ATTN_NORM);
+	self.attack_finished = time + 0.5;
+
+};
+
+void() EW_FlameSCA = {
+	self.weaponmodel = "";
+	self.currentammo = self.ammo_nails + self.ammo_cells;
+};
+
+void() EW_FlameImpulse = {
+	self.weapon = IT_EXTRA_WEAPON;
+	self.extra_fire=EW_FlameFire;
+	self.extra_set_current_ammo=EW_FlameSCA;
+	W_SetCurrentAmmo();
+};
+
+void() EW_FlamePrecache = {
+	precache_model("progs/flame.mdl");
+	precache_model("progs/lavaball.mdl");
+	precache_model("progs/smoke.spr");
+	precache_sound("misc/menu2.wav");
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/w-lbolt.qc eweapon/w-lbolt.qc
--- v101qc/w-lbolt.qc	Wed Dec 31 18:00:00 1969
+++ eweapon/w-lbolt.qc	Thu Aug 29 07:44:13 1996
@@ -0,0 +1,105 @@
+void(entity e) EW_LBoltDamage = {
+	if(e.takedamage) {
+		spawn_touchblood (self.cnt/2);
+		T_Damage ( e, self, self.owner, self.cnt/2);
+	}
+	sound(e, CHAN_BODY, "shambler/sboom.wav", 1, ATTN_NORM);
+};
+
+void() EW_LBoltImpactBoom = {
+	sound(self, CHAN_WEAPON, "shambler/sboom.wav", 1, ATTN_NORM);
+	setmodel(self, "");
+	self.touch=SUB_Null;
+	self.solid=SOLID_NOT;
+	self.movetype=MOVETYPE_NONE;
+	self.think = SUB_Remove;
+	self.nextthink = time+1;
+};
+
+void(entity e) EW_LBoltTouch = {
+	EW_LBoltDamage(other);
+	EW_LBoltImpactBoom();
+};
+
+void(vector p1) EW_LBoltWriteVector = {
+	WriteCoord (MSG_BROADCAST, p1_x);
+	WriteCoord (MSG_BROADCAST, p1_y);
+	WriteCoord (MSG_BROADCAST, p1_z);
+};
+
+void() EW_LBoltLightning = {
+	local vector p1, p2;
+	local entity e1, e2;
+	traceline ( self.origin, self.origin + '0 0 600', FALSE, self);
+	p1 = trace_endpos;
+	e1 = trace_ent;
+	traceline ( self.origin, self.origin - '0 0 600', FALSE, self);
+	p2 = trace_endpos;
+	e2 = trace_ent;
+
+	if (e1 != world && e1.takedamage) {
+		EW_LBoltTouch(e1);
+	}
+	if (e2 != world && e2.takedamage) {
+		EW_LBoltTouch(e2);
+	}
+	if ((e1 != world && e1.takedamage) || (e2 != world && e2.takedamage)) {
+		EW_LBoltImpactBoom();
+	}
+		
+	WriteByte (MSG_BROADCAST, SVC_TEMPENTITY);
+	if(self.cnt > 50) WriteByte(MSG_BROADCAST, TE_LIGHTNING1);
+	else WriteByte (MSG_BROADCAST, TE_LIGHTNING2);
+	WriteEntity (MSG_BROADCAST, self);
+	EW_LBoltWriteVector(p1);
+	EW_LBoltWriteVector(p2);
+
+	if (self.t_width < time)
+	{
+		sound (self, CHAN_WEAPON, "weapons/lhit.wav", 1, ATTN_NORM);
+		self.t_width = time + 0.6;
+	}
+	self.cnt=self.cnt - 1;
+	if(self.cnt<=0) remove(self);
+	self.nextthink = time + 0.05;
+};
+
+void() EW_LBoltFire = {
+	local vector dir;
+	// Put here the code to execute when your weapon is fired.
+	// Include changing ammo_*, currentammo, attack_finished ...
+	if(self.ammo_cells <= 0) {
+		self.weapon = W_BestWeapon();
+		W_SetCurrentAmmo();
+		return;
+	}
+	self.currentammo = self.ammo_cells = self.ammo_cells - 1;
+	dir = aim(self, 10000);
+
+	launch_spike(self.origin + '0 0 16', dir);
+	newmis.nextthink = time + 0.05;
+	newmis.cnt = 120;
+	newmis.think = EW_LBoltLightning;
+	newmis.touch = EW_LBoltTouch;
+	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+	self.attack_finished = time + 0.8;
+};
+
+void() EW_LBoltSCA = {
+	// Perform SetCurrentAmmo
+	self.weaponmodel = "";
+	self.currentammo = self.ammo_cells;
+};
+
+void() EW_LBoltImpulse = {
+	// if(! (self.items & IT_NAILGUN)) return; // Check for having weapon
+	self.weapon = IT_EXTRA_WEAPON;
+	self.extra_fire=EW_LBoltFire;
+	self.extra_set_current_ammo=EW_LBoltSCA;
+	W_SetCurrentAmmo();
+};
+
+void() EW_LBoltPrecache = {
+	precache_sound("shambler/sboom.wav");
+	precache_sound("weapons/lhit.wav");
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/w-templa.qc eweapon/w-templa.qc
--- v101qc/w-templa.qc	Wed Dec 31 18:00:00 1969
+++ eweapon/w-templa.qc	Thu Aug 29 07:39:02 1996
@@ -0,0 +1,77 @@
+// This is a template for adding a weapon to quake, using Jeff Epler
+// <jepler@inetnebr.com>'s ExtraWeapon system.
+//
+// First, pick a prefix for your weapon.  Here, we use "Template".
+// So, all the functions we create will start EW_Template and then have
+// more characters to designate the use of the function.
+//
+// The filename to write all this in is w-templa.qc (8 letters for DOS
+// users)
+//
+// Now, implement some functions:
+//
+// At the least, you probably need to have EW_TemplateFire,
+// EW_TemplateSCA [set current ammo] and EW_TemplateImpulse
+// You're also likely to need EW_TemplatePrecache
+//
+// Now, in the file "impulses" you need to put one or two lines:
+// In the first part of the file (before the *** divider)
+// put the name of the EW_TemplateImpulse and the number 0 or 1
+// (If you have multiple weapons to access through one impulse,
+// put EW_TemplateImpulse 3 if there are 3 weapons.
+// Then, you're given a number from 1 to 3 depending how far
+// the used impulse was from the "base" impulse)
+//
+// In EW_TemplateImpulse, set the self.extra_weapon property to
+// the function to call to fire the weapon (EW_TemplateFire)
+// and the .extra_set_current_ammo property to EW_TemplateSCA
+// Then call the SCA function.
+//
+// Now, run the "mkimpulse" program
+// Inspect the output for what impulse is what, and save the output
+// to w-extra.qc  (mkimpulse < impulses > w-extra.qc)
+//
+// Finally, put w-templa.qc and w-extra.qc in progs.dat after weapons.qc
+// in the order above and recompile
+//
+// Now, play!
+//
+// (You should be able to add many weapons so long as their names
+// differ and you keep your 'impulses' file up to date)
+//
+// This sample has a rough copy of the nailgun
+
+void() EW_TemplateFire = {
+	local vector dir;
+	// Put here the code to execute when your weapon is fired.
+	// Include changing ammo_*, currentammo, attack_finished ...
+	if(self.ammo_nails <= 0) {
+		self.weapon = W_BestWeapon();
+		W_SetCurrentAmmo();
+		return;
+	}
+	self.currentammo = self.ammo_nails = self.ammo_nails - 1;
+	dir = aim(self, 10000);
+
+	launch_spike(self.origin + '0 0 16', dir);
+	sound (self, CHAN_WEAPON, "weapons/rocket1i.wav", 1, ATTN_NORM);
+};
+
+void() EW_TemplateSCA = {
+	// Perform SetCurrentAmmo
+	self.weaponmodel = "";
+	self.currentammo = self.ammo_nails;
+};
+
+void() EW_TemplateImpulse = {
+	// if(! (self.items & IT_NAILGUN)) return; // Check for having weapon
+	self.weapon = IT_EXTRA_WEAPON;
+	self.extra_fire=EW_TemplateFire;
+	self.extra_set_current_ammo=EW_TemplateSCA;
+	W_SetCurrentAmmo();
+};
+
+void() EW_TemplatePrecache = {
+	precache_model("progs/spike.mdl");
+	precache_sound("weapons/rocket1i.wav");
+};
diff -ur --new-file -x progs.dat -x progdefs.h -x *.bak -x *~ -x *.rej -x *.cfg -x *.sav v101qc/weapons.qc eweapon/weapons.qc
--- v101qc/weapons.qc	Thu Jul 25 01:51:24 1996
+++ eweapon/weapons.qc	Thu Aug 29 07:21:17 1996
@@ -8,6 +8,8 @@
 
 
 // called by worldspawn
+void() EW_Precache;
+
 void() W_Precache =
 {
 	precache_sound ("weapons/r_exp3.wav");	// new rocket explosion
@@ -22,6 +24,7 @@
 	precache_sound ("weapons/grenade.wav");	// grenade launcher
 	precache_sound ("weapons/bounce.wav");		// grenade bounce
 	precache_sound ("weapons/shotgn2.wav");	// super shotgun
+	EW_Precache();
 };
 
 float() crandom =
@@ -812,6 +815,10 @@
 		self.weaponframe = 0;
 		self.items = self.items | IT_CELLS;
 	}
+	else if (self.weapon == IT_EXTRA_WEAPON)
+	{
+		self.extra_set_current_ammo();
+	}
 	else
 	{
 		self.currentammo = 0;
@@ -890,7 +897,10 @@
 	makevectors	(self.v_angle);			// calculate forward angle for velocity
 	self.show_hostile = time + 1;	// wake monsters up
 
-	if (self.weapon == IT_AXE)
+	if (self.weapon == IT_EXTRA_WEAPON) {
+		self.extra_fire();
+	}
+	else if (self.weapon == IT_AXE)
 	{
 		sound (self, CHAN_WEAPON, "weapons/ax1.wav", 1, ATTN_NORM);
 		r = random();
@@ -1154,35 +1164,12 @@
 
 /*
 ============
-ImpulseCommands
-
-============
-*/
-void() ImpulseCommands =
-{
-	if (self.impulse >= 1 && self.impulse <= 8)
-		W_ChangeWeapon ();
-
-	if (self.impulse == 9)
-		CheatCommand ();
-	if (self.impulse == 10)
-		CycleWeaponCommand ();
-	if (self.impulse == 11)
-		ServerflagsCommand ();
-
-	if (self.impulse == 255)
-		QuadCheat ();
-		
-	self.impulse = 0;
-};
-
-/*
-============
 W_WeaponFrame
 
 Called every frame so impulse events can be handled as well as possible
 ============
 */
+void() ImpulseCommands;
 void() W_WeaponFrame =
 {
 	if (time < self.attack_finished)
