/*#define pc  /** Einstellen fr PC-Compilierung**/

/*#####################################################################*\
#   Modul-Info fr  PT/NT/ST--Module     (c) 1993 von Christian Marz    #
#                                        PC-Version von Robert Kukla    #
#=======================================================================#
#   V1.0, 26.3.93:  quick-and-dirty Version                             #
#   V1.1, 27.3.93:  Parameter -s -p, Pattern-bersicht, "M.K."-Test,    #
#                   schneller durch Laden der Patterns ins Ram          #
#   V1.2, 28.3.93:  Lustigere Meldungen, Speicher-alloc-Bug weg,        #
#                   Kompaktere Pattern-bersicht, Close(file)-Bug weg   #
#   V1.3,  3.4.93:  -c zum Kommados zaehlen, -a alle Speeds anzeigen,   #
#                   Parameter defaults, Optik verbessert                #
#   V1.4, 11.4.93:  Bug: kein MK-Mod dann File noch offen, Optik++,     #
#                   Mehrfachangabe von Files als Argumente              #
#   V1.5, 12.4.93:  Zhlen der Samples eingebaut: -u, Optik++           #
#   V1.6,  2.5.93:  MEMTYPE als non-Chipmem, Argumente -SU zu -FS,      #
#                   ungenaue Junklngenberechnung, Speedtabellenkopf    #
#                   nur bei weiteren Ausgaben,  Optik++                 #
#   V1.7, 25.7.93:  Volume+Finetunewerte fr Samples anzeigen; \n bei   #
#                   non-headed fehlte, Samplelnge>$FFFF anzeigen,      #
#                   bei filename: [256][10] statt [10][256], Optik++    #
#   V1.8,  1.8.93:  Erkennt Unterschied zw. PT/PT+/NT/ST4+8/PRU mods;   #
#                   Kommando $E wird aufgeschlsselt ausgezhlt;        #
#                   repeatlen=0 als Fehler erkennen; Bei mehreren Files #
#                   NACH jedem wieder das MEM freigeben; Optik++        #
#   V1.9, 30.8.93:  PC-Version von Robert Kukla in Turbo C compilierbar #
#                   dazu '#define pc' angeben.                          #
#   V1.X, 13.9.93:  Amiga-V1.8,11.8.93 bernommen, Roberts nderungs-  #
#                   vorschlge eingebaut. Vorallem Optik++. Aber auch   #
#                   den -u Switch fr benutzte/unbenutzte Patterns und  #
#                   Kommando 0 Statistik eingebaut.                     #
#   V1.Y, 20.9.93:  Roberts Anregungen umgesetzt; Optik++;              #
#                   -a Arrangement der Patterns im Song als Tabelle.    #
#                   -l Locate commands Funktion eingebaut.              #
#                   -r Das Auftreten von beliebiges Samples anzeigen.   #
#   V1.Z, 3.10.93:  Bei -r HEX oder DEZ (=!xy) angebbar.                #
#                   Im PC-Teil ein paar Typedef's eingefhrt.           #
#                   Filenamen mit/ohne `mod' suffix/extension suchen    #
#                   Hilfstexte ausfhrlicher.                           #
#   Was noch fehlt: - Das Auftreten von Kommando $E_x und $0 anzeigen   #
#                   - Rxy statt r!xy verwenden(?)                       #
#                   - Ctrl-C Signal endlich abfangen und auswerten      #
\*#####################################################################*/

/* CM's Info zur die Textausgabe:
     Ich benutze diverse ANSI X3.64-ESC Funktionen fr Fett-, Kursiv-,
   Underline- und 4-Farbendruck. Auerdem werden einige Spezialzeichen aus
   dem erweiterten ANSI-Zeichensatz verwendet, z.B:  vorallem 
     Das Programm an sich verwendet (fast) ausschlielich C-Funktionen
   und wurde kompiliert mit Aztec-C v3.6, der leider (noch) nicht ANSI-
   genormt war. Daher sind u.a. einige Typen nicht korrekt benannt. Ein
   paar Amiga-spezifische Funktionen aus der Intui.lib sind auch noch zu
   berprfen. Alle Ausgaben gehen aber ins normale Shell-Fenster raus.
     Alle #include's habe ich mal in ein PRECOMP-file vorkompiliert, um die
   bersetzungszeit zu beschleunigen. Ich wei daher nicht,welche #includes
   eigentlich gebraucht wrden.
*/

#ifdef pc
  #include <stdio.h>
  #include <io.h>
  #include <fcntl.h>

  #define FALSE 0
  #define TRUE 1
  typedef UBYTE unsigned char;
  typedef BOOL int;

  #define Seek lseek
  #define Read read
  #define Open open
  #define Close close
  #define OFFSET_BEGINNING SEEK_SET
  #define MODE_OLDFILE O_RDONLY|O_BINARY
#endif

/*Ein paar Basisstellen des MOD-Formats*/
#define SAM_BASE   20
#define SAM_MAX    32
#define PATL_INFO  950
#define PATL_START 952
#define PAT_BASE   1084
#define PAT_INCR   1024
#define PAT_MAX    128

#ifndef pc
  #define MEMTYPE    (MEMF_PUBLIC|MEMF_CLEAR)   /*normaler leerer Speicher*/

  struct  Library    *IntuitionBase=NULL; /* fr memory-management ntig*/
  struct  Remember   *RemKey=NULL;       /* Speicherverwaltungsstruktur*/
  struct  FileHandle *file=NULL;        /* Laden: Indizierbare Datei */
#else
  int file=0;
#endif

UBYTE   *filebuffer=NULL,       /* Platz zum Laden */
        filename[10][256];      /* Namen der Files */
BOOL    show_all,               /* Arg.: alles anzeigen */
        show_cia_speed,         /* Arg.: CIA-Speed-Kommandos listen */
        show_command,           /* Arg.: Kommandos listen */
        show_pat_count,         /* Arg.: PatternInfo anzeigen */
        show_used_only,         /* Arg.: nur benutzte Patterns auswerten */
        show_sam_count,         /* Arg.: Samplezhlung anzeigen */
        show_com_count,         /* Arg.: Kommandozhlung anzeigen */
        show_arrangement,       /* Arg.: Pattern Arrangement */
        show_sam_replay;        /* Arg.: Sample Replay Stellen*/
int     seek4command=0,         /* Arg.wert: Dieses Kommando zeigen*/
        seek4sample=0;          /* Arg.wert: Dieses Sample zeigen*/

char   *modname[]={
           "Protracker",
           "Noisetracker",
           "Protracker, using more than 64 patterns",
           "Startrekker, using 4 channels",
           "Startrekker, using 8 channels",
           "-","-","-","-","-",
           "ProRunner mod (packed PT-mod)",
           "UNIC mod (Laxitys NT-version)",
           "KRIS mod (4-Mats commercial NT-version)",
           "-","-","-","-","-","-","-" },
       *com_name[16]={
           "Arpeggio","Slide up smooth","Slide down smooth",
           "Slide to note","Vibrato oscillate",
           "Cont. command 3+Volume slide",
           "Cont. command 4+Volume slide",
           "Tremolo","<unused>","Sample offset",
           "Volume slide","Position jump",
           "Sample volume","Pattern break",
           "Special effects","Speed setting" },
       *spc="                                                                                ",
       *top="";


/******* allgemeine Unterroutinen ****************************************/

void cleanup()
{
#ifdef pc
  if (filebuffer) { free(filebuffer); filebuffer=NULL; }
#else
  if (RemKey)  { FreeRemember(&RemKey,TRUE); RemKey=NULL; } /* Speicher freigeben*/
  if (IntuitionBase)  CloseLibrary(IntuitionBase);
#endif
  if (file)  { Close(file); file=NULL; }
}

void error(fm)  char *fm;
{
  printf("\n  Can't find \033[33m`%s'\033[0m\n\n",fm);
  cleanup(); exit(1);
}

#ifndef pc
void openall()
{
  if (!(IntuitionBase= OpenLibrary("intuition.library",0)))
     error("Intuition-Library");
}
#endif

/******* spezielle Unterroutinen ****************************************/

void print_help(callsign)
char *callsign;
{
  printf("\n   \033[32;43m\033[0m");
  printf("\n   \033[32;43m    __ _ _\033[31m                                       \033[32m\033[0m");
  printf("\n   \033[32;43m   /  \\|\\|\\'s  PT/NT/ST  MOD-Info, Version 1-Z   \033[32m\033[0m");
  printf("\n   \033[32;43m   \\___| ` \\\033[31m   1993 Christian Marz, 08.Oct.93   \033[32m\033[0m");
  printf("\n   \033[32;43m   \033[31mported to MS-DOS by Robert Kukla, 15.Sep.93   \033[32m\033[0m");
  printf("\n   \033[32;43m                                                 \033[0m");
  printf("\n   \033[32;43m\033[0m\n\n");
  printf("   \033[4;1;33mUsage:\033[0m    \033[3m%s \033[0m {options} [filename(s)]\n\n",callsign);
  printf("   \033[4;33mFilename:\033[0m  - praefix/suffix `\033[0;32mmod\033[0m' will be added if needed.\n");
  printf("              - a filename including spaces are not recognized.\n");
  printf("   \033[4;33mOptions:\033[0m  default setting is  \033[32m-fas\033[0m\n");
  printf("       \033[32m-u\033[0m    count only in \033[32;1mU\033[0msed \033[0mpatterns\n");
  printf("       \033[32m-p\033[0m    show \033[32;1mP\033[0mattern usage\n");
  printf("       \033[32m-a\033[0m    show \033[32;1mA\033[0mrrangement of patterns\n");
  printf("       \033[32m-c\033[0m    show \033[32;1mC\033[0mommand statistics\n");
  printf("       \033[32m-l\033[0mx   show \033[32;1mL\033[0mocations of command $x\n");
  printf("       \033[32m-f\033[0m    show \033[32;1mF\033[0mxy speed commands >=$20 (ProTrackers CIA-timer)\n");
  printf("       \033[32m-s\033[0m    show \033[32;1mS\033[0mample information\n");
  printf("       \033[32m-r\033[0mxy  show \033[32;1mR\033[0meplay locations of sample $xy (-r!xy for decimal value)\n");
  printf("   \033[3;33mKnown Bugs: \033[0m breaking with CTRL-C will not give free allocated mem!\n\n");
}
/*------------------------------------------------------------------*/
char  *note(n)
   int n;
{
   if (n>900)  switch(n) {
/* Note:    C    C#   D    D#   E    F    F#   G    G#   A    A#   B */
/*Octave 0:1712,1616,1525,1440,1357,1281,1209,1141,1077,1017, 961, 907*/
      case 1712:  return("\033[33mC-0\033[0m");
      case 1616:  return("\033[33mC#0\033[0m");
      case 1525:  return("\033[33mD-0\033[0m");
      case 1440:  return("\033[33mD#0\033[0m");
      case 1357:  return("\033[33mE-0\033[0m");
      case 1281:  return("\033[33mF-0\033[0m");
      case 1209:  return("\033[33mF#0\033[0m");
      case 1141:  return("\033[33mG-0\033[0m");
      case 1077:  return("\033[33mG#0\033[0m");
      case 1017:  return("\033[33mA-0\033[0m");
      case  961:  return("\033[33mA#0\033[0m");
      case  907:  return("\033[33mB-0\033[0m");
      default:  return("\033[33;1mbug\033[0m");
   }
   else if (n>450) switch(n) {
/*Octave 1: 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453*/
      case 856:  return("C-1");
      case 808:  return("C#1");
      case 762:  return("D-1");
      case 720:  return("D#1");
      case 678:  return("E-1");
      case 640:  return("F-1");
      case 604:  return("F#1");
      case 570:  return("G-1");
      case 538:  return("G#1");
      case 508:  return("A-1");
      case 480:  return("A#1");
      case 453:  return("B-1");
      default:  return("\033[33;1mbug\033[0m");
   }
   else if (n>220) switch(n) {
/*Octave 2: 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226*/
      case 428:  return("C-2");
      case 404:  return("C#2");
      case 381:  return("D-2");
      case 360:  return("D#2");
      case 339:  return("E-2");
      case 320:  return("F-2");
      case 302:  return("F#2");
      case 285:  return("G-2");
      case 269:  return("G#2");
      case 254:  return("A-2");
      case 240:  return("A#2");
      case 226:  return("B-2");
      default:  return("\033[33;1mbug\033[0m");
   }
   else if (n>110) switch(n) {
/*Octave 3: 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113*/
      case 214:  return("C-3");
      case 202:  return("C#3");
      case 190:  return("D-3");
      case 180:  return("D#3");
      case 170:  return("E-3");
      case 160:  return("F-3");
      case 151:  return("F#3");
      case 143:  return("G-3");
      case 135:  return("G#3");
      case 127:  return("A-3");
      case 120:  return("A#3");
      case 113:  return("B-3");
      default:  return("\033[33;1mbug\033[0m");
   }
   else switch(n) {
/*Octave 4: 107, 101,  95,  90,  85,  80,  76,  71,  67,  64,  60,  57*/
      case 107:  return("\033[33mC-4\033[0m");
      case 101:  return("\033[33mC#4\033[0m");
      case  95:  return("\033[33mD-4\033[0m");
      case  90:  return("\033[33mD#4\033[0m");
      case  85:  return("\033[33mE-4\033[0m");
      case  80:  return("\033[33mF-4\033[0m");
      case  76:  return("\033[33mF#4\033[0m");
      case  71:  return("\033[33mG-4\033[0m");
      case  67:  return("\033[33mG#4\033[0m");
      case  64:  return("\033[33mA-4\033[0m");
      case  60:  return("\033[33mA#4\033[0m");
      case  57:  return("\033[33mB-4\033[0m");
      default:  return("\033[33;1mbug\033[0m");
   }
}
/*-------------------------------------------------------------------*/
void print_head()   /*tabellenkopf fr Speedkommandos*/
{
  printf("   \033[4m%.37s\033[0m\n",spc);
  printf("   |\033[32m pattern \033[31m|\033[32m track \033[31m|\033[32m position \033[31m|\033[32m $Fxx \033[31m|\033[0m\n");
}
/*------------------------------------------------------------------*/
void print_patterns(upat,pm,maxpos,used)
   UBYTE *upat;
   int   pm,maxpos,used;
{
   int  p,i, t=0, z=16;
   printf("   \033[43;7;1m Pattern Usage: \033[0m  %d patterns total (%d used), %d arranged into song.\n",pm+1,used,maxpos);
   do {
      p= (pm-t>=z) ? t+z : t+pm%z+1;
      printf("   \033[4m        ");
      for (i=t; i<p; i++)  printf("    ");
      printf("\033[0m\n   |\033[32mpattrn\033[0m|");
      for (i=t; i<p; i++)  printf("\033[32m %-2d\033[0m|",i);
      printf("\033[0m\n   \033[4m|used *|");
      for (i=t; i<p; i++)
         if (upat[i]>0)  printf(" %-2d|",upat[i]);
                   else  printf("\033[33mNOT\033[0;4m|");
      printf("\033[0m\n");
      t+=z;
   } while (t<=pm);
   printf("\n");
}
/*------------------------------------------------------------------*/
void print_arrangement(pbrk,pn,pm,mpos,used,maxpos)
  UBYTE  *pbrk, *pn;
  int    pm, mpos, used, maxpos;
{
   int   i,p,x,t=0,z=22,zl,zlr;
   printf("   \033[43;7;1m Pattern Arrangement: \033[0m  %d in total (%d used), %d arranged into song.\n",pm+1,used,mpos);
   maxpos--;
   p= (maxpos-t>=z) ? t+z : t+maxpos%z+1;
   zl= (p-t)*3+6;
   printf("   \033[4m");
   for (i=0; i<zl; i++)  printf(" ");
   printf("\033[0m\n");
   do {
      printf("   |\033[32mpos\033[0m|\033[32m");
      for (i=t; i<p; i++)  if (i>109) printf("`%2d",i-100);
                           else if (i>99) printf("`0%1d",i-100);
                                else printf("%3d",i);
      printf("\033[0m|\n   |pat|");
      for (i=t; i<p; i++)  printf("%3d",pn[i]);
      printf("\033[0m|\n   |\033[33mbrk\033[0m|\033[33;1m");
      for (i=t; i<p; i++)
         if (pbrk[pn[i]]==0)  printf("\033[33;1m---");
         else if (pbrk[pn[i]] > 128)
            if ((x=254-pbrk[pn[i]]) > 9)
               printf("\033[0;33m%2d>",x);
            else
               printf("\033[0;33m>%1d>",x);
         else
            if ((x=pbrk[pn[i]]-1) > 99)
               printf("\033[0;32m%3d",x);
            else if (x > 9)
               printf("\033[0;32m^%2d",x);
            else
               printf("\033[0;32m^%1d^",x);
      printf("\033[0m|\n");
      t+=z;
      p= (maxpos-t>=z) ? t+z : t+maxpos%z+1;
      zl= (p-t)*3+6;
      zlr= (z*3+6)-zl;
      if (t>maxpos)                      /*Am Ende nichts unterstr.*/
         { zlr=0; printf("   \033[0;1m"); }
      else
         printf("   \033[4;1m");         /*Kein Ende: Ober+Unterstreichen*/
      for (i=0; i<zl; i++)  printf("");
      printf("\033[0;1m");
      for (i=0; i<zlr; i++)  printf("");
      printf("\033[0m\n");
   } while (t<=maxpos);
}
/*------------------------------------------------------------------*/
void print_commands(comcnt,comEcnt)
   int  *comcnt, *comEcnt;
{
   int i;
   printf("   \033[43;7;1m Command Statistics: \033[0m\n   \033[4m         ");
   for (i=0; i<16; i++)
       if (comcnt[i]>999)     printf("     ");
       else if (comcnt[i]>99) printf("    ");
       else                   printf("   ");
   printf("\033[0m\n   |\033[32mcommand\033[0m|");
   for (i=0; i<16; i++)
       if (comcnt[i]>999)     printf("\033[32m $%1x \033[0m|",i);
       else if (comcnt[i]>99) printf("\033[32m $%1x\033[0m|",i);
       else                   printf("\033[32m$%1x\033[0m|",i);
   printf("\033[0m\n   \033[0m| count |");
   for (i=0; i<16; i++)
       if (comcnt[i]>999)     printf("%4d|",comcnt[i]);
       else if (comcnt[i]>99) printf("%3d|",comcnt[i]);
       else                   printf("%2d|",comcnt[i]);
   printf("\033[0m\n   \033[1m");
   for (i=0; i<16; i++)
       if (comcnt[i]>999)     printf("");
       else if (comcnt[i]>99) printf("");
       else                   printf("");
   printf("\033[0m\n");
   if (comcnt[0xE]) {             /*Spezial-Kommando $E..*/
      printf("   \033[4m /\\ ");
      for (i=0; i<16; i++)
          if (comEcnt[i]>999)     printf("     ");
          else if (comEcnt[i]>99) printf("    ");
          else                    printf("   ");
      printf("\033[0m\n   |\033[32mcom.$E_\033[0m|");
      for (i=0; i<16; i++)
          if (comEcnt[i]>999)     printf("\033[32m $%1x \033[0m|",i);
          else if (comEcnt[i]>99) printf("\033[32m $%1x\033[0m|",i);
          else                    printf("\033[32m$%1x\033[0m|",i);
      printf("\033[0m\n   \033[0m| count |");
      for (i=0; i<16; i++)
          if (comEcnt[i]>999)     printf("%4d|",comEcnt[i]);
          else if (comEcnt[i]>99) printf("%3d|",comEcnt[i]);
          else                    printf("%2d|",comEcnt[i]);
      printf("\033[0m\n   \033[1m");
      for (i=0; i<16; i++)
          if (comEcnt[i]>999)     printf("");
          else if (comEcnt[i]>99) printf("");
          else                    printf("");
      printf("\033[0m\n");
   }
}

/************************************************************************/

void look_in_patterns()
{
   struct samples{               /* Protracker Sampledaten */
             UBYTE  name[24];
             int    vol, fine;
             long   len, rep, rlen;
          } samp[SAM_MAX];
   UBYTE  buffer[32],
          patterns[PAT_MAX],
          used_pat[PAT_MAX],
          pat_break[PAT_MAX];
   int    com_count[16],          /*Kommandos 1-7,9-F*/
          comE_count[16],         /*E-Kommandos 0-7,9-F*/
          sam_count[32],
          max_pos, pm, last_pos,
          cia_speed,
          t, p, firstfound,
          restartpos, used;
   long   tl;

   register int    i, base2, base3, command, base0;
   register UBYTE  value;
   BOOL   headed=FALSE;

   for (i=1; i<SAM_MAX; i++) {          /* Sample-Daten einlesen */
      sam_count[i]=0;
      Seek (file,SAM_BASE+(i-1)*30,OFFSET_BEGINNING);
      Read (file,buffer,32);
      for (t=0; t<22; t++)
         samp[i].name[t]= (buffer[t] & 0x7f) < 32 ? 0 : buffer[t];
      samp[i].name[21]= 0;
      samp[i].len= ((long)buffer[22])*512+((long)buffer[23])*2;
      samp[i].fine= buffer[24] & 0x0F;
      samp[i].vol= buffer[25];
      samp[i].rep= ((long)buffer[26])*512+((long)buffer[27])*2;
      samp[i].rlen= ((long)buffer[28])*512+((long)buffer[29])*2;
   }
   Seek (file,PATL_INFO,OFFSET_BEGINNING);  /* Musteranzahl lesen*/
   Read (file,buffer,2);
   max_pos= buffer[0];
   restartpos= buffer[1];            /*Noisetracker Restartpos.*/
      /***vorlufig unbenutzt!***/
   Seek (file,PATL_START,OFFSET_BEGINNING);
   Read (file,patterns,PAT_MAX);
   pm=used=0;
   for (i=0; i<PAT_MAX; i++) {          /* hchste Musternummer finden */
      if (patterns[i]>pm)  pm=patterns[i];
      used_pat[i]=pat_break[i]=0;
   }
   last_pos=PAT_MAX;
   while (last_pos>max_pos && patterns[last_pos-1]==0)  last_pos--;
   for (i=0; i<max_pos; i++)  used_pat[patterns[i]]++;  /*Muster zhlen*/
   used=0;
   for (i=0; i<max_pos; i++)  if (used_pat[i]>0) used++;  /*gebr. Muster z.*/

   if (show_command || show_cia_speed || show_com_count || show_sam_count
         || show_arrangement || show_sam_replay) {
      /*Ansonsten braucht man nicht die Patterns einzuladen*/
      /*Achtung: File ist noch offen aus main()*/
#ifdef pc
      filebuffer = (char*) malloc((pm+1)*PAT_INCR);
#else
      filebuffer= (UBYTE*) AllocRemember(&RemKey,(pm+1)*PAT_INCR,MEMTYPE);
#endif
      if (filebuffer <= 0) {
         printf ("   \033[32mJerk, I wanna have \033[33m%d Bytes\033[32m in one piece! Please buy more RAM.\n\n",(pm+1)*PAT_INCR);
         return;
      }
      else {
         Seek (file,PAT_BASE,OFFSET_BEGINNING);
         Read (file,filebuffer,(pm+1)*PAT_INCR);
      }
   }
   Close(file); file=NULL;   /*Jetzt kann mans erledigen!*/
   /*alles andere hat jetzt geladene Patterns zur Verfgung*/

   if (show_cia_speed)  /***und allgemeine Daten errechnen***/
      printf("   \033[43;7;1m ProTracker CIA-Speeds: \033[0m  looking for F-xy values >=$20\n");
   for (i=0; i<16; i++)  { com_count[i]=comE_count[i]=0; }
   cia_speed=0;
   firstfound=-1;
   for (p=0; p<=pm; p++)
      if (used_pat[p]>0 || !show_used_only) {
          /* alle Muster (die auch gespielt werden - rob) */
         for (t=0; t<4; t++) {               /* alle 4 Tracks */
            base3=(base2=(base0=p*PAT_INCR+t*4)+2)+1;
            for (i=0; i<PAT_INCR; i+=16) {   /* alle 64 Zeilen */
               /*** Diverse Berechnungen: ***/
               com_count[command=((value=filebuffer[base2+i]) & 0x0F)]++;
               sam_count[((value & 0xF0)>>4)+(filebuffer[base0+i] & 0x10)]++;
               if (!command && !filebuffer[base3+i])  com_count[0]--;
                  /* entspricht nun auch den 0-xy Kommandos*/
               if (show_arrangement && p>firstfound) {
                  if (command==0xB) { /*Wert in Hex-Ziffern gespeichert*/
                     pat_break[p]=filebuffer[base3+i]+1;
                     firstfound=p;
                  }
                  if (command==0xD) { /*Wert in Dez.Zif.!->noch umrechnen*/
                     int t=filebuffer[base3+i];
                     pat_break[p]=254-((t/16)*10+t%16);
                     firstfound=p;
                  }
               }
               if (command==0xE) {
                  comE_count[((UBYTE)filebuffer[base3+i] & 0xF0)>>4]++;
               }
               if (command==0xF && show_cia_speed) {
                  if (filebuffer[base3+i] > 0x1F) {
                     cia_speed++;
                     if (show_cia_speed) {
                        if (! headed) { print_head(); headed=TRUE; }
                        printf("   |   %2d    |   %1d   |    %2d    |  \033[33m%2x\033[0m  |\n",p,t,i/16,filebuffer[base3+i]);
                     }
                  }
               } /*ENDE: Speedcommandos auflisten*/
            }  /*alle scores*/
         }  /*alle tracks*/
      } /*alle Muster zhlen, falls -used */
   if (show_cia_speed) {
      if (headed)
         printf("   \033[1m%.37s\033[0m\n",top);
      else  printf("\n");
      printf("   \033[4;1mTotal:\033[0m  %d speed commands of which have %d a speed set >=$20\n\n",com_count[0xF],cia_speed);
   }

   if (show_pat_count) {
      print_patterns(used_pat,pm,max_pos,used);
   }

   if (show_arrangement) {
      print_arrangement(pat_break,patterns,pm,max_pos,used,last_pos);
   }

   if (show_command) {
      static int  com[4], comval[4];
      int  found;
      printf("   \033[43;7;1m Command Locations: \033[0m  %d locations of `\033[1m%x\033[0m'=`%s'\n",com_count[seek4command],seek4command,com_name[seek4command]);
      printf("   \033[4m%.50s\033[0m\n",spc);
      printf("   |\033[32mpattern\033[31m|\033[32mposition\033[31m|\033[32mtrack-0\033[31m|\033[32mtrack-1\033[31m|\033[32mtrack-2\033[31m|\033[32mtrack-3\033[31m|\033[0m\n");
      for (p=0; p<=pm; p++)
         if (used_pat[p]>0 || !show_used_only) {
            base0=p*PAT_INCR+2;
            for (i=0; i<PAT_INCR; i+=16) {      /* alle 64 Pattern-Zeilen */
               base3=(base2=base0+i)+1;
               found=0;
               for (t=0; t<4; t++) {            /* alle 4 Tracks */
                  if (seek4command==(com[t]=(int)(filebuffer[base2+(t<<2)] & 0x0F)))
                     found++;
                  comval[t]=(int)filebuffer[base3+(t<<2)];
               }
               if (found>0) {
                  printf("   |  %2d   |   %2d   |",p,i/16);
                  for (t=0; t<4; t++) {
                     if (seek4command==com[t])
                        printf("  $\033[33m%2x\033[0m  |",comval[t]);
                     else
                        printf("       |");
                  }
                  printf("\n");
               }
            }  /*alle Zeilen im Pattern*/
         } /*alle Muster zhlen, falls -used */
      printf("   \033[1m%.50s\033[0m\n",top);
   }

   if (show_com_count) {
      print_commands(com_count,comE_count);
   }

   if (show_sam_replay) {
      static   int  sam[4], samval[4];
      register int  found, samp;
      printf("   \033[43;7;1m Sample Replay Locations: \033[0m  %d replay locations of sample #\033[1m%d\033[0m.\n",sam_count[seek4sample],seek4sample);
      printf("   \033[4m%.50s\033[0m\n",spc);
      printf("   |\033[32mpattern\033[31m|\033[32mposition\033[31m|\033[32mtrack-0\033[31m|\033[32mtrack-1\033[31m|\033[32mtrack-2\033[31m|\033[32mtrack-3\033[31m|\033[0m\n");
      for (p=0; p<=pm; p++)
         if (used_pat[p]>0 || !show_used_only) {
            for (i=0; i<PAT_INCR; i+=16) {      /* alle 64 Pattern-Zeilen */
               base2=(base0=p*PAT_INCR+i)+2;
               found=0;
               for (t=0; t<4; t++) {   /* alle 4 Tracks */
                  if (seek4sample==
                     (sam[t]=(int)((filebuffer[base2+(t<<2)] & 0xF0)>>4)
                                 + (filebuffer[base0+(t<<2)] & 0x10) ))
                     found++;
                  samval[t]=((filebuffer[base0+(t<<2)] & 0x0F)<<8)
                           + (filebuffer[base0+(t<<2)+1]) ;
               }
               if (found>0) {
                  printf("   |  %2d   |   %2d   |",p,i/16);
                  for (t=0; t<4; t++) {
                     if (seek4sample==sam[t])
                        printf("  %s  |",note(samval[t]));
                     else
                        printf("       |");
                  }
                  printf("\n");
               }
            }  /*alle Zeilen im Pattern*/
         } /*alle Muster zhlen, falls -used */
      printf("   \033[1m%.50s\033[0m\n",top);
   }

   /*Speicher wieder freigeben, damit es sich bei Multi-Names nicht sammelt:*/
#ifdef pc
   if (filebuffer) { free(filebuffer); filebuffer=NULL; }
#else
   if (RemKey)  { FreeRemember(&RemKey,TRUE); RemKey=NULL; }
#endif

   if (show_sam_count) {
      t=0;
      for (i=1; i<SAM_MAX; i++)  if (sam_count[i]>0) t++;
      printf("   \033[43;7;1m Sample Usage: \033[0m  module contains %d played samples.\n",t);
      printf("   \033[4m%.73s\033[0m\n",spc);
      printf("   |\033[32m$nb\033[31m|\033[32m samplename / songtext \033[31m|\033[32m$v\033[31m|\033[32mft\033[31m|\033[32m$len.\033[31m|\033[32m$junk\033[31m|\033[32mcount\033[31m|\033[32m comments          \033[31m|\033[0m\n");
      for (i=1; i<SAM_MAX; i++) {
         if (sam_count[i]>0 || samp[i].len>2) {
            if (samp[i].rep==0 && samp[i].rlen<=2)
               tl=0;
            else {
               tl=samp[i].len-samp[i].rep-samp[i].rlen;
               if (tl<0)  tl=0;
            }
            printf("   |%2x | %-21s |",i,samp[i].name);
            if ((samp[i].vol==0) && (sam_count[i]>0))
               printf("\033[33m 0\033[0m|");
            else
               printf("%2x|",samp[i].vol);
            if (samp[i].fine>7)
               printf("\033[33m-%1x\033[0m|",16-samp[i].fine);
            else if (samp[i].fine>0)
               printf("\033[33m+%1x\033[0m|",samp[i].fine);
            else
               printf("%2x|",samp[i].fine);
            if (samp[i].len>0xFFFF)
               printf("\033[33m%5lx\033[0m|",samp[i].len);
            else
               printf("%4lx |",samp[i].len);
            if (tl>0xFFFF)
               printf("%5lx|",tl);
            else
               printf("%4lx |",tl);
            if (sam_count[i]>9999)
               printf("%5d|",sam_count[i]);
            else
               printf("%4d |",sam_count[i]);
            if (sam_count[i]==0 && samp[i].len>0)
               printf("\033[33;3;1mloaded but unused! \033[0m|\n");
            else if (sam_count[i]>0 && samp[i].rlen==0)
               printf("\033[33;3;1mbad repeat length! \033[0m|\n");
            else if (tl>255)
               printf("\033[33;1mcut overhead junk! \033[0m|\n");
            else if (sam_count[i]>0 && samp[i].len==0)
               printf("\033[33;3m empty but played  \033[0m|\n");
            else
               printf(" good              |\n");
         } /*if exists sample*/
      } /*for each sample*/
      printf("   \033[1m%.73s\033[0m\n",top);
   }
}

/******* Hauptprogramm ***************************************************/

main (argc,argv)
     int   argc;
     char  *argv[];
{
  int   i, j, names, name, check;
  UBYTE marker[8],         /*kleiner Buffer fr 4 Zeichenmarkierung*/
        fname[260];        /*Filename*/
  BOOL  bad, exists;

  show_command=show_cia_speed=show_pat_count=show_com_count=FALSE;
  show_sam_count=show_used_only=show_arrangement=show_sam_replay=FALSE;
  show_all= bad= TRUE;
  names=0;
  for (i=1; i<argc; i++) {
     if (argv[i][0]=='-') {
        for (j=1; argv[i][j]>' '; j++) {
           if  ((argv[i][j]=='p') || (argv[i][j]=='P'))
              { show_pat_count=TRUE; show_all=FALSE; }
           else if ((argv[i][j]=='a') || (argv[i][j]=='A'))
              { show_arrangement=TRUE; show_all=FALSE; }
           else if ((argv[i][j]=='f') || (argv[i][j]=='F'))
              { show_cia_speed=TRUE; show_all=FALSE; }
           else if ((argv[i][j]=='c') || (argv[i][j]=='C'))
              { show_com_count=TRUE; show_all=FALSE; }
           else if ((argv[i][j]=='s') || (argv[i][j]=='S'))
              { show_sam_count=TRUE; show_all=FALSE; }
           else if ((argv[i][j]=='u') || (argv[i][j]=='U'))
              show_used_only=TRUE;
           else if ((argv[i][j]=='l') || (argv[i][j]=='L')) {
              sscanf(&argv[i][++j],"%1x",&seek4command); /*1 HEX-ZEichen lesen*/
              if (seek4command<1 || seek4command>15) {
                 printf("   \033[0mA command $\033[33m%1x\033[0m does not exist.\n",seek4command);
              }
              else {
                 show_command=TRUE; show_all=FALSE;
              }
           }
           else if ((argv[i][j]=='r') || (argv[i][j]=='R')) {
              j++;
              if (argv[i][j]=='!')              /*2 DEZ-Zeichen lesen*/
                 sscanf(&argv[i][++j],"%2d",&seek4sample);
              else                              /*2 HEX-Zeichen lesen*/
                 sscanf(&argv[i][j],"%2x",&seek4sample);
              if (argv[i][j+1]!=' ') j++;
              if (seek4sample<1 || seek4sample>31) {
                 printf("   \033[0mA sample with a number of $\033[33m%x\033[0m does not exist.\n",seek4sample);
              }
              else {
                 show_sam_replay=TRUE; show_all=FALSE;
              }
           }
           else
              printf("   \033[0mWhat in hell should option -\033[33m%c\033[0m do?\n",argv[i][j]);
        }
     }
     else {
        if (names<10)  {
           strncpy(filename[names],argv[i],255);
           names++; bad=FALSE;
        }
        else
           printf("   Max. 10 filenames should be given!  `\033[33m%s\033[0m' was ignored.\n",argv[i]);
     }
  }
  if (bad)  {
     print_help(argv[0]);
     exit(0);
  }
  if (show_all) {
     show_com_count= FALSE;
     show_cia_speed= show_arrangement= show_sam_count= TRUE;
  }

#ifndef pc
  openall();
#endif

  for (name=0; name<names; name++) {
     printf("   \033[4m            \033[0m\n   \033[43;7;1m MODinf 1.Z \033[0m  checking:  \033[33m%s\n",filename[name]);
     printf("   \033[0;42;7m 1993\033[1;3m C/V\\ \033[0m  mod-type:  ");
     strcpy(fname,filename[name]);
     exists=TRUE;
     file= Open(fname,MODE_OLDFILE);
     if (file<=0) {                     /*normaler Filename*/
        i=strlen(fname); /*Anfangen mit \0 */
        do {
           fname[i+4]=fname[i]; i--;
        } while(i>=0 && fname[i]!='/' && fname[i]!='\\' && fname[i]!=':');
        strncpy(&fname[i+1],"MOD.",4);
        file= Open(fname,MODE_OLDFILE);  /*Filename mit Prfix "MOD." */
        if (file<=0) {
           strcpy(fname,filename[name]);
           strcat(fname,".MOD");
           file= Open(fname,MODE_OLDFILE); /*Filename mit Suffix ".MOD" */
           if (file<=0) {
              exists=FALSE;
              printf("\n\n   \033[32mArgh! I can't find \033[33m`%s'\033[0m\n\n",filename[name]);
           }
        }
     }
     if (exists) { /*File exists*/
        Seek (file,PAT_BASE-4,OFFSET_BEGINNING);
        Read (file,marker,4);
        check=20;
        if (!strncmp(marker,"M.K.",4))  check=0;
        if (!strncmp(marker,"M!K!",4))  check=2;
        if (!strncmp(marker,"FLT4",4))  check=3;
        if (!strncmp(marker,"FLT8",4))  check=4;
        if (!strncmp(marker,"SNT!",4))  check=10;
        if (!strncmp(marker,"UNIC",4))  check=11;
        if (!strncmp(marker,"KRIS",4))  check=12;
        Seek (file,PATL_INFO,OFFSET_BEGINNING);
        Read (file,marker,4);
        if (check==0 && (UBYTE)marker[1]<0x7F)  check=1;   /*99% Noisetracker!*/
        if (check>10) {
           if (check<20)
              printf("\033[32m%s\033[0m\n\n   No further checking possible.\n\n",modname[check]);
           else
              printf("\n\n   \033[32mBoy, this isn't any PT/NT/ST-Module with 31 samples!!!\033[0m\n\n");
           Close(file); file=NULL;              /* unbedingt erledigen! */
        }
        else {
           printf("\033[32m%s\033[0m\n\n",modname[check]);
           look_in_patterns();                  /* enthlt auch: Close(file) */
        }
     } /*file exists?*/
  } /*each file*/
  cleanup();
  return(0);
}



/*End of Transmission*/
