; #########################################################################
; # this file contains all common include files, macros, protos etc.
; # it should be included first in all asm files in this project. zathan.
; #########################################################################

      .386	
      .model flat, stdcall			; all files should be win32
      option casemap :none   			; case sensitive

; #########################################################################
; # includes
; #########################################################################

      include windows.inc			
      include user32.inc
      include kernel32.inc
      include comctl32.inc			
;      include gdi32.inc				
      include wsock32.inc			; winsocket
      include resource.inc                      ; for resource constants

      includelib user32.lib
      includelib kernel32.lib
      includelib comctl32.lib
;      includelib gdi32.lib
      includelib wsock32.lib

; #########################################################################
; # macros
; #########################################################################

      szText MACRO Name, Text:VARARG
        LOCAL lbl
          jmp lbl
            Name db Text,0
          lbl:
        ENDM

      m2m MACRO M1, M2
        push M2
        pop  M1
      ENDM

      return MACRO arg
        mov eax, arg
        ret
      ENDM

; #########################################################################
; # procedures
; #########################################################################

        WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD	; in WinMain.asm

        WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD	; in WndProc.asm
        AddViewString PROTO :DWORD                      ; in WndProc.asm

	GetWordCount PROTO :DWORD			; in strings.asm
	GetWordPtr PROTO :DWORD,:DWORD			; in strings.asm
	GetWordLength PROTO :DWORD			; in strings.asm

	OnConnect PROTO 				; in IRCSocket.asm
	ReadSocket PROTO				; in IRCSocket.asm
	WriteSocket PROTO				; in IRCSocket.asm
	OnDisconnect PROTO				; in IRCSocket.asm
	IRCCommand PROTO :DWORD				; in IRCSocket.asm
	SendIRCString PROTO :DWORD			; in IRCSocket.asm

        wsprintfA PROTO C :DWORD, :DWORD, :VARARG	; in kernel32.lib 
	wsprintf EQU <wsprintfA>			; but not in kernel32.inc

; #########################################################################
; # constants
; #########################################################################

        VERSION         TEXTEQU         <"0.17">
        MAX_STRLEN      EQU             0200h   ; 512 char string buffers 
