; #########################################################################
; # this file contains useful string operations that I could not find a 
; # usable API call for. 
; # all functions by zathan unless otherwise specified. 
; # feel free to use these in your own programs.
; #########################################################################

	include asmIRC.inc

.code
; #########################################################################
; # GetWordCount searches a string for spaces and returns the # of words
; # Notes: if the string contains only spaces it returns 1 instead of 0...
; # it looks for spaces only, so tabs, lf, cr etc does not seperate words
; #########################################################################
GetWordCount proc lpszString:DWORD

    mov edi, lpszString
    invoke lstrlen, edi		    ; get string length
    .if eax==NULL
  	return 0		    ; exit right away for 0-length strings
    .endif
    mov ecx,eax			    ; ecx = strlen
    xor ebx,ebx			    ; ebx = wordcount
    mov al,' '             	    ; look for space

@L1:
    mov edx, edi		    ; remember last position

    repnz scasb			    ; look for space

    inc edx			    ; if edx==edi then this space is right 
    cmp edx,edi                     ; after the last space found
    je @L1			    ; so ignore it and start over

    inc ebx		            

    or ecx,ecx
    jnz @L1

    return ebx			    ; ebx = wordcount

GetWordCount endp ; #######################################################

; #########################################################################
; # GetWordPtr returns a pointer to word n in a string
; # Notes: if n > words in string then returns address of terminating zero
; #        0,1 = first word, 2 = second word etc.
; #########################################################################
GetWordPtr proc lpszString:DWORD, n:DWORD

    invoke lstrlen, lpszString
    mov ecx, eax		   	; ecx=strlen
    mov ebx, n    			; ebx=# of word we want
    mov edi, lpszString			; edi=in string
    mov al, ' ' 			; space

    or ebx,ebx				; get 0th word?
    jz @EXIT

@L1:
    mov edx, edi			; edx=address of current word
    repnz scasb				; find next word
    dec ebx				; was it the right word?
    jnz @L1				; no, find next
					; yes, return the address
    return edx				; return address of the word

@EXIT:
    return edi				; return address of the string

GetWordPtr endp ; #########################################################

; #########################################################################
; # GetWordLength returns the length of a word in a string.
; #########################################################################
GetWordLength proc lpszString:DWORD

    invoke lstrlen, lpszString
    mov ecx,eax			; ecx=strlen
    mov ebx,ecx			; ebx=strlen
    mov edi, lpszString
    mov al,' '

    repnz scasb 		; look for space
    jnz @EXIT
        			; ecx=length of remaining string
    inc ecx			; take the space after word into account
    sub ebx,ecx			; ebx=length of string - length after word
@EXIT:
    return ebx

GetWordLength endp ; ######################################################

end