;@GOTO TRANSLATE

COMMENT  $

Author
------
EliCZ

Observation
-----------
My AMD K6 is TOO good in recognizing instructions when DRX system is active.

Conditions
----------
AMD K6 CPU (all modes), ES and CS address the same space, DRX active,
instruction REPE/REPNE STOSB/MOVSB  must be overwritten by itself

	 $

.586P
.MODEL FLAT, STDCALL

 EXTRN ExitProcess:PROC
 EXTRN SetUnhandledExceptionFilter:PROC
 EXTRN MessageBoxA:PROC
 ;EXTRN RaiseException:PROC 
 EXTRN SetErrorMode:PROC


.CODE
STARTUP:

;----------------------------activate DRX system------------------------------

 CALL SetUnhandledExceptionFilter, OFFSET MyFilter
;CALL  RaiseException, MyxCode, MyxFlags, NumberMyParams, OFFSET MyInfo
; CALL  SetErrorMode, SEM_FAILCRITICALERRORS
; CALL  SetErrorMode, SEM_NOGPFAULTERRORBOX
; MOV OldErrorMode, EAX

 ;SUB  EAX,EAX
 ;MOV  [EAX],EAX;,[EAX]
 INT  3
 NOP
 CLC
 MOV AL,0F9H		 ;STC  ( NOP (90H) is the only safe clearing byte )
			 ;you can use for example AL=66H and after CodeChange
			 ;POP Reg16
			 ;then AMD executes POP Reg32

;ES=CS
 CLD
 MOV ECX,CLength
 LEA EDI,CodeChange

 LEA EDX,NoEffect

CodeChange:
 REP STOSB		 ;AMD recognizes NEW instruction
 CLength EQU $-CodeChange ;on IP=CodeChange+1 (STOSB) when DRX system is active
			 ;in CX is not 0 but 1 !!!!
			 ;OR CX,CX
			 ;JE NoAMDBug

			 ;you can use also MOVSB:
			 ;LEA SI,NewCode   ;NewCode DB 0F9H, 0F9H
			 ;REP MOVSB
 JNC NoAMDBug

 LEA EDX,Effect

NoAMDBug:
 ;SUB  EAX,EAX
 ;MOV  EAX,[EAX]
 INT 3
 NOP
 CALL MessageBoxA, 0, EDX, OFFSET MyTitle, 0
 CALL ExitProcess, 0


MyFilter PROC STDCALL

 USES  ESI

 ARG  _EXCEPTION_POINTERS_

 MOV  EBX, _EXCEPTION_POINTERS_
 MOV  ESI, [EBX].PEXCEPTION_RECORD
 SUB  EAX, EAX
 MOV  EBX, [EBX].PCONTEXT
 INC  EAX
 CMP  [ESI].ExceptionCode, STATUS_BREAKPOINT
 JNE  GoUnhandled
 CMP  Pass, 0
 JE   DeleteBkpt

 DEC  EAX
DeleteBkpt:
 MOV  [EBX].cx_Dr7,EAX
 DEC  EAX
 ADD  EAX, Pass
 INC  [EBX].cx_Eip
 MOV  [EBX].cx_Dr0,EAX
 INC  Pass
 DEC  EAX
GoUnhandled:
 RET
MyFilter ENDP

.DATA
 INCLUDE ETRICKS.INC
;typedef struct _EXCEPTION_POINTERS {
;    PEXCEPTION_RECORD ExceptionRecord;
;    PCONTEXT ContextRecord;
;} EXCEPTION_POINTERS, *PEXCEPTION_POINTERS;
 _EXCEPTION_POINTERS	STRUC
  PEXCEPTION_RECORD	DD  ?
  PCONTEXT		DD  ?
 _EXCEPTION_POINTERS	ENDS

 Pass	  DD 0
 MyTitle  DB "AMD K6 Bug Test by EliCZ",0
 Effect   DB "I'm sorry, but test is POSITIVE! :-(",0
 NoEffect DB "Test is NEGATIVE! :o)",0

 SEM_FAILCRITICALERRORS      EQU 0001
 SEM_NOGPFAULTERRORBOX       EQU 0002
 SEM_NOALIGNMENTFAULTEXCEPT  EQU 0004
 SEM_NOOPENFILEERRORBOX      EQU 8000

 OldErrorMode DD ?
COMMENT @
MyxCode        EQU  0FDCBA987H
MyxFlags       EQU  0
NumberMyParams EQU  6
MyInfo         DB   "It's"
               DB   " my "
               DB   "litt"
               DB   "le e"
               DB   "xcep"
               DB   "tion"
@
END   STARTUP

:TRANSLATE
@ECHO OFF
TASM  /M /Q /T	AMDK6BUG.BAT
LINK386 	AMDK6BUG,,,,AMDK6BUG
DEL		AMDK6BUG.OBJ
