//Win2K+ only. Emulate debug privilege. Manipulate SDs using SDDL strings.

//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>
#include "PrintSDDL.h"
#define PW_STATIC_LINKING
#include <ProcessWorks.h>

#define SE_SECURITY_PRIVILEGE  8
#define SE_TAKE_OWNERSHIP_PRIVILEGE 9
#define SE_DEBUG_PRIVILEGE     20
#define ADJUST_CURRENT_PROCESS 0
#define ADJUST_CURRENT_THREAD  1
#ifdef __cplusplus
extern "C"
#endif
__declspec(dllimport) LONG WINAPI RtlAdjustPrivilege(DWORD, BOOL, DWORD, BYTE*);

int _tmain(int argc, TCHAR **argv) {

  #define ProcessName _T("CALC.EXE")
  #define UserName _T("GUEST")
  CHAR WinExecCmdLine[256];
#ifdef UNICODE
  sprintf(WinExecCmdLine, "RUNAS.EXE /U:%S %S", UserName, ProcessName);
#else
  sprintf(WinExecCmdLine, "RUNAS.EXE /U:%s %s", UserName, ProcessName);
#endif
  WinExec(WinExecCmdLine, SW_SHOWNORMAL);
  DWORD i;
  LONG Pid;
  for(i=0; i<10; i++) {
    Sleep(3000);
    Pid = ProcessName2PID(ProcessName);
    if(Pid == MEMERROR) {
      _tprintf(_T("Not enough memory!"));
      return(getch());
    }
    if(Pid != PIDERROR) {
      break;
    }
  }
  if(Pid == PIDERROR) {
    _tprintf(_T("Can't find %s process!"), ProcessName);
    return(getch());
  }

  #define WantedInfo OWNER_SECURITY_INFORMATION | GROUP_SECURITY_INFORMATION | DACL_SECURITY_INFORMATION
  BYTE WasEnabled;

//Enable debug privilege to see SD
  RtlAdjustPrivilege(SE_DEBUG_PRIVILEGE, TRUE, ADJUST_CURRENT_PROCESS, &WasEnabled);
  HANDLE hProc = OpenProcess(READ_CONTROL, FALSE, Pid);
  LPTSTR ObSecInfo = PrintSDDL(hProc, WantedInfo, NULL);
  _tprintf(_T("\n\n###%s###\n%s"), ProcessName, ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  CloseHandle(hProc);

//Disable debug privilege to see nothing
  RtlAdjustPrivilege(SE_DEBUG_PRIVILEGE, FALSE, ADJUST_CURRENT_PROCESS, &WasEnabled);
  hProc = OpenProcess(READ_CONTROL, FALSE, Pid);
  ObSecInfo = PrintSDDL(hProc, WantedInfo, NULL);
  _tprintf(_T("\n\n###%s###\n%s"), ProcessName, ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  CloseHandle(hProc);

//Enable take-ownership privilege
  RtlAdjustPrivilege(SE_TAKE_OWNERSHIP_PRIVILEGE, TRUE, ADJUST_CURRENT_PROCESS, &WasEnabled);
  hProc = OpenProcess(WRITE_OWNER, FALSE, Pid);
//Write admins as owner
  ModifySD(hProc, 0, NULL, _T("O:BA"));
  CloseHandle(hProc);
//Disable take-ownership privilege because it's not needed
  RtlAdjustPrivilege(SE_TAKE_OWNERSHIP_PRIVILEGE, FALSE, ADJUST_CURRENT_PROCESS, &WasEnabled);

//Open for permissions view/change
  hProc = OpenProcess(READ_CONTROL | WRITE_DAC, FALSE, Pid);
  ObSecInfo = PrintSDDL(hProc, WantedInfo, NULL);
  _tprintf(_T("\n\n###%s###\n%s"), ProcessName, ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);

//No access for all
//  _stprintf(DInfo, _T("D:"));
//  ModifySD(hProc, 0, NULL, DInfo);

//All access for all
//  _stprintf(DInfo, _T(" "));
//  ModifySD(hProc, DACL_SECURITY_INFORMATION, NULL, DInfo);

//Add all access for admins
  ObSecInfo = PrintSDDL(hProc, DACL_SECURITY_INFORMATION, NULL);
  TCHAR DInfo[3072];
  DWORD DLen = _tcslen(ObSecInfo);
  //assume there's no access denied ace for admins in dacl (other parsing would be required)
  //add all access allowed ace for admins to the end of SDDL
  _stprintf(DInfo, _T("%s%s"), DLen ? ObSecInfo : _T("D:"), _T("(A;;0x1f0fff;;;BA)"));
  LocalFree(ObSecInfo);
  ModifySD(hProc, 0, NULL, DInfo);

//Show new SD
  ObSecInfo = PrintSDDL(hProc, WantedInfo, NULL);
  _tprintf(_T("\n\n###%s###\n%s"), ProcessName, ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  CloseHandle(hProc);

//Finally can I (admin) open process for all access?
  _tprintf(_T("\n\n###%s###\n"), ProcessName);
  hProc = OpenProcess(PROCESS_ALL_ACCESS, FALSE, Pid);
  if(hProc != NULL) {
    _tprintf(_T("can be opened for all access."));
    CloseHandle(hProc);
  }
  else {
    _tprintf(_T("can NOT be opened for all access!"));
  }

  return(getch());
}