#define WIN32_LEAN_AND_MEAN
//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>
#ifdef SDDL
  #include <ntsecapi.h>
  #include "PrintSDDL.h"
  #define PrintSD PrintSDDL
#else
  #include "PrintSD.h"
#endif
//#define PW_STATIC_LINKING
#include <ProcessWorks.h>

#define SE_SECURITY_PRIVILEGE  8
#define SE_TAKE_OWNERSHIP_PRIVILEGE 9
#define SE_DEBUG_PRIVILEGE     20
#define ADJUST_CURRENT_PROCESS 0
#define ADJUST_CURRENT_THREAD  1
#ifdef __cplusplus
extern "C"
#endif
__declspec(dllimport) LONG WINAPI RtlAdjustPrivilege(DWORD, BOOL, DWORD, BYTE*);
#ifdef __cplusplus
extern "C"
#endif
__declspec(dllimport) LONG WINAPI NtConnectPort(PHANDLE, PUNICODE_STRING,
  PSECURITY_QUALITY_OF_SERVICE, PVOID, PVOID, PULONG, PVOID, PULONG);

int _tmain(int argc, TCHAR **argv) {

  BYTE WasEnabledSP, WasEnabledTP, WasEnabledDP;
  RtlAdjustPrivilege(SE_SECURITY_PRIVILEGE,       TRUE, ADJUST_CURRENT_PROCESS, &WasEnabledSP);
  RtlAdjustPrivilege(SE_TAKE_OWNERSHIP_PRIVILEGE, TRUE, ADJUST_CURRENT_PROCESS, &WasEnabledTP);
  RtlAdjustPrivilege(SE_DEBUG_PRIVILEGE,          TRUE, ADJUST_CURRENT_PROCESS, &WasEnabledDP);


//Now open (for READ_CONTROL, opt. for ACCESS_SYSTEM_SECURITY) various objects
//and pass handle to PrintSD. If you can't open object try to take its ownership
//and try to open it once again (not implemented here).

  DWORD ReqSecInfo = OWNER_SECURITY_INFORMATION | GROUP_SECURITY_INFORMATION | DACL_SECURITY_INFORMATION | SACL_SECURITY_INFORMATION;
  HANDLE hProc = OpenProcess(READ_CONTROL | ACCESS_SYSTEM_SECURITY, FALSE, GetCurrentProcessId());
  if(hProc == NULL) {
    hProc = GetCurrentProcess();
   ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  LPTSTR ObSecInfo = PrintSD(hProc, ReqSecInfo, NULL);
  _tprintf(_T("###Current Process###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  if(ReqSecInfo)
    CloseHandle(hProc);

  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  LONG CSRPid = ProcessName2PID(_T("csrss.exe"));
  hProc = OpenProcess(READ_CONTROL | ACCESS_SYSTEM_SECURITY, FALSE, CSRPid);
  if(hProc == NULL) {
    hProc = OpenProcess(READ_CONTROL, FALSE, CSRPid);
   ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  ObSecInfo = PrintSD(hProc, ReqSecInfo, NULL);
  _tprintf(_T("\n\n\n###csrss.exe###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  if(hProc)
    CloseHandle(hProc);

//Modify ACLs of calc.exe using SetPrAcl or TMext02x and see result
  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  hProc = OpenProcess(READ_CONTROL | ACCESS_SYSTEM_SECURITY, FALSE, ProcessName2PID(_T("calc.exe")));
  if(hProc == NULL) {
    hProc = OpenProcess(READ_CONTROL, FALSE, ProcessName2PID(_T("calc.exe")));
    ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  ObSecInfo = PrintSD(hProc, ReqSecInfo, NULL);
  _tprintf(_T("\n\n\n###calc.exe###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  if(hProc)
    CloseHandle(hProc);

  hProc = GetCurrentProcess();
  HANDLE hThreadNew, hThread = GetCurrentThread();
  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  if(!DuplicateHandle(hProc, hThread, hProc, &hThreadNew, READ_CONTROL | ACCESS_SYSTEM_SECURITY, FALSE, 0)) {
    hThreadNew = hThread;
    ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  ObSecInfo = PrintSD(hThreadNew, ReqSecInfo, NULL);
  _tprintf(_T("\n\n\n###Current Thread###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  if(ReqSecInfo)
    CloseHandle(hThreadNew);

  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  HANDLE hFile = CreateFile(_T("NUL"), READ_CONTROL | ACCESS_SYSTEM_SECURITY, 0, NULL, OPEN_EXISTING, 0, NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    hFile = CreateFile(_T("NUL"), READ_CONTROL, 0, NULL, OPEN_EXISTING, 0, NULL);
  }
  if(hFile != INVALID_HANDLE_VALUE) {
    ObSecInfo = PrintSD(hFile, ReqSecInfo, NULL);
    _tprintf(_T("\n\n\n###NUL###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
    LocalFree(ObSecInfo);
    CloseHandle(hFile);
  }

  LPCTSTR Machines[4] = {_T("APPLE"), _T("ORANGE"), NULL, LPCTSTR(-1)};

  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  hFile = CreateFile(_T("\\\\.\\C:"), READ_CONTROL | ACCESS_SYSTEM_SECURITY, 0, NULL, OPEN_EXISTING, 0, NULL);
  if(hFile == INVALID_HANDLE_VALUE) {
    hFile = CreateFile(_T("\\\\.\\C:"), READ_CONTROL, 0, NULL, OPEN_EXISTING, 0, NULL);
    ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  if(hFile != INVALID_HANDLE_VALUE) {
    ObSecInfo = PrintSD(hFile, ReqSecInfo, Machines);
    _tprintf(_T("\n\n\n###C:###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
    LocalFree(ObSecInfo);
    CloseHandle(hFile);
  }

  ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  HANDLE hPort;
  #define _PortNameW (L"\\DbgUiApiPort")
  WCHAR PortNameW[64] = _PortNameW;
  UNICODE_STRING PortName = {sizeof(_PortNameW)-sizeof(WCHAR), sizeof(PortNameW), PortNameW};
  SECURITY_QUALITY_OF_SERVICE QoS = {sizeof(QoS), SecurityImpersonation, FALSE, FALSE};
  if(NtConnectPort(&hPort, &PortName, &QoS, NULL,NULL,NULL,NULL,NULL) >= 0) {
    ObSecInfo = PrintSD(hPort, ReqSecInfo, NULL);
    _tprintf(_T("\n\n\n###DbgApiPort###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
    LocalFree(ObSecInfo);
    CloseHandle(hPort);
  }

  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  HWINSTA hWinStaNew, hWinSta = GetProcessWindowStation();
  if(!DuplicateHandle(hProc, hWinSta, hProc, (HANDLE*)&hWinStaNew, READ_CONTROL | ACCESS_SYSTEM_SECURITY, FALSE, 0)) {
    hWinStaNew = hWinSta;
    ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  ObSecInfo = PrintSD(hWinStaNew, ReqSecInfo, NULL);
  _tprintf(_T("\n\n\n###Current WinSta###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  if(ReqSecInfo)
    CloseWindowStation(hWinStaNew);

  ReqSecInfo |= SACL_SECURITY_INFORMATION;
  HDESK hDeskNew, hDesk = GetThreadDesktop(GetCurrentThreadId());
  if(!DuplicateHandle(hProc, hDesk, hProc, (HANDLE*)&hDeskNew, READ_CONTROL | ACCESS_SYSTEM_SECURITY, FALSE, 0)) {
    hDeskNew = hDesk;
    ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
  }
  ObSecInfo = PrintSD(hDeskNew, ReqSecInfo, NULL);
  _tprintf(_T("\n\n\n###Current Desktop###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  if(ReqSecInfo)
    CloseDesktop(hDeskNew);

#ifndef SDDL
//tokens
  HANDLE hToken = NULL;

  hProc = OpenProcess(PROCESS_QUERY_INFORMATION, FALSE, CSRPid);
  OpenProcessToken(hProc, MAXIMUM_ALLOWED, &hToken);
  CloseHandle(hProc);
  ObSecInfo = PrintToken(hToken, NULL);
  _tprintf(_T("\n\n\n###csrss.exe Token###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  CloseHandle(hToken);

//restore init. priv. status in order to see 'default' states of privileges for this process' token
  RtlAdjustPrivilege(SE_SECURITY_PRIVILEGE,       WasEnabledSP, ADJUST_CURRENT_PROCESS, &WasEnabledSP);
  RtlAdjustPrivilege(SE_TAKE_OWNERSHIP_PRIVILEGE, WasEnabledTP, ADJUST_CURRENT_PROCESS, &WasEnabledTP);
  RtlAdjustPrivilege(SE_DEBUG_PRIVILEGE,          WasEnabledDP, ADJUST_CURRENT_PROCESS, &WasEnabledDP);

  OpenProcessToken(GetCurrentProcess(), MAXIMUM_ALLOWED, &hToken);
  ObSecInfo = PrintToken(hToken, NULL);
  _tprintf(_T("\n\n\n###Current Process Token###\n%s"), ObSecInfo ? ObSecInfo : _T("Heap exhausted!"));
  LocalFree(ObSecInfo);
  CloseHandle(hToken);
#endif

  return(0);
}
