//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>
#include <aclapi.h>

#define SE_SECURITY_PRIVILEGE  8
#define ADJUST_CURRENT_PROCESS 0
#ifdef __cplusplus
extern "C"
#endif
__declspec(dllimport) LONG WINAPI RtlAdjustPrivilege(DWORD, BOOL, DWORD, BYTE*);

int _tmain(int argc, TCHAR **argv) {
  BYTE WasEnabled;
  RtlAdjustPrivilege(SE_SECURITY_PRIVILEGE, TRUE, ADJUST_CURRENT_PROCESS, &WasEnabled);


  HANDLE hFile = CreateFile(_T("NUL"), READ_CONTROL | ACCESS_SYSTEM_SECURITY, 0, NULL, OPEN_EXISTING, 0, NULL);
  if(hFile == INVALID_HANDLE_VALUE)
    return(0);

  DWORD ReqLen = 65536;
  PSECURITY_DESCRIPTOR pSD;
  if(!(pSD = LocalAlloc(LMEM_FIXED, ReqLen)))
    return(0);

  if(!GetKernelObjectSecurity(hFile, DACL_SECURITY_INFORMATION |  SACL_SECURITY_INFORMATION,
       pSD, 65536, &ReqLen)) {
    CloseHandle(hFile);
    goto freeend;
  }
  CloseHandle(hFile);

  PACL pDacl;
  BOOL bDaclDefaulted, bDaclPresent;
  if(!GetSecurityDescriptorDacl(pSD, &bDaclPresent, &pDacl, &bDaclDefaulted))
    goto freeend;
  if(!bDaclPresent)
    goto freeend;
  ACL_SIZE_INFORMATION DaclSizeInfo;
  if(!GetAclInformation(pDacl, &DaclSizeInfo, sizeof(DaclSizeInfo), AclSizeInformation))
    goto freeend;
  ULONG DaclEntries;
  PEXPLICIT_ACCESS pDaclEntries;
  if(GetExplicitEntriesFromAcl(pDacl, &DaclEntries, &pDaclEntries) != ERROR_SUCCESS)
    goto freeend;

  PACL pSacl;
  BOOL bSaclDefaulted, bSaclPresent;
  if(!GetSecurityDescriptorSacl(pSD, &bSaclPresent, &pSacl, &bSaclDefaulted))
    goto freeend1;
  if(!bSaclPresent)
    goto freeend;
  ACL_SIZE_INFORMATION SaclSizeInfo;
  if(!GetAclInformation(pSacl, &SaclSizeInfo, sizeof(SaclSizeInfo), AclSizeInformation))
    goto freeend1;
  ULONG SaclEntries;
  PEXPLICIT_ACCESS pSaclEntries;
  if(GetExplicitEntriesFromAcl(pSacl, &SaclEntries, &pSaclEntries) != ERROR_SUCCESS)
    goto freeend1;

  _tprintf(_T("DAces=%u   DExes=%u\nSAces=%u   SExes=%u\n"),
    DaclSizeInfo.AceCount, DaclEntries, SaclSizeInfo.AceCount,SaclEntries);

  LocalFree(pSaclEntries);
 freeend1:
  LocalFree(pDaclEntries);
 freeend:
  LocalFree(pSD); 
  return(0);
}
