    
// __________________________________________________________
//
//                         ConStart.h
//        Startup Code for Win32 Console Applications
//                04-29-1998 Sven B. Schreiber
//                        sbs@orgon.com
// __________________________________________________________
    
#ifndef  _CONSTART_H_
#define  _CONSTART_H_
#include <proginfo.h>

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

////////////////////////////////////////////////////////////////////
#ifndef _RC_PASS_
////////////////////////////////////////////////////////////////////

// =================================================================
// CONSTANTS
// =================================================================

#define EOF (-1)

// =================================================================
// GLOBAL VARIABLES
// =================================================================

HANDLE hStdIn, hStdOut, hStdErr;
    
// =================================================================
// GLOBAL STRINGS
// =================================================================

TBYTE atUsage [] = S(\r\n)
                   S(Usage: MAIN_MODULE %s\r\n);

TBYTE atAbout [] = S(\r\n)
                   S(\\\\ ABOUT_TEXT1\r\n)
                   S(\\\\ ABOUT_TEXT2\r\n)
                   S(\\\\ ABOUT_TEXT3\r\n)
                   S(\\\\ ABOUT_TEXT4\r\n);

// =================================================================
// PROTOTYPES
// =================================================================

DWORD Main (DWORD argc, TBYTE *argv [], TBYTE *envp []);
    
// =================================================================
// STARTUP CODE
// =================================================================

#pragma comment (linker, "/entry:\"WinStartup\"")

// -----------------------------------------------------------------

void WinStartup ()
    {
    PVOID  pBuffer;
    PTBYTE ptCmdLine;
    PTBYTE ptEnvStrings;
    PTBYTE *argv;
    PTBYTE *envp;
    PTBYTE cmdp;
    DWORD  argc, envc, i;
    TBYTE  q;
    DWORD  dStatus = 0;

    ptCmdLine    = GetCommandLine ();
    ptEnvStrings = GetEnvironmentStrings ();

    argc = i = 0;
    while (TRUE)
        {
        while (ptCmdLine [i++] == ' ');
        q = (ptCmdLine [--i] == '"' ? ptCmdLine [i++] : ' ');
        if (!ptCmdLine [i]) break;

        argc++;
        while (ptCmdLine [i] && (ptCmdLine [i++] != q));
        }
    envc = i = 0;
    while (ptEnvStrings [i])
        {
        if (ptEnvStrings [i] != '=') envc++;
        while (ptEnvStrings [i++]);
        }
    pBuffer = LocalAlloc (LMEM_FIXED,
                          (argc     * sizeof (PTBYTE)) +
                          ((envc+1) * sizeof (PTBYTE)) +
                          ((lstrlen (ptCmdLine) + 1) *
                           sizeof (TBYTE)));

    if (pBuffer != NULL)
        {
        argv = (PTBYTE *) pBuffer;
        envp = argv + argc;
        cmdp = (PTBYTE) (envp + (envc+1));

        lstrcpy (cmdp, ptCmdLine);

        argc = i = 0;
        while (TRUE)
            {
            while (cmdp [i++] == ' ');
            q = (cmdp [--i] == '"' ? cmdp [i++] : ' ');
            if (!cmdp [i]) break;

            argv [argc++] = cmdp + i;
            while (cmdp [i])
                {
                if (cmdp [i++] == q)
                    {
                    cmdp [i-1] = 0;
                    break;
                    }
                }
            }
        envc = i = 0;
        while (ptEnvStrings [i])
            {
            if (ptEnvStrings [i] != '=')
                {
                envp [envc++] = ptEnvStrings + i;
                }
            while (ptEnvStrings [i++]);
            }
        envp [envc] = NULL;

        hStdIn  = GetStdHandle (STD_INPUT_HANDLE);
        hStdOut = GetStdHandle (STD_OUTPUT_HANDLE);
        hStdErr = GetStdHandle (STD_ERROR_HANDLE);

        if ((hStdIn  != INVALID_HANDLE_VALUE) &&
            (hStdOut != INVALID_HANDLE_VALUE) &&
            (hStdErr != INVALID_HANDLE_VALUE))
            {
            dStatus = Main (argc, argv, envp);
            }
        LocalFree (pBuffer);
        }
    ExitProcess (dStatus);
    return;
    }
    
// =================================================================
// STANDARD I/O
// =================================================================

int getchar (void)
    {
    int   c;
    DWORD n;

    c = 0;
    return (ReadFile (hStdIn, &c, 1, &n, NULL) && n ? c : EOF);
    }

// -----------------------------------------------------------------

int putchar (int c)
    {
    DWORD n;

    return (WriteFile (hStdOut, &c, 1, &n, NULL) ? c : EOF);
    }

// -----------------------------------------------------------------

int printf (PTBYTE ptFormat,
            ...)
    {
    TBYTE atBuffer [1024];
    DWORD i, n;

    wvsprintf (atBuffer, ptFormat, (PVOID) ((&ptFormat)+1));

    for (i = 0; atBuffer [i]; i++)
        {

#ifdef UNICODE

        ((PBYTE) atBuffer) [i] = (atBuffer [i] < 0x0100
                                  ? (BYTE) atBuffer [i]
                                  : '?');

#endif // #ifdef UNICODE

        }
    return (WriteFile (hStdOut, (PBYTE) atBuffer, i, &n, NULL)
            ? n
            : EOF);
    }
    
// -----------------------------------------------------------------

DWORD KeyPressed (void)
    {
    INPUT_RECORD InputRecord;
    DWORD        dCount;
    DWORD        dKeyCode = 0;

    GetNumberOfConsoleInputEvents (hStdIn, &dCount);
    while (dCount &&
           ReadConsoleInput (hStdIn, &InputRecord, 1, &dCount))
        {
        if ((InputRecord.EventType == KEY_EVENT) &&
            (InputRecord.Event.KeyEvent.bKeyDown))
            {
            dKeyCode = InputRecord.Event.KeyEvent.wVirtualKeyCode;
            break;
            }
        GetNumberOfConsoleInputEvents (hStdIn, &dCount);
        }
    return dKeyCode;
    }

////////////////////////////////////////////////////////////////////
#endif // #ifndef _RC_PASS_
////////////////////////////////////////////////////////////////////

#endif // #ifndef _CONSTART_H_

// =================================================================
// END OF FILE
// =================================================================
