
// __________________________________________________________
//
//                         ProgInfo.h
//                  Program Info Definitions
//                04-29-1998 Sven B. Schreiber
//                        sbs@orgon.com
// __________________________________________________________
    
#ifndef _PROGINFO_H_
#define _PROGINFO_H_
#include <windows.h>

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// MACROS
// =================================================================

#define _SA($a) #$a
#define _SW($a) L ## #$a

#define SA($a) _SA($a)
#define SW($a) _SW($a)

#define _PAIR($a,$b) $a ## $b
#define PAIR($a,$b) _PAIR($a,$b)

// -----------------------------------------------------------------

#if MAIN_VERSION_LOW < 10

#define _V2($a,$b)       $a ## .0 ## $b
#define _V2X($a,$b) V ## $a ## .0 ## $b

#else // #if MAIN_VERSION_LOW < 10

#define _V2($a,$b)       $a ## .  ## $b
#define _V2X($a,$b) V ## $a ## .  ## $b

#endif // #if MAIN_VERSION_LOW < 10 #else

#define V2($a,$b) _V2($a,$b)
#define V2X($a,$b) _V2X($a,$b)

// -----------------------------------------------------------------

#define _V4($a,$b,$c) $a ## . ## $b ## .0. ## $c
#define V4($a,$b,$c) _V4($a,$b,$c)

// -----------------------------------------------------------------

#define MAIN_V              V2X (MAIN_VERSION_HIGH, \
                                 MAIN_VERSION_LOW)

#define MAIN_VERSION        V2  (MAIN_VERSION_HIGH, \
                                 MAIN_VERSION_LOW)

#define MAIN_VERSION_QUAD   V4  (MAIN_VERSION_HIGH, \
                                 MAIN_VERSION_LOW,  \
                                 MAIN_BUILD)

#define MAIN_VERSION_BINARY    ((MAIN_VERSION_HIGH * 100) \
                               + MAIN_VERSION_LOW)

// -----------------------------------------------------------------

#ifdef  UNICODE

#define S($a) SW($a)
#define _T($a) L ## $a
#define TSIZE($a) (sizeof ($a) >> 1)
#define lstrcpyb($a,$b) lstrcpyn ($a, $b, TSIZE ($a))

#else   // #ifdef UNICODE

#define S($a) SA($a)
#define _T($a) $a
#define TSIZE($a) sizeof ($a)
#define lstrcpyb($a,$b) lstrcpyn ($a, $b, TSIZE ($a))

#endif  // #ifdef UNICODE #else

#define T($a) _T($a)

// =================================================================
// PROGRAM INFORMATION
// =================================================================

#define MAIN_ID                 MAIN_PREFIX.MAIN_MODULE
#define MAIN_ID_VERSION         MAIN_ID.MAIN_VERSION_HIGH
#define MAIN_FILENAME           MAIN_MODULE.MAIN_EXTENSION
#define MAIN_CAPTION            MAIN_NAME MAIN_V
#define MAIN_COMMENT            MAIN_DATE MAIN_AUTHOR

// -----------------------------------------------------------------

#define MAIN_CLASS              MAIN_MODULE.MAIN_VERSION_QUAD
#define MAIN_MENU               MAIN_MODULE.Menu
#define MAIN_ICON               MAIN_MODULE.Icon
#define MAIN_CURSOR             MAIN_MODULE.Cursor
#define MAIN_BITMAP             MAIN_MODULE.Bitmap
#define MAIN_DIALOG             MAIN_MODULE.Dialog
#define MAIN_ABOUT              MAIN_MODULE.About

// -----------------------------------------------------------------

#define MAIN_COPYRIGHT          Copyright \xA9 MAIN_YEAR
#define MAIN_COPYRIGHT_EX       MAIN_COPYRIGHT MAIN_COMPANY

// -----------------------------------------------------------------

#define MAIN_DATE_US            MAIN_MONTH-MAIN_DAY-MAIN_YEAR
#define MAIN_DATE_GERMAN        MAIN_DAY.MAIN_MONTH.MAIN_YEAR
#define MAIN_DATE               MAIN_DATE_US

// -----------------------------------------------------------------

#define MAIN_LANGUAGE           0409

#ifdef  UNICODE
#define MAIN_CODEPAGE           04B0
#else
#define MAIN_CODEPAGE           04E4
#endif

#define MAIN_TRANSLATION        PAIR (MAIN_LANGUAGE, MAIN_CODEPAGE)

// -----------------------------------------------------------------

#ifdef  MAIN_EXE
#define MAIN_VFT                VFT_APP
#define MAIN_EXTENSION          exe
#endif

#ifdef  MAIN_DLL
#define MAIN_VFT                VFT_DLL
#define MAIN_EXTENSION          dll
#endif

// -----------------------------------------------------------------

#define ABOUT_CAPTION           About MAIN_NAME
#define ABOUT_ICON              MAIN_ICON
#define ABOUT_DIALOG            MAIN_ABOUT
#define ABOUT_TEXT1             MAIN_FILENAME
#define ABOUT_TEXT2             MAIN_CAPTION
#define ABOUT_TEXT3             MAIN_COMMENT
#define ABOUT_TEXT4             MAIN_EMAIL

////////////////////////////////////////////////////////////////////
#ifdef _RC_PASS_
////////////////////////////////////////////////////////////////////

// =================================================================
// HEADER FILES
// =================================================================

#include <ver.h>

// =================================================================
// VERSION INFO
// =================================================================

#define MAIN_RC_VERSION \
VS_VERSION_INFO VERSIONINFO \
\
FILEVERSION     MAIN_VERSION_HIGH, MAIN_VERSION_LOW, 0, MAIN_BUILD \
PRODUCTVERSION  MAIN_VERSION_HIGH, MAIN_VERSION_LOW, 0, MAIN_BUILD \
FILEFLAGSMASK   VS_FFI_FILEFLAGSMASK \
FILEFLAGS       0 \
FILEOS          VOS_UNKNOWN \
FILETYPE        MAIN_VFT \
FILESUBTYPE     VFT2_UNKNOWN \
  { \
  BLOCK "StringFileInfo" \
    { \
    BLOCK SA(MAIN_TRANSLATION) \
      { \
      VALUE "OriginalFilename", SA(MAIN_FILENAME\0) \
      VALUE "InternalName",     SA(MAIN_MODULE\0) \
      VALUE "ProductName",      SA(MAIN_NAME\0) \
      VALUE "FileDescription",  SA(MAIN_CAPTION\0) \
      VALUE "CompanyName",      SA(MAIN_COMPANY\0) \
      VALUE "ProductVersion",   SA(MAIN_VERSION_QUAD\0) \
      VALUE "FileVersion",      SA(MAIN_VERSION_QUAD\0) \
      VALUE "LegalCopyright",   SA(MAIN_COPYRIGHT_EX\0) \
      VALUE "Comments",         SA(MAIN_COMMENT\0) \
      } \
    } \
  BLOCK "VarFileInfo" \
      { \
      VALUE "Translation", 0xMAIN_LANGUAGE, 0xMAIN_CODEPAGE \
      } \
  }

// =================================================================
// RESOURCES
// =================================================================

#define MAIN_RC_MENU   MAIN_MENU   MENU
#define MAIN_RC_ICON   MAIN_ICON   ICON   MAIN_MODULE.ico
#define MAIN_RC_CURSOR MAIN_CURSOR CURSOR MAIN_MODULE.cur
#define MAIN_RC_BITMAP MAIN_BITMAP BITMAP MAIN_MODULE.bmp

////////////////////////////////////////////////////////////////////
#endif // #ifdef _RC_PASS_
////////////////////////////////////////////////////////////////////

#endif // #ifndef _PROGINFO_H_

// =================================================================
// END OF FILE
// =================================================================
