
#include "psapi.h"

// global variables
_EnumProcesses           EnumProcesses;
_EnumProcessModules      EnumProcessModules;
_GetModuleFileNameEx     GetModuleFileNameEx;
_GetModuleInformation    GetModuleInformation;


BOOL LoadPsapiDll()
{
	HINSTANCE hPsapi;

	// load psapi.dll into our memory context
	hPsapi = LoadLibrary("psapi.dll");
	if (!hPsapi)
		return FALSE;

	// get important function address
	EnumProcesses             = (_EnumProcesses)GetProcAddress(
		hPsapi,
		"EnumProcesses");
	EnumProcessModules        = (_EnumProcessModules)GetProcAddress(
		hPsapi,
		"EnumProcessModules");
	GetModuleFileNameEx       = (_GetModuleFileNameEx)GetProcAddress(
		hPsapi,
		"GetModuleFileNameExA");
	GetModuleInformation      = (_GetModuleInformation)GetProcAddress(
		hPsapi,
		"GetModuleInformation");	

	if (!EnumProcesses || !EnumProcessModules || !GetModuleFileNameEx || !GetModuleInformation)
		return FALSE;

	return TRUE;
}

