// PSAPI stuff (why the hell didn't I find a psapi.h ;)

#ifndef __psapi_h__
	#define __psapi_h__

    #include <windows.h>

	// structs
	typedef struct _MODULEINFO
	{
		LPVOID lpBaseOfDll;
		DWORD SizeOfImage;
		LPVOID EntryPoint;
	} MODULEINFO, *LPMODULEINFO;

	// psapi API prototypes
	typedef BOOL (WINAPI* _EnumProcesses)
	(
	  DWORD * lpidProcess,  // array to receive the process identifiers
	  DWORD cb,             // size of the array
	  DWORD * cbNeeded      // receives the number of bytes returned
	);

	typedef BOOL (WINAPI* _EnumProcessModules)
	(
	  HANDLE hProcess,      // handle to the process
	  HMODULE * lphModule,  // array to receive the module handles
	  DWORD cb,             // size of the array
	  LPDWORD lpcbNeeded    // receives the number of bytes returned
	);
  
	typedef DWORD (WINAPI* _GetModuleFileNameEx)
	(
	  HANDLE hProcess,    // handle to the process
	  HMODULE hModule,    // handle to the module
	  LPTSTR lpFilename,  // buffer that receives the path
	  DWORD nSize         // size of the buffer
	);

	typedef BOOL (WINAPI* _GetModuleInformation)
	(
	  HANDLE hProcess,         // handle to the process
	  HMODULE hModule,         // handle to the module
	  LPMODULEINFO lpmodinfo,  // structure that receives information
	  DWORD cb                 // size of the structure
	);

	// functions
    BOOL LoadPsapiDll();

	// function addresses
	extern _EnumProcesses           EnumProcesses;
    extern _EnumProcessModules      EnumProcessModules;
    extern _GetModuleFileNameEx     GetModuleFileNameEx;
    extern _GetModuleInformation    GetModuleInformation;

#endif