/*

				-=[ PROCS.DLL ]=-
				   by yoda/F2F
				   
You're able to use parts of this code if you mention my name.
Please report me any suggestions, comments or bugfixes.
    
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <tlhelp32.h>
#include "psapi.h"
#include "th32.h"

#pragma comment(linker,"/BASE:0x20000000 /FILEALIGN:512 /MERGE:.rdata=.text /MERGE:.data=.text /SECTION:.text,EWR /IGNORE:4078")

#define MAX_PROCESS_NUM        60
#define MAX_MODULE_NUM         200
#define NT_PROCESS_ACCESS      PROCESS_VM_READ | PROCESS_QUERY_INFORMATION

// prototypes
BOOL   IsNT();
BOOL   StrNCopy(char* szIn, char* szOut, DWORD dwInSize, DWORD dwOutSize);

DWORD  __stdcall GetNumberOfProcesses();
BOOL   __stdcall GetProcessIDList(DWORD *dwIDArray, DWORD dwArraySize);
BOOL   __stdcall GetProcessPath(DWORD dwPID, char *szBuff, DWORD dwBuffSize);
BOOL   __stdcall GetProcessBaseSize(DWORD dwPID, DWORD *dwImageBase, DWORD *dwImageSize);

DWORD  __stdcall GetNumberOfModules(DWORD dwPID);
BOOL   __stdcall GetModuleHandleList(DWORD dwPID,DWORD *dwHandleArray, DWORD dwArraySize);
BOOL   __stdcall GetModulePath(DWORD dwPID, DWORD dwModh, char *szBuff, DWORD dwBuffSize);
BOOL   __stdcall GetModuleSize(DWORD dwPID, DWORD dwModh, DWORD *dwImageSize);

DWORD  __stdcall GetProcessPathID(char* szPath);
HANDLE __stdcall GetModuleHandleEx(DWORD dwPID, char* szModule);

// global variables
BOOL              bNT;


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  fdwReason, 
                       LPVOID lpReserved
					 )
{
	switch(fdwReason) 
    { 
	case DLL_PROCESS_ATTACH:
		// save the current OS
		bNT = IsNT();

		if (bNT)
		{
			if (!LoadPsapiDll())
				return FALSE;  // needed dll not available :(
		}
		else
			if (!GetTh32())    // ToolHelp32 API's not available :(
				return FALSE;
	}
	return TRUE;
}

BOOL IsNT()
{
	DWORD dwWinVer;

	// get the OS
	dwWinVer = GetVersion();
	dwWinVer = dwWinVer >> 31;
	return (dwWinVer == 0 ? TRUE : FALSE);
}

BOOL StrNCopy(char* szIn, char* szOut, DWORD dwInSize, DWORD dwOutSize)
{
	DWORD dwCopy;

	if (!dwInSize || !dwOutSize)
		return FALSE;

	dwCopy = dwInSize;
	if (dwCopy > dwOutSize)
		dwCopy = dwOutSize;

	lstrcpyn(szOut, szIn, dwCopy);
	return TRUE;
}

// returns:
// 0 - error
DWORD __stdcall GetNumberOfProcesses()
{
	DWORD               i;
	HANDLE              hSnap;
	PROCESSENTRY32      ProcInfo;
	DWORD               dwPIDs[MAX_PROCESS_NUM], dwBytesWritten;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		ProcInfo.dwSize = sizeof(ProcInfo);
		if (!_Process32First(hSnap, &ProcInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}
		i = 1;
		while (_Process32Next(hSnap, &ProcInfo))
			++i;

		// clean up
		CloseHandle(hSnap);

		return i;
	}
	else
	{
		// NT !
		if (!EnumProcesses(
			(DWORD*)&dwPIDs[0],
			sizeof(dwPIDs),
			&dwBytesWritten))
			return 0;
		return (dwBytesWritten / sizeof(DWORD)); // divide the return size of bytes by 4
	}
}

BOOL __stdcall GetProcessIDList(DWORD *dwIDArray,
					  DWORD  dwArraySize)
{
	HANDLE              hSnap;
	DWORD               *pDW, dwBytesWritten;
	PROCESSENTRY32      ProcInfo = {sizeof(ProcInfo)};

	if (dwArraySize < sizeof(DWORD))
		return FALSE;

	if (!bNT)
	{
		// non NT !
		// make snapshot
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
		if (hSnap == INVALID_HANDLE_VALUE)
			return FALSE;

		__try // maybe the array is not writeable
		{
			pDW = dwIDArray;

			if (!_Process32First(hSnap, &ProcInfo))
			{
				CloseHandle(hSnap);
				return FALSE;
			}

			*pDW++ = ProcInfo.th32ProcessID;
			dwArraySize -= sizeof(DWORD);

			while (dwArraySize && _Process32Next(hSnap, &ProcInfo))
			{
				*pDW++ = ProcInfo.th32ProcessID;
				dwArraySize -= sizeof(DWORD);
			}

			// clean up
			CloseHandle(hSnap);		
		}
		__except(1)
		{
			CloseHandle(hSnap);
			return FALSE;
		}
		return TRUE;
	}
	else
	{
		// NT !
		if (!EnumProcesses(
			(DWORD*)&dwIDArray[0],
			dwArraySize,
			&dwBytesWritten))
			return FALSE;
		return TRUE;
	}
}

BOOL __stdcall GetProcessPath(DWORD dwPID, char* szBuff, DWORD dwBuffSize)
{
	HANDLE              hSnap;
	PROCESSENTRY32      ProcInfo   = {sizeof(ProcInfo)};
	char*               szPath     = NULL;
	DWORD               dwModh;     // we just need the first handle
	DWORD               dwBytesWritten;
	HANDLE              hProc;
	BOOL                bDone;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
		if (hSnap == INVALID_HANDLE_VALUE)
			return FALSE;

		if (!_Process32First(hSnap, &ProcInfo))
		{
			CloseHandle(hSnap);
			return FALSE;
		}

		if (ProcInfo.th32ProcessID == dwPID)
		{
			CloseHandle(hSnap);
			if (!StrNCopy(
				ProcInfo.szExeFile,
				szBuff,
				sizeof(ProcInfo.szExeFile),
				dwBuffSize))
				return FALSE;
			return TRUE;
		}

		while (_Process32Next(hSnap, &ProcInfo))
			if (ProcInfo.th32ProcessID == dwPID)
			{
				CloseHandle(hSnap);
				if (!StrNCopy(
					ProcInfo.szExeFile,
					szBuff,
					sizeof(ProcInfo.szExeFile),
					dwBuffSize))
					return FALSE;
				return TRUE;
			}

		// clean up
		CloseHandle(hSnap);
		return FALSE;  // PID not found
	}
	else
	{
		// NT !

		// get a process handle
		hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPID);
		if (!hProc)
			return FALSE;

		// get the first module handle and its path
		if (!EnumProcessModules(
			hProc,
			(HINSTANCE*)&dwModh,
			sizeof(dwModh),
			&dwBytesWritten))
		{
			CloseHandle(hProc);
			return FALSE;
		}
		if (!GetModuleFileNameEx(
			hProc,
			(HINSTANCE)dwModh,
			szBuff,
			dwBuffSize))
			bDone = FALSE;
		else
			bDone = TRUE;

		// clean up
		CloseHandle(hProc);
		
		return bDone;
	}
}

// returns:
// FALSE -> normal on NT !
BOOL __stdcall GetProcessBaseSize(DWORD dwPID, DWORD *dwImageBase, DWORD *dwImageSize)
{
	HANDLE              hSnap;
	PROCESSENTRY32      ProcInfo             = { sizeof(ProcInfo) };
	MODULEENTRY32       ModInfo              = { sizeof(ModInfo) };
	char                cProcPath[MAX_PATH]  = {0};
	DWORD               dwPIDChain[MAX_PROCESS_NUM];
	DWORD               dwModh;
	DWORD               dwBytesWritten, dwPIDCnt, i;
	HANDLE              hProc;
	MODULEINFO          ModInfoNT;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
		if (hSnap == INVALID_HANDLE_VALUE)
			return FALSE;

		// get exe path of PID
		if (!_Process32First(hSnap, &ProcInfo))
		{
			CloseHandle(hSnap);
			return FALSE;
		}

		if (ProcInfo.th32ProcessID == dwPID)
			lstrcpy(cProcPath, ProcInfo.szExeFile);

		while (!cProcPath[0] && _Process32Next(hSnap, &ProcInfo))
			if (ProcInfo.th32ProcessID == dwPID)
				lstrcpy(cProcPath, ProcInfo.szExeFile);

		CloseHandle(hSnap);
		if (!cProcPath[0])
			return FALSE;

		// find process exe in module list
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
		if (hSnap == INVALID_HANDLE_VALUE)
			return FALSE;

		if (!_Module32First(hSnap, &ModInfo))
		{
			CloseHandle(hSnap);
			return FALSE;
		}

		if (lstrcmpi(ModInfo.szExePath, cProcPath) == 0)
			goto FoundModPath;

		while (_Module32Next(hSnap, &ModInfo))
			if (lstrcmpi(ModInfo.szExePath, cProcPath) == 0)
				goto FoundModPath;

		// ... module not found !
		// clean up
		CloseHandle(hSnap);
		return FALSE; // bad exit

FoundModPath:
		// clean up
		CloseHandle(hSnap);

		__try // maybe no write access !
		{
			*dwImageBase = (DWORD)ModInfo.modBaseAddr;
			*dwImageSize = (DWORD)ModInfo.modBaseSize;
		}
		__except(1)
		{
			return FALSE;
		}
		return TRUE;
	}
	else
	{
		// NT !
		if (!EnumProcesses(
			&dwPIDChain[0],
			sizeof(dwPIDChain),
			&dwBytesWritten))
			return FALSE;

		dwPIDCnt = dwBytesWritten / 4;

		for (i=0; i < dwPIDCnt; i++)
			if (dwPIDChain[i] == dwPID)
			{
				// found PID in process ID List
				hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPIDChain[i]);
				if (!hProc)
					return FALSE;

				// get ImageBase and SizeOfImage of the process module
				if (!EnumProcessModules(
					hProc,
					(HINSTANCE*)&dwModh,
					sizeof(dwModh),
					&dwBytesWritten))
				{
					CloseHandle(hProc);
					return FALSE;
				}

				if (!GetModuleInformation(
					hProc,
					(HINSTANCE)dwModh,
					&ModInfoNT,
					sizeof(ModInfoNT)))
				{
					CloseHandle(hProc);
					return FALSE;
				}

				__try // maybe no write access
				{
					*dwImageBase = (DWORD)ModInfoNT.lpBaseOfDll;
					*dwImageSize = (DWORD)ModInfoNT.SizeOfImage;
				}
				__except(1)
				{
					CloseHandle(hProc);
					return FALSE;
				}

				// clean up
				CloseHandle(hProc);
				return TRUE;
			}

		return FALSE;	 // PID not found
	}
}

// returns:
// 0 - error
DWORD __stdcall GetNumberOfModules(DWORD dwPID)
{
	HANDLE              hSnap;
	MODULEENTRY32       ModInfo              = { sizeof(ModInfo) };
	DWORD               i                    = 1;
	DWORD               hModChain[MAX_MODULE_NUM];
	DWORD               dwBytesWritten;
	HANDLE              hProc;
	BOOL                bDone;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		if (!_Module32First(hSnap, &ModInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}

		while (_Module32Next(hSnap, &ModInfo))
			i++;

		// clean up
		CloseHandle(hSnap);
		return i;
	}
	else
	{
		// NT !
		hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPID);
		if (!hProc)
			return 0;

		bDone = EnumProcessModules(
			hProc,
			(HINSTANCE*)&hModChain[0],
			sizeof(hModChain),
			&dwBytesWritten);
		
		// clean up
		CloseHandle(hProc);

		if (!bDone)
			return 0;

		return (dwBytesWritten / sizeof(DWORD));
	}
}

// handle = ImageBase of module
BOOL __stdcall GetModuleHandleList(DWORD dwPID, DWORD *dwHandleArray, DWORD dwArraySize)
{
	HANDLE              hSnap;
	MODULEENTRY32       ModInfo              = { sizeof(ModInfo) };
	DWORD               *pDW, dwBytesWritten;
	HANDLE              hProc;
	BOOL                bDone;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		if (!_Module32First(hSnap, &ModInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}

		pDW = dwHandleArray;

		__try // maybe the array has no write access
		{
			do
			{
				if (!dwArraySize)
					break;
				*pDW++ = (DWORD)ModInfo.hModule;
				dwArraySize -= sizeof(DWORD);
			} while (_Module32Next(hSnap, &ModInfo));

		}
		__except(1)
		{
			CloseHandle(hSnap);
			return FALSE;
		}

		// clean up
		CloseHandle(hSnap);
		return TRUE;
	}
	else
	{
		// NT !
		hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPID);
		if (!hProc)
			return FALSE;

		bDone = EnumProcessModules(
			hProc,
			(HINSTANCE*)dwHandleArray,
			dwArraySize,
			&dwBytesWritten);

		// clean up
		CloseHandle(hProc);

		return bDone;
	}
}

BOOL __stdcall GetModulePath(DWORD dwPID, DWORD dwModh, char* szBuff, DWORD dwBuffSize)
{
	HANDLE              hSnap;
	MODULEENTRY32       ModInfo              = { sizeof(ModInfo) };
	HANDLE              hProc;
	DWORD               dwRet;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		if (!_Module32First(hSnap, &ModInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}

		do
		{
			if ((DWORD)ModInfo.hModule == dwModh)
			{
				CloseHandle(hSnap);
				goto FoundModule;
			}
		} while (_Module32Next(hSnap, &ModInfo));

		// clean up
		CloseHandle(hSnap);
		return FALSE;

FoundModule:
		if (!StrNCopy(
			ModInfo.szExePath,
			szBuff,
			sizeof(ModInfo.szExePath),
			dwBuffSize))
			return FALSE;		
		return TRUE;
	}
	else
	{
		// NT !
		hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPID);
		if (!hProc)
			return FALSE;

		dwRet = GetModuleFileNameEx(
			hProc,
			(HINSTANCE)dwModh,
			szBuff,
			dwBuffSize);

		// clean up
		CloseHandle(hProc);

		return (dwRet != 0);
	}
}

BOOL __stdcall GetModuleSize(DWORD dwPID, DWORD dwModh, DWORD *dwImageSize)
{
	HANDLE              hSnap;
	MODULEENTRY32       ModInfo              = { sizeof(ModInfo) };
	HANDLE              hProc;
	MODULEINFO          ModInfoNT;

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		if (!_Module32First(hSnap, &ModInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}

		do
		{
			if ((DWORD)ModInfo.hModule == dwModh)
			{
				CloseHandle(hSnap);
				goto ModuleFound;
			}
		} while (_Module32Next(hSnap, &ModInfo));

		// clean up
		CloseHandle(hSnap);
		return FALSE;

ModuleFound:
		__try // maybe no write access
		{
			*dwImageSize = (DWORD)ModInfo.modBaseSize;
		}
		__except(1)
		{
			return FALSE;
		}
		return TRUE;
	}
	else
	{
		// NT !
		hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPID);
		if (!hProc)
			return FALSE;

		if (!GetModuleInformation(
			hProc,
			(HINSTANCE)dwModh,
			&ModInfoNT,
			sizeof(ModInfoNT)))
		{
			CloseHandle(hProc);
			return FALSE;
		}

		// clean up
		CloseHandle(hProc);

		__try // maybe no write access
		{
			*dwImageSize = (DWORD)ModInfoNT.SizeOfImage;
		}
		__except(1)
		{
			return FALSE;
		}
		return TRUE;
	}
}

// returns:
// 0 - error
DWORD  __stdcall GetProcessPathID(char* szPath)
{
	char            cSearchBuff[MAX_PATH];
	char            cModPath[MAX_PATH];
	PROCESSENTRY32  ProcInfo                   = { sizeof(ProcInfo) };
	HANDLE          hSnap;
	DWORD           dwBytesWritten, i;
	DWORD           dwPIDs[MAX_PROCESS_NUM];
	HANDLE          hProc, hMod;
	BOOL            bDone;

	// get a upcased copy of the search path
	lstrcpy(cSearchBuff, szPath);
	_strupr(cSearchBuff);

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		if (!_Process32First(hSnap, &ProcInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}

		do
		{
			// search cSearchBuff in the process path
			_strupr(ProcInfo.szExeFile);
			if (strstr(ProcInfo.szExeFile, cSearchBuff))
			{
				CloseHandle(hSnap);
				return ProcInfo.th32ProcessID;
			}
		} while (_Process32Next(hSnap, &ProcInfo));

		// clean up
		CloseHandle(hSnap);
		return 0; // path not found
	}
	else
	{
		// NT !
		// fill PID array
		if (!EnumProcesses(
			(DWORD*)&dwPIDs[0],
			sizeof(dwPIDs),
			&dwBytesWritten))
			return 0;

		dwBytesWritten /= sizeof(DWORD);

		// test every path of the first module of each process
		for (i=0; i < dwBytesWritten; i++)
		{
			hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPIDs[i]);
			if (!hProc)
				continue;

			if (!EnumProcessModules(
				hProc,
				(HINSTANCE*)&hMod,
				sizeof(hMod),
				&dwBytesWritten))
			{
				CloseHandle(hProc);
				continue;
			}

			bDone = GetModuleFileNameEx(
				hProc,
				(HMODULE)hMod,
				cModPath,
				sizeof(cModPath));

			CloseHandle(hProc); // clean up
			if (!bDone)
				continue;

			_strupr(cModPath);
			if (strstr(cModPath, cSearchBuff))
				return dwPIDs[i];
		}
		return 0; // path not found
	}
}

// returns:
// 0 - error
HANDLE __stdcall GetModuleHandleEx(DWORD dwPID, char* szModule)
{
	char            cSearchBuff[MAX_PATH];
	char            cModPath[MAX_PATH];
	MODULEENTRY32   ModInfo                  = { sizeof(ModInfo) };
	HANDLE          hSnap;
	DWORD           dwBytesWritten, i;
	HANDLE          hProc, hTheMod;
	HANDLE          hMods[MAX_MODULE_NUM];

	// get a upcased copy of the search path
	lstrcpy(cSearchBuff, szModule);
	_strupr(cSearchBuff);

	if (!bNT)
	{
		// non NT !
		hSnap = _CreateToolhelp32Snapshot(TH32CS_SNAPMODULE, dwPID);
		if (hSnap == INVALID_HANDLE_VALUE)
			return 0;

		// compare each module path with the search buff
		if (!_Module32First(hSnap, &ModInfo))
		{
			CloseHandle(hSnap);
			return 0;
		}

		do
		{
			_strupr(ModInfo.szExePath);
			if (strstr(ModInfo.szExePath, cSearchBuff))
			{
				CloseHandle(hSnap);
				return ((HANDLE)ModInfo.modBaseAddr);
			}
		} while (_Module32Next(hSnap, &ModInfo));

		// clean up
		CloseHandle(hSnap);
		return 0; // module path not found
	}
	else
	{
		// NT !
		hProc = OpenProcess(NT_PROCESS_ACCESS, FALSE, dwPID);
		if (!hProc)
			return 0;

		if (!EnumProcessModules(
			hProc,
			(HINSTANCE*)&hMods[0],
			sizeof(hMods),
			&dwBytesWritten))
		{
			CloseHandle(hProc);
			return 0;
		}

		dwBytesWritten /= sizeof(DWORD);
		hTheMod = 0;
		for (i=0; i < dwBytesWritten; i++)
		{
			if (!GetModuleFileNameEx(
				hProc,
				(HANDLE)hMods[i],
				cModPath,
				sizeof(cModPath)))
			{
				CloseHandle(hProc);
				continue;
			}

			_strupr(cModPath);
			if (strstr(cModPath, cSearchBuff))
			{
				hTheMod = hMods[i];
				break;
			}
		}
		CloseHandle(hProc);
		return hTheMod; // module path not found
	}
}
