'##########################################################################

  $COMPILE EXE             '<< Tell compiler to make an executable file.

  $INCLUDE "HEADER.INC"    '<< Include the header file with constants etc..

'##########################################################################

FUNCTION WinMain(ByVal Instance      as LONG, _
                 ByVal hPrevInstance as LONG, _
                 lpszCmdLine         as ASCIIZ PTR, _
                 ByVal nCmdShow      as LONG) AS LONG

    LOCAL  Msg         as tagMSG           '<< UDT for messages
    LOCAL  wc          as WNDCLASSEX       '<< UDT for window class
    LOCAL  szClassName as ASCIIZ * 16
    LOCAL  Wid&
    LOCAL  Hgt&

    hInstance=Instance             '<< put instance into GLOBAL variable
    DisplayName$= "Generic"

    szClassName = "Generic_Class"

    '-----------------------------------------------
    ' fill window class UDT with the required values
    '-----------------------------------------------
    wc.cbSize        = SIZEOF(wc)
    wc.style         = %CS_HREDRAW or _
                       %CS_VREDRAW or _
                       %CS_BYTEALIGNCLIENT or _
                       %CS_BYTEALIGNWINDOW
    wc.lpfnWndProc   = CODEPTR(WndProc)    '<< address of message proc
    wc.cbClsExtra    = 0
    wc.cbWndExtra    = 0
    wc.hInstance     = hInstance
    wc.hIcon         = LoadIcon(hInstance,"TEMPLATE")
    wc.hCursor       = LoadCursor(%NULL,ByVal %IDC_ARROW)
    wc.hbrBackground = %COLOR_APPWORKSPACE + 1
    wc.lpszMenuName  = %NULL
    wc.lpszClassName = VarPtr(szClassName)
    wc.hIconSm       = LoadIcon(hInstance,"TEMPLATE")

    '----------------------------------------------
    ' register the class with the operating system
    '----------------------------------------------
    RegisterClassEx wc

    '----------------------------------------
    ' get some numbers to set the window size
    '----------------------------------------
    Sw&=GetSystemMetrics(%SM_CXSCREEN)           ' << screen width
    Sh&=GetSystemMetrics(%SM_CYSCREEN)           ' << screen height
    Wid& = 500                                   ' << set win width
    Hgt& = 350                                   ' << set win height

    '------------------------------
    ' Create the window & center it
    '------------------------------
    hWnd = CreateWindowEx(%WS_EX_LEFT, _
                        szClassName, _           ' window class name
                        ByCopy DisplayName$, _   ' window title
                        %WS_OVERLAPPEDWINDOW, _  ' window style
                        Sw&\2-(Wid&\2), _        ' initial x position
                        Sh&\2-(Hgt&\2), _        ' initial y position
                        Wid&, _                  ' initial x size
                        Hgt&, _                  ' initial y size
                        %NULL, _                 ' parent window handle
                        %NULL, _                 ' window menu handle
                        hInstance, _             ' program instance handle
                        ByVal %NULL)             ' creation parameters

    '----------------------------------------
    ' load the menu resource from the current 
    ' module and set it to the created window
    '----------------------------------------
    hMnu&=LoadMenu( hInstance,"MENU1")
    SetMenu hWnd, hMnu&

    '---------------------------------
    ' display the window and update it
    '---------------------------------
    ShowWindow hWnd, nCmdShow
    UpdateWindow hWnd

    '-------------------------------------------------
    ' Enter the main message loop which continues
    ' until your application sends a "PostQuitMessage"
    ' to it from the WM_DESTROY message in WndProc.
    ' When the GetMessage() function receives the message
    ' it returns zero (0) which exits the loop.
    '-------------------------------------------------
    Do While GetMessage(Msg,%NULL,0,0) <> 0
      TranslateMessage Msg
      DispatchMessage  Msg
    Loop

  FUNCTION = Msg.wParam

END FUNCTION

'##########################################################################

FUNCTION WndProc(ByVal hWin   as LONG, _
                 ByVal Msg    as LONG, _
                 ByVal wParam as LONG, _
                 ByVal lParam as LONG) EXPORT as LONG

      LOCAL hDC as LONG
      LOCAL Ps  as PaintStruct
      LOCAL Rct as Rect

  Select Case Msg

      Case %WM_COMMAND
        '----------------------------------------------------
        ' Menus, toolbar buttons and normal buttons send a
        ' WM_COMMAND message to their parent window. You get
        ' the ID of the sending item by trapping the low word
        ' of the passed "wParam" and process the command as
        ' your application requires.
        '----------------------------------------------------
        Select Case LoWrd(wParam)
          Case 1098
            SendMessage hWin,%WM_SYSCOMMAND,%SC_CLOSE,ByVal %NULL

          Case 1099
          x&=ShellAbout(hWin,ByCopy "  About "+DisplayName$+"#Windows Generic Application",_
                        ByCopy DisplayName$+" Copyright  1998"+chr$(13,10)+_
                        "PowerBASIC, Inc.",_
                        LoadIcon(hInstance,"TEMPLATE"))

        End Select

      Case %WM_CREATE
        '----------------------------------------
        ' startup code that needs to be performed
        ' before the CreateWindowEx() function
        ' returns a handle can be done here.
        '----------------------------------------

      Case %WM_SIZE
        '--------------------------------
        ' used when a child window in the 
        ' client area has to be resized.
        '--------------------------------
  
      Case %WM_PAINT
        '------------------------------------------------------
        ' The operating system sends a WM_PAINT message to
        ' a window whenever something changes in that window,
        ' resizing, being overlapped by another window,
        ' restoring or maximizing the window. You trap it
        ' if you need to draw a graphic or place a bitmap image
        ' in the window's client area.
        '------------------------------------------------------
        hDC = BeginPaint(hWin,Ps)
          GetClientRect hWin,Rct
          Paint_Proc hWin,hDC
        EndPaint hWin,Ps
        Function=0
        Exit Function

      Case %WM_CLOSE
        ' -------------------------------------------
        ' This message allows you to close files, deallocate
        ' memory and perform exit confirmation before the 
        ' WM_DESTROY message is sent. It allows you to change 
        ' your mind and keep the application going if you
        ' need to do so.
        ' -------------------------------------------
        Select Case MessageBox(hWin,"Do you wish to Exit ?",_
                               ByCopy DisplayName$,%MB_YESNO)
          Case %IDNO
            Function=0
            Exit Function
        End Select

      Case %WM_DESTROY
        ' -------------------------------------------------------
        ' This message is necessary to send the "PostQuitMessage"
        ' to the main message loop in the WinMain() function. If
        ' it is not present in the WndProc() function, the window
        ' will disappear but remain in memory.
        ' -------------------------------------------------------
        PostQuitMessage 0
        Function=0
        Exit Function

  END Select

  FUNCTION = DefWindowProc(hWin,Msg,wParam,lParam)
  '-----------------------------------------------------
  ' The DefWindowProc() function does all of the default
  ' message processing that your application does not
  ' need to trap and process.
  '-----------------------------------------------------

END FUNCTION

'##########################################################################

SUB Paint_Proc(hWin as LONG,hDC as LONG)

    ' This sub is unused but it is where graphic that have to remain
    ' on the screen after resizing and being overlapped by other
    ' windows needs to be placed.

    ' Resizing, being overlapped by another window, restoring or
    ' maximizing a window trigger a WM_PAINT message from the
    ' operating system to the window which repaints it with the
    ' color specified in the "wc.hbrBackground" member of the structure
    ' or "User defined type" in the WinMain function.

    ' Drawing graphics or placing bitmap images from this SUB will
    ' display the graphic or bitmap after the WM_PAINT message has been
    ' processed so that it becomes a "persistent" graphic.

END SUB

'##########################################################################
