;
; Inject.asm
; ----------
; By Gij
; ======
;
; Intercepts calls to WSOCK32!connect by Gamespy, rerouting connection
; request to the registration server to the local host.
;
; Much of this is based on Stone's articles. Respect.
;
; 23/Jun/98

BITS 32

extern _CallNextHookEx
extern _GetProcAddress@8
extern _LoadLibraryA
extern _Process32First
extern _Process32Next
extern _ExitProcess@4
extern _GetModuleHandleA@4
extern _OpenProcess@12
extern _WriteProcessMemory@20
extern _ReadProcessMemory@20

global _WinMain@16

TH32CS_SNAPPROCESS 	equ 2
PROCESS_VM_WRITE 	equ 32
MAX_PATH 		equ 260

IAT_ENTRY_ADDR 		equ 0x4b7794 ; Virtual Size Of code + Virtual Address
                                     ; + Load Base 
BACKUP_IAT_ENTRY_ADDR 	equ 0x4e2b42



;------------------------------------------------------------------------------=
; Code

SEGMENT .text USE32 CLASS=CLASS

_WinMain@16:

;	int3

	call Get_Proc_Addresses

	call Find_Target_Process
	test eax,eax
	jz exit_program

open_process:

	push dword [th32ProcessID]
	push dword 0
	push DWORD PROCESS_VM_WRITE
	call _OpenProcess@12
	mov [Process_Handle],eax

	call Read_In_Save_Orig_Entry
	call Write_Code_And_IAT


exit_program:

	push dword 0
	call _ExitProcess@4

	ret


;------------------------------------------------------------------------------=
; Get_Proc_Addresses:
;		The LCC Libraries don't include addresses for Toolhelp32,
;		so it has to be done manually.

Get_Proc_Addresses:

	push dword Kernel32
	call _GetModuleHandleA@4
	mov [Kernel32_Handle],eax

	push dword Create32Snapshot
	push dword [Kernel32_Handle]
	call _GetProcAddress@8
	mov [Snap_PROC],eax

	push dword Process32First
	push dword [Kernel32_Handle]
	call _GetProcAddress@8
	mov [Walk_First],eax

	push dword Process32Next
	push dword [Kernel32_Handle]
	call _GetProcAddress@8
	mov [Walk_Next],eax

	ret

;------------------------------------------------------------------------------=
; Find Target Process: 
;		Uses Toolhelp32 to walk through the task list 
;		looking for gamespy.
Find_Target_Process:

	push dword 0
	push dword TH32CS_SNAPPROCESS
	call [Snap_PROC]			; create snapshot of processes
	mov [Snapshot],eax

	push dword PROCESSENTRY32
	push dword [Snapshot]
	call dword [Walk_First]			; Get First Entry

.loop_mark:

	test eax,eax
	jz Return

	mov ecx,260
	mov edi,szExeFile
	xor al,al
	repnz scasb				; Find End Of module EXE name 
	dec edi
	cmp byte [edi],0
	jnz Return
	mov esi,EXE_Name+EXE_NAME_LEN-1
	mov ecx,EXE_NAME_LEN
	std
	rep cmpsb				; compare with gamespy.exe 
	jz Found_Target				; jump if this is the one

	push dword PROCESSENTRY32
	push dword [Snapshot]
	call dword [Walk_Next]			; get next entry

	jmp .loop_mark

Found_Target:

	mov eax,1
	ret

Return:

	xor eax,eax
	ret


;------------------------------------------------------------------------------=
; Read_In_Save_Orig_Entry:
;		Read in DWORD IAT Entry at IAT_ENTRY_ADDR and 
;		save at BACKUP_IAT_ENTRY_ADDR

Read_In_Save_Orig_Entry:

	push dword Written_Count
	push dword 4 ; dword 
	push dword Orig_Connect_Entry
	push dword IAT_ENTRY_ADDR
	push dword [Process_Handle]
	call _ReadProcessMemory@20

	push dword Written_Count
	push dword 4 ; dword 
	push dword Orig_Connect_Entry
	push dword BACKUP_IAT_ENTRY_ADDR
	push dword [Process_Handle]
	call _WriteProcessMemory@20

	ret

;------------------------------------------------------------------------------=
; Write_Code_And_IAT:
;		Append Replacment code at [code_write_addr]
;		overwrite old IAT entry with address of replacment code.

Write_Code_And_IAT:

Inject_API_Hook:

	push dword Written_Count
	push dword Connect_Hook_End-Connect_Hook
	push dword Connect_Hook
	push dword [Code_Write_Address]
	push dword [Process_Handle]
	call _WriteProcessMemory@20

Hook_API_IAT_Entry:

	push dword Written_Count
	push dword 4 ; dword 
	push dword Code_Write_Address
	push dword IAT_ENTRY_ADDR
	push dword [Process_Handle]
	call _WriteProcessMemory@20

	ret


;------------------------------------------------------------------------------=
; Connect Hook:
;		replacment code, this is called instead of WSOCK32!connect
;		it checks the ip and port, and changes the IP if neccesey
;		thus rerouting the connection to Localhost
;
; Proto: int connect (SOCKET, const struct sockaddr FAR*  name,int namelen );

IP 	equ 0x5EA1B6CC 
PORT 	equ 0x2364

Connect_Hook:

;	int3

	push ebp
	mov ebp,esp

	pushad				; save just in case

	mov esi,[ebp+0ch]
	cmp dword [esi+4],IP
	jnz call_API
	cmp word [esi+2],PORT
	jnz call_API

Modify_Params:

	mov dword [esi+4],0x0100007f	; chane IP addr to 127.0.0.1

call_API:

	popad				; everything that gets pushed must 
					; be popped

	push dword [ebp+10h]
	push dword [ebp+0ch]
	push dword [ebp+8h]

	call dword [BACKUP_IAT_ENTRY_ADDR] ; Call WSOCK32!connect at new IAT 
					   ; entry

	mov esp,ebp
	pop ebp
	ret 0ch

Connect_Hook_End:

;------------------------------------------------------------------------------=
; Data

SEGMENT .data USE32 CLASS=DATA

Kernel32 		db "kernel32.dll",0
Process32First 		db "Process32First",0
Process32Next 		db "Process32Next",0
Create32Snapshot 	db "CreateToolhelp32Snapshot",0

EXE_Name 		db "GAMESPY.EXE",0
EXE_NAME_LEN 		equ 12

Snap_PROC 		dd 0	; Address of "CreateToolhelp32Snapshot" is here
Walk_First 		dd 0    ; Address of "Process32First" is here
Walk_Next 		dd 0    ; Address of "Process32Next" is here

Written_Count 		dd 0
Process_Handle 		dd 0

Code_Write_Address 	dd 0x4b661e ; Virtual Size Of code + Virtual Address + 
                                    ; Load Base 

Orig_Connect_Entry	dd 0

Kernel32_Handle 	dd 0
Snapshot 		dd 0

PROCESSENTRY32:
dwSize 			dd PROCESSENTRY32_END-PROCESSENTRY32
cntUsage 		dd 0
th32ProcessID 		dd 0
th32DefaultHeapID 	dd 0
th32ModuleID 		dd 0
cntThreads 		dd 0
th32ParentProcessID 	dd 0
pcPriClassBase 		dd 0
dwFlags 		dd 0
szExeFile times MAX_PATH db 0
PROCESSENTRY32_END:

;------------------------------------------------------------------------------=
; "Don't you know who that fat lady really is? ... Ah, buddy. Ah, buddy. 
;  It's God Himself. God himself, buddy."