comment %

	ClipWipe - a program to wipe (empty) the Windows 95 clipboard.

	Copyright (c) 1998 G. Adam Stanislav
	All Rights Reserved

	e-mail: whizkid@bigfoot.com
	snailmail: Whiz Kid Technomagic, Rhinelander, WI 54501, USA

	The copy-and-paste and cut-and-paste abilities of Windows 95
	are no doubt wonderful. Alas, these operations often end
	up wasting large amounts of memory (for example when copying
	a bitmap, or a large text buffer). Unfortunately, very few
	programs offer to delete the contents of the Windows
	clipboard (CorelDRAW! is a wonderful exception).

	This program allows you to empty the contents of the
	clipboard and regain the memory it is wasting.

	I suggest you either place it on the Desktop, or create
	a Desktop shortcut to it. You will find it very useful,
	especially if your system does not have much memory.


THE LEGAL STUFF
===============

	You may distribute this program to others for non-commercial
	purposes. You must distribute the whole package (ZIP file)
	with all original files intact. You may not charge for it.

	You can also download it from my web site at:

	http://www.geocities.com/SiliconValley/Heights/7394/
	====================================================

	Although this software may be distributed freely, its
	use is not free. You may use it for 30 days for
	evaluation purposes. After 30 days, you must either
	delete it from your system or mail $35.00 (US currency) to:

		G. Adam Stanislav
		Whiz Kid Technomagic
		Rhinelander, WI 54501

	If you are an OEM, VAR, computer consultant, or similar,
	and want to distribute this program to your custommers,
	contact me at whizkid@bigfoot.com for licensing. Since that
	constitues commercial purposes, you may not distribute
	this program without a license.

%
.386
.model flat

option prologue:none
option epilogue:none

include ..\win.inc
include ..\wincalls.inc

.data
szAppName	db	"ClipWipe", 0
szBusy	db	"Could not access the clipboard:", 0Ah
	db	"It is in use by another application.", 0
szEmpty	db	"The clipboard is empty.", 0
szFull	db	"The clipboard contains copied data.", 0Ah
	db	"Do you wish to empty it?", 0
szSuccess	db	"Clipboard emptied successfully.", 0
szFail	db	"Failed to empty the clipboard.", 0

.code

align DWORD
clipwipe	proc	stdcall	public

	pusha

	sub	edi, edi
	push	edi
	call	GetModuleHandle
	mov	esi, eax	; "hInstance"

@@:
	push	esi
	call	OpenClipboard
	or	eax, eax
	jne	@F

	; Clipboard open by another application. Ask whether to retry.
	push	MB_RETRYCANCEL or MB_ICONWARNING
	push	NEAR PTR szAppName
	push	NEAR PTR szBusy
	push	esi
	call	MessageBox
	cmp	eax, IDRETRY
	je	@B

	popa
	ret

@@:
	push	edi
	call	EnumClipboardFormats
	or	eax, eax
	je	$IsEmpty
	mov	edi, eax
	push	eax
	call	IsClipboardFormatAvailable
	or	eax, eax
	je	@B

	; Clipboard is not empty
	push	MB_ICONQUESTION or MB_YESNO
	push	NEAR PTR szAppName
	push	NEAR PTR szFull
	push	esi
	call	MessageBox
	cmp	eax, IDNO
	je	$Quit

@@:
	call	EmptyClipboard
	or	eax, eax
	jne	@F

	; Failed to empty clipboard
	push	MB_ICONERROR or MB_RETRYCANCEL
	push	NEAR PTR szAppName
	push	NEAR PTR szFail
	push	esi
	call	MessageBox
	cmp	eax, IDRETRY
	je	@B

$Quit:
	call	CloseClipboard

	popa
	ret

@@:
	; Clipboard emptied successfully
	call	CloseClipboard
	push	MB_ICONINFORMATION or MB_OK
	push	NEAR PTR szAppName
	push	NEAR PTR szSuccess
	push	esi
	call	MessageBox

	popa
	ret

$IsEmpty:
	; Clipboard is empty
	call	CloseClipboard

	push	MB_ICONINFORMATION or MB_OK
	push	NEAR PTR szAppName
	push	NEAR PTR szEmpty
	push	esi
	call	MessageBox

	popa
	ret

clipwipe	endp

end

