/* POLYTEST.C

	Programmed by G. Adam Stanislav, March 27, 1998

	Copyright  1998 G. Adam Stanislav
	All rights reserved

	The purpose of this program is to show how to use clockwise.dll to
	determine whether a polygon has been drawn clockwise or counter-clockwise,
	as well as to test visually that the algorithm used in the DLL works
	properly.

	This program is written in C rather than assembly language mostly to test
	that the DLL will work with programs written in languages other than ASM.

	This program contains no menu: All you do is click the mouse to add vertices
	to a polygon, or right-click to start a new polygon. The program will
	accept up to 2,048 vertices, and presumably beep afterwards (I say presumably
	as I have never actually tried clicking 2,048 times...).

*/

#include "clockwise.h"
#include "resource.h"

#define POLYSIZE	2048

POINT poly[POLYSIZE];
unsigned long nPoints = 0;

LRESULT CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam) {
	HDC	hdc;
	PAINTSTRUCT	ps;

	switch (iMsg) {
		case WM_PAINT:
			hdc = BeginPaint(hwnd, &ps);
			SelectObject(hdc, GetStockObject(LTGRAY_BRUSH));
			SelectObject(hdc, GetStockObject(BLACK_PEN));

			Polygon(hdc, poly, nPoints);

			EndPaint(hwnd, &ps);
			return 0;

		case WM_LBUTTONDOWN:
			if (nPoints < POLYSIZE) {
				poly[nPoints].x = LOWORD (lParam);
				poly[nPoints++].y = HIWORD (lParam);
				switch (ClockWise(poly, nPoints, XRIGHTYDOWN)) {
					case COUNTERCLOCKWISE:
						SetWindowText(hwnd, "Counter-clockwise");
						break;
					case CLOCKWISE:
						SetWindowText(hwnd, "Clockwise");
						break;
					default:
						SetWindowText(hwnd, "Undetermined");
				}
				InvalidateRect(hwnd, NULL, TRUE);
			}
			else
				MessageBeep(0);
			return 0;

		case WM_RBUTTONDOWN:
			nPoints = 0;
			SetWindowText(hwnd, "None");
			InvalidateRect(hwnd, NULL, TRUE);
			return 0;

		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
	}
	return DefWindowProc(hwnd, iMsg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow) {
	static char szAppName[] = "PolyTest";
	HWND	hwnd;
	MSG	msg;
	WNDCLASSEX	wndclass;

	wndclass.cbSize	= sizeof(wndclass);
	wndclass.style	= CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc	= WndProc;
	wndclass.cbClsExtra	=
	wndclass.cbWndExtra	= 0;
	wndclass.hInstance	= hInstance;
	wndclass.hIcon	=
	wndclass.hIconSm	= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
	wndclass.hCursor	= LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground	= (HBRUSH) GetStockObject(WHITE_BRUSH);
	wndclass.lpszMenuName	= NULL;
	wndclass.lpszClassName	= szAppName;

	RegisterClassEx(&wndclass);

	hwnd = CreateWindow(szAppName, "Polygon Direction",
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, hInstance, NULL);

	ShowWindow(hwnd, iCmdShow);
	UpdateWindow(hwnd);

	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

