TITLE	clockwise.asm, version 1.0
comment #

	Programmed by G. Adam Stanislav
	Whiz Kid Technomagic
	Rhinelander, WI 54501, USA

	whizkid@bigfoot.com
	http://www.bigfoot.com/~whizkid

	March 29, 1998

	Copyright  1998 G. Adam Stanislav
	All rights reserved

	This is a Windows 95/NT DLL which determines whether a polygon is convex
	or concave.

	To find the latest version of this DLL, go to http://www.bigfoot.com/~whizkid
	and follow the link to the Windows assembly language page.

	Algorithm used:

	1. Check if polygon has at least three vertices. If not, return 0.

	2. For every vertex check if the adjacent edges are clockwise or counter-
	clockwise.

	3. If either all edges are clockwise, or all edges are counter-clockwise,
	the polygon is convex. Return 1.
	
	4. Otherwise it is concave. Return -1.

	Note: It is not necessary to check all vertices if the polygon is concave.
	We simply set a clockwise/counter-clockwise flag. As soon as both flags
	are set, we know the polygon is concave.

	On the other hand, if the polygon is convex, we need to check the
	adjacent edges of all vertices.

	To determine whether the edges are clockwise or counter-clockwise, I am
	using an algorithm discovered by Paul Bourke of Brain Dynamics Research Unit,
	Mental Health Research Institute, Victoria, Australia. In his own words:

	"Consider 3 consecutive points, p0,p1,p2, on the plane (p.x,p.y,p.z) p.z=0
	Take the cross product between p1-p0 and p2-p1
	If p.z is positive then the cross product lies out from the page and
	the curve is anticlockwise.
	If p.z is negative then the curve lies into the page and the curve
	is clockwise."

	Note: The code in this DLL is thread-safe. That means any number of threads
	may call it at the same time.

	LIMITATION: The algorithm used here works only with convex and concave
	polygons. It does NOT work with stellar polygons (i.e. polygons in which
	one edge intersects another at a point other than a vertex).

	If you know how to determine a polygon is stellar, please e-mail me at
	whizkid@bigfoot.com so I can include such a test here.

	The legal stuff:
	================

	You may use convex.dll with commercial or non-commercial applications
	free of charge. However, if you use this DLL commercially, you are required
	to place my copyright notice for the DLL in your documentation and in the
	"About" display of your program. Note that an icon (convex.ico) is
	included in the resource section of this DLL. You may use it in the "About"
	display of my copyright. It was declared in the resource file as resource
	number 1 (i.e. 1 ICON DISCARDABLE "convex.ico").

	The key word above is APPLICATIONS: You may not distribute this DLL
	with an operating system (for example, Microsoft may not include this DLL
	with any version of Windows without an express permission from the author).

	If you distribute this DLL with your applications, install it in Windows
	system directory (folder). In doing so, do not overwrite any newer version
	of the DLL. You must include this source code whenever you are distributing
	the DLL.

	You may not modify this DLL in any way. That implies that you may not remove
	the resources linked with this DLL (file version, copyright and other
	information, the icon).

	Exception: Paul Bourke may use this code in any way he sees fit. After all,
	this DLL would not be written without his help.

#
.386
.model flat

.code

align DWORD
_dll@12	proc

	mov	eax, 1
	ret	12

_dll@12	endp

_p$ = 8
_n$ = 12
_z$ = -8
align DWORD
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; #include <windows.h>
;;
;; int __stdcall Convex(POINT *p, unsigned int n);
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
_Convex@8 proc	public

	push	ebp
	mov	ebp, esp
	sub	esp, 8
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi

	sub	eax, eax
	mov	ecx, DWORD PTR _n$[ebp]
	cmp	ecx, 3
	jb	$Done

	sub	ebx, ebx	; BL = flag = 0
	mov	edi, DWORD PTR _p$[ebp]		; EDI = p
	mov	esi, ecx		; ESI = n

$Loop:
	; ECX = i + 1
	push	esi		; Save n
	lea	edx, [ecx+1]	; EDX = i + 2
	cmp	edx, esi
	jb	@F
	sub	edx, esi

	; EDX = k = (i + 2) % n

@@:
	push	DWORD PTR [edi][edx*8+4]	; p[k].y
	push	DWORD PTR [edi][edx*8]	; p[k].x

	dec	edx
	jns	@F
	add	edx, esi

	; EDX = j = (i + 1) % n

@@:
	mov	esi, DWORD PTR [edi][edx*8+4]	; p[j].y
	sub	esi, DWORD PTR [edi][ecx*8-4]	; - p[i].y
	pop	eax			; p[k].x
	sub	eax, DWORD PTR [edi][edx*8]	; - p[j].x
	push	edx
	imul	esi
	mov	DWORD PTR _z$[ebp], eax
	mov	DWORD PTR _z$[ebp+4], edx
	pop	edx

	mov	esi, DWORD PTR [edi][edx*8]	; p[j].x
	sub	esi, DWORD PTR [edi][ecx*8-8]	; - p[i].x
	pop	eax		; p[k].y
	sub	eax, DWORD PTR [edi][edx*8+4]	; - p[j].y
	imul	esi
	pop	esi		; Restore n
	sub	eax, _z$[ebp]
	sbb	edx, _z$[ebp+4]
	js	$or1
	jnz	$or2
	or	eax, eax
	jz	$LoopIt

$or2:
	or	bl, 2
	jmp	$LoopIt

$or1:
	or	bl, 1

$LoopIt:
	cmp	bl, 3
	je	@F
	loop	$Loop

@@:
	sub	eax, eax	; EAX = unknown
	cmp	bl, al
	je	$Done

	inc	al			; EAX = CONVEX
	cmp	bl, 3
	jne	$Done

	neg	eax		; EAX = CONCAVE

$Done:
	pop	edi
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	leave
	ret	8

_Convex@8 endp

end	_dll@12
