TITLE	polyarea.asm
.386
.model flat

comment ^

	Programmed by G. Adam Stanislav
	Whiz Kid Technomagic
	Rhinelander, WI 54501, USA

	whizkid@bigfoot.com
	http://www.bigfoot.com/~whizkid

	March 30, 1998

	Copyright  1998 G. Adam Stanislav
	All rights reserved

	This is a Windows 95/NT DLL which calculates the area of a polygon.

	To find the latest version of this DLL, go to http://www.bigfoot.com/~whizkid
	and follow the link to the Windows assembly language page.

	The following is the C language equivalent of the code in this DLL:

	#include <windows.h>
	
	#define j	((i + 1) % n)
	
	double WINAPI PolygonArea(POINT *p, UINT n) {
		int i;
		double area = 0.0;
		
		if (n < 3)
			return 0.0;
			
		for (i = 0; i < n; i++)
			area += (double)(p[i].x * p[j].y - p[i].y * p[j].x);
			
		area *= 0.5;

		return area < 0.0 ? -area : area;
	}

	The legal stuff:
	================

	You may use polyarea.dll with commercial or non-commercial applications
	free of charge. However, if you use this DLL commercially, you are required
	to place my copyright notice for the DLL in your documentation and in the
	"About" display of your program. Note that an icon (polyarea.ico) is
	included in the resource section of this DLL. You may use it in the "About"
	display of my copyright. It was declared in the resource file as resource
	number 1 (i.e. 1 ICON DISCARDABLE "polyarea.ico").

	The key word above is APPLICATIONS: You may not distribute this DLL
	with an operating system (for example, Microsoft may not include this DLL
	with any version of Windows without an express permission from the author).

	If you distribute this DLL with your applications, install it in Windows
	system directory (folder). In doing so, do not overwrite any newer version
	of the DLL. You must include this source code whenever you are distributing
	the DLL.

	You may not modify this DLL in any way. That implies that you may not remove
	the resources linked with this DLL (file version, copyright and other
	information, the icon).

^

.code

align DWORD
_dll@12	proc

	mov	eax, 1
	ret	12

_dll@12	endp

_p$ = 20
_n$ = 24
align DWORD
_PolygonArea@8	proc	public

	push	ebx
	push	ecx
	push	edx
	push	esi


	fld1
	fldz
	fsubr	st(1), st
	; st = 0.0, st(1) = -1

	mov	ecx, _n$[esp]
	cmp	ecx, 3
	jb	$QuickExit

	mov	esi, _p$[esp]	; ESI = p
	sub	ebx, ebx
	jmp	@F

$TheLoop:
	; ECX = i + 1
	mov	ebx, ecx

	; EBX = j = (i + 1) % n
@@:
	fild	DWORD PTR [esi][ecx*8-8]	; p[i].x
	fimul	DWORD PTR [esi][ebx*8+4]	; p[j].y
	faddp	st(1), st

	fild	DWORD PTR [esi][ecx*8-4]	; p[i].y
	fimul	DWORD PTR [esi][ebx*8]	; p[j].x
	fsubp	st(1), st

	loop	$TheLoop

	fabs
	fscale

$QuickExit:
	; Microsoft languages expect a double to be returned
	; on the top of the math coprocessor stack.
	fstp	st(1)

	pop	esi
	pop	edx
	pop	ecx
	pop	ebx

	ret	8

_PolygonArea@8	endp

end	_dll@12
