PAGE 58,132
TITLE VVMD 

COMMENT /

VVMD.ASM
Written by 	Christopher G. Hill
Copyright 	15 May 1991 all rights reserved

You are free to use this example in your own code. You may not sell this
for any price, nor may you charge for its distribution. You are free to 
pass it on to any friend or aquaintance. I will accept no responsibility
for damages occuring due your use of this code in any way. Any use of this
is to be done at your own risk.

/

        .386p

;******************************************************************************
;                             I N C L U D E S
;******************************************************************************

.XLIST
	INCLUDE VMM.Inc
        INCLUDE Debug.Inc
        INCLUDE VVMD.Inc
.LIST



VVMD_CB_DATA STRUC
VVMD_Data	dd	?		;just for the hell of it
VVMD_CB_DATA ENDS

;******************************************************************************
;                V I R T U A L   D E V I C E   D E C L A R A T I O N
;******************************************************************************

Declare_Virtual_Device VVMD, 3, 0, VVMD_Control, VVMD_Dev_ID,, \
                                    VVMD_API_PROC , VVMD_API_Proc


;******************************************************************************
;                         L O C A L   D A T A
;******************************************************************************

VxD_LOCKED_DATA_SEG
        ALIGN   4
VVMD_CB_Offset  dd  0
VxD_LOCKED_DATA_ENDS


;******************************************************************************
;                      I N I T I A L I Z A T I O N  
;******************************************************************************


VxD_ICODE_SEG

BeginProc VVMD_Sys_Crit_Init
        push    ebx
        VMMCall _Allocate_Device_CB_Area, <<SIZE VVMD_CB_DATA>, 0>
        test    eax, eax
        jnz     SHORT VVMD_CB_OK
        Debug_Out "VVMD: Allocate_Device_CB_Area failed"
        VMMCall Fatal_Memory_Error

VVMD_CB_OK:
        mov     [VVMD_CB_Offset], eax
        pop     ebx
        
        clc
        ret
EndProc VVMD_Sys_Crit_Init

VxD_ICODE_ENDS


VxD_LOCKED_CODE_SEG

;******************************************************************************
;   VVMD_Control
;
;       Every VxD needs a control function, and this one is no exception.
;       This is a call-back routine to handle the messages that are sent
;       to VxD's to control system operation. 
;==============================================================================

BeginProc VVMD_Control

        Control_Dispatch Sys_Critical_Init, VVMD_Sys_Crit_Init
        clc
        ret

EndProc VVMD_Control

VxD_LOCKED_CODE_ENDS


VxD_CODE_SEG

BeginDoc
;******************************************************************************
;
;   VVMD_API_Proc
;
;   DESCRIPTION:
;
;       This is the exported API procedure that is callable from VM's. 
;       An application needs only to use INT 2Fh, AX=1684h, BX=device ID
;       and a call back address is returned. Then, when the
;       address is called, eventually it ends up here. 
;	For this API, the API function number will be passed in AX. Other
;	parameters are passed in other registers.
;
;   ENTRY:
;       ebp -> Client data area
;       ebx -> Current VMCB
;
;   FUNCTIONS:
;
;	VVMD version
;		entry:		Client_AX = VER_ID
;		returns:	VERSION in Client_AX
;
;	Kill VM
;		entry:		Client_EBX = Handle of VM to kill
;		returns:	carry flag clear on success
;				carry set on error and error code in Client_AX
;		error codes:	INVALID_HANDLE if VM handle invalid
;				SYS_VM_ERR if VM handle was System VM's
;				CUR_VM_ERR if VM handle was current VM's
;
;	Number of active VMs (including the system VM)
;		entry:		Client_AX = GET_LIST_SIZE
;		returns:	number of VM handles in Client_AX
;
;	List of VM handles
;		entry:		Client_AX = GET_LIST
;				Client_EBX = linear address of caller's buffer
;					     that will hold the handles.
;		returns:	fills the caller's buffer with 32-bit VM
;				handles.
;		note:		It is up to the caller to insure that enough
;				memory exists at the location pointed to in
;				the ebx register. The value in ebx must be 
;				the linear 32-bit address of the user's buffer.
;
;	NOTE: If the function number passed in Client_AX is not one of the
;	above, the carry flag is set and the value: INVALID_FN is returned
;	in the Client_AX register.
;
;	SEE: VVMD.INC for the values of the above equates.
;
;==============================================================================
EndDoc

BeginProc VVMD_API_Proc

CODE_STRING "VVMD_API_Proc"

	push	ebx

	cmp	WORD PTR[ebp.Client_AX],VER_ID
	jne	short VVMD_API_0
	mov	WORD PTR[ebp.Client_AX],VERSION
	and	WORD PTR[ebp.Client_Flags],NOT CF_Mask
	jmp	VVMD_API_Exit		;return version in ax, carry clear
VVMD_API_0:
	cmp	WORD PTR[ebp.Client_AX],KILL_VM
	je	short VVMD_API_KILL_VM
	cmp	WORD PTR[ebp.Client_AX],GET_LIST_SIZE
	je	short VVMD_API_LIST_SIZE
	cmp	WORD PTR[ebp.Client_AX],GET_LIST
	je	short VVMD_API_GET_LIST
	mov	WORD PTR[ebp.Client_AX],INVALID_FN
	jmp	VVMD_API_Error		;don't recognize this function num

VVMD_API_LIST_SIZE:
	xor	ecx,ecx
	VMMCall	Get_Sys_VM_Handle
VMMD_API_LS_0:
	inc	ecx
	VMMCall	Get_Next_VM_Handle
	VMMCall	Test_Sys_VM_Handle
	jnz	VMMD_API_LS_0
	mov	[ebp.Client_AX],cx
	and	[ebp.Client_Flags],NOT CF_Mask
	jmp	short VVMD_API_Exit	
VVMD_API_GET_LIST:
	push	edi
	mov	edi,[ebp.Client_EBX]	;linear buffer address in client's EBX
	VMMCall	Get_Sys_VM_Handle
VVMD_API_GL_0:
	mov	[edi],ebx
	add	edi,4
	VMMCall	Get_Next_VM_Handle
	VMMCall	Test_Sys_VM_Handle
	jnz	VVMD_API_GL_0
	pop	edi
	and	[ebp.Client_Flags],NOT CF_Mask
	jmp	short VVMD_API_Exit
VVMD_API_KILL_VM:
	mov	ebx,[ebp.Client_EBX]
	VMMCall	Validate_VM_Handle	;make sure it's a valid handle
	mov	WORD PTR[ebp.Client_AX],INVALID_HANDLE
	jc	short VVMD_API_ERROR	;carry set if invalid
	VMMCall	Test_Sys_VM_Handle
	mov	WORD PTR[ebp.Client_AX],SYS_VM_ERR
	jz	short VVMD_API_Error	;zero set if system VM handle
	VMMCall	Test_Cur_VM_Handle
	mov	WORD PTR[ebp.Client_AX],CUR_VM_ERR
	jz	short VVMD_API_Error	;zero set if current VM handle
	VMMCall	Nuke_VM			;it all looks ok from here so do it
	and	WORD PTR[ebp.Client_Flags],NOT CF_Mask
	jmp	short VVMD_API_Exit	;exit with carry flag clear

VVMD_API_Error:
	or	WORD PTR[ebp.Client_Flags],CF_Mask

VVMD_API_Exit:
        pop     ebx
        ret
EndProc VVMD_API_Proc

VxD_CODE_ENDS

        END
