// what source (c) '96/97 Niklas Beisert
// this header must stay at top of this file.
// you may only look at the source, you may not use it.
// you may not release anything containing this code or derivatives.
// you may modify for personal needs or experiments.
// you may use the algorithms in non commercial productions if you credit me.

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

static int starttime;
static int pausetime;
static int inited;
static volatile int pausecount;
int keyhit();

int musicstart(void *song)
{
  while (pausecount&&!keyhit())
    Sleep(100);
  pausecount=0;
  starttime=GetTickCount();
  inited=1;
  return 1;
}

void musicstop()
{
  inited=0;
}

double musictimer()
{
  int t=-starttime;
  if (!pausecount)
    t+=GetTickCount();
  return t/1000.0;
}

void musicpoll()
{
  while (pausecount&&!keyhit())
    Sleep(100);
}

void musicpause()
{
  if (pausecount++||!inited)
    return;
  starttime-=GetTickCount();
}

void musicunpause()
{
  if (!pausecount||--pausecount||!inited)
    return;
  starttime+=GetTickCount();
}
