;@goto translate


.586P

.MODEL           FLAT, STDCALL

   OPTION        CASEMAP: NONE

   INCLUDE       WINDOWS.inc
   UNICODE       = FALSE
   INCLUDE       APIMACRO.mac

   INCLUDE       ApiHooks.inc

   INCLUDELIB    iKERNEL32.lib
   INCLUDELIB    iUSER32.lib
   INCLUDELIB    iApiHooks.lib



.DATA?
   PIDarraysize  EQU    1000H
   PIDarray      DWORD  PIDarraysize/4 DUP (?) 

.CODE

;======================================

COMMENT $
  Block for RemoteExecute---------------------------------- 
  1) must be self-relative (offsets via Delta).
  2) must save EAX at the beginning and must put it to ECX
     before entering CodeEnd.
  3) you must reserve 4 bytes at code end.
  4) can return any value in EAX; recommended values
     are ErrorSuccess, ErrorRemoteExec and user error codes
     > ErrorTimeOut+5.
  5) as always, must preserve EBX, EBP, ESP, ESI, EDI.
  6) you can protect code with SEH especially if it uses
     addresses from other modules because those  modules may
     not be present or may be relocated in target process.
     Unhandled exception in system process -> BugCheck.
  ---------------------------------------------------------
$ 
    ASSUME FS:  NOTHING
    ASSUME EDI: PTR DWORD

    GetModuleHandleA EQU [EDI][_GetModuleHandleA-_FreeLibrary]
    FreeLibrary      EQU [EDI][_FreeLibrary     -_FreeLibrary]
    DllName          EQU [EDI][_DllName         -_FreeLibrary]
    DllOfs           EQU [EDI][_FreeLibrary       -ScoutDelta]

  Scout:
    PUSH     EAX          ;Save BeginEAX  (point 2)
    PUSH     EDI          ;Save EDI       (point 5)
    SUB      EAX,  EAX
    CALL     XX

 ;xHandler==================================
   ScoutDelta:
    CALL     xDelta
   xDelta:
    POP      EDX
    MOV      ECX, [ESP+12]
    LEA      EDX, [EDX][ScoutxEnd-xDelta]
    MOV      EAX, [ESP+8]
    MOV      (CONTEXT PTR [ECX]).regEip, EDX
    MOV      (CONTEXT PTR [ECX]).regEsp, EAX
    SUB      EAX, EAX
    RETN
 ;==========================================

   XX:
    MOV      EDI, [ESP]
    LEA      EDI, DllOfs
    PUSH     FS:[EAX]
    MOV      FS:[EAX], ESP

    LEA      ECX,  DllName
    sWin32   GetModuleHandleA, ECX
    sWin32   FreeLibrary, EAX

    PUSH     ErrorSuccess     ;return code
    TEST     EAX,  EAX
    POP      EAX          
    JNE      ScoutCleanUp
   ScoutxEnd:
    PUSH     ErrorRemoteExec  ;return code
    POP      EAX
   ScoutCleanUp:
    POP      FS:[0]
    POP      EDX
    POP      EDI          ;Restore EDI        (point 5) 
    POP      ECX          ;EndECX := BeginEAX (point 2)

   ScoutCodeEnd DWORD 0   ;4 bytes reserved   (point 3) 

   
  ALIGN 4
    _GetModuleHandleA  DWORD ?
    _FreeLibrary       DWORD ?
    TEXTA   _DllName,  <Alien.dll/0>

  ScoutSize  EQU ($-Scout)

    ASSUME   EDI: NOTHING
;======================================

   TEXT      zTitle,    <Refiltration/0> 
   TEXT      GAPFailed, <Can/-t retrieve process IDs./0> 
   TEXT      Done,      </#u processes refiltered./0>

 Start:
;=================================================
   ;Prepare API addresses in Scout

   iMOV      EAX, GetModuleHandleA
   MOV       _GetModuleHandleA, EAX
   iMOV      EAX, FreeLibrary
   MOV       _FreeLibrary, EAX
;=================================================
   SUB       EBP, EBP
   ;Get identificators of all currently running processes.
 
   MOV       ESI, OFFSET PIDarray
   sWin32    GetCurrentPIDs, ESI, SIZEOF PIDarray
   TEST      EAX, EAX
   MOV       EBX, sGAPFailed
   JE        MsgBox
   MOV       EBX, EAX       ;total number of processes
;=================================================
   ;Execute Scout in the process represented
   ;by given identificator.
   ;(Scout unloads Alien.dll)
   ;In W9X you can help "hooking" KERNEL32.DLL process by any
   ;activity while ApiHooks does its job, for example by runnig
   ;other application.
   ;KERNEL32.DLL process can be hooked easily via TMext01x.dll
   ;(at least on the second try).

  NextPID:
   LODSD     ;get PID

    ;Use NT4 technique in W2K if possible
   ;and give ApiHooks 10 seconds to complete remote execution.

   iWin32    RemoteExecuteTimeW2K, EAX, 10000, OFFSET Scout, ScoutSize, OFFSET ScoutCodeEnd
   TEST      EAX, EAX
   JNE       @F
   INC       EBP  ;Scout was applied and unloaded Alien.dll
  @@:
   DEC       EBX
   JG        NextPID
;=================================================
   ;Print results and exit.

   MOV       EBX, OFFSET PIDarray
   icWin32i  wsprintf, EBX, sDone, EBP
  MsgBox:
   iWin32i   MessageBox, NULL, EBX, szTitle, MB_ICONINFORMATION 
   iWin32    ExitProcess, NULL

INCLUDE GetPIDs.inc

END Start

:translate
@echo off
ML   /c /coff /nologo ReFilter.bat
LINK ReFilter /nologo /SUBSYSTEM:WINDOWS /MERGE:.idata=.text /IGNORE:4078 /SECTION:.text,EWR
DEL  ReFilter.obj
PAUSE
CLS