// ApiHook.h - constants and structure for Hook libraries

 #define  HOOK_EXPORT      0001
 #define  HOOK_IMPORT      0002
 #define  HOOK_BY_ADDRESS  0004
 #define  HOOK_HARD        0008

 #define  HOOKS_END        (LPCSTR)-1
 #define  DYNAMIC_HOOKS    (LPCSTR)-2

 #define  ALL_MODULES      (LPCSTR)-1

 typedef struct  _ADDR_CONTENTS      {
  DWORD         *ReturnWhere;
  DWORD          ReturnWhat;
 } ADDR_CONTENTS, *PADDR_CONTENTS;

 typedef  struct _API_UNHOOK  {
  DWORD          MaxNoAddr;
  DWORD          CurNoAddr;
  PADDR_CONTENTS WhereWhat; 
 } API_UNHOOK, *PAPI_UNHOOK;

 typedef struct  _API_HOOK   {
  LPCSTR       ModuleExport;
  LPCSTR       ApiNameOrOrd;
  DWORD        dwFlags;
  LPCSTR       ModuleImport;
  PAPI_UNHOOK  UnhookAddresses;
  LPVOID       HookAddress;
 } API_HOOK, *PAPI_HOOK;


 __declspec(dllimport) DWORD __stdcall EstablishApiHooksA(LPCSTR lpszDll, DWORD ProcessId);
 __declspec(dllimport) DWORD __stdcall EstablishApiHooksW(LPCSTR lpszDll, DWORD ProcessId);
 __declspec(dllimport) DWORD __stdcall EstablishApiHooksTimeA(LPCSTR lpszDll, DWORD ProcessId, LONG dwMilliseconds);
 __declspec(dllimport) DWORD __stdcall EstablishApiHooksTimeW(LPCSTR lpszDll, DWORD ProcessId, LONG dwMilliseconds);
 __declspec(dllimport) DWORD __stdcall EstablishApiHooksTimeW2KA(LPCSTR lpszDll, DWORD ProcessId, LONG dwMilliseconds);
 __declspec(dllimport) DWORD __stdcall EstablishApiHooksTimeW2KW(LPCSTR lpszDll, DWORD ProcessId, LONG dwMilliseconds);
 __declspec(dllimport) DWORD __stdcall RemoteExecuteTime(DWORD ProcessId, LONG dwMilliseconds, LPVOID lpBlock, DWORD BlockSize, LPVOID lpCodeEnd);
 __declspec(dllimport) DWORD __stdcall RemoteExecuteTimeW2K(DWORD ProcessId, LONG dwMilliseconds, LPVOID lpBlock, DWORD BlockSize, LPVOID lpCodeEnd);

 #ifdef UNICODE
 #define EstablishApiHooks  EstablishApiHooksW
 #define EstablishApiHooksTime  EstablishApiHooksTimeW
 #define EstablishApiHooksTimeW2K  EstablishApiHooksTimeW2KW
 #else
 #define EstablishApiHooks  EstablishApiHooksA
 #define EstablishApiHooksTime  EstablishApiHooksTimeA
 #define EstablishApiHooksNT4Time  EstablishApiHooksTimeW2KA
 #endif

 #define  ErrorSuccess     0
 #define  ErrorException   1
 #define  ErrorOpenProcess 2
 #define  ErrorRemoteAlloc 3
 #define  ErrorRemoteExec  4
 #define  ErrorRemoteFree  5
 #define  ErrorTimeOut     9

 #define  H_E              HOOK_EXPORT
 #define  H_I              HOOK_IMPORT
 #define  H_B              HOOK_BY_ADDRESS
 #define  H_H              HOOK_HARD
 #define  HOOK_EXACT       HOOK_EXPORT | HOOK_IMPORT
 #define  HOOK_ALL         HOOK_EXPORT | HOOK_BY_ADDRESS
