;ApiHook.inc - constants and structure for Hook libraries

;standard-----------------------------------------------------------------------
   HOOK_EXPORT       EQU     0001B
   HOOK_IMPORT       EQU     0010B
   HOOK_BY_ADDRESS   EQU     0100B
   HOOK_HARD         EQU     1000B

   HOOKS_END         EQU     -1
   HOOKS_DYNAMIC     EQU     -2

   ALL_MODULES       EQU     -1

   ADDR_CONTENTS     STRUCT  DWORD
    ReturnWhere      LPDWORD ?
    ReturnWhat       DWORD   ?
   ADDR_CONTENTS     ENDS

   PADDR_CONTENTS    TYPEDEF PTR ADDR_CONTENTS

   API_UNHOOK        STRUCT  DWORD
    MaxNoAddr        DWORD   ?
    CurNoAddr        DWORD   0
    WhereWhat        PADDR_CONTENTS ?
   API_UNHOOK        ENDS

   PAPI_UNHOOK       TYPEDEF PTR API_UNHOOK

   API_HOOK          STRUCT  DWORD
    ModuleExport     LPCSTR      ?
    ApiNameOrOrd     LPCSTR      ?
    dwFlags          DWORD       ?
    ModuleImport     LPCSTR      ?
    UnhookAddresses  PAPI_UNHOOK ?
    HookAddress      LPVOID      ?
   API_HOOK          ENDS

   PAPI_HOOK         TYPEDEF PTR API_HOOK

   ErrorSuccess      = 0
   ErrorException    = 1
   ErrorOpenProcess  = 2
   ErrorRemoteAlloc  = 3
   ErrorRemoteExec   = 4
   ErrorRemoteFree   = 5
   ErrorCommandLine  = 6
   ErrorCreateProcess= 7
   ErrorProcNotFound = 8
   ErrorTimeOut      = 9
  
  
   H_E               = HOOK_EXPORT
   H_I               = HOOK_IMPORT
   H_B               = HOOK_BY_ADDRESS
   H_H               = HOOK_HARD
   HOOK_EXACT        = HOOK_EXPORT OR HOOK_IMPORT
   HOOK_ALL          = HOOK_EXPORT OR HOOK_BY_ADDRESS

;useful-------------------------------------------------------------------------

   EndHooks          EQU DWORD HOOKS_END
 
   BeginHooks MACRO __nomen
           PUBLIC  __nomen
           ALIGN 4
          __nomen LABEL API_HOOK
           ENDM
 
   MkHook  MACRO  __symbol, __module_export, __procedure, __method, __module_import
           IFNB <__symbol>
            __symbol LABEL API_HOOK
           ENDIF
           IFNB <__module_export>
            DWORD s&__module_export
           ELSE
            DWORD sKERNEL32
           ENDIF
           IFDEF  s&__procedure
            DWORD s&__procedure
           ELSE
            DWORD __procedure
           ENDIF
           IFNB <__method>
            DWORD __method
           ELSE
            DWORD HOOK_ALL
           ENDIF
           IFNB <__module_import>
            IFDEF s&__module_import
             DWORD s&__module_import
            ELSE
             DWORD __module_import
            ENDIF
           ELSE
            DWORD ALL_MODULES
           ENDIF
           IFDEF Unhook&__procedure
            DWORD Unhook&__procedure
           ELSE
            DWORD NULL
           ENDIF
           DWORD New&__procedure
           ENDM

  MkUnhook MACRO  __procedure, __maxunhooks
           LOCAL __buffer
           ALIGN 4
          __buffer LABEL ADDR_CONTENTS
           REPT  __maxunhooks*((SIZEOF ADDR_CONTENTS)/(SIZEOF DWORD))
           DWORD 0
           ENDM
           Unhook&__procedure LABEL API_UNHOOK
           DWORD __maxunhooks
           DWORD 0
           DWORD OFFSET __buffer
           ENDM
;-------------------------------------------------------------------------------