                                                                                       
#include <windows.h>
#include <stdio.h>
#include <vector>
#include "Res/resource.h"
#include "Main.h"

using namespace std;
typedef vector<HMODULE> DllArray;

HINSTANCE hInstance;
DllArray hDllArray;

BYTE ch[2] = {'5','2'};
HWND Main_hWnd;

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	// Store the instance we get
	hInstance = hInstance;
    DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_DIALOG), NULL, (DLGPROC)DlgProc,0);
	// Return true, we are ready for hook on the system
	return TRUE;
}


void main()
{
    EnumDlls();
    WinMain(NULL,NULL,NULL,NULL); 
    printf("Freeing Dlls...\n");
    FreeDlls();
}


BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message) // what are we doing ?
	{ 	       
		case WM_INITDIALOG: 
		{   
            Main_hWnd=hWnd;
            LoadDlls(hWnd);
		}
		break;

        case PI_GETASM:
        {
           printf("\nMessage From Plugin Recieved:\n");
           printf("WPARAM = %ld\n",wParam);
           printf("LPARAM = 0x%08X\n",lParam);
           printf("Sending message back to Plugin ;)\n");
           strcpy((char*)lParam,"Hello From Parent!!!");
        }
        break;

		case WM_LBUTTONDOWN: 
		{
			ReleaseCapture(); 
			SendMessage(hWnd,WM_NCLBUTTONDOWN,HTCAPTION,0); 
		}
		break;

		case WM_PAINT: // constantly painting the window
		{
			return 0;
		}
		break;
		
        
		case WM_COMMAND:
		{
            for(int MsgLoop=0;MsgLoop<hDllArray.size();MsgLoop++)
            {
                if(LOWORD(wParam) == WM_PLUGIN+MsgLoop)
                {
                    printf("Executing Selected Plugin: #%ld...\n",MsgLoop+1);
                    ExecuteDll(MsgLoop);
                    break;
                }
            }

		    switch(LOWORD(wParam)) // what we press on?
			{
				case IDC_EXIT:
				{
                   SendMessage(hWnd,WM_CLOSE,0,0);
				}
				break;
			}
		}
		break;
        
        case WM_CLOSE: // We colsing the Dialog
        {
          EndDialog(hWnd,0); 
        }
	    break;
	}
	return 0;
}

void EnumDlls()
{
  WIN32_FIND_DATA W32FindData;
  HANDLE hFile;
  HMODULE hDll;
  DWORD dwRetVal=0;
  char cFilePath[MAX_PATH]="";
  char cWildCard[]="*.dll";  
  
  ZeroMemory(&W32FindData,0);
  
  GetModuleFileName(NULL,cFilePath,MAX_PATH-1);
  SetCurrentDirectory(ExtractFilePath(cFilePath));

  printf("Generating Plugin List: \n");

  hFile=FindFirstFile(cWildCard,&W32FindData);

  if(hFile!=INVALID_HANDLE_VALUE)
  {
    hDll = LoadLibrary(W32FindData.cFileName);
    printf("Found Plugin -> Loading... (0x%08X)\n",hDll);

    if(hDll != NULL){
        hDllArray.insert(hDllArray.end(),hDll);
    }

    while(FindNextFile(hFile,&W32FindData))
    {
       hDll = LoadLibrary(W32FindData.cFileName);

       printf("Found Plugin -> Loading... (0x%08X)\n",hDll);
       
       if(hDll != NULL){
          hDllArray.insert(hDllArray.end(),hDll);
       }
    }
  }

  printf("Generated List of: %ld Plugins\n\n",hDllArray.size());
  
}

void LoadDlls(HWND hWnd)
{
    HMENU hMenu = GetMenu(hWnd);
    HMENU hNewMenu;
    
    if(hDllArray.size()==0)
        return;
    
    hNewMenu=CreatePopupMenu();
    AppendMenu(hMenu,MF_POPUP,(INT)hNewMenu,"Plugins");        

    for(int i=0;i<hDllArray.size();i++)
    {
        PLG_INFO pPlgInfo = (PLG_INFO)GetProcAddress((HINSTANCE)hDllArray[i],"PluginInfo");
        printf("Getting Plugin #%ld Description: \"%s\"\n",i+1,pPlgInfo());
        AppendMenu(hNewMenu,MF_STRING,i+WM_PLUGIN,pPlgInfo());
        printf("Plugin #%ld added to Menu...\n",i+1);
    }

     DrawMenuBar(hWnd);
}

void ExecuteDll(DWORD dwIndex)
{
    if(dwIndex<0 || dwIndex>=hDllArray.size())
        return;

    INSTALL pFunc = (INSTALL)GetProcAddress((HINSTANCE)hDllArray[dwIndex],"InstallDll");

    if(pFunc!=NULL)
    {
        printf("Plugin #%ld Executed...\n",dwIndex+1);
        pFunc(ch,&Main_hWnd);
    }
    else
        printf("Can't Execute Dll!\n");
}

void FreeDlls()
{
    for(int i=0;i<hDllArray.size();i++)
    {
        if(hDllArray[i]!=NULL)
            FreeLibrary(hDllArray[i]);
    }
}

char* ExtractFilePath(char *cpFilePath)
{
    INT i=0,Length = lstrlen(cpFilePath);
    cpFilePath+=Length;
       
    while(*cpFilePath!='\\')
    {
        i++;
        cpFilePath--;
    }

    cpFilePath++;
    *cpFilePath='\0';
    cpFilePath-=(Length-i+1);

    return cpFilePath;
}