/*
msr_test - last updated: 17th April 2004

Test application for the ring3 MSR access. Reads the time-stamp counter directly
from msr 0x10, rather than issuing the RDTSC instruction. Might seem a bit silly,
but this MSR should be safe on all >= Pentium machines, while I frankly don't
know what happens if you try to read an invalid MSR (and I'm not taking the chance
of a ring0 exception).

See the included msr_license.txt for, well, the license. Basically: no GPL.
Copyright by f0dder - f0dder(at)flork(dot)dk - http://f0dder.has.it
*/
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "msr_ring3.h"

#define MSR_TSC				0x10		// Time Stamp Counter

// if you have XP, try reading these
#define MSR_SYSENTER_CS		0x174		// Target Ring 0 CS Selector	
#define MSR_SYSENTER_ESP	0x175		// Target Ring 0 ESP		
#define MSR_SYSENTER_EIP	0x176		// Target Ring 0 Entry Point EIP	


uint work(void)
{
	uint regs[64];
	char*	buf = (char*)regs;

	if(!msr_initialize())
	{
		wsprintf(buf, "error = 0x%08X", msr_GetLastError());
		MessageBox(NULL, "Error performing ring3msr initialization", buf, MB_OK | MB_ICONEXCLAMATION);
		return 1;
	}

	// do a normal RDTSC so we can compare values - this a crude way to check if the rdmsr
	// succeeded, plus it gives an idea how long the DeviceIoControl execution takes.
	/*__asm {
		rdtsc
		mov	[tsc_high], edx
		mov [tsc_low], eax
	}

	if(!msr_rdmsr(MSR_TSC, &msr_high, &msr_low))
	{
		MessageBox(NULL, "Error performing ring3msr rdmsr", "error", MB_OK | MB_ICONEXCLAMATION);
	}*/

	// Read Processor Brand String
	uint r = 0;

	for (uint msr = 0xC0010030; msr <= 0xC0010035; msr++, r += 2)
	{
		if(!msr_rdmsr(msr, &regs[r+1], &regs[r]))
		{
			MessageBox(NULL, "Error performing ring3msr rdmsr", "error", MB_OK | MB_ICONEXCLAMATION);
		}
	}

	regs[r] = 0;

	MessageBox(NULL, buf, "information for your pleasure", MB_OK);

	memset( regs, 0, sizeof(regs) );

	strcpy( buf, "Intel(r) Pentium 4(tm) Processor" );

	r = 0;

	for (uint msr = 0xC0010030; msr <= 0xC0010035; msr++, r += 2)
	{
		if(!msr_wrmsr(msr, regs[r+1], regs[r]))
		{
			MessageBox(NULL, "Error performing ring3msr wrmsr", "error", MB_OK | MB_ICONEXCLAMATION);
		}
	}

	if(!msr_deinitialize())
	{
		MessageBox(NULL, "Error performing ring3msr de-initialization", "error", MB_OK | MB_ICONEXCLAMATION);
	}

	//wsprintf(buf, "MSR TSC: %08X:%08X, RDTSC: %08X:%08X, delta=0x%08X", msr_high, msr_low, tsc_high, tsc_low, msr_low-tsc_low);

	MessageBox(NULL, buf, "information for your pleasure", MB_OK);

	return 0;
}


void entry32(void)
{
	ExitProcess(work());
}
