COMMENT #
w9x_ring0 - last updated: 17th April 2004

Module to gain ring0 access on Windows 9x (all of them I suppose) by using
one of the wellknown hacks, by modifying the IDT of some ring3-callable
ring0 handled interrupt to point to our own code.

See the included msr_license.txt for, well, the license. Basically: no GPL.
Copyright by f0dder - f0dder(at)flork(dot)dk - http://f0dder.has.it
#

.586p
.model flat,stdcall
option casemap:none
option proc:private
ASSUME FS:NOTHING

include		<windows.inc>
include		<kernel32.inc>
include		<user32.inc>
includelib	<kernel32.lib>
includelib	<user32.lib>

; export these for public use
PUBLIC w9x_ring0hack_rdmsr
PUBLIC w9x_ring0hack_wrmsr

USEINT equ 05h					; the interrupt we'll use for our purposes


;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
; CODE section
;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.code

;
; The following proc was taken from "Win9x Ring0 Quest" by Super/29A
;
w9x_ring0hack_int5 proc uses esi, r0code:dword 
LOCAL IDTR[6]:byte
	sidt	fword ptr [IDTR]

	mov		esi, dword ptr [IDTR+2]

	push	dword ptr [esi+(8*USEINT)+0]		; save IDT entry
	push	dword ptr [esi+(8*USEINT)+4]

	push	[r0code]
	pop		word ptr [esi+(8*USEINT)+0]
	pop		word ptr [esi+(8*USEINT)+6]

	int		USEINT   ; ring0!

	pop		dword ptr [esi+(8*USEINT)+4]		; restore IDT entry
	pop		dword ptr [esi+(8*USEINT)+0]

	ret
w9x_ring0hack_int5 endp

;
; Ring0 entrypoints
;
r0_rdmsr:
	rdmsr
	iretd

r0_wrmsr:
	wrmsr
	iretd


;
; Public accessable + exported code
;
w9x_ring0hack_wrmsr proc STDCALL msr:dword, msrhi:dword, msrlo:dword
	mov		ecx, [msr]
	mov		edx, [msrhi]
	mov		eax, [msrlo]

	invoke	w9x_ring0hack_int5, offset r0_wrmsr

	ret
w9x_ring0hack_wrmsr endp


w9x_ring0hack_rdmsr proc STDCALL msr:dword, pmsrhi:dword, pmsrlo:dword
	mov		ecx, [msr]
	invoke	w9x_ring0hack_int5, offset r0_rdmsr

	mov		ecx, [pmsrhi]
	mov		[ecx], edx
	mov		ecx, [pmsrlo]
	mov		[ecx], eax

	ret
w9x_ring0hack_rdmsr endp



COMMENT #
;
; Some old test code for just the ring0hack
;
.data?
tschi	DWORD ?
tsclo	DWORD ?
buffer	BYTE 256 dup (?)

.data
szFormat	BYTE "hack TSC: %08X:%08X, rdtsc: %08X:%08X", 0
szHello		BYTE "Hello, world!",0
szErrNT		BYTE "Sorry, NT detected - ring0hack only works on 9x", 0

.code
ENTRY32:
	invoke	GetVersion
	test	eax, eax
	js		@@okay

	invoke	MessageBox, NULL, addr szErrNT, addr szHello, MB_OK
	invoke	ExitProcess, 1

@@okay:
	invoke	w9x_ring0hack_rdmsr, 00000010h, addr tschi, addr tsclo
	rdtsc

	invoke	wsprintf, addr buffer, addr szFormat, [tschi], [tsclo], edx, eax
	invoke	MessageBoxA, NULL, addr buffer, addr szHello, MB_OK

	invoke	ExitProcess, 0	

END ENTRY32
#

END
