#include <dpmi.h>
#include <go32.h>

// #define MIDAS_USED

unsigned long *framebuffer=0; // You put the frame in that buffer.
long screensize;     // Size of the screen in bytes.
long screenx,screeny; // Size of the screen in pixels.
long byteperpixel;

  // some go32 procedure
void dosmemget(unsigned long _offset, size_t _length, void *_buffer);
void dosmemput(const void *_buffer, size_t _length, unsigned long _offset);

typedef  unsigned char          boolean;
typedef  unsigned char          byte;
typedef  unsigned short int     word;
typedef  unsigned long int      dword;

// This structure used in the VESA BIOS EXTENSIONS.
typedef struct { word ModeAttributes;
                 byte WindowAAttributes;
                 byte WindowBAttributes;
                 word WindowGranularity;
                 word WindowSize;
                 word StartSegmentWindowA;
                 word StartSegmentWindowB;
//                 void (*WindowPositioningFunction)(int page);
                 dword res4;
                 word BytesPerScanLine;

                 // VBE v1.0/1.1:
                 word PixelWidth;
                 word PixelHeight;
                 byte CharacterCellPixelWidth;
                 byte CharacterCellPixelHeight;
                 byte NumberOfMemoryPlanes;
                 byte BitsPerPixel;
                 byte NumberOfBanks;
                 byte MemoryModelType;
                 byte SizeOfBank;
                 byte NumberOfImagePages;
                 byte Reserved1;

                 // VBE v1.2+:
                 byte RedMaskSize;
                 byte RedFieldPosition;
                 byte GreenMaskSize;
                 byte GreenFieldPosition;
                 byte BlueMaskSize;
                 byte BlueFieldPosition;
                 byte ReservedMaskSize;
                 byte ReservedFieldPosition;
                 byte DirectColourModeInfo;

                 // VBE v2.0+:
                 dword PhysicalAddress;
                 dword offscreenstart;
                 word offscreensize;
                 byte Reserved2[206];
               } VESAMODEINFOBLOCK;
VESAMODEINFOBLOCK modeinfo;

long bytesperscanline;
short screenselector=0; //0 means: we have to create a new descriptor
long vbeversion=0; // 0 means: We havenot try to set the video mode yet.
                   // 1 menas: VBE 1.2 (no LINEAR framebuffer)
                   // 2 means: VBE 2.0
long truecolor;   // 0 = 16 bit/pixel
                  // 1 = 32 bit/pixel



   int VBE_detect(VESAMODEINFOBLOCK *vbeinfo)
        {
          __dpmi_regs r;

//          strncpy(vbeinfo.VBESig, "VBE2", 4);
          r.x.ax = 0x4F00;
          r.x.di = __tb & 0x0F;
          r.x.es = (__tb >> 4) & 0xFFFF;
          dosmemput(vbeinfo, sizeof(*vbeinfo), __tb);
          __dpmi_int(0x10, &r);
          dosmemget(__tb, sizeof(*vbeinfo), vbeinfo);
        };

   // get that long structure. To detect the mode number,
   // and get the LINEAR FRAME BUFFER ADDRESS (if VBE 2.0)
   void VBE_getModeInfo(unsigned short mode)
        {
          __dpmi_regs r;

          r.x.ax = 0x4F01;
          r.x.cx = mode;
          r.x.di = __tb & 0x0F;
          r.x.es = (__tb >> 4) & 0xFFFF;
          __dpmi_int(0x10, &r); // You have to use this dpmi_int procedure
                                // for compatibility !
          dosmemget(__tb, sizeof(modeinfo), &modeinfo);
           // You have to use dosmem for safe operation.
        }


void settextmode(void) {
  __dpmi_regs r;
  r.x.ax = 3; // 80x25 text mode.
  __dpmi_int(0x10, &r);
 };


void dosvideoexit(char *errormessage) {
 printf("%s\n",errormessage);
 exit(0);
 };

// You have to call this to copy the framebuffer to the screen.
// DJGPP uses the sucker UNIX style asm.
long longstomove; // We can use GLOBAL (data segment) variables in __asm__
long left,*position,page;
void screenfresh() {
 __dpmi_regs r;

 if (vbeversion==2) {
 __asm__ ("
  pushw %es
  movw _screenselector,%es
  movl $0,%edi
  movl _screensize,%ecx
  movl _framebuffer,%esi
  cmpl $0,_truecolor
  je convert

  movl _screeny,%edx
  ciky:
  pushl %edi
  movl _screenx,%ecx
  REP
    MOVSL
  popl %edi
  addl _bytesperscanline,%edi
  decl %edx
  jne ciky

  jmp done

  convert:

  movl _screeny,%edx
  cld
  ciky2:
  pushl %edx
  pushl %edi
  movl _screenx,%ecx

  convert2:
  lodsl
  movl %eax,%ebx
  movl %eax,%edx
  and $0xf8,%eax
  and $0xfc00,%ebx
  and $0xf80000,%edx
  shrl $3,%eax
  shrl $5,%ebx
  shrl $8,%edx
  add %ebx,%eax
  add %edx,%eax
  stosw
  decl %ecx
  jne convert2

  popl %edi
  popl %edx
  addl _bytesperscanline,%edi
  decl %edx
  jne ciky2

  done:
  popw %es
  ");
  } else {
  left=screensize>>2;
  position=framebuffer;
  page=0;

  while(left) {
   r.x.dx = page;
   r.x.bx = 0;
   r.x.ax = 0x4f05;
   __dpmi_int(0x10, &r);
   longstomove=left;
   if (longstomove>0x4000) longstomove=0x4000;
   // Now we switch to asm :)
   __asm__ ("
    push %es
    cld
    movl _longstomove,%ecx
    movl _position,%esi
    movl $0,%edi
    subl %ecx,_left
    movw _screenselector,%es
    cmp $0,_truecolor
    je qconvert
    rep
     movsl
    jmp qdone

    qconvert:
    shll $1,%ecx

    qconvert2:
    lodsl
    movl %eax,%ebx
    movl %eax,%edx
    and $0xf8,%eax
    and $0xfc00,%ebx
    and $0xf80000,%edx
    shrl $3,%eax
    shrl $5,%ebx
    shrl $8,%edx
    add %ebx,%eax
    add %edx,%eax
    stosw
    decl %ecx
    jne qconvert2

    qdone:
    movl %esi,_position
    incl _page
    pop %es
    ");
   };

  };
 };


void clearframebuffer() {
 __asm__ ("
  movl _screenx,%ecx
  imull _screeny,%ecx
  movl _framebuffer,%edi
  cld
  movl $0,%eax
  rep
   stosl
  ");
 };

void clearzbuffer() {
 __asm__ ("
  movl _screenx,%ecx
  imull _screeny,%ecx
  leal (,%ecx,4),%edi
  addl _framebuffer,%edi
  cld
  movl $0,%eax
  rep
   stosl
  ");
 };

void setmodeold(int x,int y); // for version 1.2 of VBE

long getmodenumber(int x,int y,int bpp) {
 long mode=0x4100-1;
 do {
  mode++;
  VBE_getModeInfo(mode);
  } while(mode<0x4180 && (modeinfo.BitsPerPixel!=bpp || modeinfo.PixelHeight!=y || modeinfo.PixelWidth!=x));
 if (mode==0x4180) mode=0;
 return mode;
 };

long zbufferneed=0;
// You have to call this to initialize VIDEO and select video mode.
void setmode(int x,int y) {
 __dpmi_regs r;
 __dpmi_meminfo mi;
 long a;
 long mode;

 mode=getmodenumber(x,y,32);
 if (!mode) { // VBE 2.0 32bit/pixel not supportted
  mode=getmodenumber(x,y,16); // try 16 bit/pixel
  if (!mode) { // 16 bit/pixel not supported too. Try VBE 1.2
   setmodeold(x,y); // this proc tryes to set VBE 1.2 modes
   return;
   } else {
   truecolor=0; // use VBE 2.0 16 bit/pixel
   byteperpixel=2;
   };

  } else {
  truecolor=1; /// use VBE 2.0 32 bit/pixel
  byteperpixel=4;
  };

  mi.size = (unsigned long)(x*y*byteperpixel);
  mi.address = modeinfo.PhysicalAddress;
  __dpmi_physical_address_mapping(&mi);
  screensize=mi.size;
  screenx=x;
  screeny=y;

  if (!screenselector) {
   screenselector = __dpmi_allocate_ldt_descriptors(1);
   };
  __dpmi_set_segment_base_address(screenselector, mi.address);
  __dpmi_set_segment_limit(screenselector,0xffffffff);
  if (framebuffer) {
   free(framebuffer);
   };

  if (zbufferneed) {
   framebuffer=(long *)malloc(x*y*2*byteperpixel);
   } else {
   framebuffer=(long *)malloc(x*y*byteperpixel);
   };

  bytesperscanline=modeinfo.BytesPerScanLine;
  r.x.bx = mode;
  r.x.ax = 0x4f02;
  __dpmi_int(0x10, &r);
  vbeversion=2;
 };

long getmodenumberold(int x,int y,int bpp) {
 long mode=0x100-1;
 do {
  mode++;
  VBE_getModeInfo(mode);
  } while(mode<0x180 && (modeinfo.BitsPerPixel!=bpp || modeinfo.PixelHeight!=y || modeinfo.PixelWidth!=x));
 if (mode==0x180) mode=0;
 return mode;
 };


void setmodeold(int x,int y) {
 __dpmi_regs r;
 long mode;

 mode=getmodenumberold(x,y,32);
 if (!mode) {
  mode=getmodenumberold(x,y,16);
  if (!mode) {
   dosvideoexit("Nonsupported video mode");
   };
  byteperpixel=2; // use16bit/pixel VBE 1.2 mode
  truecolor=0;
  } else { // use 32bit/pixel VBE 1.2 mode
  byteperpixel=4;
  truecolor=1;
  };

  r.x.bx = mode; // set up the video mode with VBE 1.2
  r.x.ax = 0x4f02;
  __dpmi_int(0x10, &r);

 screensize=(unsigned long)(x*(y+4)*byteperpixel);
 screenx=x;
 screeny=y;
 vbeversion=1;
  if (framebuffer) {
   free(framebuffer);
   };
  if (zbufferneed) {
   framebuffer=(long *)malloc(x*y*2*byteperpixel);
   } else {
   framebuffer=(long *)malloc(x*y*byteperpixel);
   };
 if (!screenselector) {
  screenselector = __dpmi_allocate_ldt_descriptors(1);
  }; // VBE 1.2 uses 64 pages at 0xa0000
    // This always mapped to its phisical, so we dont have  to map as
    // in VBE 2.0
 __dpmi_set_segment_base_address(screenselector, 0xa0000);
 __dpmi_set_segment_limit(screenselector,0x10000);
 };


void quit(char *message) {
 settextmode();
 if (message[0]) {
  printf("%s\n",message);
  };
 exit(0);
 };


char ktb[256],ktbstay[256]; // A simple keyboard handler. Ofcoz, its bettah than DOS`s for we now.
long b;
static void keyirq() {

 b=inportb(0x60);
 ktb[b&127]=(b<128);
 if (b<127) {
  ktbstay[b&127]=-1;
  };
 outportb(32,32);
 };

__dpmi_paddr oldkeyirq;
void initkey() {
 __dpmi_paddr paddr;
 _go32_dpmi_seginfo seg;

 seg.pm_selector=_my_cs();
 seg.pm_offset=(int)keyirq;
 _go32_dpmi_allocate_iret_wrapper(&seg);
 paddr.selector=seg.pm_selector;
 paddr.offset32=seg.pm_offset;

 __dpmi_get_protected_mode_interrupt_vector(9,&oldkeyirq);
 __dpmi_set_protected_mode_interrupt_vector(9,&paddr);
 };
void uninitkey() {
 __dpmi_set_protected_mode_interrupt_vector(9,&oldkeyirq);
 };


long clock=0;
long gettickcount() {
 return clock;
 };
void settickcount(long f) {
 clock=f;
 };

#ifndef MIDAS_USED
static void timer() {
 clock++;
 outportb(32,32);
 };

void settimer(long ra) {
    outportb(0x43, 0x36);
    outportb(0x40, (1197000/ra) & 0xff);
    outportb(0x40, (1197000/ra) >> 8);
    };
__dpmi_paddr oldirq;
void installtimer(long a) {
 __dpmi_paddr paddr;
 _go32_dpmi_seginfo seg;

 seg.pm_selector=_my_cs();
 seg.pm_offset=(int)timer;
 _go32_dpmi_allocate_iret_wrapper(&seg);
 paddr.selector=seg.pm_selector;
 paddr.offset32=seg.pm_offset;

 __dpmi_get_protected_mode_interrupt_vector(8,&oldirq);
 __dpmi_set_protected_mode_interrupt_vector(8,&paddr);
 outportb(0x21,inportb(0x21)&0xfe);
 settimer(a);
 };
void uninstalltimer() {
 __dpmi_set_protected_mode_interrupt_vector(8,&oldirq);
    outportb(0x43, 0x36);
    outportb(0x40, 0);
    outportb(0x40, 0);
 };
#else

#include "libs/midasdll.h"

void MIDAS_CALL timer() {
 clock++;
 };

void installtimer(long a) {
 midasSetDefaults();
 MIDASsetTimerCallbacks(a*1000,FALSE,&timer,0,0);
 };
void uninstalltimer() {
 MIDASremoveTimerCallbacks();
 };

#endif


extern void start(int argc,char *argv[]);
void main(int argc,char *argv[]) {
 start(argc,argv);
 };

void messagez() { // only in win95
 };

void subtickcount(long a) {
 clock-=a;
 };

void presskey() {
 getch();
 };

