;
;       ________________________________________________________________
;
;                                 PEexport.ASM
;                        PE Export Section Dumper V1.02
;               04-01-1998 Sven B. Schreiber sbs@psbs.franken.de
;                        This is Public Domain Software
;       ________________________________________________________________
;
;
;
;==============================================================================
;
; PLEASE NOTE
;
; PEexport is Public Domain Software and is distributed with the ASM source
; code included. This software package may be distributed freely on any media
; including bulletin board systems and Internet hosts, provided that all files
; are included and no fee is charged for the software. Although all code and
; documentation belongs to the Public Domain, I strongly recommend that all
; changes be documented properly, including the name of the author, the date,
; and what parts have been changed in which way. Feel free to contact me at
; sbs@psbs.franken.de, 100557.177@compuserve.com, or sbs_msn@msn.com.
;
; DISCLAIMER
;
; This software is provided "as is" and any expressed or implied warranties,
; including, but not limited to, the implied warranties of merchantibility and
; fitness for a particular purpose are disclaimed. In no event shall the
; author Sven B. Schreiber be liable for any direct, indirect, incidental,
; special, exemplary, or consequential damages (including, but not limited to,
; procurement of substitute goods or services; loss of use, data, or profits;
; or business interruption) however caused and on any theory of liability,
; whether in contract, strict liability, or tort (including negligence or
; otherwise) arising in any way out of the use of this software, even if
; advised of the possibility of such damage.
;
;==============================================================================
;
; Version History
; ---------------
;
; 12-12-1995  V1.00  SBS  Original Version
;
; 01-29-1996  V1.01  SBS  Update
;
;       Output format changed to include unbiased ordinal numbers as well.
;       New format is "<Name>=<Unbiased>,<Biased>".
;
; 04-01-1998  V1.02  TomCat  NASM Version
;
;       The source is rewritten to NASM by Tamas Kaproncai [tomcat@szif.hu].
;
;==============================================================================
;
;       CONSTANTS
;
;==============================================================================
;
PATH_LENGTH             equ     260             ;maximum path length
COMMAND_TAIL            equ     0081h           ;command tail address
;
;------------------------------------------------------------------------------
;
DOS                     equ     21h             ;dos api
;
DOS_DISPLAY             equ     02h             ;display character
DOS_OPEN                equ     3Dh             ;open file
DOS_CLOSE               equ     3Eh             ;close file
DOS_READ                equ     3Fh             ;read file
DOS_WRITE               equ     40h             ;write file
DOS_MOVEPOINTER         equ     42h             ;move file pointer
DOS_REALLOCATE          equ     4Ah             ;reallocate memory block
DOS_TERMINATE           equ     4Ch             ;terminate program
DOS_GETPSP              equ     51h             ;get current psp address
;
;------------------------------------------------------------------------------
;
STDIN                   equ     0               ;standard input
STDOUT                  equ     1               ;standard output
STDERR                  equ     2               ;standard error output
STDAUX                  equ     3               ;standard comm output
STDPRN                  equ     4               ;standard printer output
;
;------------------------------------------------------------------------------
;
RET_NORMAL_END          equ     0               ;program terminated normally
RET_MEMORY_ERROR        equ     1               ;memory allocation error
RET_INVALID_COMMAND     equ     2               ;invalid command line
RET_FILE_NOT_FOUND      equ     3               ;input file not found
RET_NO_PE_FILE          equ     4               ;input file is not a pe file
RET_BAD_PE_FILE         equ     5               ;input file is corrupt
RET_BAD_EXPORT_DIR      equ     6               ;export directory is corrupt
RET_BAD_EXPORT_DATA     equ     7               ;export data is corrupt
RET_NO_EXPORTS          equ     8               ;input file exports nothing
;
;------------------------------------------------------------------------------
;
LF                      equ     0Ah             ;linefeed
CR                      equ     0Dh             ;carriage return
;
;------------------------------------------------------------------------------
;
PE_MACHINE_UNKNOWN      equ     0000h           ;unknown machine
PE_MACHINE_I386         equ     014ch           ;intel 386+ and compatible
PE_MACHINE_R3000B       equ     0160h           ;mips (big endian)
PE_MACHINE_R3000        equ     0162h           ;mips (little endian)
PE_MACHINE_R4000        equ     0166h           ;mips (little endian)
PE_MACHINE_R10000       equ     0168h           ;mips (little endian)
PE_MACHINE_ALPHA        equ     0184h           ;alpha axp
PE_MACHINE_POWERPC      equ     01F0h           ;power pc (little endian)
;
;------------------------------------------------------------------------------
;
PE_RELOCS_STRIPPED      equ     0001h           ;relocation info stripped
PE_EXECUTABLE_IMAGE     equ     0002h           ;file is executable
PE_LINE_NUMS_STRIPPED   equ     0004h           ;line nunbers stripped
PE_LOCAL_SYMS_STRIPPED  equ     0008h           ;local symbols stripped
PE_BYTES_REVERSED_LO    equ     0080h           ;bytes of machine word reversed
PE_32BIT_MACHINE        equ     0100h           ;32 bit word machine
PE_DEBUG_STRIPPED       equ     0200h           ;debugging info stripped
PE_SYSTEM               equ     1000h           ;system file
PE_DLL                  equ     2000h           ;file is a dll
PE_BYTES_REVERSED_HI    equ     8000h           ;bytes of machine word reversed
;
;==============================================================================
;
;       STRUCTURES
;
;==============================================================================
;
		struc   MZ_HEADER
mzSignature     RESW    1               ;signature
mzExtraBytes    RESW    1               ;number of bytes in last (partial) page
mzPages         RESW    1               ;number of whole and part pages in file
mzRelocItems    RESW    1               ;number of pointers in relocation table
mzHeaderSize    RESW    1               ;size of header, in paragraphs
mzMinAlloc      RESW    1               ;minimum allocation
mzMaxAlloc      RESW    1               ;maximum allocation
mzInitSS        RESW    1               ;initial ss value
mzInitSP        RESW    1               ;initial sp value
mzChecksum      RESW    1               ;complemented checksum
mzInitIP        RESW    1               ;initial ip value
mzInitCS        RESW    1               ;initial cs value
mzRelocTable    RESW    1               ;byte offset to relocation table
mzOverlay       RESW    1               ;overlay number
mzReserved1     RESW    16              ;(reserved)
mzNextHeader    RESD    1               ;pointer to next header
		endstruc
MZ_HEADER_      equ     2+2+2+2+2+2+2+2+2+2+2+2+2+2+32+4
;
;------------------------------------------------------------------------------
;
		struc   PE_HEADER
peMachine       RESW    1               ;machine type
peNumSections   RESW    1               ;number of sections
peTimeDate      RESD    1               ;time/date stamp
peSymbolTable   RESD    1               ;pointer to symbol table
peNumSymbols    RESD    1               ;number of symbol table entries
peSizeOptHeader RESW    1               ;size of optional header
peAttributes    RESW    1               ;file attributes
		endstruc
PE_HEADER_      equ     2+2+4+4+4+2+2
;
;------------------------------------------------------------------------------
;
		struc   PE_OPT_HEADER
ohSignature     RESW    1               ;signature
ohLinkerMajor   RESB    1               ;linker major version number
ohLinkerMinor   RESB    1               ;linker minor version number
ohTextSize      RESD    1               ;size of code sections
ohDataSize      RESD    1               ;size of initialized data sections
ohBssSize       RESD    1               ;size of uninitialized data sections
ohEntryPoint    RESD    1               ;main program entry point
ohTextBase      RESD    1               ;code section load address
ohDataBase      RESD    1               ;data section load address
ohImageBase     RESD    1               ;preferred load address
ohSectionAlign  RESD    1               ;section alignment in memory
ohFileAlign     RESD    1               ;section alignment in file
ohOsMajor       RESW    1               ;required os major version number
ohOsMinor       RESW    1               ;required os minor version number
ohImageMajor    RESW    1               ;image major version number
ohImageMinor    RESW    1               ;image minor version number
ohSubSysMajor   RESW    1               ;subsystem major version number
ohSubSysMinor   RESW    1               ;subsystem minor version number
ohReserved1     RESD    1               ;(reserved)
ohImageSize     RESD    1               ;size of image including all headers
ohHeaderSize    RESD    1               ;size of mz/pe header and section table
ohFileChecksum  RESD    1               ;file checksum (drivers and services)
ohSubSystem     RESW    1               ;required subsystem
ohDllFlags      RESW    1               ;(obsolete)
ohStackReserve  RESD    1               ;size of stack space to reserve
ohStackCommit   RESD    1               ;size of stack space to commit
ohHeapReserve   RESD    1               ;size of local heap space to reserve
ohHeapCommit    RESD    1               ;size of local heap space to commit
ohLoaderFlags   RESD    1               ;(obsolete)
ohNumDataDir    RESD    1               ;number of data directory entries
ohExportAddr    RESD    1               ;export table address
ohExportSize    RESD    1               ;export table size
ohImportAddr    RESD    1               ;import table address
ohImportSize    RESD    1               ;import table size
ohResourceAddr  RESD    1               ;resource table address
ohResourceSize  RESD    1               ;resource table size
ohExceptionAddr RESD    1               ;exception table address
ohExceptionSize RESD    1               ;exception table size
ohSecurityAddr  RESD    1               ;security table address
ohSecuritySize  RESD    1               ;security table size
ohBaseRelocAddr RESD    1               ;base relocation table address
ohBaseRelocSize RESD    1               ;base relocation table size
ohDebugDataAddr RESD    1               ;debug data address
ohDebugDataSize RESD    1               ;debug data size
ohCopyrightAddr RESD    1               ;copyright string address
ohCopyrightSize RESD    1               ;copyright string length
ohGlobalPtrAddr RESD    1               ;global pointer register address
ohGlobalPtrSize RESD    1               ;global pointer register size
ohTlsAddr       RESD    1               ;thread local storage table address
ohTlsSize       RESD    1               ;thread local storage table size
ohLoadConfAddr  RESD    1               ;load configuration table address
ohLoadConfSize  RESD    1               ;load configuration table size
ohReservedAddr1 RESD    1               ;(reserved)
ohReservedSize1 RESD    1               ;(reserved)
ohReservedAddr2 RESD    1               ;(reserved)
ohReservedSize2 RESD    1               ;(reserved)
ohReservedAddr3 RESD    1               ;(reserved)
ohReservedSize3 RESD    1               ;(reserved)
ohReservedAddr4 RESD    1               ;(reserved)
ohReservedSize4 RESD    1               ;(reserved)
ohReservedAddr5 RESD    1               ;(reserved)
ohReservedSize5 RESD    1               ;(reserved)
		endstruc
PE_OPT_HEADER_  equ     2+1+1+4+4+4+4+4+4+4+4+4+2+2+2+2+2+2+4+4+4+4+2+2+4+4+4+4+4+4+8+8+8+8+8+8+8+8+8+8+8+8+8+8+8+8
;
;------------------------------------------------------------------------------
;
		struc   SECTION_HEADER
shSectionName   RESB    8               ;section name
shLoadSize      RESD    1               ;section size in memory
shLoadAddr      RESD    1               ;section offset in memory
shRawSize       RESD    1               ;section size in file
shRawAddr       RESD    1               ;section offset in file
shRelocations   RESD    1               ;pointer to relocation entries
shLineNumbers   RESD    1               ;pointer to line number entries
shNumRelocs     RESW    1               ;number of relocation entries
shNumLines      RESW    1               ;number of line number entries
shAttributes    RESD    1               ;section attributes
		endstruc
SECTION_HEADER_ equ     8+4+4+4+4+4+4+2+2+4
;
;------------------------------------------------------------------------------
;
		struc   EXPORT_DIR
edExportFlags   RESD    1               ;export flags
edTimeDate      RESD    1               ;time/date stamp
edVersionMajor  RESW    1               ;major version number
edVersionMinor  RESW    1               ;minor version number
edFileName      RESD    1               ;pointer to file name
edOrdinalBase   RESD    1               ;starting ordinal number (bias)
edNumAddresses  RESD    1               ;number of address entries
edNumNames      RESD    1               ;number of name entries
edAddresses     RESD    1               ;pointer to address table
edNames         RESD    1               ;pointer to name table
edOrdinals      RESD    1               ;pointer to ordinal table
		endstruc
EXPORT_DIR_     equ     4+4+2+2+4+4+4+4+4+4+4
;
;==============================================================================
;
;       CODE SEGMENT
;
;==============================================================================
;
	segment _text public 'CODE'
;
;------------------------------------------------------------------------------
;
	DW      CodeSegment_
	DB      " Code Segment "
;
;==============================================================================
;
;       no parameters
;
;------------------------------------------------------------------------------
;
..start:
	mov     ah,DOS_GETPSP                   ;load base segment address
	int     DOS
	mov     es,bx
	mov     ax,_data                        ;load data segment address
	mov     ds,ax
	sub     ax,bx                           ;compute psp/code/stack size
	mov     bx,DataSegment_                 ;compute data segment size
	dec     bx
	mov     cl,4
	shr     bx,cl
	inc     bx
	add     bx,ax                           ;add segment sizes
	mov     ah,DOS_REALLOCATE               ;set program memory block size
	int     DOS
	mov     si, sMemoryError                ;memory allocation error
	mov     al,RET_MEMORY_ERROR
	jb      Main1
	mov     si, sBanner                     ;display banner
	call    InfoString
	call    ParseCommandLine                ;parse command line
	call    Execute                         ;execute program
Main1:
	cmp     si,0                            ;final message?
	jz      Main2
	push    ax
	call    InfoString                      ;display message
	pop     ax
Main2:
	mov     ah,DOS_TERMINATE                ;terminate program
	int     DOS
;
;==============================================================================
;
;       no parameters
;
;------------------------------------------------------------------------------
;
ParseCommandLine:
	mov     si,COMMAND_TAIL                 ;evaluate command tail
	mov     di,InputFile                    ;copy input file path
	mov     cx,InputFile_
ParseCommandLine1:
	inc     si                              ;skip initial spaces
	cmp     byte [es:si-1],' '
	jz      ParseCommandLine1
	dec     si
	mov     bx,di                           ;set end marker
ParseCommandLine2:
	cmp     cx,1                            ;buffer full?
	jna     ParseCommandLine3
	mov     al,[es:si]                      ;copy character
	inc     si
	mov     [di],al
	inc     di
	dec     cx
	cmp     al,CR                           ;end?
	jz      ParseCommandLine3
	cmp     al,' '                          ;look for trailing spaces
	jz      ParseCommandLine2
	mov     bx,di                           ;advance end marker
	jmp     ParseCommandLine2
ParseCommandLine3:
	mov     byte [bx],0                     ;terminate string
	retn
;
;==============================================================================
;
;       <       si  -  message (0 if no message)
;               al  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
Execute:
	mov     bx,InputFile                    ;test input file path
	cmp     byte [bx],1
	mov     si, sInvalidCommand
	mov     al,RET_INVALID_COMMAND
	jb      Execute2
	mov     si,InputFile                    ;open input file
	call    OpenFile
	mov     si, sFileNotFound               ;input file not found
	mov     al,RET_FILE_NOT_FOUND
	jb      Execute2
	call    LoadFileHeaders                 ;load mz/pe file headers
	jb      Execute1
	call    LoadExportDir                   ;find export directory
	jb      Execute1
	call    DumpExportTable                 ;dump exported names
Execute1:
	pushf
	push    si
	push    ax
	call    CloseFile                       ;close input file
	pop     ax
	pop     si
	popf
	jb      Execute2                        ;error
	mov     si, sNormalEnd                  ;ok
	mov     al,RET_NORMAL_END
Execute2:
	retn
;
;==============================================================================
;
;       <       si  -  message (0 if no message)
;               al  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
LoadFileHeaders:
	mov     di,MZ_Header                    ;read dos stub header
	mov     cx,MZ_HEADER_
	call    ReadFileBlock
	mov     si, sUnknownFileType            ;incomplete dos stub header
	mov     al,RET_NO_PE_FILE
	jb near LoadFileHeaders1
	mov     bx,MZ_Header                    ;evaluate dos stub header
	mov     dx,[bx+mzSignature]             ;dos executable?
	xchg    dl,dh
	cmp     dx,'ZM'
	stc
	mov     si, sUnknownFileType
	mov     al,RET_NO_PE_FILE
	jnz near LoadFileHeaders1
	cmp     word [bx+mzRelocTable],40h      ;test new-exe id
	stc
	mov     si, sMzExecutable
	mov     al,RET_NO_PE_FILE
	jnz near LoadFileHeaders1
	mov     ax, word [bx+mzNextHeader]      ;move to next header
	mov     dx, word [bx+mzNextHeader+2]
	call    SetFilePointer
	mov     si, sUnknownFileType            ;error
	mov     al,RET_NO_PE_FILE
	jb      LoadFileHeaders1
	call    ReadFileWord                    ;read signature
	mov     dx,ax
	xchg    dl,dh
	mov     si, sUnknownFileType            ;incomplete header
	mov     al,RET_NO_PE_FILE
	jb      LoadFileHeaders1
	cmp     dx,'EN'                         ;new executable?
	stc
	mov     si, sNeExecutable
	mov     al,RET_NO_PE_FILE
	jz      LoadFileHeaders1
	cmp     dx,'EL'                         ;linear windows executable?
	stc
	mov     si, sLeExecutable
	mov     al,RET_NO_PE_FILE
	jz      LoadFileHeaders1
	cmp     dx,'XL'                         ;linear os/2 executable?
	stc
	mov     si, sLxExecutable
	mov     al,RET_NO_PE_FILE
	jz      LoadFileHeaders1
	cmp     dx,'EP'                         ;portable executable?
	stc
	mov     si, sUnknownFileType
	mov     al,RET_NO_PE_FILE
	jnz     LoadFileHeaders1
	call    ReadFileWord                    ;read 2nd half of signature
	mov     dx,ax
	mov     si, sUnknownFileType            ;error
	mov     al,RET_NO_PE_FILE
	jb      LoadFileHeaders1
	add     dx,-1                           ;pe signature ok?
	jb      LoadFileHeaders1
	mov     di,PE_Header                    ;read pe main header
	mov     cx,PE_HEADER_
	call    ReadFileBlock
	mov     si, sBadFileHeader              ;incomplete pe main header
	mov     al,RET_BAD_PE_FILE
	jb      LoadFileHeaders1
	mov     di,PE_OptHeader                 ;read pe optional header
	mov     cx,PE_OPT_HEADER_
	call    ReadFileBlock
	mov     si, sBadFileHeader              ;incomplete pe optional header
	mov     al,RET_BAD_PE_FILE
	jb      LoadFileHeaders1
	clc                                     ;ok
	mov     si,0
	mov     al,RET_NORMAL_END
LoadFileHeaders1:
	retn
;
;==============================================================================
;
;       <       si  -  message (0 if no message)
;               al  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
LoadExportDir:
	mov     bx,PE_OptHeader                 ;test export table size
	mov     ax, word [bx+ohExportSize]
	or      ax, word [bx+ohExportSize+2]
	stc                                     ;no export section
	mov     si, sNoExports
	mov     al,RET_NO_EXPORTS
	jz near LoadExportDir2
	mov     bx,PE_Header                    ;load number of sections
	mov     cx,[bx+peNumSections]
LoadExportDir1:
	sub     cx,1                            ;count sections
	mov     si, sExportsNotFound            ;export section not found
	mov     al,RET_NO_EXPORTS
	jb near LoadExportDir2
	push    cx
	mov     di,SectionHeader                ;read next section header
	mov     cx,SECTION_HEADER_
	call    ReadFileBlock
	pop     cx
	mov     si, sBadSectionHeader           ;incomplete section header
	mov     al,RET_BAD_PE_FILE
	jb      LoadExportDir2
	mov     bx,PE_OptHeader                 ;load section address
	mov     ax, word [bx+ohExportAddr]
	mov     dx, word [bx+ohExportAddr+2]
	mov     bx,SectionHeader                ;test section header
	sub     ax, word [bx+shLoadAddr]        ;section address too low?
	sbb     dx, word [bx+shLoadAddr+2]
	jb      LoadExportDir1
	sub     ax, word [bx+shLoadSize]        ;section address too high?
	sbb     dx, word [bx+shLoadSize+2]
	jnb     LoadExportDir1
	add     ax, word [bx+shLoadSize]        ;restore section offset
	adc     dx, word [bx+shLoadSize+2]
	add     ax, word [bx+shRawAddr]         ;restore section offset
	adc     dx, word [bx+shRawAddr+2]
	call    SetFilePointer
	mov     si, sExportsNotFound            ;error
	mov     al,RET_NO_EXPORTS
	jb      LoadExportDir2
	mov     di,ExportDir                    ;read export directory
	mov     cx,EXPORT_DIR_
	call    ReadFileBlock
	mov     si, sBadExportDir               ;incomplete export directory
	mov     al,RET_BAD_EXPORT_DIR
	jb      LoadExportDir2
	mov     bx,ExportDir                    ;test number of exported names
	mov     ax, word [bx+edNumNames]
	or      ax, word [bx+edNumNames+2]
	stc                                     ;no exported names
	mov     si, sNoExportedNames
	mov     al,RET_NO_EXPORTS
	jz      LoadExportDir2
	mov     bx,SectionHeader                ;compute memory bias
	mov     ax, word [bx+shLoadAddr]
	mov     dx, word [bx+shLoadAddr+2]
	sub     ax, word [bx+shRawAddr]
	sbb     dx, word [bx+shRawAddr+2]
	mov     word [dMemoryBias],ax
	mov     word [dMemoryBias+2],dx
	clc                                     ;ok
	mov     si,0
	mov     al,RET_NORMAL_END
LoadExportDir2:
	retn
;
;==============================================================================
;
;       <       si  -  message (0 if no message)
;               al  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
DumpExportTable:
	mov     si, sSectionName                ;display section name
	call    InfoString
	push    si
	mov     bx,SectionHeader
	call    DumpSectionName
	pop     si
	call    InfoString
	mov     si, sRecordHeader               ;start record header
	call    OutputString
	push    si
	mov     bx,ExportDir                    ;insert exported file name
	mov     ax, word [bx+edFileName]
	mov     dx, word [bx+edFileName+2]
	call    DumpFileString
	pop     si
	pushf
	call    OutputString                    ;complete record header
	popf
	jb near DumpExportTable4                ;error
	mov     bx,ExportDir                    ;load number of exported names
	mov     ax, word [bx+edNumNames]        ;set name count
	mov     dx, word [bx+edNumNames+2]
	mov     word [dNumNames],ax
	mov     word [dNumNames+2],dx
	mov     ax, word [bx+edNames]           ;set name table pointer
	mov     dx, word [bx+edNames+2]
	mov     word [dNames],ax
	mov     word [dNames+2],dx
	mov     ax, word [bx+edOrdinals]        ;set ordinal table pointer
	mov     dx, word [bx+edOrdinals+2]
	mov     word [dOrdinals],ax
	mov     word [dOrdinals+2],dx
	mov     cx,NUM_NAMES                    ;load block size
DumpExportTable1:
	sub     word [dNumNames],cx             ;count names
	sbb     word [dNumNames+2],0
	jnb     DumpExportTable2                ;load complete block
	add     cx, word [dNumNames]
	jz near DumpExportTable5                ;no more names
DumpExportTable2:
	push    cx
	mov     ax, word [dNames]               ;move to name pointer table
	mov     dx, word [dNames+2]
	sub     ax, word [dMemoryBias]
	sbb     dx, word [dMemoryBias+2]
	call    SetFilePointer
	pop     cx
	jb near DumpExportTable4                ;error
	push    cx
	mov     di,Names                        ;read name pointers
	shl     cx,1
	shl     cx,1
	add     word [dNames],cx
	adc     word [dNames+2],0
	call    ReadFileBlock
	pop     cx
	jb near DumpExportTable4                ;error
	push    cx
	mov     ax, word [dOrdinals]            ;move to ordinal number table
	mov     dx, word [dOrdinals+2]
	sub     ax, word [dMemoryBias]
	sbb     dx, word [dMemoryBias+2]
	call    SetFilePointer
	pop     cx
	jb      DumpExportTable4                ;error
	push    cx
	mov     di,Ordinals                     ;read ordinal numbers
	shl     cx,1
	add     word [dOrdinals],cx
	adc     word [dOrdinals+2],0
	call    ReadFileBlock
	pop     cx
	jb      DumpExportTable4                ;error
	mov     di,0
DumpExportTable3:
	push    cx
	push    di
	mov     si, sRecordData                 ;start record data line
	call    OutputString
	pop     di
	push    di
	push    si
	mov     bx,Names                        ;insert name
	shl     di,1
	shl     di,1
	mov     ax,[bx+di]
	mov     dx,[bx+di+2]
	call    DumpFileString
	pop     si
	sbb     al,al                           ;save error flag
	push    ax
	call    OutputString                    ;continue record data line
	pop     ax
	pop     di
	push    di
	push    ax
	mov     bx,Ordinals                     ;load ordinal number
	shl     di,1
	mov     ax,[bx+di]
	mov     dx,0
	push    dx
	push    ax
	push    si
	call    DumpDecimalNumber               ;insert unbiased ordinal number
	pop     si
	call    OutputString                    ;continue record data line
	pop     ax
	pop     dx
	push    si
	mov     bx,ExportDir                    ;insert biased ordinal number
	add     ax, word [bx+edOrdinalBase]
	adc     dx, word [bx+edOrdinalBase+2]
	call    DumpDecimalNumber
	pop     si
	call    OutputString                    ;complete record data line
	pop     ax
	pop     di
	pop     cx
	add     al,al                           ;test error flag
	jb      DumpExportTable4
	inc     di                              ;count names
	cmp     di,cx
	jb      DumpExportTable3                ;next record data line
	cmp     cx,NUM_NAMES                    ;last block?
	jnz     DumpExportTable5
	jmp     DumpExportTable1                ;next block
DumpExportTable4:
	stc                                     ;error
	mov     si, sBadExportData
	mov     al,RET_BAD_EXPORT_DATA
	jmp     DumpExportTable6
DumpExportTable5:
	clc                                     ;ok
	mov     si,0
	mov     al,RET_NORMAL_END
DumpExportTable6:
	retn
;
;==============================================================================
;
;       >       dx:ax  -  image offset
;
;       <           c  -  set if error
;
;------------------------------------------------------------------------------
;
DumpFileString:
	mov     bx,ax                           ;null pointer?
	or      bx,dx
	sub     bx,1
	jb      DumpFileString1
	sub     ax, word [dMemoryBias]          ;compute file offset
	sbb     dx, word [dMemoryBias+2]
	call    SetFilePointer                  ;move to string base
	jb      DumpFileString1
	mov     di,StringBuffer                 ;read string
	mov     cx,StringBuffer_
	call    ReadFileString
	jb      DumpFileString1
	mov     si,StringBuffer                 ;display string
	call    OutputString
	clc                                     ;ok
DumpFileString1:
	retn
;
;==============================================================================
;
;       >       dx:ax  -  binary number
;
;------------------------------------------------------------------------------
;
DumpDecimalNumber:
	mov     di,NumberBuffer                 ;convert to string
	call    NumberToString
	mov     si,NumberBuffer                 ;display string
	jmp     OutputString
;
;==============================================================================
;
;       >       bx  -  section header
;
;------------------------------------------------------------------------------
;
DumpSectionName:
	lea     dx,[bx+shSectionName]           ;get section name address
	mov     si,dx                           ;scan section name
	mov     cx,8
DumpSectionName1:
	cmp     byte [si],0                     ;end?
	jz      DumpSectionName2
	inc     si                              ;go on
	loop    DumpSectionName1
DumpSectionName2:
	mov     cx,si                           ;compute name length
	sub     cx,dx
	jz      DumpSectionName3                ;no data
	mov     bx,STDERR                       ;display section name
	mov     ah,DOS_WRITE
	int     DOS
DumpSectionName3:
	retn
;
;==============================================================================
;
;       >       dx:ax  -  binary number
;                  di  -  buffer (11 bytes)
;
;------------------------------------------------------------------------------
;
NumberToString:
	push    di                              ;save buffer base
	add     di,10                           ;write backwards to buffer
	mov     byte [di],0
NumberToString1:
	push    di
	mov     bx,10                           ;extract digit
	call    Divide
	pop     di
	dec     di                              ;save digit
	add     bl,'0'
	mov     [di],bl
	mov     bx,ax                           ;more digits?
	or      bx,dx
	jnz     NumberToString1
	mov     si,di                           ;left justify
	pop     di
NumberToString2:
	mov     al,[si]                         ;copy digits
	inc     si
	mov     [di],al
	inc     di
	cmp     al,0                            ;end?
	jnz     NumberToString2
	retn
;
;==============================================================================
;
;       >       dx:ax  -  dividend
;                  bx  -  divisor
;
;       <       dx:ax  -  quotient
;                  bx  -  remainder
;
;------------------------------------------------------------------------------
;
Divide:
	mov     si,bx                           ;load divisor
	mov     bx,0                            ;clear remainder
	mov     cx,32                           ;load bit count
Divide1:
	shl     ax,1                            ;shift dividend to remainder
	rcl     dx,1
	rcl     bx,1
	adc     al,0                            ;save remainder bit
	sub     bx,si                           ;try subtraction
	jnb     Divide2                         ;ok
	ror     al,1                            ;was remainder > ffff?
	rol     al,1
	jb      Divide3                         ;ok
	add     bx,si                           ;undo subtraction
Divide2:
	cmc
Divide3:
	rcr     al,1                            ;save result bit
	rol     al,1
	loop    Divide1
	retn
;
;==============================================================================
;
;       CONSOLE I/O
;
;==============================================================================
;
;       >       si  -  string
;
;       <       si  -  next string
;
;------------------------------------------------------------------------------
;
OutputString:
	mov     dx,si                           ;save base address
OutputString1:
	inc     si                              ;seek end of string
	cmp     byte [si-1],0
	jnz     OutputString1
	mov     cx,si                           ;compute string length
	dec     cx
	sub     cx,dx
	jz      OutputString2                   ;no data
	push    si
	mov     bx,STDOUT                       ;display string
	mov     ah,DOS_WRITE
	int     DOS
	pop     si
OutputString2:
	retn
;
;==============================================================================
;
;       >       si  -  string
;
;       <       si  -  next string
;
;------------------------------------------------------------------------------
;
InfoString:
	mov     dx,si                           ;save base address
InfoString1:
	inc     si                              ;seek end of string
	cmp     byte [si-1],0
	jnz     InfoString1
	mov     cx,si                           ;compute string length
	dec     cx
	sub     cx,dx
	jz      InfoString2                     ;no data
	push    si
	mov     bx,STDERR                       ;display string
	mov     ah,DOS_WRITE
	int     DOS
	pop     si
InfoString2:
	retn
;
;==============================================================================
;
;       FILE I/O
;
;==============================================================================
;
;       >       si  -  path
;
;       <       ax  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
OpenFile:
	mov     word [dFileBlockOffset],0       ;clear data block offset
	mov     word [dFileBlockOffset+2],0
	mov     word [wFileBlockPointer],0      ;clear data block pointer
	mov     word [wFileBlockEnd],0          ;clear data block end pointer
	mov     dx,si                           ;open file
	mov     al,0
	mov     ah,DOS_OPEN
	int     DOS
	mov     word [hFile],0                  ;clear file handle
	jb      OpenFile1                       ;error
	mov     [hFile],ax                      ;save file handle
OpenFile1:
	retn
;
;==============================================================================
;
;       <       ax  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
CloseFile:
	mov     word [dFileBlockOffset],0       ;clear data block offset
	mov     word [dFileBlockOffset+2],0
	mov     word [wFileBlockPointer],0      ;clear data block pointer
	mov     word [wFileBlockEnd],0          ;clear data block end pointer
	mov     ax,[hFile]                      ;file opened?
	cmp     ax,1
	jb      CloseFile1                      ;error
	mov     bx,ax                           ;close file
	mov     ah,DOS_CLOSE
	int     DOS
CloseFile1:
	retn
;
;==============================================================================
;
;       >       dx:ax  -  file pointer
;
;       <          ax  -  return code
;                   c  -  set if error
;
;------------------------------------------------------------------------------
;
SetFilePointer:
	mov     di, word [dFileBlockOffset]     ;load data block offset
	mov     si, word [dFileBlockOffset+2]
	mov     cx,ax                           ;file pointer above buffer?
	mov     bx,dx
	sub     cx,di
	sbb     bx,si
	jnb     SetFilePointer1
	sub     di,[wFileBlockEnd]              ;compute buffer start offset
	sbb     si,0
	add     di,FileBuffer
	adc     si,0
	mov     cx,ax                           ;file pointer below buffer?
	mov     bx,dx
	sub     cx,di
	sbb     bx,si
	jb      SetFilePointer1
	add     cx,FileBuffer                   ;set data block pointer only
	mov     [wFileBlockPointer],cx
	mov     ax,-1                           ;ok
	clc
	jmp     SetFilePointer2
SetFilePointer1:
	mov     word [dFileBlockOffset],ax      ;save data block offset
	mov     word [dFileBlockOffset+2],dx
	mov     word [wFileBlockPointer],0      ;clear data block pointer
	mov     word [wFileBlockEnd],0          ;clear data block end pointer
	mov     ax,[hFile]                      ;file opened?
	cmp     ax,1
	jb      SetFilePointer2                 ;error
	mov     bx,ax                           ;set file pointer
	mov     dx, word [dFileBlockOffset]
	mov     cx, word [dFileBlockOffset+2]
	mov     al,0
	mov     ah,DOS_MOVEPOINTER
	int     DOS
SetFilePointer2:
	retn
;
;==============================================================================
;
;       <       dx:ax  -  file pointer
;
;------------------------------------------------------------------------------
;
GetFilePointer:
	mov     ax, word [dFileBlockOffset]     ;load data block offset
	mov     dx, word [dFileBlockOffset+2]
	sub     ax,[wFileBlockEnd]              ;consider buffer pointer
	sbb     dx,0
	add     ax,[wFileBlockPointer]
	adc     dx,0
	retn
;
;==============================================================================
;
;       <       ax  -  return code
;                c  -  set if error
;
;------------------------------------------------------------------------------
;
ReadFile:
	mov     word [wFileBlockPointer],FileBuffer    ;init data block pointer
	mov     word [wFileBlockEnd],FileBuffer ;init data block end pointer
	mov     ax,[hFile]                      ;file opened?
	cmp     ax,1
	jb      ReadFile1                       ;error
	mov     bx,ax                           ;read data block
	mov     cx,FileBuffer_
	mov     dx,FileBuffer
	mov     ah,DOS_READ
	int     DOS
	jb      ReadFile1                       ;error
	add     word [dFileBlockOffset],ax      ;compute data block offset
	adc     word [dFileBlockOffset+2],0
	add     [wFileBlockEnd],ax              ;set data block end pointer
	clc                                     ;ok
ReadFile1:
	retn
;
;==============================================================================
;
;       >       di  -  buffer
;               cx  -  buffer size
;
;       <        c  -  set if end of file
;
;------------------------------------------------------------------------------
;
ReadFileBlock:
	call    ReadFileByte                    ;read byte from input file
	mov     [di],al                         ;save byte
	inc     di
	loop    ReadFileBlock                   ;count bytes
	retn
;
;==============================================================================
;
;       >       di  -  buffer
;               cx  -  buffer size
;
;       <        c  -  set if end of file
;
;------------------------------------------------------------------------------
;
ReadFileString:
	call    ReadFileByte                    ;read byte from input file
	mov     [di],al                         ;save byte
	inc     di
	inc     al                              ;end of string?
	dec     al
	loopnz  ReadFileString                  ;count bytes
	mov     byte [di-1],0                   ;terminate string
	retn
;
;==============================================================================
;
;       <       dx:ax  -  file word
;                   c  -  set if end of file
;
;       si, di not changed
;
;------------------------------------------------------------------------------
;
ReadFileDWord:
	call    ReadFileWord                    ;read low word
	mov     cx,ax
	call    ReadFileWord                    ;read high word
	mov     dx,ax                           ;load file dword
	mov     ax,cx
	retn
;
;==============================================================================
;
;       <       ax  -  file word
;                c  -  set if end of file
;
;       cx, si, di not changed
;
;------------------------------------------------------------------------------
;
ReadFileWord:
	call    ReadFileByte                    ;read low byte
	mov     dl,al
	call    ReadFileByte                    ;read high byte
	mov     dh,al
	mov     ax,dx                           ;load file word
	retn
;
;==============================================================================
;
;       <       al  -  file byte (0 if end of file)
;                c  -  set if end of file
;
;       cx, dx, si, di not changed
;
;------------------------------------------------------------------------------
;
ReadFileByte:
	mov     bx,[wFileBlockPointer]          ;load data block pointer
	cmp     [wFileBlockEnd],bx              ;end of data block?
	jz      ReadFileByte1                   ;load next data block
	mov     al,[bx]                         ;load file byte
	inc     word [wFileBlockPointer]        ;advance data block pointer
	retn                                    ;nc = ok
ReadFileByte1:
	cmp     word [wFileBlockEnd],FileBuffer ;file buffer empty?
	stc
	jz      ReadFileByte2
	push    cx
	push    dx
	push    si
	push    di
	call    ReadFile                        ;load next data block
	pop     di
	pop     si
	pop     dx
	pop     cx
	jb      ReadFileByte2                   ;error
	cmp     word [wFileBlockEnd],FileBuffer+1      ;end of file?
	jnb     ReadFileByte
ReadFileByte2:
	mov     al,0                            ;return 0 if end of file
	retn                                    ;c = end of file
;
;==============================================================================
;
CodeSegment_    equ     $
;
;==============================================================================
;
;       STACK SEGMENT
;
;==============================================================================
;
	segment _stack stack 'STACK'
;
	DW      StackSegment_
	DB      " Stack Segment"
	times 128 DW 0                          ;local stack
;
StackSegment_   equ     $
;
;==============================================================================
;
;       DATA SEGMENT
;
;==============================================================================
;
	segment _data public 'DATA'
;
;------------------------------------------------------------------------------
;
	DW      DataSegment_
	DB      " Data Segment "
;
;==============================================================================
;
;       INITIALIZED DATA
;
;------------------------------------------------------------------------------
;
hFile                   DW      0
dFileBlockOffset        DD      0
wFileBlockPointer       DW      FileBuffer
wFileBlockEnd           DW      FileBuffer
;
;------------------------------------------------------------------------------
;
dMemoryBias             DD      0
dNumNames               DD      0
dNames                  DD      0
dOrdinals               DD      0
;
;------------------------------------------------------------------------------
;
sBanner:
  DB CR,LF
  DB "________________________________________________________________",CR,LF
  DB CR,LF
  DB "                          PEexport.ASM",CR,LF
  DB "                 PE Export Section Dumper V1.02",CR,LF
  DB "        04-01-1998 Sven B. Schreiber sbs@psbs.franken.de",CR,LF
  DB "                 This is Public Domain Software",CR,LF
  DB "________________________________________________________________",CR,LF
  DB CR,LF
  DB 0
;
sNormalEnd:
  DB CR,LF
  DB "PEexport: Normal end.",CR,LF
  DB 0
;
sMemoryError:
  DB CR,LF
  DB "PEexport: Memory allocation error.",CR,LF
  DB 0
;
;------------------------------------------------------------------------------
;
sInvalidCommand:
  DB CR,LF
  DB "Usage: PEexport <input file>",CR,LF
  DB 0
;
sFileNotFound:
  DB CR,LF
  DB "PEexport: Input file not found.",CR,LF
  DB 0
;
;------------------------------------------------------------------------------
;
sMzExecutable:
  DB CR,LF
  DB "PEexport: Input file is a DOS executable.",CR,LF
  DB 0
;
sNeExecutable:
  DB CR,LF
  DB "PEexport: Input file is a Win16 executable.",CR,LF
  DB 0
;
sLeExecutable:
  DB CR,LF
  DB "PEexport: Input file is a Windows VxD executable.",CR,LF
  DB 0
;
sLxExecutable:
  DB CR,LF
  DB "PEexport: Input file is an OS/2 executable.",CR,LF
  DB 0
;
sUnknownFileType:
  DB CR,LF
  DB "PEexport: Input file is not a PE executable.",CR,LF
  DB 0
;
;------------------------------------------------------------------------------
;
sBadFileHeader:
  DB CR,LF
  DB "PEexport: Bad input file header.",CR,LF
  DB 0
;
sBadSectionHeader:
  DB CR,LF
  DB "PEexport: Bad input file section header.",CR,LF
  DB 0
;
sBadExportDir:
  DB CR,LF
  DB "PEexport: Bad export directory table.",CR,LF
  DB 0
;
sBadExportData:
  DB CR,LF
  DB "PEexport: Bad export data table.",CR,LF
  DB 0
;
sExportsNotFound:
  DB CR,LF
  DB "PEexport: Export data section not found.",CR,LF
  DB 0
;
sNoExports:
  DB CR,LF
  DB "PEexport: Input file doesn't export anything.",CR,LF
  DB 0
;
sNoExportedNames:
  DB CR,LF
  DB "PEexport: Input file doesn't export any names.",CR,LF
  DB 0
;
;------------------------------------------------------------------------------
;
sSectionName:
  DB CR,LF,"Export section is '",0,"'",CR,LF,0
;
sRecordHeader:
  DB CR,LF,"[",0,"]",CR,LF,0
;
sRecordData:
  DB 0,"=",0,",",0,CR,LF,0
;
;==============================================================================
;
;       UNINITIALIZED DATA
;
;------------------------------------------------------------------------------
;
%assign XX  0
;
;------------------------------------------------------------------------------
;
MZ_Header       equ     $  + XX
%assign XX  XX + MZ_HEADER_
;
PE_Header       equ     $  + XX
%assign XX  XX + PE_HEADER_
;
PE_OptHeader    equ     $  + XX
%assign XX  XX + PE_OPT_HEADER_
;
;------------------------------------------------------------------------------
;
SectionHeader   equ     $  + XX
%assign XX  XX + SECTION_HEADER_
;
ExportDir       equ     $  + XX
%assign XX  XX + EXPORT_DIR_
;
;------------------------------------------------------------------------------
;
NUM_NAMES       equ     1000
;
Names_          equ     NUM_NAMES * 4
Names           equ     $  + XX
%assign XX  XX + Names_
;
Ordinals_       equ     NUM_NAMES * 2
Ordinals        equ     $  + XX
%assign XX  XX + Ordinals_
;
;------------------------------------------------------------------------------
;
InputFile_      equ     PATH_LENGTH
InputFile       equ     $  + XX
%assign XX  XX + InputFile_
;
StringBuffer_   equ     0400h
StringBuffer    equ     $  + XX
%assign XX  XX + StringBuffer_
;
NumberBuffer_   equ     10+1
NumberBuffer    equ     $  + XX
%assign XX  XX + NumberBuffer_
;
FileBuffer_     equ     8000h
FileBuffer      equ     $  + XX
%assign XX  XX + FileBuffer_
;
;==============================================================================
;
DataSegment_    equ     $ + XX
;
;==============================================================================
;