; Simple demo showing how to use the keyboard handler
;
%include "Gaz\Dos\Macros\Kb.mac"
%include "Gaz\Dos\Macros\System.mac"
[BITS 32]
[section .text]
GLOBAL _WdosxStart
_WdosxStart:
	push	ds
	pop	es
	mov	edx,_Choices			; display intro text
	mov	ah,9
	int	$21
	KBInit
	xor	eax,eax				; eax holds the choice we want
_choiceloop:
	cmp	[_kb_key_table + _kb_1],dword 0	; 1?
	je	_choiceloop2
	mov	eax,1
_choiceloop2:
	cmp	[_kb_key_table + _kb_2],dword 0	; 2?
	je	_choiceloop3
	mov	eax,2
_choiceloop3:
	cmp	[_kb_key_table + _kb_3],dword 0	; 3?
	je	_choiceloop4
	mov	eax,3
_choiceloop4:
	cmp	eax,0				; loop until a choice has been made
	je	_choiceloop
	cmp	eax,3				; exit chosen?
	je	near _end
	cmp	eax,2				; buffered input test?
	je	_buffertest
	mov	edx,_Info1			; must be key detect test so display some info
	mov	ah,9
	int	$21
_detecttestloop:
	mov	edi,$0b8000			; edi->usual text screen
	mov	esi,_kb_key_table		; the key table
	mov	eax,128				; 128 keys to check
	mov	cx,$0f00			; set the char color
_detecttestloop2:
	mov	cl,'!'				; ! stands for a key being pressed
	cmp	[esi],dword 0			; is it really being pressed?
	jne	_go				; not zero, so yes
	mov	cl,'.'				; not being pressed, so put a . in instead
_go:
	mov	[edi],cx			; put the key on the screen
	add	edi,2				; next char on screen
	add	esi,4				; next key in table
	dec	eax				; another key done
	jnz	_detecttestloop2		; loop until all 128 keys done
	cmp	[_kb_key_table + _kb_esc],dword 0	; escape pressed?
	je	_detecttestloop			; no, keep dispaying those keys
	jmp	_end				; end demo
_buffertest:
	mov	edx,_Info2			; display some info
	mov	ah,9
	int	$21
	KBLedsOn				; turn on LED updating
	KBBufferClear				; clear the key buffer
_buffertestloop1:
	KBBufferCount eax			; get number of keys in buffer in eax
	cmp	eax,10				; 10 keys in buffer?
	jne	_buffertestloop1		; no, wait until there are
	mov	edi,_mybuffer			; edi->buffer to store the keys
_buffertestloop2:
	KBReadKey eax				; read a key from the buffer
	jc	_buffertestend			; loop until there are no keys in the buffer
	mov	[edi],al			; add the key to the buffer
	inc	edi				; move the buffer pointer on
	jmp	_buffertestloop2		; keep going
_buffertestend:
	mov	edx,_mybuffer			; display keys pressed
	mov	ah,9
	int	$21
_end:
	Exit					; exit
;
; ------------------------------------------------------------------------
;
[section .data]
_Choices	db "Simple keyboard handler demo.",10,13,10,13
		db "Press 1 for key detecting test",10,13
		db "      2 for buffered input test",10,13
		db "   or 3 to exit.",10,13,10,13,"$"
_Info1		db "Press any keys you like, hit escape to exit...$"
_Info2		db "Press 10 keys (they won't be displayed until all pressed)...$"
_mybuffer	db 0,0,0,0,0,0,0,0,0,0,10,13,"$"
;
; ------------------------------------------------------------------------
;
%include "Gaz\Dos\Includes\Routs.inc"
