; Standard Library - character type testing
; by Gaz
;
%ifndef _MYCTYPE
%define _MYCTYPE
;
;------------------------------------------------------------------------------------
;
; Tests whether a character is alphanumeric
;
%ifdef _MYSTR_ISALALPHANUMERIC_MACRO
_mystr_isalalphanumeric_2:
	cmp	al,'0'				; character below '0'?
	jb	_mystr_isalalphanumeric_notnum	; yes, not an alphanumeric
	cmp	al,'9'				; below or equal to '9'?
	jbe	_mystr_isalalphanumeric_end	; yes, it's an alphanumeric
	cmp	al,'A'				; below 'A'?
	jb	_mystr_isalalphanumeric_notnum	; yes, not an alphanumeric
	cmp	al,'Z'				; below or equal to 'Z'?
	jbe	_mystr_isalalphanumeric_end	; yes, it's an alphanumeric
	cmp	al,'a'				; below 'a'?
	jb	_mystr_isalalphanumeric_notnum	; yes, not an alphanumeric
	cmp	al,'z'				; above 'z'?
	ja	_mystr_isalalphanumeric_notnum	; yes, not an alphanumeric
_mystr_isalalphanumeric_end:
	clc					; flag it's an alphanumeric
	ret
_mystr_isalalphanumeric_notnum:
	stc					; flag it's not an alphanumeric character
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Tests whether a character is alphabetical
;
%ifdef _MYSTR_ISALALPHA_MACRO
_mystr_isalalpha_2:
	cmp	al,'A'				; is it below 'A'
	jb	_mystr_isalalpha_notnum		; yes, can't be a letter
	cmp	al,'Z'				; is it below 'Z'
	jbe	_mystr_isalalpha_end
	cmp	al,'a'
	jb	_mystr_isalalpha_notnum
	cmp	al,'z'
	ja	_mystr_isalalpha_notnum
_mystr_isalalpha_end:
	clc
	ret
_mystr_isalalpha_notnum:
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Checks whether a byte is an ASCII character
;
%ifdef _MYSTR_ISALASCII_MACRO
_mystr_isalascii_2:
	cmp	al,127
	ja	_mystr_isalascii_error
	clc
	ret
_mystr_isalascii_error:
	stc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Checks whether a byte is a control character
;
%ifdef _MYSTR_ISALCONTROL_MACRO
_mystr_isalcontrol_2:
	cmp	al,$01f
	jbe	_mystr_isalcontrol_end
	cmp	al,$07f
	je	_mystr_isalcontrol_end
	stc
	ret
_mystr_isalcontrol_end:
	clc
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Checks whether a byte is a number digit
;
%ifdef _MYSTR_ISALDIGIT_MACRO
_mystr_isaldigit_2:
	cmp	al,'0'				; character below '0'?
	jb	_mystr_isaldigit_error		; yes, not a number
	cmp	al,'9'				; above '9'?
	ja	_mystr_isaldigit_error		; yes, not a number
	clc					; flag it's a number
	ret
_mystr_isaldigit_error:
	stc					; flag it's not a number
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Checks whether a byte is lowercase
;
%ifdef _MYSTR_ISALLOWER_MACRO
_mystr_isallower_2:
	cmp	al,'a'				; below 'a'?
	jb	_mystr_isallower_error		; yes, error
	cmp	al,'z'				; no, above 'z'?
	ja	_mystr_isallower_error		; yes, error
	clc					; no, flag ok
	ret
_mystr_isallower_error:
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Checks whether a byte is uppercase
;
%ifdef _MYSTR_ISALUPPER_MACRO
_mystr_isalupper_2:
	cmp	al,'A'				; below 'A'?
	jb	_mystr_isalupper_error		; yes, error
	cmp	al,'Z'				; no, above 'Z'?
	ja	_mystr_isalupper_error		; yes, error
	clc					; no, flag ok
	ret
_mystr_isalupper_error:
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Checks whether a byte is a hex digit or not
;
%ifdef _MYSTR_ISALHEXDIGIT_MACRO
_mystr_isalhexdigit_2:
	cmp	al,'0'				; character below '0'?
	jb	_mystr_isalhexdigit_error	; yes, not a hex digit
	cmp	al,'9'				; above '9'?
	ja	_mystr_isalhexdigit_b		; yes, possibly a hex digit
	clc					; flag it's a hex digit
	ret
_mystr_isalhexdigit_b:
	cmp	al,'A'				; below 'A'?
	jb	_mystr_isalhexdigit_error	; yes, error
	cmp	al,'F'				; above 'F'?
	ja	_mystr_isalhexdigit_c		; yes, possibly a hex digit
	clc					; no, flag it's a hex digit
	ret
_mystr_isalhexdigit_c:
	cmp	al,'a'				; below 'a'?
	jb	_mystr_isalhexdigit_error	; yes, error
	cmp	al,'f'				; above 'f'?
	ja	_mystr_isalhexdigit_error	; yes, error
	clc					; no, flag it's a hex digit
	ret
_mystr_isalhexdigit_error:
	stc					; flag it's not a hex digit
	ret
%endif

%endif

