; Miscellaneous routines for NASM and WDOSX
;
%ifndef _MYMISC
%define _MYMISC
;
%ifdef _MYMISC_DETECT_OS_MACRO
%include "gaz\includes\dpmi.inc"
%endif
[BITS 32]
[segment .data]
;
%ifdef _MYMISC_DETECT_OS_MACRO
_os_type		dd _OS_TYPE_DOS
_os_version		dw 0
_os_subversion		dw 0
%endif

%ifdef _MYMISC_DETECT_CPU_MACRO
_cpu_type		dd _CPU_TYPE_386
_cpu_mmx		dd _CPU_MMX_UNSUPPORTED
_cpu_fpu		dd _CPU_FPU_UNSUPPORTED
%endif
;
[segment .text]
;
;--------------------------------------------------------------------
;
; Detects the current OS we're running under. Original DJGPP code by
; Shawn Hargreaves for Allegro. Converted to NASM by Gaz
;
%ifdef _MYMISC_DETECT_OS_MACRO
_mymisc_detect_os_2:
	push	eax
	push	ebx
	push	ecx
	push	edi
	mov	[_os_type],dword _OS_TYPE_DOS	; assume it's DOS
	mov	edi,_RMRegisters		; real-mode register structure
	mov	[_RMR_SP],dword 0		; real-mode stack
	mov	[_RMR_AX],word $01600		; function to get windows version
	mov	ax,$300				; simulate real-mode interrupt
	mov	bl,$02f				; interrupt $2f
	mov	bh,0				; reserved
	mov	cx,0				; don't copy any of the pm stack
	int	$31				; call the real-mode interrupt
	jc	near _mymisc_detect_os_end	; DPMI error, give up!
	mov	eax,[_RMR_EAX]
	cmp	al,0
	je	_mymisc_detect_os_notwinx	; not Win3x enhanced mode
	cmp	al,1
	je	_mymisc_detect_os_notwinx	; Win2x
	cmp	al,$080
	je	_mymisc_detect_os_notwinx	; obsolete XMS installed
	cmp	al,$0ff
	je	_mymisc_detect_os_notwinx	; Win2x
	cmp	al,4				; Win95?
	jne	_mymisc_detect_os_win3x		; no, Win 3.x
	mov	[_os_type], dword _OS_TYPE_WIN95	; yes, flag it's Win95
	jmp	_mymisc_detect_os_winversion	; and go get the version
_mymisc_detect_os_win3x:
	mov	[_os_type], dword _OS_TYPE_WIN3	; flag it's Win 3.x
_mymisc_detect_os_winversion:
	mov	ebx,eax
	and	ebx,$0ff
	mov	[_os_version],bx		; save the major version
	shr	eax,8
	and	eax,$0ff
	mov	[_os_subversion],ax		; and the subversion
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_notwinx:
	mov	ax,$0440d			; not Winx, but could be a Win95 DOS box with the "prevent
	mov	cx,$0870			; MS-DOS programs from detecting Windows" option checked
	mov	bl,0				; so try a Win95 only DOS call
	int	$21
	jc	_mymisc_detect_os_notwin95	; call failed, can't be Win95
	mov	[_os_type],dword _OS_TYPE_WIN95	; success, flag it's Win95
	pop	edi				; no idea about the version though...
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_notwin95:
	mov	ah,$030
	int	$21
	cmp	al,$05				; NT DOSbox returns 5 as the major version
	jne	_mymisc_detect_os_notwinnt	; not NT
	mov	ax,$0440d			; try a DOS 7 function in case it really is DOS v5.x
	mov	cx,$0870			; get lock flag state
	mov	bl,0				; default drive
	int	$21
	jnc	_mymisc_detect_os_winnt		; call succeeded, must be NT
	cmp	ax,1				; call failed, was the error code invalid function?
	je	_mymisc_detect_os_notwinnt	; yes, can't be NT
_mymisc_detect_os_winnt:
	mov	[_os_type], dword _OS_TYPE_WINNT
	mov	[_os_version],word 4		; anyone know how to get the WinNT version from a DOSbox?
	mov	[_os_subversion],word 0
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_notwinnt:
	mov	edi,_RMRegisters		; real-mode register structure
	mov	[_RMR_SP],dword 0		; real-mode stack
	mov	[_RMR_AX],word $04010		; function to get OS2 version
	mov	ax,$300				; simulate real-mode interrupt
	mov	bl,$02f				; interrupt $2f
	mov	bh,0				; reserved
	mov	cx,0				; don't copy any of the pm stack
	int	$31				; call the real-mode interrupt
	jc	near _mymisc_detect_os_end	; DPMI error, give up!
	mov	eax,[_RMR_EAX]
	cmp	ax,$04010
	je	_mymisc_detect_os_notos2
	cmp	ax,0
	jne	_mymisc_detect_os_notwarp
	mov	[_os_type], dword _OS_TYPE_WARP
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_notwarp:
	mov	[_os_type], dword _OS_TYPE_OS2
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_notos2:
	mov	eax,$0ffff5
	cmp	[eax], dword '02/2'
	jne	_mymisc_detect_os_notdosemu
	cmp	[eax + 4], dword '5/93'
	jne	_mymisc_detect_os_notdosemu
	xor	eax,eax
	int	$0e6
	cmp	ax,$0aa55
	jne	_mymisc_detect_os_end
	mov	[_os_type], dword _OS_TYPE_DOSEMU
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_notdosemu:
	mov	eax,$04452
	int	$21
	cmp	ax,$01072
	jb	_mymisc_detect_os_end
	jc	_mymisc_detect_os_end
	mov	[_os_type], dword _OS_TYPE_OPENDOS
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
_mymisc_detect_os_end:
	pop	edi
	pop	ecx
	pop	ebx
	pop	eax
	ret
%endif
;
;--------------------------------------------------------------------
;
; Detects the CPU type, including whether it supports MMX and has an FPU.
;
%ifdef _MYMISC_DETECT_CPU_MACRO
_mymisc_detect_cpu_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	pushfd					; save flags
	mov	[_cpu_type],dword _CPU_TYPE_386	; assume it's a 386 to start with
	mov	[_cpu_mmx],dword _CPU_MMX_UNSUPPORTED	; and doesn't support MMX
	mov	[_cpu_fpu],dword _CPU_FPU_UNSUPPORTED	; and doesn't have an FPU
	cli					; stop interrupts
	pushfd					; get the current flags in eax
	pop	eax
	or	eax,_MYMISC_FLAGS_AC		; set the Alignment Check bit (only available on 486+)
	push	eax				; put the flags back into place
	popfd
	pushfd					; get the flags back into eax
	pop	eax
	and	eax,_MYMISC_FLAGS_AC		; is the AC bit still set?
	jz	_mymisc_detect_cpu_fpu		; no, must be a 386, go check the FPU
	mov	[_cpu_type],dword _CPU_TYPE_486	; yes, must be a 486+
	pushfd					; get the current flags in eax
	pop	eax
	or	eax,_MYMISC_FLAGS_CPUID		; set the CPUID flag
	push	eax				; put the flags back into place
	popfd
	pushfd					; get the flags back into eax
	pop	eax
	and	eax,_MYMISC_FLAGS_CPUID		; is the CPUID flag still set?
	jz	_mymisc_detect_cpu_fpu		; no, must be the 486 we assumed it was earlier so go check the FPU
	mov	eax,1				; yes, use CPUID to return version and feature information
	cpuid
	shr	eax,8				; get family information (bits 11-8)
	and	eax,$0f				; mask off bits
	cmp	eax,4				; is it a 486?
	je	_mymisc_detect_cpu_fpu		; yes, like we assumed before, so go check the FPU
	mov	[_cpu_type],dword _CPU_TYPE_586	; no, must be a Pentium or above
	cmp	eax,6				; could it be a Pentium Pro?
	jne	_mymisc_detect_cpu_notppro	; no
	mov	[_cpu_type],dword _CPU_TYPE_686	; yes, so flag it's a Pentium Pro
_mymisc_detect_cpu_notppro:
	and	edx,_MYMISC_FEATURES_MMX	; does the CPU support MMX?
	jz	_mymisc_detect_cpu_fpu		; no, go check the FPU
	mov	[_cpu_mmx],dword _CPU_MMX_SUPPORTED	; yes, flag it supports MMX
_mymisc_detect_cpu_fpu:
	xor	eax,eax				; set eax to hold $0ffffffff
	dec	eax
	push	eax				; store this temporarily on the stack				; 
	fninit
	fnstsw	[esp]
	mov	bx,[esp]
	pop	eax				; restore temporary variable space
	or	bx,bx
	jnz	_mymisc_detect_cpu_end
	mov	[_cpu_fpu],dword _CPU_FPU_SUPPORTED
_mymisc_detect_cpu_end:
	popfd					; restore flags (and interrupt state)
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	ret
%endif
;
;--------------------------------------------------------------------
;
; Wait for specified number of microseconds
;
%ifdef _MYMISC_MICROSECOND_DELAY_MACRO
_mymisc_microsecond_delay_2:
	push	eax				; save registers
	push	ecx
	push	edx
	mov	ecx,[esp + 16]			; get delay value
	mov	edx,ecx				; cx:dx holds value
	shr	ecx,16
	mov	ah,$086				; delay function
	int	$015
	pop	edx				; restore registers
	pop	ecx
	pop	eax
	ret
%endif
;
;--------------------------------------------------------------------
;
; According to the Interrupt List, the resolution of the wait period
; on most systems is 997 microseconds so milliseconds are probably
; more useful (and almost certainly accurate enough)...
;
%ifdef _MYMISC_MILLISECOND_DELAY_MACRO
_mymisc_millisecond_delay_2:
	push	eax				; save registers
	push	ecx
	push	edx
	mov	eax,[esp + 16]
	shl	eax,3
	lea	ecx,[eax + eax*2]
	shl	eax,7
	sub	eax,ecx				; eax=eax*1000
	mov	ecx,eax				; cx:dx = delay value
	mov	edx,eax
	shr	ecx,16
	mov	ah,$086				; delay function
	int	$015
	pop	edx				; restore registers
	pop	ecx
	pop	eax
	ret
%endif
;
%endif
