; Video subsystem
;
; Original flat-form binary code by Gaz. Corrections, conversion to RDOFF format,
; and (working!) pmode bank switching detection by Michael Tippach (aka Wuschel).
;
; Many thanx to Wuschel for correcting my incompetence!
;

%ifndef _MYVESA
%define _MYVESA

_MYVESAROUTSIZE		equ 512
_MYVESAROUTSIZED	equ 128

[BITS 32]
[section .bss]

_VESASpare			resd 1		; some spare variables
_VESASpare2			resd 1
_VESASpare3			resd 1

%ifdef _VESAINIT_MACRO
_VESA_SVGAInfo:					; VESA VBE data structure
_VSI_VESASignature		resd 1		; 'VESA'
_VSI_VESAVersion		resw 1		; major & minor numbers as bytes
_VSI_OEMStringPtr		resd 1		; far pointer to manufacturer's string
_VSI_Capabilities		resd 1		; VBE 2.0 only
_VSI_VideoModePtr		resd 1		; far pointer to list of modes
_VSI_MemoryAmount		resw 1		; number of 64k memory blocks installed
_VSI_OEMSoftwareRevision	resw 1		; VBE 2.0 only, software revision number
_VSI_OEMVendorNamePtr		resd 1		; VBE 2.0 only, far pointer to manufacturer's name string
_VSI_OEMProductNamePtr		resd 1		; VBE 2.0 only, far pointer to product name string
_VSI_OEMProductRevisionPtr	resd 1		; VBE 2.0 only, far pointer to product revision string
times 512-$+_VESA_SVGAInfo	resb 1		; make up to 512 bytes

_VESA_SVGAModeInfo:				; VESA mode info data structure
_VSMI_ModeAttributes		resw 1		; mode attributes
_VSMI_WinAAttributes		resb 1		; attributes for each window (bit 0=set if exists, bit 1=set if readable,
_VSMI_WinBAttributes		resb 1		; bit 2=set if writeable, other bits reserved)
_VSMI_WinGranularity		resw 1		; used to be 64k most of the time, but nowadays is usually less
_VSMI_WinSize			resw 1		; window size
_VSMI_WinASegment		resw 1		; for gfx modes should be $a000 but...
_VSMI_WinBSegment		resw 1
_VSMI_WinFuncPtr		resd 1		; address of Window Function Call for fast bank switching
						; _much_ faster than the equivalent BIOS call
_VSMI_BytesPerScanLine		resw 1		; bytes/scanline
_VSMI_XResolution		resw 1		; x resolution (pixels for graphics modes, character for text)
_VSMI_YResolution		resw 1		; y resolution
_VSMI_XCharSize			resb 1		; character x width (pixels)
_VSMI_YCharSize			resb 1		; character y width (pixels)
_VSMI_NumberOfPlanes		resb 1		; number of bit planes
_VSMI_BitsPerPixel		resb 1		; bits/pixel
_VSMI_NumberOfBanks		resb 1		; number of banks
_VSMI_MemoryModel		resb 1		; memory model
_VSMI_BankSize			resb 1		; memory bank size (Kb)
_VSMI_NumberOfPages		resb 1		; maximum number of screen buffers available for page switching
_VSMI_Reserved			resb 1
_VSMI_RedMaskSize		resb 1		; size of direct color red mask in bits
_VSMI_RedMaskPosition		resb 1		; bit position of lsb of red mask
_VSMI_GreenMaskSize		resb 1		; green mask details
_VSMI_GreenMaskPosition		resb 1
_VSMI_BlueMaskSize		resb 1		; blue mask details
_VSMI_BlueMaskPosition		resb 1
_VSMI_ReservedMaskSize		resb 1		; reserved mask details
_VSMI_ReservedMaskPosition	resb 1
_VSMI_DirectColorModeInfo	resb 1		; direct color mode attributes
_VSMI_LFBAddress		resd 1		; VBE 2.0 only, physical address of linear framebuffer
_VSMI_OffScreenMemoryPtr	resd 1		; VBE 2.0 only, pointer to start of off-screen memory
_VSMI_OffScreenMemorySize	resw 1		; VBE 2.0 only, size of off-screen memory (Kb)
times 512-$+_VESA_SVGAModeInfo	resb 1		; make up to 512 bytes

_VESAModeList	times 2048	resb 1		; unlikely to be > 1024 modes

_VESASegment			resw 1		; DOS segment of allocated low memory
_VESASelector			resw 1		; selector of the allocated memory
_VESADosAddress			resd 1		; DOS linear address of allocated low memory

_VESAXResolution		resw 1		; x resolution of requested mode
_VESAYResolution		resw 1		; y
_VESABitsPerPixel		resb 1		; bits/pixel
				resb 1
_VESAMode			resw 1		; currently set mode
_VESAFlag			resd 1		; 0=no, 1+=yes (1=installed, >1=install,mode set)
_VESATextFlag			resd 1		; report information to screen?
_VESAScreenSize			resd 1		; size of the screen
_VESABankFlag			resd 1		; type of banks in use
_VESADoubleFlag			resd 1		; whether we're doing hardware double-buffering or not
_VESAOptimisedFlag		resd 1		; whether we're using Pentium-optimised screen copying routines or not
_VESALFBDoubleFlag		resd 1		; whether we're using hardware double-buffering and a LFB

_VESADoScreenCount		resd 1		; number of whole 64K segments to do
_VESADoScreenCount2		resd 1		; number of other dwords to do
_VESAWinSegment			resd 1		; segment address of the writeable window
_VESAWinCall			resd 1		; holds the window to bank switch (if used)
_VESABankInc			resd 1		; if bank switching is used this takes into account the window granularity
_VESAScreen1Address		resd 1		; starting addresses of the two screens (or the bank numbers
_VESAScreen2Address		resd 1		; in bank switching modes)
_VESAScreen1Scanline		resd 1		; starting scanlines of the two screens for harware double
_VESAScreen2Scanline		resd 1		; buffering (will get swapped)
%endif

[section .data]

%ifdef _VESAINIT_MACRO
_VESALFBAddress		dd 0			; linear address of mapped LFB
_VESAMallocAddress	dd 0			; address of allocated screen
_VESAScreen		dd 0			; address of screen
_VESAScreenFlag		dd 0			; screen we're displaying

_VESAError1		db 10,13,"VESA: Can't allocate low memory!$"
_VESAError1d		db 10,13,"VESA: Can't deallocate low memory!$"
_VESAError2		db 10,13,"VESA: Can't call real-mode interrupt!$"
_VESAError3		db 10,13,"VESA: No VESA BIOS Extensions (VBE) installed!$"
; _VESAError4 free
_VESAError5		db 10,13,"VESA: No VESA graphics card detected!$"
_VESAError6		db 10,13,"VESA: Using linear framebuffer$"
_VESAError8		db 10,13,"VESA: Using protected-mode bank switching$"
_VESAError9		db 10,13,"VESA: Using real-mode bank switching$"
_VESAInitOk		db 10,13,"Initialised VESA BIOS Extensions v1.2 or above$"
%endif

[section .text]
;
;------------------------------------------------------------------------------------
;
; Call to detect the VBE subsystem
;
%ifdef _VESAINIT_MACRO
_VESAInit_2:
	HeapInit 0				; initialise the heap it hasn't already been
	DetectCPU				; detect the CPU type
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	mov	dword [_RMR_SP], 0		; real-mode register structure stack pointer
	mov	eax,[esp + 28]
	mov	[_VESATextFlag],eax		; save the flag
	mov	[_VESAFlag],dword 0		; no VESA yet
	mov	ax,$100				; allocate some low memory
	mov	bx,64				; 1024 bytes to allocate (don't really need this much but...)
	int	$31
	jc	near _VESAInitE1		; carry set on DPMI error
	mov	[_VESASegment],ax		; segment address
	mov	[_VESASelector],dx		; selector allocated (need this to free the memory later)
	mov	ecx,eax				; convert segment address to linear address
	and	ecx,0ffffh
	shl	ecx,4
	mov	[_VESADosAddress],ecx		; linear address of VBE info block
	mov	edi,_RMRegisters		; real-mode register structure
	mov	[_RMR_EAX],dword $4f00		; function $4f, sub-function 0 - try and detect VBE
	mov	[_RMR_ES],ax			; segment
	mov	[_RMR_EDI],dword 0		; offset
	mov	ax,$300				; simulate real-mode interrupt
	mov	bl,$10				; interrupt $10
	mov	bh,0				; reserved
	mov	cx,0				; don't copy any of the pm stack
	int	$31
	jc	near _VESAInitE2		; carry set on DPMI error
	mov	eax,[_RMR_EAX]			; get real-mode eax register
	cmp	al,$4f				; VBE detected?
	jne	near _VESAInitE3		; no, exit
	mov	esi,[_VESADosAddress]		; address of VBE info in DOS memory
	mov	eax,[esi]			; get VBE signature
	cmp	eax,'VESA'
	jne	near _VESAInitE5		; not VESA!
	mov	edi,_VESA_SVGAInfo		; copy info to buffer - we might want it later
	mov	ecx,512				; 512 bytes to copy (well, 256 in VBE1.2 but 512 in VBE2 and some
						; implementations of VBE1.2 actually used 512 bytes...)
	rep	movsb				; copy into our structure
	mov	edi,_VESAModeList		; now copy the mode list to pm memory
	mov	eax,[_VSI_VideoModePtr]		; convert far pointer to linear address
	mov	esi,eax
	and	eax,0ffffh
	shr	esi,16
	and	esi,0ffffh
	shl	esi,4
	add	esi,eax
	mov	[_VSI_VideoModePtr],edi		; save offset of new mode list
_VESAInitLoop:
	lodsw					; get next mode number
	cmp	ax,-1				; end of list?
	je	_VESAInitLoopDone		; yes, finish
	stosw					; no, save mode number
	jmp	_VESAInitLoop			; keep looping through mode numbers
_VESAInitLoopDone:
	stosw					; save end of list marker
	mov	ax,$101				; free DOS memory
	mov	dx,[_VESASelector]		; selector to DOS memory
	int	$31
	jc	_VESAInitE1d			; carry set on DPMI error
	cmp	[_VESATextFlag],dword 0		; display messages?
	je	_VESAInitOk1			; no
	mov	edx,_VESAInitOk			; yes, display VESA VBE initialised
	mov	ah,9
	int	$21
_VESAInitOk1:
	mov	[_VESAFlag],dword 1		; flag VESA VBE installed
%define _VESAEND_MACRO
	AtExit	_VESAEnd_2
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_VESAInitE1:
	mov	edx,_VESAError1			; these set edx to point to different error messages
	jmp	_VESAInitEEnd
_VESAInitE1d:
	mov	edx,_VESAError1d
	jmp	_VESAInitEEnd
_VESAInitE2:
	mov	edx,_VESAError2
	jmp	_VESAInitEEnd2
_VESAInitE3:
	mov	edx,_VESAError3
	jmp	_VESAInitEEnd2
_VESAInitE5:
	mov	edx,_VESAError5
	jmp	_VESAInitEEnd2
_VESAInitEEnd:
	cmp	[_VESATextFlag],dword 0		; display messages?
	je	_VESAInitEEndb			; no, end
	mov	ah,9				; error message
	int	$21
_VESAInitEEndb:
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
_VESAInitEEnd2:
	cmp	[_VESATextFlag],dword 0
	je	_VESAInitEEnd2b
	mov	ah,9
	int	$21
_VESAInitEEnd2b:
	mov	ax,$101				; free DOS memory
	mov	dx,[_VESASelector]
	int	$31
	jc	_VESAInitE1d			; carry set on DPMI error
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	stc				; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call this before exiting to return to text mode and free up any allocated resources
;
%ifdef _VESAEND_MACRO
_VESAEnd_2:
	push	eax				; save registers
	push	ebx
	push	ecx
        cmp     [_VESAFlag],dword 0		; VESA VBE installed?
        je     _VESAEnd2			; no, end
	cmp	[_VESALFBAddress],dword 0	; yes, previously mapped LFB?
	jne	_VESAEndGo1			; no
	mov	ebx,[_VESALFBAddress]		; yes, un-map the mapping
	mov	ecx,ebx				; bx:cx holds the mapped address
	shr	ebx,16
	mov	ax,$0801			; free mapping
	int	$31				; if this fails our mapped address was invalid...
	mov	[_VESALFBAddress],dword 0	; flag no mapping
_VESAEndGo1:
	mov	eax,[_VESAMallocAddress]
	or	eax,eax				; previously allocated screen?
	jz	_VESAEndGo2			; no
	Free	eax				; yes, de-allocate it
	mov	[_VESAMallocAddress],dword 0	; no allocated screen
_VESAEndGo2:
	cmp	[_VESAFlag],dword 1		; has a mode been set?
	je	_VESAEnd2			; no, don't bother switching to text mode
	mov	eax,3				; back to text mode
	int	$10
_VESAEnd2:
	mov	[_VESAFlag],dword 0		; flag VESA VBE not installed
	pop	ecx				; restore registers
	pop	ebx
	pop	eax
	clc					; flag success
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Call to set a mode, eax=0 if not set (doesn't exist) or error, 1+ if set
; bit 0=set if LFB, bit 1=set if pmode bank switching, bit 2=set if real-mode bank switching
; eax=x resolution, upper word used as flags to only use set bank switching, bit 0 (ie bit 16 of eax) is
; set to only use a LFB, bit 1 set to only use pmode bank switching, bit 2 set for real-mode bank switching
; top-most bit used for suggest mode (see demo code for an example)
; ebx=y resolution, upper word reserved
; cl=bits per pixel
; edx=0/1 where 1=report information to screen
;
%ifdef _VESASETMODE_MACRO
_VESASetMode_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	mov	eax,[esp + 40]			; x resolution
	mov	ebx,[esp + 36]			; y resolution
	mov	ecx,[esp + 32]			; bits/pixel
	mov	edx,[esp + 28]			; information flag
	mov	[_VESATextFlag],edx
	mov	[_VESASpare3],eax
	and	eax,$07fffffff
	mov	[_VESASpare2],eax
	mov	[_VESAXResolution],ax		; save the mode info for later
	mov	[_VESAYResolution],bx
	mov	[_VESABitsPerPixel],cl
	mov	[_VESASpare],dword 0		; holds the result of this function
	cmp	[_VESAFlag],dword 0		; VESA VBE installed?
	je	near _VESASetModeEnd		; no, exit
	cmp	[_VESALFBAddress],dword 0	; previously mapped LFB?
	jne	_VESASetModeGo1			; no
	mov	ebx,[_VESALFBAddress]		; yes, un-map the mapping
	mov	ecx,ebx				; bx:cx holds mapped address
	shr	ebx,16
	mov	ax,$0801
	int	$31				; if this fails our mapped address was invalid...
	mov	[_VESALFBAddress],dword 0	; flag no mapping
_VESASetModeGo1:
	mov	eax,[_VESAMallocAddress]
	cmp	eax,0				; previously allocated screen?
	je	_VESASetModeGo2			; no
	Free	eax				; yes, free up the memory
	mov	[_VESAMallocAddress],dword 0	; no allocated screen
_VESASetModeGo2:
	mov	ax,$100				; allocate some low memory
	mov	bx,64				; number of 16-byte paragraphs wanted (ie 1K)
	int	$31
	jc	near _VESASetModeEnd		; trouble
	mov	[_VESASegment],ax		; save the segment and selector
	mov	[_VESASelector],dx
	and	eax,0ffffh			; convert segment address to linear address
	shl	eax,4
	mov	[_VESADosAddress],eax		; save address of allocated memory
	mov	esi,[_VSI_VideoModePtr]		; esi->mode list
	mov	ebp,eax				; address of allocated DOS memory
	xor	eax,eax				; zero eax
_VESASetModeLoop:
	lodsw					; ax=mode
	cmp	ax,-1				; end of list?
	je	near _VESASetModeEnd2		; yes, stop looking
	mov	[_VESAMode],ax			; no, save the mode
	mov	edi,_RMRegisters		; real-mode register structure
	mov	[_RMR_EAX],dword $4f01		; get VBE mode info of this mode
	mov	[_RMR_EBX],dword 0
	mov	[_RMR_ECX],eax			; mode we want to know about
	mov	ax,[_VESASegment]		; segment address of allocated memory
	mov	[_RMR_ES],ax
	mov	[_RMR_EDI],dword 0		; offset
	mov	ax,$300				; simulate real-mode interrupt
	mov	bl,$10				; int $10
	mov	bh,0
	mov	cx,0
	int	$31
	jc	near _VESASetModeEnd2		; carry set on DPMI error
	mov	ax,[ebp+18]			; is this the mode we want?
	cmp	ax,[_VESAXResolution]		; x resolution we want?
	jne	_VESASetModeLoop		; not correct x resolution, keep looking
	mov	ax,[ebp+20]
	cmp	ax,[_VESAYResolution]		; y resolution we want
	jne	_VESASetModeLoop		; not correct y resolution, keep looking
	mov	al,[ebp+25]
	cmp	al,[_VESABitsPerPixel]		; bits/pixel we want
	jne	_VESASetModeLoop		; not correct number of bits/pixel, keep looking
	mov	esi,[_VESADosAddress]		; correct mode, copy info to buffer
	mov	edi,_VESA_SVGAModeInfo		; copy to our mode info structure
	mov	ecx,512				; 512 bytes to copy
	rep	movsb				; copy
	xor	eax,eax				; zero eax so we can work with 32 bits
        mov	ax,[_VSMI_WinAAttributes]	; work out which window to write to
        and	eax,5				; mask in bits 0 and 2 (window exists and window writeable attributes)
        cmp	eax,5				; both set?
        jne	_VESASetModeWindowCheck		; no, try the other window
        mov	[_VESAWinCall],dword 0		; select window A (used in bank switching calls)
        mov	ax,[_VSMI_WinASegment]		; get the window's segment address
        shl	eax,4				; make into a linear address
        mov	[_VESAWinSegment],eax		; save for _VESADoScreen
        jmp	_VESASetModeGranularityCheck	; go and do the window granularity check
_VESASetModeWindowCheck:
	mov	ax,[_VSMI_WinBAttributes]	; can't use window A so check window B
	and	eax,5				; again, require it to exist and be writeable
	cmp	eax,5				; things cool?
	jne	near _VESASetModeEnd2		; utterly insane (or damaged) card with neither window writeable...
	mov	[_VESAWinCall],dword 1		; select window B (used in bank switching calls)
	mov	ax,[_VSMI_WinBSegment]		; get the window's segment address
	shl	eax,4				; make into a linear address
	mov	[_VESAWinSegment],eax		; save for _VESADoScreen
_VESASetModeGranularityCheck:
	xor	eax,eax				; work out the bank granularity, older cards are 64K but most recent ones are less
	mov	ax,[_VSMI_WinGranularity]
	cmp	eax,64				; maximum granularity is 64K
	jne	_VESASetModeGranularity1	; no, try a lower granularity
	mov	ebx,1				; 64K = 1 bank
_VESASetModeGranularity1:
	cmp	eax,32
	jne	_VESASetModeGranularity2
	mov	ebx,2				; 64K = 2 banks
_VESASetModeGranularity2:
	cmp	eax,16
	jne	_VESASetModeGranularity3
	mov	ebx,4				; 64K = 4 banks
_VESASetModeGranularity3:
	cmp	eax,8
	jne	_VESASetModeGranularity4
	mov	ebx,8				; 64K = 8 banks
_VESASetModeGranularity4:
	cmp	eax,4
	jne	_VESASetModeGranularity5
	mov	ebx,16				; 64K = 16 banks
_VESASetModeGranularity5:
	cmp	eax,2
	jne	_VESASetModeGranularity6
	mov	ebx,32				; 64K = 32 banks
_VESASetModeGranularity6:
	cmp	eax,1
	jne	_VESASetModeGranularityGo
	mov	ebx,64				; 64K = 64 banks
_VESASetModeGranularityGo:
	mov	[_VESABankInc],ebx		; save the number of banks/64K
	xor	eax,eax				; work out size of the screen
	mov	ax,[_VESAXResolution]		; eax=x resolution
	xor	edx,edx
	mov	dx,[_VESAYResolution]		; edx is the count (ie screen height)
	xor	esi,esi				; start from zero
_VESASetModeSizeLoop:
	add	esi,eax				; add scanline length for every scanline
	dec	edx				; done one scanline
	jnz	_VESASetModeSizeLoop		; keep going until all scanlines done
	mov	edx,esi				; save total number of pixels
	xor	eax,eax				; now work out number of bytes/pixel
	mov	al,[_VESABitsPerPixel]
	inc	eax				; I only check for 8,15,16,24 and 32 bits/pixel
	shr	eax,3				; but this shouldn't really be a problem
	mov	esi, edx			; work out actual screen size (thanx to Michael Tippach
	imul	esi, eax			; for teaching me this elementary x86)
	mov	[_VESAScreenSize],esi		; save the screen size for a bit later
	mov	[_VESALFBDoubleFlag],dword 0	; assume no double buffer + LFB
	mov	eax,[_VESASpare3]
	and	eax,$080000000
	mov	[_VESASpare3],eax
	mov	eax,[_VESASpare2]
	shr	eax,16
	mov	[_VESASpare2],eax
	cmp	eax,0				; force bank switching?
	je	_VESASetModeSkip1		; no, set mode normally
	cmp	eax,1				; yes, force LFB use?
	jne	near _VESASetModeNoLFB		; no, don't try to use LFB
_VESASetModeSkip1:
	mov	ax,$4f02			; now set the mode
	mov	bx,[_VESAMode]			; mode we want to set
	or	bx,$04000			; try and set using an LFB
	int	$10				; set it
	cmp	ah,0				; success?
	jnz	near _VESASetModeNoLFB		; non-zero is no, so try and set without an LFB
	mov	[_VESADoubleFlag],dword 0	; no double-buffer
	mov	esi,[_VESAScreenSize]		; get the screen size
	mov	eax,$04f07			; try and set the display start to a second screen
	mov	ebx,$080			; function $080 - set display start at VBL (this isn't supported by
						; all cards, but is used in _VESADoScreen so if it fails we won't
						; use a double-buffer and it won't matter)
	xor	ecx,ecx				; horizontal pixel offset of 0
	xor	edx,edx
	mov	dx,[_VESAYResolution]		; vertical pixel offset - start straight after the first screen
	int	$10
	cmp	ax,$04f				; success?
	jne	_VESASetModeLFBNoBuffer		; no, don't try for a double-buffer
	mov	eax,$04f07			; yes, get the new screen co-ordinates
	mov	ebx,1
	int	$10
	and	ecx,$0ffff			; mask off top word
	or	ecx,ecx				; horizontal offset still 0?
	jnz	_VESASetModeLFBNoBuffer		; no, don't try for a double-buffer
	cmp	dx,[_VESAYResolution]		; vertical offset still the same?
	jne	_VESASetModeLFBNoBuffer		; no, don't try for a double-buffer
	shl	esi,1				; yes, double screen size
	mov	[_VESADoubleFlag],dword 1	; flag we're using a double buffer
_VESASetModeLFBNoBuffer:
	mov	ebx,[_VSMI_LFBAddress]		; map our LFB to a linear address so we can access it
	mov	ecx,ebx
	shr	ebx,16				; bx:cx is the address to map
	mov	edi,esi				; si:di = size of region to map (ie the screen size)
	shr	esi,16
	mov	ax,$0800			; map the LFB
	int	$31
	jc	near _VESASetModeNoLFB		; DPMI error, but don't give up yet - try and use a non-LFB mode
	shl	ebx,16				; get the mapped linear address (from bx:cx)
	mov	bx,cx
	mov	[_VESALFBAddress],ebx		; save for _VESADoScreen
	mov	[_VESABankFlag],dword 1		; 1=we're using an LFB
	mov	[_VESASpare],dword 1		; 1=we're using an LFB
	mov	[_VESAScreen],ebx		; save start address of the screen
	mov	edi,_VESADoScreen		; now setup the actual screen copying routine
	mov	eax,[_VESAScreenSize]		; divide screen size by 4 for screen copying routine
	mov	[_VESAScreen1Address],dword 0	; but first set the start addresses for the two screens
	mov	[_VESAScreen2Address],eax	; (in case we're using them)
	shr	eax,2
	mov	[_VESAScreenSize],eax		; save the screen size for _VESADoScreen
	cmp	[_VESADoubleFlag],dword 0	; buffered screen?
	je	_VESASetModeLFBSingle		; no
	mov	esi,_VESADoScreenHardwareDoubleStart	; yes, setup the hardware double-buffer swap routine
	mov	ecx,_VESAHardwareDoubleSize	; size of routine
	rep	movsb				; copy the routine into pplace
	mov	[_VESAScreen1Scanline],dword 0	; screen 1 starts at scanline 0
	xor	ecx,ecx
	mov	cx,[_VESAYResolution]		; screen 2 starts at the y resolution
	mov	[_VESAScreen2Scanline],ecx
	mov	ecx,[_VESAScreen]		; and setup addresses for the two screens
	mov	[_VESAScreen1Address],ecx
	add	[_VESAScreen2Address],ecx
	mov	[_VESALFBDoubleFlag],dword 1	; flag we're using a LFB with a double-buffer
;	not	dword [_VESAScreenFlag]
	jmp	_VESASetModeLFBGo
_VESASetModeLFBSingle:
	shl	eax,2				; get original screen size back
	Malloc	eax,ecx				; allocate some space for the screen
	jc	near _VESASetModeEnd2		; end if error
	shr	eax,2				; /4 because we'll copy dwords
	mov	[_VESAMallocAddress],ecx	; save allocated address
	mov	[_VESAScreen],ecx
	mov	esi,_VESADoScreenVblStart	; start routine for non-buffered screens
	mov	ecx,_VESASingleScreenStartSize	; size of routine
	rep	movsb				; copy it into place
	mov	esi,_VESADoScreenLFBStart	; install the LFB screen copy routine
	mov	ecx,_VESADoScreenLFBSize	; size of the routine
	mov	[_VESAOptimisedFlag],dword 0
	cmp	[_cpu_type],dword _CPU_TYPE_PENTIUM	; Pentium or better CPU?
	jb	_VESASetModeLFBNoPentium	; no :(
	mov	esi,_VESADoScreenLFBPStart	; yes, use the optimised routine instead
	mov	ecx,_VESADoScreenLFBPSize
	shr	eax,2				; divide the screen size by 4 again (ie by 16 in total)
	mov	[_VESAScreenSize],eax		; because we're copying 16 bytes/loop
	mov	[_VESAOptimisedFlag],dword 1
_VESASetModeLFBNoPentium:
	rep	movsb				; copy the routine
	mov	esi,_VESADoScreenVblEndStart	; copy the routine end
	mov	ecx,_VESASingleScreenEndSize
	rep	movsb				; copy final part
_VESASetModeLFBGo:
	cmp	[_VESATextFlag],dword 0		; display messages?
	je	_VESASetModeLFB
	mov	edx,_VESAError6			; try and display message, probably won't work
	mov	ah,9
	int	$21
_VESASetModeLFB:
	jmp	_VESASetModeOk			; everything done so exit the routine
_VESASetModeNoLFB:
	mov	eax,[_VESASpare2]
	cmp	eax,0				; force bank switching?
	je	_VESASetModeSkip2		; no, set mode normally
	mov	ebx,[_VESASpare3]		; only suggest type of bank switching?
	cmp	ebx,0				; 0=no
	je	_VESASetModeNoLFB2		; no, want to force a type of bank switching
	cmp	eax,2				; yes, only suggest type of bank switching to use
	jle	_VESASetModeSkip2		; try pmode bankswitching if a LFB or Pmode's been suggested
_VESASetModeNoLFB2:
	cmp	eax,2				; force bankswitching, force pmode use?
	jne	near _VESASetModeNoPModeSwitching	; no, don't try to use pmode bank switching
_VESASetModeSkip2:
	mov	ax,$4f02			; set the mode
	mov	bx,[_VESAMode]			; try and detect pmode bank switching, many thanx to Michael
	int	$10				; Tippach for providing some working code
	mov	edi,_RMRegisters		; real-mode register structure
	mov	word [_RMR_AX],$4f0a		; request VBE protected mode interface
	mov	word [_RMR_BX],0		; get all protected mode routines
	mov	bl,$10				; int $10 to call
	mov	cx,0				; don't copy any of the pmode stack
	mov	ax,$300
	int	$31				; simulate real-mode interrupt
	cmp	byte [_RMR_AH],0		; call succeeded?
	jnz	near _VESASetModeNoPModeSwitching	; no, no pmode bank switching
	mov	ax,[_RMR_ES]			; yes, es:di -> pmode code
	mov	edi,[_RMR_EDI]
	and	eax,$0ffff			; convert to linear address
	shl	eax,4
	and	edi,$0ffff
	add	eax,edi
	movzx	edi,word [eax]			; eax->(word) offset of bank switch routine
	add	eax,edi				; eax->bank switch routine
        mov     [_VSMI_WinFuncPtr],eax		; save the call address
	mov	eax,[_VESAScreenSize]		; the screen size
	Malloc	eax,ebx				; allocate space for the screen
	jc	near _VESASetModeEnd2		; end if error
	mov	[_VESAMallocAddress],ebx	; save allocated address
	mov	[_VESAScreen],ebx		; and store this as the screen address
	xor	ebx,ebx				; ebx is number of whole 64K segments
_VESASetModePM0:
	cmp	eax,65536			; 64K or more left in screen size?
	jb	_VESASetModePM1
	inc	ebx				; another 64K block to do in _VESADoScreen
	sub	eax,65536
	jmp	_VESASetModePM0
_VESASetModePM1:
	mov	[_VESADoScreenCount],ebx
	xor	ebx,ebx
	cmp	eax,0				; any of the screen left to do?
	je	_VESASetModePM2			; no, only whole 64K blocks
	mov	ebx,eax				; yes, get number of bytes over to do
	shr	ebx,2				; divide by 4 (we copy dwords)
_VESASetModePM2:
	mov	[_VESADoScreenCount2],ebx
	mov	[_VESABankFlag],dword 2		; 2=pmode bank switching
	mov	[_VESASpare],dword 2		; 2=pmode bank switching
	mov	edi,_VESADoScreen		; now setup the actual screen copying routine
	mov	[_VESADoubleFlag],dword 0	; assume no buffered screen
	xor	edx,edx				; clear edx for divide
	mov	eax,[_VESADoScreenCount]	; number of 64K blocks to do
	cmp	[_VESADoScreenCount],dword 0	; part of another block to do?
	je	_VESASetModePM3			; no, do nothing
	inc	eax				; yes, add another block in (our routine copies from the start of blocks)
_VESASetModePM3:
	mov	[_VESAScreen1Address],dword 0	; setup the actual screen bank numbers
	mov	ebx,eax				; bank number to start second screen display at
	imul	ebx,[_VESABankInc]		; multiply by the granularity
	mov	[_VESAScreen2Address],ebx	; and save it
	shl	eax,16				; * 65536 = number of bytes
	xor	ecx,ecx
	mov	cx,[_VESAXResolution]		; the x resolution
	xor	ebx,ebx
	mov	bl,[_VESABitsPerPixel]		; the bits/pixel
	inc	ebx
	shr	ebx,3				; now = number of bytes/pixel
	imul	ecx,ebx				; ecx holds size of 1 scanline
	div	ecx				; divide edx:eax with ecx (ie get how many scanlines there are per screen)
	mov	[_VESAScreen1Scanline],dword 0
	mov	[_VESAScreen2Scanline],eax	; save this vertical pixel offset
	mov	edx,eax				; put into edx for the function call
	mov	eax,$04f07			; try and set the display start to a second screen
	mov	ebx,$080			; function $080 - set display start at VBL
	xor	ecx,ecx				; horizontal pixel offset of 0
	int	$10
	cmp	ax,$04f				; success?
	jne	_VESASetModePMNoBuffer		; no, don't try for a double-buffer
	mov	eax,$04f07			; get the new screen co-ordinates
	mov	ebx,1
	int	$10
	and	ecx,$0ffff			; mask off top word
	or	ecx,ecx				; horizontal offset still 0?
	jnz	_VESASetModePMNoBuffer		; no, don't try for a double-buffer
	and	edx,$0ffff			; mask off top word
	cmp	edx,[_VESAScreen2Scanline]	; vertical offset still the same?
	jne	_VESASetModePMNoBuffer		; no, don't try for a double-buffer
	mov	[_VESADoubleFlag],dword 1	; yes, flag we're using a double buffer
_VESASetModePMNoBuffer:
	cmp	[_VESADoubleFlag],dword 0	; buffered screen?
	je	_VESASetModePMSingle		; no
	mov	esi,_VESADoScreenDoubleStart	; yes, setup the start routine
	mov	ecx,_VESADoubleScreenStartSize	; size of routine
	rep	movsb				; copy the routine into place
	jmp	_VESASetModePMGo
_VESASetModePMSingle:
	mov	esi,_VESADoScreenVblStart	; start routine for non-buffered screens
	mov	ecx,_VESASingleScreenStartSize	; size of routine
	rep	movsb				; copy it into place
_VESASetModePMGo:
	mov	esi,_VESADoScreenPModeStart	; install the LFB screen copy routine
	mov	ecx,_VESADoScreenPModeSize	; size of the routine
	mov	[_VESAOptimisedFlag],dword 0
	cmp	[_cpu_type],dword _CPU_TYPE_PENTIUM	; Pentium or better CPU?
	jb	_VESASetModePModeNoPentium	; no :(
	mov	ecx,[_VESADoScreenCount2]	; yes, divide the remaining count by 4 (we're moving 16 bytes a time not 4)
	shr	ecx,2
	mov	[_VESADoScreenCount2],ecx
	mov	esi,_VESADoScreenPModePStart	; use the optimised routine
	mov	ecx,_VESADoScreenPModePSize
	mov	[_VESAOptimisedFlag],dword 1
_VESASetModePModeNoPentium:
	rep	movsb				; copy the routine
	mov	esi,_VESADoScreenVblEndStart	; copy the routine end
	mov	ecx,_VESASingleScreenEndSize
	cmp	[_VESADoubleFlag],dword 0	; buffered screen?
	je	_VESASetModePMEnd		; no
	mov	esi,_VESADoScreenDoubleEndStart	; yes, use alternate routine
	mov	ecx,_VESADoubleScreenEndSize
_VESASetModePMEnd:
	rep	movsb				; copy final part
	cmp	[_VESATextFlag],dword 0		; report information?
	je	_VESASetModePM			; no
	mov	edx,_VESAError8			; yes
	mov	ah,9
	int	$21
_VESASetModePM:
	jmp	_VESASetModeOk
_VESASetModeNoPModeSwitching:
	mov	eax,[_VESASpare2]
	cmp	eax,0				; force bank switching?
	je	_VESASetModeSkip3		; no, set mode normally
	mov	ebx,[_VESASpare3]		; only suggest type of bank switching?
	cmp	ebx,0				; 0=no
	jne	_VESASetModeSkip3		; yes, suggest type of bank switching so try real mode
	cmp	eax,4				; no, force bank switching, force real mode use?
	jne	near _VESASetModeEnd2		; no, don't try to use real mode bank switching
_VESASetModeSkip3:
	mov	ax,$4f02			; set the mode
	mov	bx,[_VESAMode]
	int	$10
	mov	eax,[_VESAScreenSize]		; the screen size
	Malloc	eax,ebx				; allocate space for the screen
	jc	near _VESASetModeEnd2		; end if error
	mov	[_VESAMallocAddress],ebx	; save allocated address
	mov	[_VESAScreen],ebx		; and store this as the screen address
	xor	ebx,ebx				; ebx is number of whole 64K segments
_VESASetModeRM0:
	cmp	eax,65536			; 64K or more left in screen size?
	jb	_VESASetModeRM1
	inc	ebx				; another 64K block to do in _VESADoScreen
	sub	eax,65536
	jmp	_VESASetModeRM0
_VESASetModeRM1:
	mov	[_VESADoScreenCount],ebx
	xor	ebx,ebx
	cmp	eax,0				; any of the screen left to do?
	je	_VESASetModeRM2			; no, only whole 64K blocks
	mov	ebx,eax				; yes, get number of bytes over to do
	shr	ebx,2				; divide by 4 (we copy dwords)
_VESASetModeRM2:
	mov	[_VESADoScreenCount2],ebx
	mov	[_VESABankFlag],dword 4		; 4=real-mode bank switching :(
	mov	[_VESASpare],dword 4		; 4=real-mode bank switching :(
	mov	edi,_VESADoScreen		; now setup the actual screen copying routine
	mov	[_VESADoubleFlag],dword 0	; assume no buffered screen
	xor	edx,edx				; clear edx for divide
	mov	eax,[_VESADoScreenCount]	; number of 64K blocks to do
	cmp	[_VESADoScreenCount],dword 0	; part of another block to do?
	je	_VESASetModeRM3			; no, do nothing
	inc	eax				; yes, add another block in (our routine copies from the start of blocks)
_VESASetModeRM3:
	mov	[_VESAScreen1Address],dword 0	; setup the actual screen bank numbers
	mov	ebx,eax				; bank number to start second screen display at
	imul	ebx,[_VESABankInc]		; multiply by the granularity
	mov	[_VESAScreen2Address],ebx	; and save it
	shl	eax,16				; * 65536 = number of bytes
	xor	ecx,ecx
	mov	cx,[_VESAXResolution]		; the x resolution
	xor	ebx,ebx
	mov	bl,[_VESABitsPerPixel]		; the bits/pixel
	inc	ebx
	shr	ebx,3				; now = number of bytes/pixel
	imul	ecx,ebx				; ecx holds size of 1 scanline
	div	ecx				; divide edx:eax with ecx (ie get how many scanlines there are per screen)
	mov	[_VESAScreen1Scanline],dword 0
	mov	[_VESAScreen2Scanline],eax	; save this vertical pixel offset
	mov	edx,eax				; put into edx for the function call
	mov	eax,$04f07			; try and set the display start to a second screen
	mov	ebx,$080			; function $080 - set display start at VBL
	xor	ecx,ecx				; horizontal pixel offset of 0
	int	$10
	cmp	ax,$04f				; success?
	jne	_VESASetModeRMNoBuffer		; no, don't try for a double-buffer
	mov	eax,$04f07			; get the new screen co-ordinates
	mov	ebx,1
	int	$10
	and	ecx,$0ffff			; mask off top word
	or	ecx,ecx				; horizontal offset still 0?
	jnz	_VESASetModeRMNoBuffer		; no, don't try for a double-buffer
	and	edx,$0ffff			; mask off top word
	cmp	edx,[_VESAScreen2Scanline]	; vertical offset still the same?
	jne	_VESASetModeRMNoBuffer		; no, don't try for a double-buffer
	mov	[_VESADoubleFlag],dword 1	; yes, flag we're using a double buffer
_VESASetModeRMNoBuffer:
	cmp	[_VESADoubleFlag],dword 0	; buffered screen?
	je	_VESASetModeRMSingle		; no
	mov	esi,_VESADoScreenDoubleStart	; yes, setup the start routine
	mov	ecx,_VESADoubleScreenStartSize	; size of routine
	rep	movsb				; copy the routine into place
	jmp	_VESASetModeRMGo
_VESASetModeRMSingle:
	mov	esi,_VESADoScreenVblStart	; start routine for non-buffered screens
	mov	ecx,_VESASingleScreenStartSize	; size of routine
	rep	movsb				; copy it into place
_VESASetModeRMGo:
	mov	esi,_VESADoScreenRealModeStart	; install the LFB screen copy routine
	mov	ecx,_VESADoScreenRealModeSize	; size of the routine
	mov	[_VESAOptimisedFlag],dword 0
	cmp	[_cpu_type],dword _CPU_TYPE_PENTIUM	; Pentium or better CPU?
	jb	_VESASetModeRMNoPentium		; no :(
	mov	ecx,[_VESADoScreenCount2]	; yes, divide the remaining count by 4 (we're moving 16 bytes a time not 4)
	shr	ecx,2
	mov	[_VESADoScreenCount2],ecx
	mov	esi,_VESADoScreenRealModePStart	; use the optimised routine
	mov	ecx,_VESADoScreenRealModePSize
	mov	[_VESAOptimisedFlag],dword 1
_VESASetModeRMNoPentium:
	rep	movsb				; copy the routine
	mov	esi,_VESADoScreenVblEndStart	; copy the routine end
	mov	ecx,_VESASingleScreenEndSize
	cmp	[_VESADoubleFlag],dword 0	; buffered screen?
	je	_VESASetModeRMEnd		; no
	mov	esi,_VESADoScreenDoubleEndStart	; yes, use alternate routine
	mov	ecx,_VESADoubleScreenEndSize
_VESASetModeRMEnd:
	rep	movsb				; copy final part
	cmp	[_VESATextFlag],dword 0		; report information?
	je	_VESASetModeOk			; no
	mov	edx,_VESAError9			; yes
	mov	ah,9
	int	$21
_VESASetModeOk:
	inc	dword [_VESAFlag]		; flag we've set a mode
_VESASetModeEnd2:
	mov	ax,$101				; free allocated DOS memory
	mov	dx,[_VESASelector]
	int	$31
_VESASetModeEnd:
	mov	eax,[_VESASpare]		; the function result
	or	eax,eax				; is it zero?
	jz	_VESASetModeError		; yes, function failed
	clc					; no, flag success
	jmp	_VESASetModeEnd3
_VESASetModeError:
	stc					; flag error
_VESASetModeEnd3:
	pop	edi				; restore registers
	pop	esi
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Gets the current display position
;
%ifdef _VESAGETDISPLAYSTART_MACRO
_VESAGetDisplayStart_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	xor	ecx,ecx
	xor	edx,edx
	mov	eax,$4f07			; function 7 - get/set display start
	mov	ebx,1				; subfunction 1 - get display start
	int	$10
	cmp	ax,$04f				; success?
	jne	_VESAGetDisplayStartError
	mov	[_VESASpare],ecx
	mov	[_VESASpare2],edx
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_VESAGetDisplayStartError:
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Sets the display start to the horizontal and vertical offset specified.
;
%ifdef _VESASETDISPLAYSTART_MACRO
_VESASetDisplayStart_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	mov	ecx,[esp + 24]
	mov	edx,[esp + 20]
	mov	eax,$4f07			; function 7 - get/set display start
	xor	ebx,ebx				; subfunction 0 - set display start
	int	$10
	cmp	ax,$04f				; success?
	jne	_VESASetDisplayStartError
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_VESASetDisplayStartError:
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Sets the display start to the horizontal and vertical offset specified.
;
%ifdef _VESASETDISPLAYSTARTVBL_MACRO
_VESASetDisplayStartVbl_2:
	push	eax				; save registers
	push	ebx
	push	ecx
	push	edx
	mov	ecx,[esp + 24]
	mov	edx,[esp + 20]
	mov	eax,$4f07			; function 7 - get/set display start
	mov	ebx,$080			; subfunction $80 - set display start at vbl
	int	$10
	cmp	ax,$04f				; success?
	jne	_VESASetDisplayStartVblError
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	clc					; flag success
	ret
_VESASetDisplayStartVblError:
	pop	edx				; restore registers
	pop	ecx
	pop	ebx
	pop	eax
	stc					; flag error
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Sets a new 256 color palette.
;
%ifdef _VESASETPALETTE256_MACRO
_VESASetPalette256_2:
	push	eax				; save registers
	push	ecx
	push	edx
	push	esi
	mov	esi,[esp + 20]			; get address of new palette
	mov	edx,$03c8			; set DAC to write mode and palette index to zero
	xor	eax,eax
	out	dx,al
	inc	edx
	cld					; set direction flag
	mov	ecx,768				; 768 bytes to output
	rep	outsb				; output bytes
	pop	esi				; restore registers
	pop	edx
	pop	ecx
	pop	eax
	clc					; flag success
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Saves the current 256 color palette.
;
%ifdef _VESASAVEPALETTE256_MACRO
_VESASavePalette256_2:
	push	eax				; save registers
	push	ecx
	push	edx
	push	edi
	mov	edi,[esp + 20]			; get address to save palette to
	mov	edx,$03c7			; set DAC to read mode and palette index to zero
	xor	eax,eax
	out	dx,al
	inc	edx
	cld					; set direction flag
	mov	ecx,768
	rep	insb
	pop	edi				; restore registers
	pop	edx
	pop	ecx
	pop	eax
	clc					; flag success
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; Waits for the vertical blank
;
%ifdef _VESAWAITVBL_MACRO
_VESAWaitVBL_2:
	push	eax				; save registers
	push	edx
	mov     dx,$3da				; wait for the vbl
_VESAWaitVBL1:
	in	al,dx
	test	al,8
	jnz	_VESAWaitVBL1
	mov	dx,$3da
_VESAWaitVBL2:
	in	al,dx
	test	al,8
	jz	_VESAWaitVBL2
	pop	edx				; restore registers
	pop	ecx
	ret
%endif
;
;------------------------------------------------------------------------------------
;
; copies the buffer _VESAScreen to the actual screen
; expects es=ds
;
%ifdef _VESASETMODE_MACRO
	times ($$-$) & 31 nop			; alignment
_VESADoScreen:
	times	_MYVESAROUTSIZE	db 0		; space for the actual routine
	ret
;
; LFB and hardware double buffer screen swapping routine
;
;
_VESADoScreenHardwareDoubleStart:
	mov     edx,$3da			; wait for the vbl
_VESADoScreenHardwareDoubleVbl1:
	in	al,dx
	test	al,8
	jnz	_VESADoScreenHardwareDoubleVbl1
	mov	edx,$3da
_VESADoScreenHardwareDoubleVbl2:
	in	al,dx
	test	al,8
	jz	_VESADoScreenHardwareDoubleVbl2
	mov	esi,[_VESAScreen]
	mov	edx,[_VESAScreen1Address]
	mov	eax,[_VESAScreen2Address]
	not	dword [_VESAScreenFlag]		; displaying the other screen
	mov	[_VESAScreen2Address],edx
	mov	[_VESAScreen1Address],eax
	mov	[_VESAScreen],eax		; draw onto screen 2
	mov	edx,[_VESAScreen1Scanline]
	mov	eax,[_VESAScreen2Scanline]
	mov	[_VESAScreen2Scanline],edx	; display screen 1
	mov	[_VESAScreen1Scanline],eax
	mov	eax,$04f07			; VBE get/set display start function
	xor	ebx,ebx				; function 0 - set display start
	xor	ecx,ecx				; horizontal pixel offset of 0
	int	$10
	ret
_VESADoScreenHardwareDoubleEnd:
;
; Standard routine start - wait for the VBL
;
_VESADoScreenVblStart:
	xor	edi,edi				; linear offset of 0
	mov     dx,$3da				; wait for the vbl
_VESADoScreenVbl1:
	in	al,dx
	test	al,8
	jnz	_VESADoScreenVbl1
	mov	dx,$3da
_VESADoScreenVbl2:
	in	al,dx
	test	al,8
	jz	_VESADoScreenVbl2
	mov	esi,[_VESAScreen]
	xor	edx,edx				; bank 0 to start with
_VESADoScreenVblStartEnd:
;
; Standard routine end - just exit here
;
_VESADoScreenVblEndStart:
	ret
_VESADoScreenVblEndEnd:
;
; Non-LFB and hardware double buffer screen swapping routine start
;
_VESADoScreenDoubleStart:
	mov	edi,[_VESAScreen1Address]	; get the start address for the current screen 1
	mov	eax,[_VESAScreen2Address]	; swap the two 
	mov	[_VESAScreen2Address],edi
	mov	edx,edi				; if it's not an LFB mode then it's the bank number to start with
	mov	[_VESAScreen1Address],eax
	mov	esi,[_VESAScreen]
_VESADoScreenDoubleStartEnd:
;
; Non-LFB and hardware double buffer screen swapping routine end
;
_VESADoScreenDoubleEndStart:
	mov     dx,$3da				; wait for the vbl
_VESADoScreenDoubleVbl1:
	in	al,dx
	test	al,8
	jnz	_VESADoScreenDoubleVbl1
	mov	dx,$3da
_VESADoScreenDoubleVbl2:
	in	al,dx
	test	al,8
	jz	_VESADoScreenDoubleVbl2
	mov	esi,[_VESAScreen]
	xor	edx,edx				; bank 0 to start with
	mov	edx,[_VESAScreen1Scanline]	; get the starting scanline for displaying screen 1
	mov	eax,[_VESAScreen2Scanline]	; swap the two starting scanlines around
	mov	[_VESAScreen2Scanline],edx
	mov	[_VESAScreen1Scanline],eax
	mov	eax,$04f07			; VBE get/set display start function
	xor	ebx,ebx				; function 0 - set display start
	xor	ecx,ecx				; horizontal pixel offset of 0
	int	$10
	ret
_VESADoScreenDoubleEndEnd:
;
; Linear framebuffer copy routine
;
_VESADoScreenLFBStart:
	add	edi,[_VESALFBAddress]		; edi -> the linear framebuffer
	mov	ecx,[_VESAScreenSize]		; ecx holds the screen size (in dwords)
	rep	movsd				; copy our buffer to the actual screen
_VESADoScreenLFBEnd:
;
; Pentium optimized version of the above
;
_VESADoScreenLFBPStart:
	add	edi,[_VESALFBAddress]		; edi -> the linear framebuffer
	mov	ecx,[_VESAScreenSize]		; ecx holds the screen size divided by 16 (we're moving 16 bytes/loop)
_VESADoScreenLFBP_loop:
	fild	qword [esi]
	fild	qword [esi+8]
	fxch
	fistp	qword [edi]
	fistp	qword [edi+8]
	add	esi,16
	add	edi,16
	dec	ecx
	jnz	_VESADoScreenLFBP_loop
_VESADoScreenLFBPEnd:
;
; Protected mode bank switching copy routine - thanx to Michael Tippach for
; correcting my incompetence.
;
_VESADoScreenPModeStart:
	mov	eax,dword $4f05			; set bank function
	mov	ebx,[_VESAWinCall]		; window to select
	mov	ecx,[_VESADoScreenCount]	; number of 64K blocks to do
_VESADoScreenPModeLoop:
	push	ecx				; save the count
	push	eax				; save only the registers that we need
	push	ebx				; (calling the pmode set bank function
	push	edx				; can trash all general purpose
	push	esi				; registers)
	call	[_VSMI_WinFuncPtr]		; call the pmode set bank function
	pop	esi				; restore the ones we saved
	pop	edx
	pop	ebx
	pop	eax
	mov	edi,[_VESAWinSegment]		; offset of segment
	mov	ecx,16384			; 64K to copy
	rep	movsd				; copy block to actual screen
	add	edx,[_VESABankInc]		; onto next bank
	pop	ecx				; restore the count
	dec	ecx				; loop for all 64K blocks to do
	jnz	_VESADoScreenPModeLoop
	mov	ecx,[_VESADoScreenCount2]	; any more dwords to do?
	cmp	ecx,0
	je	_VESADoScreenPModeEnd		; 0=no
	push	esi				; only bothered about esi and the
	push	ecx				; count so only save them
	call	[_VSMI_WinFuncPtr]		; set the last bank
	pop	ecx				; restore registers
	pop	esi
	mov	edi,[_VESAWinSegment]		; offset of segment
	rep	movsd				; copy remaining dwords
_VESADoScreenPModeEnd:
;
; Pentium optimized version of the above
;
_VESADoScreenPModePStart:
	mov	eax,dword $4f05			; set bank function
	mov	ebx,[_VESAWinCall]		; window to select
	mov	ecx,[_VESADoScreenCount]	; number of 64K blocks to do
_VESADoScreenPModePLoop:
	push	ecx				; save the count
	push	eax				; save only the registers that we need
	push	ebx				; (calling the pmode set bank function
	push	edx				; can trash all general purpose
	push	esi				; registers)
	call	[_VSMI_WinFuncPtr]		; call the pmode set bank function
	pop	esi				; restore the ones we saved
	pop	edx
	pop	ebx
	pop	eax
	mov	edi,[_VESAWinSegment]		; offset of segment
	mov	ecx,4096			; 64K to copy
_VESADoScreenPModeP_loop:
	fild	qword [esi]
	fild	qword [esi+8]
	fxch
	fistp	qword [edi]
	fistp	qword [edi+8]
	add	esi,16
	add	edi,16
	dec	ecx
	jnz	_VESADoScreenPModeP_loop
	add	edx,[_VESABankInc]		; onto next bank
	pop	ecx				; restore the count
	dec	ecx				; loop for all 64K blocks to do
	jnz	_VESADoScreenPModePLoop
	mov	ecx,[_VESADoScreenCount2]	; any more dwords to do?
	cmp	ecx,0
	je	_VESADoScreenPModePEnd		; 0=no
	push	esi				; only bothered about esi and the
	push	ecx				; count so only save them
	call	[_VSMI_WinFuncPtr]		; set the last bank
	pop	ecx				; restore registers
	pop	esi
	mov	edi,[_VESAWinSegment]		; offset of segment
_VESADoScreenPModeP_loop2:
	fild	qword [esi]
	fild	qword [esi+8]
	fxch
	fistp	qword [edi]
	fistp	qword [edi+8]
	add	esi,16
	add	edi,16
	dec	ecx
	jnz	_VESADoScreenPModeP_loop2
_VESADoScreenPModePEnd:
;
; Real mode bank switching copy routine, speed improvement by Michael Tippach
;
_VESADoScreenRealModeStart:
	mov	ebx,[_VESAWinCall]		; window to select
	mov	ecx,[_VESADoScreenCount]	; number of 64K blocks to do
_VESADoScreenRealModeLoop:
	push	ecx				; save the count
	mov	eax,$4f05			; set bank function
	int	$10
	mov	edi,[_VESAWinSegment]		; offset of segment
	mov	ecx,16384			; 64K to copy
	rep	movsd				; copy block to actual screen
	add	edx,[_VESABankInc]		; onto next bank
	pop	ecx				; restore the count
	dec	ecx				; loop for all 64K blocks to do
	jnz	_VESADoScreenRealModeLoop
	mov	ecx,[_VESADoScreenCount2]	; any more dwords to do?
	cmp	ecx,0
	je	_VESADoScreenRealModeEnd	; 0=no
	push	ecx
	mov	eax,$4f05			; set final bank
	int	$10
	mov	edi,[_VESAWinSegment]		; offset of segment
	pop	ecx
	rep	movsd				; copy remaining dwords
_VESADoScreenRealModeEnd:
;
; Pentium optimized version of the above
;
_VESADoScreenRealModePStart:
	mov	ebx,[_VESAWinCall]		; window to select
	mov	ecx,[_VESADoScreenCount]	; number of 64K blocks to do
_VESADoScreenRealModePLoop:
	push	ecx				; save the count
	mov	eax,$4f05			; set bank function
	int	$10
	mov	edi,[_VESAWinSegment]		; offset of segment
	mov	ecx,4096			; 64K to copy
_VESADoScreenRealModeP_loop:
	fild	qword [esi]
	fild	qword [esi+8]
	fxch
	fistp	qword [edi]
	fistp	qword [edi+8]
	add	esi,16
	add	edi,16
	dec	ecx
	jnz	_VESADoScreenRealModeP_loop
	add	edx,[_VESABankInc]		; onto next bank
	pop	ecx				; restore the count
	dec	ecx				; loop for all 64K blocks to do
	jnz	_VESADoScreenRealModePLoop
	mov	ecx,[_VESADoScreenCount2]	; any more dwords to do?
	cmp	ecx,0
	je	_VESADoScreenRealModePEnd	; 0=no
	push	ecx
	mov	eax,$4f05			; set final bank
	int	$10
	mov	edi,[_VESAWinSegment]		; offset of segment
	pop	ecx
_VESADoScreenRealModeP_loop2:
	fild	qword [esi]
	fild	qword [esi+8]
	fxch
	fistp	qword [edi]
	fistp	qword [edi+8]
	add	esi,16
	add	edi,16
	dec	ecx
	jnz	_VESADoScreenRealModeP_loop2
_VESADoScreenRealModePEnd:
;
; Equates for the routine sizes
;
_VESAHardwareDoubleSize		equ _VESADoScreenHardwareDoubleEnd - _VESADoScreenHardwareDoubleStart
_VESASingleScreenStartSize	equ _VESADoScreenVblStartEnd - _VESADoScreenVblStart
_VESASingleScreenEndSize	equ _VESADoScreenVblEndEnd - _VESADoScreenVblEndStart
_VESADoubleScreenStartSize	equ _VESADoScreenDoubleStartEnd - _VESADoScreenDoubleStart
_VESADoubleScreenEndSize	equ _VESADoScreenDoubleEndEnd - _VESADoScreenDoubleEndStart
_VESADoScreenLFBSize		equ _VESADoScreenLFBEnd - _VESADoScreenLFBStart
_VESADoScreenLFBPSize		equ _VESADoScreenLFBPEnd - _VESADoScreenLFBPStart
_VESADoScreenPModeSize		equ _VESADoScreenPModeEnd - _VESADoScreenPModeStart
_VESADoScreenPModePSize		equ _VESADoScreenPModePEnd - _VESADoScreenPModePStart
_VESADoScreenRealModeSize	equ _VESADoScreenRealModeEnd - _VESADoScreenRealModeStart
_VESADoScreenRealModePSize	equ _VESADoScreenRealModePEnd - _VESADoScreenRealModePStart
;
%endif

%endif
