/*

DUMPW4.C	Windows95 W4 file dumper
Clive Turvey, Electronics Engineer, March 1995
Copyright (C) Tenth Planet Software Intl., Clive Turvey 1995. All rights reserved.

Compiled using Microsoft C/C++ v8.00 (Visual C/C++ v1.00)

******************************************************************************

 ====     ===
  \\      / th
   \\    /
    \\  /  Planet
     \\/    Software
     /\\     International
    /  \\
   /    \\
  /      \\
 ===     ====

     Copyright (C) Tenth Planet Software Intl., C Turvey 1995.
                       Chicago & Southampton.

                     CompuServe ID 74011,1732
                 Email : 74011.1732@compuserve.com

******************************************************************************

 Certain portions of this code and its algorithms remain the intellectual
 property of Clive Turvey, who retains the right to use and/or modify them
 at his discretion in projects for other clients.

******************************************************************************

Here is a description of the W4 header (hex image) that Andrew Schulman sent
me, 0x12000 is arrived at from the new executable pointer in the DOS EXE
(The loader of the W4 file).

Offset  Content
0x12000   ASCII W       (Checked by loader)
0x12001   ASCII 4
0x12002   WORD 0x0400   (Windows version)
0x12004   WORD 0x2000   (Chunk size of 8K, Checked by loader, must be 8K)
0x12006   WORD 0x00E9   (Number of Chunks, Checked by loader must be less than 1K)
0x12008   ASCII D       (Compression Type - DoubleSpace)
0x12009   ASCII S
0x1200A   0x00          ?
0x1200B   0x00          ?
0x1200C   0x00          ?
0x1200D   0x00          ?
0x1200E   0x00          ?
0x1200F   0x00          ?
0x12010   DWORD 0x123B4 File Offset to Start of Chunk 0x000
0x12014  .. 0xE7        Chunk Entries ..
0x123B0   DWORD 0xB49C2 File Offset to Start of Chunk 0x0E8
0x123B4   0x5E ....     Compressed Data for Chunk 0x000
0xB49C2 ....            Compressed Data for Chunk 0x0E8

The data is compressed using a Lempel Ziv algorithm with data encoded as
raw bytes or as a depth & count into a sliding history buffer. The following
table was derived from the Microsoft loader code in the DOS portion of
VMM32.VXD. It uses the same algorithm as DoubleSpace/DriveSpace. Software
to create W3 files and convert them between W3 and W4 is provided by Microsoft
in the Win95 DDK, the program is called DEVLIB. If you don't have Win95 you
could examine DBLSPACE.BIN or DRVSPACE.BIN. The Microsoft algorithm is
complicated because they have unfolded all the bit boundary loop, so it has
about eight times as much code to plough through. I have made no attempt to
optimize my algorithm, it would be a pointless exercise, and would not serve
my attempt to document it clearly. All the compressed chunks are stored in
a contiguous manner, with the last chunk being delimited by the end of the
file. It should be noted that DEVLIB strips the extranious resource junk
from the end of the VxD (LE) files it adds to the W3 library.


Shannon-Fano Tables for W4

Data encoded as Raw or Depth followed by Count

MSB...............LSB

            xxxxxxx01    Raw 1xxxxxxx, No Depth or Count
            xxxxxxx10    Raw 0xxxxxxx, No Depth or Count

                        Depth

             00000000    Quit
             xxxxxx00          x   (0..63)
             11111100    63
          00000000011    64
          xxxxxxxx011    64  + x  (64..319)
          11111111011    319
      000000000000111    320
      xxxxxxxxxxxx111    320 + x (320..4415)
      111111111111111    Check Buffer (Every 512 bytes)

                        Count

                    1    2
                  010    3
                  110    4
                00100    5
                01100    6
                10100    7
                11100    8
              0001000    9
              0011000    10
              0101000    11
              0111000    12
              1001000    13
              1011000    14
              1101000    15
              1111000    16
            000010000    17
            xxxx10000    17  + x  (17..32)
            111110000    32
          00000100000    33
          xxxxx100000    33  + x  (33..64)
          11111100000    64
        0000001000000    65
        xxxxxx1000000    65  + x  (65..128)
        1111111000000    128
      000000010000000    129
      xxxxxxx10000000    129 + x (129..256)
      111111110000000    256
    00000000100000000    257
    xxxxxxxx100000000    257 + x (257..512)
    11111111100000000    512
            000000000    Quit


*/

#include	<stdio.h>
#include	<string.h>
#include	<malloc.h>

//#define DEBUG

typedef unsigned short WORD;
typedef unsigned char BYTE;
typedef unsigned long DWORD;

WORD decompress(BYTE *, BYTE *, WORD);
void exit(WORD);

void main(WORD,BYTE **);

#define EMAGIC					0x5A4D					// Old magic number
#define W3MAGIC					0x3357
#define W4MAGIC					0x3457

struct exe_hdr													// DOS 1, 2, 3 .EXE header
{
	WORD	e_magic;				// Magic number
	WORD	e_cblp;					// Bytes on last page of file
	WORD	e_cp;						// Pages in file
	WORD	e_crlc;					// Relocations
	WORD	e_cparhdr;			// Size of header in paragraphs
	WORD	e_minalloc;			// Minimum extra paragraphs needed
	WORD	e_maxalloc;			// Maximum extra paragraphs needed
	WORD	e_ss;						// Initial (relative) SS value
	WORD	e_sp;						// Initial SP value
	WORD	e_csum;					// Checksum
	WORD	e_ip;						// Initial IP value
	WORD	e_cs;						// Initial (relative) CS value
	WORD	e_lfarlc;				// File address of relocation table
	WORD	e_ovno;					// Overlay number
	WORD	e_res[4];				// Reserved words
	WORD	e_oemid;				// OEM identifier (for e_oeminfo)
	WORD	e_oeminfo;			// OEM information; e_oemid specific
	WORD	e_res2[10];			// Reserved words
	DWORD	e_lfanew;				// File address of new exe header
} exeheader;

struct w4_hdr
{
	WORD	w4_magic;
	WORD	w4_version;
	WORD	w4_chunk_size;
	WORD	w4_chunk_count;
	WORD	w4_ds;
	WORD	w4_unknown[3];
} w4header;

void pchar(byte)
BYTE byte;
{
	if ((byte > 31) && (byte < 127))
		putchar(byte);
	else
		putchar('.');
}

void dumpdata(len,buf,off)
DWORD len;
BYTE *buf;
DWORD off;
{
	DWORD i;

	while(len)
	{
		printf(" %08lX: ",off);

		for(i=0; i<16; i++)
		{
			if (i == 8)
				printf("- ");

			if (i < len)
				printf("%02X ",buf[i]);
			else
				printf("   ");
		}

		putchar(' ');

		for(i=0; i<16; i++)
			if (i < len)
				pchar(buf[i]);

		putchar('\n');

		if (len > 16)
			len -= 16;
		else
			len = 0;

		buf += 16;
		off += 16;
	}
}

// The following is an ugly, but functional implementation of Microsoft's
// decompression algorithm used for W4 multiple VXD files.

WORD decompress(source,dest,size)
BYTE *source, *dest;
WORD size;
{
	WORD i, j, k, bitsused, bitsleft, count, depth;
	DWORD shiftreg;

	i = 0;

	shiftreg = 0;

	for(j=0; j<4; j++)
		shiftreg = (shiftreg >> 8l) + ((DWORD)*source++ << 24l);

	bitsleft = 8;

	depth = 1;

	while(depth)
	{
#ifdef DEBUG
		printf("%04X %02X:%08lX ",i,bitsleft,shiftreg);
#endif

		if (((shiftreg & 0x0003l) == 0x0001l) ||	// xxxxxxx01, Raw 1xxxxxxx, No Depth or Count
				((shiftreg & 0x0003l) == 0x0002l))		// xxxxxxx10, Raw 0xxxxxxx, No Depth or Count
		{
			if (--size == 0xFFFF) // Violation of Buffer
				return(1);

			dest[i] = (BYTE)(((shiftreg & 0x01FCl) >> 2l) | ((shiftreg & 0x0001l) << 7l));

#ifdef DEBUG
			printf("%02X ",dest[i]);

			pchar(dest[i]);

			printf("       ");
#endif

			i++;

			bitsused = 9;
		}
		else // Cooked
		{
			while(1) // Depth
			{
				if ((shiftreg & 0x0003l) == 0x0000l)	// xxxxxx00, x (0..63)
				{
					depth = (WORD)((shiftreg & 0x00FCl) >> 2);
					bitsused = 8;
					break;
				}

				if ((shiftreg & 0x0007l) == 0x0003l)	// xxxxxxxx011, 64 + x (64..319)
				{
					depth = (WORD)((shiftreg & 0x07F8l) >> 3) + 0x0040;
					bitsused = 11;
					break;
				}

				if ((shiftreg & 0x0007l) == 0x0007l)	// xxxxxxxxxxxx111, 320 + x (320..4415)
				{
					depth = (WORD)((shiftreg & 0x7FF8l) >> 3l) + 0x0140;
					bitsused = 15;
					break;
				}

				puts("Illegal Data");
				return(1);
			}

			if ((depth != 0x0000) &&	// 00000000 Quit
					(depth != 0x113F))		// 111111111111111 Check Buffer (Every 512 bytes)
			{
#ifdef DEBUG
				printf("Depth %4d ",depth);
#endif

				while(bitsused--) // skip used bits
				{
#ifdef DEBUG
					printf("%d",(WORD)(shiftreg & 1));
#endif

					shiftreg >>= 1;
					if (--bitsleft == 0)
					{
						shiftreg += (DWORD)*source++ << 24l;
						bitsleft = 8;
					}
				}

#ifdef DEBUG
				printf("\n                 ");
#endif

				while(1) // Count
				{
					if ((shiftreg & 0x00001l) == 0x00001l)	// 1, 2
					{
						count = 2;
						bitsused = 1;
						break;
					}

					if ((shiftreg & 0x00003l) == 0x00002l)	// x10, 3 + x (3..4)
					{
						count = (WORD)((shiftreg & 0x00004l) >> 2l) + 3;
						bitsused = 3;
						break;
					}

					if ((shiftreg & 0x00007l) == 0x00004l)	// xx100, 5 + x (5..8)
					{
						count = (WORD)((shiftreg & 0x0018) >> 3l) + 5;
						bitsused = 5;
						break;
					}

					if ((shiftreg & 0x0000Fl) == 0x00008l)	// xxx1000, 9 + x (9..16)
					{
						count = (WORD)((shiftreg & 0x00070l) >> 4l) + 9;
						bitsused = 7;
						break;
					}

					if ((shiftreg & 0x0001Fl) == 0x00010l)	// xxxx10000, 17 + x (17..32)
					{
						count = (WORD)((shiftreg & 0x001E0l) >> 5l) + 17;
						bitsused = 9;
						break;
					}

					if ((shiftreg & 0x0003Fl) == 0x00020l)	// xxxxx100000, 33 + x (33..64)
					{
						count = (WORD)((shiftreg & 0x007C0l) >> 6l) + 33;
						bitsused = 11;
						break;
					}

					if ((shiftreg & 0x0007Fl) == 0x00040l)	// xxxxxx1000000, 65 + x (65..128)
					{
						count = (WORD)((shiftreg & 0x01F80l) >> 7l) + 65;
						bitsused = 13;
						break;
					}

					if ((shiftreg & 0x000FFl) == 0x00080l)	// xxxxxxx10000000, 129 + x (129..256)
					{
						count = (WORD)((shiftreg & 0x07F00l) >> 8l) + 129;
						bitsused = 15;
						break;
					}

					if ((shiftreg & 0x001FFl) == 0x00100l)	// xxxxxxxx100000000, 257 + x (257..512)
					{
						count = (WORD)((shiftreg & 0x1FE00l) >> 9l) + 257;
						bitsused = 17;
						break;
					}

					depth = 0; // 000000000, Quit Condition
					count = 0;
					bitsused = 9;
					break; // Ugly Data
				}

#ifdef DEBUG
				printf("Count %4d ",count);
#endif

				k = count;

				while(k--)
				{
					if (--size == 0xFFFF) // Violation of Buffer
						return(1);

					dest[i] = dest[i-depth];
					i++;
				}
			}
			else
			{
#ifdef DEBUG
				if (depth == 0x0000)
					printf("Quit       ");	// No More data to decompress
				else
					printf("Chk Buffer ");	// At 512 byte sector boundary
#endif

				if ((depth == 0x113F) && // Check Buffer
						(size == 0x0000))
					depth = 0; // Quit Condition
			}
		}

		while(bitsused--) // skip used bits
		{
#ifdef DEBUG
			printf("%d",(WORD)(shiftreg & 1));
#endif

			shiftreg >>= 1;
			if (--bitsleft == 0)
			{
				shiftreg += (DWORD)*source++ << 24l;
				bitsleft = 8;
			}
		}

#ifdef DEBUG
		putchar('\n');
#endif
	}

	return(size); // Should be zero
}

void main(argc,argv)
WORD argc;
BYTE *argv[];
{
	BYTE w4file[128];
	BYTE *source, *dest, *ptr;
	WORD size, chunk;
	DWORD i, start, finish, newexeoffset, offset;
	DWORD *chunk_table;
	FILE *fwfour;

	printf("\nDumpW4 v0.24 (c) Copyright Tenth Planet Software Intl., C Turvey 1995-1996.\n"
						"\t\t\t   All rights reserved. Non-Commercial use only.\n\n");

	if (argc < 2)
	{
		puts(	" ====     ===\t\t\tThis FREEWARE product was written by Clive\n"
					"  \\\\      / th\t\t\tTurvey, an English Electronics Engineer.\n"
					"   \\\\    /");
		puts(	"    \\\\  /   Planet\t\tIt is designed to decompress Win95 W4\n"
					"     \\\\/     Software\t\tlibrary files created by DEVLIB.\n"
					"     /\\\\      International");
		puts(	"    /  \\\\\t\t\tIf you like the software, or find a problem\n"
					"   /    \\\\   CIS 74011,1732\tpost some Email to 74011.1732@compuserve.com\n"
					"  /      \\\\\n"
					" ===     ====\n");

		puts("Usage : DumpW4 <Windows W4 File> [<Hex Offset within W4 File>]\n");

		exit(1);
	}

	strcpy(w4file,argv[1]);

	if (!strchr(w4file,'.')) // Yuk, this screws up .. & .
		strcat(w4file,".vxd");

	fwfour = fopen(w4file,"rb");

	if (!fwfour)
	{
		printf("Can't open file '%s'\n",w4file);
		exit(1);
	}

	if (fread(&exeheader,1,sizeof(exeheader),fwfour) != sizeof(exeheader))
	{
		printf("Unable to read .EXE header from '%s'.\n",w4file);
		fclose(fwfour);
		exit(1);
	}

	if (exeheader.e_magic != EMAGIC)
	{
		printf("'%s' not a .EXE file.\n",w4file);
		exit(1);
	}

	// Verify that the New EXE Header Address is not located in the
	// midst of the DOS relocation table or outside DOS header.

	if (((exeheader.e_lfarlc >= 0x40) ||
			((exeheader.e_lfarlc + (4 * exeheader.e_crlc)) < 0x3C)) &&
			(exeheader.e_cparhdr >= 0x04))
		newexeoffset = exeheader.e_lfanew;
	else
	{
		printf("'%s' does not appear to be a Windows W4 file.\n",w4file);
		exit(1);
	}

	fseek(fwfour,newexeoffset,0);

	/* Load W4 header, 0x10 bytes */

	if (fread(&w4header,1,sizeof(w4header),fwfour) != sizeof(w4header))
	{
		printf("Unable to read W4 header from '%s'.\n",w4file);
		fclose(fwfour);
		exit(1);
	}

	if (w4header.w4_magic == W3MAGIC) /* Check W3 signature */
	{
		printf("'%s' appears to be a Windows W3 file.\n",w4file);
		exit(1);
	}

	if (w4header.w4_magic != W4MAGIC) /* Check W4 signature */
	{
		printf("'%s' does not appear to be a Windows W4 file.\n",w4file);
		exit(1);
	}

	chunk_table = malloc(w4header.w4_chunk_count * 4);

	if(chunk_table == NULL)
	{
		printf("Insufficent chunk memory. (%ld Bytes required)\n",(w4header.w4_chunk_count * 4));
		exit(1);
	}

	source = malloc(w4header.w4_chunk_size);

	if(source == NULL)
	{
		printf("Insufficent source buffer memory. (%ld Bytes required)\n",w4header.w4_chunk_size);
		exit(1);
	}

	dest = malloc(w4header.w4_chunk_size);

	if(dest == NULL)
	{
		printf("Insufficent destination buffer memory. (%ld Bytes required)\n",w4header.w4_chunk_size);
		exit(1);
	}

	if (fread(chunk_table,4,w4header.w4_chunk_count,fwfour) != w4header.w4_chunk_count)
	{
		printf("Unable to read W4 chunk table from '%s'.\n",w4file);
		fclose(fwfour);
		exit(1);
	}

	chunk = 0;

	if (argc > 2)
	{
		sscanf(argv[2],"%lx",&offset);

		if (offset >= newexeoffset)
			chunk = (WORD)((offset - newexeoffset) / (DWORD)w4header.w4_chunk_size);
	}

	while(chunk<w4header.w4_chunk_count)
	{
		start  = chunk_table[chunk++];

		if (chunk == w4header.w4_chunk_count)
		{
			fseek(fwfour,0l,SEEK_END);

			finish = ftell(fwfour);
		}
		else
		{
			finish = chunk_table[chunk];
		}

		size = (WORD)(finish - start);

		fseek(fwfour,start,SEEK_SET);

		if (fread(source,1,size,fwfour) != size)
		{
			printf("Unable to read W4 file '%s'.\n",w4file);
			fclose(fwfour);
			exit(1);
		}

		ptr = dest;

		i = w4header.w4_chunk_size;

		while(i--)
			*ptr++ = 0xE5; // Fill destination with a clear marker

		offset = newexeoffset + ((chunk - 1) * w4header.w4_chunk_size);

		if (size == w4header.w4_chunk_size)
		{
			printf("\nChunk %4d, Uncompressed\n\n",(chunk-1));

			dumpdata((DWORD)w4header.w4_chunk_size,source,offset);
		}
		else
		{
			printf("\nChunk %4d, Compressed\n\n",(chunk-1));

			if (decompress(source,dest,w4header.w4_chunk_size) != 0)
			{
				puts("Decompression Error.");
				break;
			}

			dumpdata((DWORD)w4header.w4_chunk_size,dest,offset);
		}

	}

	free(source);

	free(dest);

	fclose(fwfour);
}

