	comment %
	ASPACK 2000 patcher
	%

	.386
	.model flat,stdcall
	locals
	jumps


	MB_ICONHAND			equ	00000010h ;error
	MB_ICONEXCLAMATION		equ	00000030h ;warning
	MB_ICONASTERISK			equ	00000040h ;info
	MB_OKCANCEL			equ	00000001h ;typ msgboxa
	ID_OK				equ	1
	PAGE_READONLY			equ	2
	PAGE_READWRITE			equ	4     
	PAGE_WRITECOPY			equ	8     
	SECTION_QUERY			equ	1
	SECTION_MAP_WRITE		equ	2
	SECTION_MAP_READ		equ	4
	SECTION_MAP_EXECUTE		equ	8
	SECTION_MAP_EXTEND_SIZE		equ	10
	FILE_MAP_COPY			equ	SECTION_QUERY
	FILE_MAP_WRITE			equ	SECTION_MAP_WRITE
	FILE_MAP_READ			equ	SECTION_MAP_READ

	FILE_ATTRIBUTE_NORMAL		equ	080h
	OPEN_EXISTING			equ	3
	GENERIC_READ			equ	80000000h
	GENERIC_WRITE			equ	40000000h
	FILE_SHARE_READ			equ	0001h

	FILE_ATTRIBUTE_ARCHIVE		equ	00000020h

	callW	macro api
	extrn	api:proc
	call	api
	endm

	_junk	macro prefix
	jmp	$+4
	db	prefix
	db	NOT prefix+1
	endm

;DEBUG	equ	1
.data
	db	0
.code
_start:
	jmp	$+6
	db	'bart'

	mov	old_esp,esp
	sub	eax,eax
	push	offset _handler
	push	dword ptr fs:[eax]
	mov	fs:[eax],esp

	mov	edx,offset szIntro
	call	msg
;-file-attribs---------------------------------------------------------------------------------
	push	offset filename
	callW	GetFileAttributesA
	inc	eax
	jne	_next			; -1

	call	cannot_open
	jmp	_exit

_next:
	dec	eax
	push	eax

clearattrib:
	push	FILE_ATTRIBUTE_ARCHIVE
	push	offset filename
	callW	SetFileAttributesA

;-open-file------------------------------------------------------------------------------------
	push	0
	push	offset filebak
	push	offset filename
	callW	CopyFileA

open:
	sub	eax,eax
	push	eax
	push	FILE_ATTRIBUTE_NORMAL
	push	OPEN_EXISTING
	push	eax
	push	eax
	push	GENERIC_READ + GENERIC_WRITE
	push	offset filename
	callW	CreateFileA
	inc	eax
	jne	__next

	call	cannot_open
	jmp	_exit

__next:
	dec	eax
	push	eax			; store file handle

;-get-file-size--------------------------------------------------------------------------------
	push	0
	push	eax			; file handle
	callW	GetFileSize

;-create-file-mapping--------------------------------------------------------------------------
	push	eax
	cmp	eax,fsize		; check file size
	je	_map

	push	1
	push	offset szCapt
	push	offset szSize
	push	0
	callW	MessageBoxA
	dec	eax			; ID_OK = 1
	je	_map

	pop	eax
	jmp	_exit

_map:	pop	eax
	sub	edx,edx
	pop	ecx
	push	ecx

	push	edx
	push	eax			; lSize
	push	edx			; hSize
	push	PAGE_READWRITE		; read&write  
	push	edx                            
	push	ecx
	callW	CreateFileMappingA

	push	eax

	sub	edx,edx

	push	edx			; map entire file
	push	edx
	push	edx
	push	FILE_MAP_WRITE		; read&write access
	push	eax
	callW	MapViewOfFile
	push	eax

	xchg	eax,edx
;-patching-------------------------------------------------------------------------------------
	IFDEF	DEBUG
	int	3
	ENDIF
	lea	edi,[edx+lpAddr1]
	mov	esi,offset _jmper
	mov	ecx,_jmperlen
	rep	movsb

	lea	edi,[edx+lpAddr2]
	mov	esi,offset _patch
	mov	ecx,_patchlen
	rep	movsb

;-info-----------------------------------------------------------------------------------------
	mov	edx,offset szSuccess
	call	msg

;-close-file-----------------------------------------------------------------------------------
_close:
	callW	UnmapViewOfFile		; params already pushed
	callW	CloseHandle
;-restore-file-time-and-attribs----------------------------------------------------------------
	pop	eax
	push	eax

	push	offset creation
	push	offset lastaccess
	push	offset lastwrite
	push	eax
	callW	SetFileTime

	callW	CloseHandle

	push	offset filename
	callW	SetFileAttributesA
;-finito---------------------------------------------------------------------------------------
_exit:
	pop	dword ptr fs:[0]
	add	esp,0Ch
	jmp	_no_error
_handler:
	pop	dword ptr fs:[0]
	mov	esp,123456
old_esp	equ	dword ptr $-4

	push	MB_ICONHAND
	push	offset szCapt
	push	offset szInternal
	push	0
	callW	MessageBoxA

_no_error:
	push	-1
	callW	ExitProcess

cannot_open:
	mov	edx,offset szCannotOpen
	msg:
	sub	eax,eax
	push	eax
	push	offset szCapt
	push	edx
	push	eax
	callW	MessageBoxA
	ret

;
;	ASPACK code:
;	popad			; restore ALL regs
;	jne	@return_to_host
;	mov	eax,000001h	; this code seems to be never
;	ret	0Ch		; executed
;@return_to_host:
;	push	offset lpRealEntrypoint
;	ret
_jmper:
	mov	eax,4A7910h
	call	eax
	popad
	db	3 dup(90h)	; nop padding
_jmperlen	equ $-_jmper

_patch:
;	int 3			; for tests only

	pushad			; save all registers
	pushfd			; save all flags

	call	_delta
_delta:	pop	ebp
	sub	ebp,offset _delta

	mov	ecx,_tablen
	lea	esi,[ebp+_table]
_apply_patch:
	lodsd
	xchg	eax,edi		; edi patch offset
	lodsb			; patch byte
	stosb			; patch file
	loop	_apply_patch

	popfd
	popad

	ret

; table_entry struct
; patch_offset	dd ?
; patch_byte	db ?
; ends

_table:
	dd	4A420Ah		; nagscreen,FF FF FF FF 82 method
	db	90h

	dd	42967Dh		; sorry! nag
	db	0EBh

	dd	4296CAh		; 1 file limit
	db	0EBh

_tablen	equ ($-_table)/5	; DWORD+BYTE
_patchlen	equ $-_patch
;


_patcher_data:

szCapt		db 'bart^CrackPl ',0


szIntro		db 0Dh,0Ah
		db 'Patch for Awave Audio 6.0',0Dh,0Ah,0

szCannotOpen	db 'Cannot open file '
filename	db 'AwaveAud.exe',0
filebak		db 'AwaveAud.exe',0

szSuccess	db 'File successfully patched!',0
szInternal	db 'Internal error occured!',0
szSize		db 'Invalid file size - should be 167 936 bytes!',0dh,0ah
		db 'Patch anyway?',0

fsize		equ 167936

lpAddr1		equ 27AF1h
lpAddr2		equ 28F10h


creation	dd 0,0
lastaccess	dd 0,0
lastwrite	dd 0,0

end _start