; Patch w wersji dla masma
; uywaem
; Micro$oft Macro Assembler Version 6.13.7299
; Micro$oft Incremental Linker Version 5.12.8078
 
.386p
.model flat

MB_ICONEXCLAMATION      equ	00000030h ;warning
MB_ICONASTERISK	        equ	00000040h ;info
MB_OKCANCEL	        equ	00000001h ;typ msgboxa

OF_READ			equ	0h	;open file only for read
OF_WRITE		equ	1h	;open file only for write
OF_READWRITE		equ	2h	;open file only for read+write

FILE_BEGIN		equ	0h	;file seek from the beginning
FILE_CURRENT		equ	1h	;from the current pos
FILE_END		equ	2h	;from the end

FILE_ATTRIBUTE_ARCHIVE  equ     00000020h

includelib e:\dev\masm\lib\kernel32.lib
includelib e:\dev\masm\lib\user32.lib

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; gdy exec jest adowany do pamici system wypenia tabel importu
; adresami funkcji api, gdy w kodzie programu umiecimy co takiego
;
; call MessageBoxA
;
; linker skompiluje to do
; ...
; push	offset cos	\
; push _hWnd		/przykladowo
; call --------<<<<<<<----------------------------------
; ...							|
; ...							|
; jmp dword ptr[adres_MessageBoxA_z_tabeli_importu]    <
;
; mona natomiast zmusi linkera, aby wywoanie MessageBoxA
; byo tumaczone w kodzie programu na
;
; push _hWnd
; call dword ptr[adres_MessageBoxA_w_tabeli_importu]
;
; przez co uzyskujemy szybsze wywoywanie funkcji api
; z pominiciem call-a do jmp dword...
; aby zadeklarowa tak "szybk" funkcj naley
; przed nazw funkcji wstawi __imp__(__imp_) a po nazwie funkcji
; @suma_bajtw_parametrw_wypychanych_na_stos_przed_wywoaniem i tak np.
;
; push	MB_OK		;warto DWORD 4 bajty
; push	offset cos	;adres jakiego stringa DWORD 4 bajty
; push	offset cos	;tak samo jak wyej
; push	_hWnd		;uchwyt DWORD 4 bajty
; call	__imp__MessageBoxA@16  ;4+4+4+4=16
;
; gdy si pomylimy z liczb parametw jakiej funkcji, jaka ma by
; wypchnita(zapisana na stos,nic innego mi do gowy nie przychodzi)
; na stos, naley poszuka w plikach .LIB nazwy tej funkcji np.
; _wsprintfA, jej "szybka" deklaracja wyglda nastpujco
; __imp__wsprintfA ju bez @ dlatego e w deklaracji _wsprintfA
; nie ma okrelonej(skoczonej) liczby parametrw
;
;int wsprintf(
;
;    LPTSTR lpOut,	// pointer to buffer for output 
;    LPCTSTR lpFmt, 	// pointer to format-control string 
;    ...	// optional arguments
;   );
; takie dobrodziejstwo, mam na myli moliwo szybkiego wywoywania
; funkcji api oferuje obecnie masm i nasm, tasm nie ma tej moliwoci
; (a moe zna kto sposb, jakby co to prosze o kontakt)
; pliki zbudowane z uyciem masma maj take t zalet, e ich rozmiar
; jest o par kilo mniejszy od tych samych skompilowanych tasmem
; 
; pozdrowienia
; bartw@free.net.pl
; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
extrn	__imp__MessageBoxA@16		:dword
extrn	__imp__ExitProcess@4		:dword
extrn	__imp__CopyFileA@12		:dword
extrn	__imp__GetFileTime@16		:dword
extrn	__imp__SetFileTime@16		:dword
extrn	__imp__GetFileAttributesA@4	:dword
extrn	__imp__SetFileAttributesA@8	:dword
extrn	__imp___lopen@8			:dword
extrn	__imp___llseek@12		:dword
extrn	__imp___lread@12		:dword
extrn	__imp___lwrite@12		:dword
extrn	__imp___lclose@4		:dword
extrn	__imp__lstrlen@4		:dword
extrn	__imp__wsprintfA		:dword

.data
filename	db 'EDITPLUS.EXE',0
filebak		db 'EDITPLUS.EXE__',0
newbytes	db 90h
newlength	equ $-newbytes
oldbytes	db 82h
oldlength	equ $-oldbytes
adress1		dd 0F2D64h

buffer		db oldlength+1 dup (0)
buf2		db 20 dup(0)

sText		db 'Rtqfwev"pcog<GfkvRnwu"x3045Hkng"'
		db 'vq"rcvej<GFKVRNWU0GZGWTN<jvvr<'
		db '11yyy0gfkvrnwu0eqoPqvgu<Vjku"et'
		db 'cem"tgoqxgu"pciuetggp.cpf"vkog"'
		db 'nkokvEtcemgt<dctv',0

;sCapt		db '[bart]',0
sCapt		db '>q',0

;sError		db 'Error!',0
sError		db '_6b',0

;sWrongBytes	db 'Wrong bytes!',10,13
		db 'Patch anyway?',0
sWrongBytes	db '6͏2:k[2s1HaP~',0

sCannotOpen	db 'Cannot open file %s',0
sCannotWrite	db 'Cannot write to file %s',0

;sSuccess	db 'File successfully patched.Enjoy!',0
sSuccess	db '|ےCyΥkڐ@P8?0mP	',0

key		equ 54952287

handle		dd 0

oldattrib	dd 0

creation	dd 0,0
lastaccess	dd 0,0
lastwrite	dd 0,0

.code
_start:

mov	ecx,key
mov	eax,offset sCapt
call	decrypt

mov	ecx,key
mov	eax,offset sError
call	decrypt

mov	eax,offset sText
@@de:
inc	ecx
sub	byte ptr[eax],2
inc	eax
cmp	byte ptr[eax],0
jne	@@de

push	MB_OKCANCEL
push	offset sCapt
push	offset sText
push	0
call	__imp__MessageBoxA@16

cmp	eax,1			;OK pressed?
jne	exit			;if not OK then exit

attrib:
push	offset filename
call	__imp__GetFileAttributesA@4

cmp	eax,-1
je	cannot_open

mov	oldattrib,eax

clearattrib:
push	FILE_ATTRIBUTE_ARCHIVE
push	offset filename
call	__imp__SetFileAttributesA@8

open:
push	OF_READWRITE		;file access mode
push	offset filename		;pointer to name of file to open
call	__imp___lopen@8			;open file

cmp	eax,-1			;error HFILE_ERROR
je	cannot_open

mov	handle,eax		;file handle from eax to handle

push	offset creation
push	offset lastaccess
push	offset lastwrite
push	handle
call	__imp__GetFileTime@16

mov	eax,adress1
call	seek

read:	push	oldlength		;length, in bytes, of data buffer
	push	offset buffer		;pointer to buffer for read data
	push	handle			;handle
	call	__imp___lread@12			;read from file

	cmp	eax,-1			;error HFILE_ERROR
	je	internal

check:	mov	ecx,oldlength		;length bytes from edi(i supose ;)
	mov	esi,offset oldbytes	;source
	mov	edi,offset buffer	;dest
	repe	cmpsb
	jne	wrong_bytes

patching:
push	0
push	offset filebak
push	offset filename
call	__imp__CopyFileA@12

mov	eax,adress1
call	seek
call	write

push	offset creation
push	offset lastaccess
push	offset lastwrite
push	handle
call	__imp__SetFileTime@16

mov	ecx,key
mov	eax,offset sSuccess
call	decrypt

push	MB_ICONASTERISK
push	offset sCapt
push	offset sSuccess
push	0
call	__imp__MessageBoxA@16

close:
push	handle
call	__imp___lclose@4

resetattrib:
push	oldattrib
push	offset filename
call	__imp__SetFileAttributesA@8

exit:
push	-1
call	__imp__ExitProcess@4

internal:
push	MB_ICONEXCLAMATION
push	offset sError
push	offset sError
push	0
call	__imp__MessageBoxA@16
jmp	close

cannot_open:
push	offset filename
push	offset sCannotOpen
push	offset buf2
call	__imp__wsprintfA


push	MB_ICONEXCLAMATION
push	offset sError
push	offset buf2
push	0
call	__imp__MessageBoxA@16
jmp	 exit

wrong_bytes:
mov	ecx,key
mov	eax,offset sWrongBytes
call	decrypt

push	MB_OKCANCEL or MB_ICONEXCLAMATION
push	offset sError
push	offset sWrongBytes
push	0
call	__imp__MessageBoxA@16

cmp	eax,1
je	patching

jmp	close

cannot_write:
push	offset filename
push	offset sCannotWrite
push	offset buf2
call	__imp__wsprintfA

push	MB_ICONEXCLAMATION
push	offset sError
push	offset buf2
push	0
call	__imp__MessageBoxA@16
jmp	close

decrypt:
xor	ecx,88
rol	ecx,1

@deloop:
	xor	byte ptr[eax],cl
	ror	byte ptr[eax],cl
	inc	eax
	inc	ecx
	cmp	byte ptr[eax],0
	jne	@deloop
ret

seek:	push	FILE_BEGIN		;position to move from 
	push	eax			;offset
	push	handle			;file handle
	call	__imp___llseek@12

	cmp	eax,-1			;error HFILE_ERROR
	je	internal
ret


write:	push	newlength		;length of newbytes
	push	offset newbytes		;pointer to buffer data
	push	handle			;file handle
	call	__imp___lwrite@12			;write to file

	cmp	eax,-1
	je	cannot_write
ret

end _start