(***************************************************************************
                               IceLock, v1.0
                               ===========

                         Copyright 1996, B. Walker
                          IceBrakr@ix.netcom.com


  Well folks, here it is, IceLock v1.0.  This is the easiest way to
handle registration of your delphi applications.  Or, at least, the easiest
for me.  Oh, and legal stuff, this component is FreeWare, I make no
guarantees, or warranties of any kind, you use this at your own risk.  And
I definately do not guarantee it is secure.  I, and others, have tried to
hack programs using this, with no success...so It's probably "pretty good
protection"...nothing is perfect..

On to usage...

First, customize IceLock:

modify the following Constants:

        UserPad
        ProgPad
        MasterKey (this is an array of values for masking the record, when
                    written to a file)

** The defaults will work just fine, but, if you use the defaults, anybody
with this component can create valid keys for your applications!!. **

In the Create method modify the variable initialization for:

        fSeedVal1 { These can also be set at design time }
        fSeedVal2
        Seed { Set in the Create Method, because it's Private! }
    And any others you may wish to modify...

  This will make your copy of IceLock, ** much ** different from anybody
elses.  If you are really worried about hackers, read further into the
source, there are plenty of notes for further obfuscating the keys/files.

  Next, install this component in your component palette, it automatically
installs into the 'Samples' page.  Now, to use it, drop on your main form,
modify the properties (most particularly IceString1 and IceString2..
possibly also the KeyFileName).  And you are affectively done, for a
minimum install...call LoadKeyFile then either check the result of
LoadKeyFile, or check the IsRegistered variable to see if it's registered.

  A better example of usage is in the IceReg application, included with
this program.  This application is a fully functional database, for
tracking users/applications and keys...  Make sure that you re-build this
application, using the copy of IceLock that you have modified/installed
into delphi...otherwise, the keys created will be invalid!.

** The Most important thing to remember!!  When you create keys for users, the
** fProgKey1 and fProgKey2 must be the same when you check the key!!!  This
** is why I suggest modifying the above mentioned const/variables, and then
** specify unique IceStrings for each application, this is the easiest way to
** go...(unless you find an easier way...)

  Last bit, have fun with this...  All I ask is that you give credit where
it is due....and if you come up with cool enhancements, please send them to
me, so I can keep track of modifications, and re-release with a new version
number...  If you find a hole, that you cannot plug, let me know, again, I
can probably plug it..and re-release.



!!!  Oh, and One More TidBit!!

  I wrote a little program, that calls LoadKeyFile, and puts the registered
users name in a label...basically a very minimal program.  Then recompiled it
without the IceLock component..  Basically, just to see what how much code
IceLock creates, using the minimum of functions..  These result are with the
compiler generating NO debug/symbol info, and the linker set to link for
size and speed:

           Using Icelock:  159296
           w/out IceLock:  158352
           ----------------------
                   total:     944 bytes of code!!!!

  Pretty slim, if I do say so myself!!
****************************************************************************)

unit IceLock;

interface

uses
  Classes;

const
(** Error Constants **)
  ieOkay        = 0; { Everything Okay }
  ieInvalidKey  = 1; { Key is invalide }
  ieFileError   = 2; { Some file error occurred, check LastIoResult for }
                     { error code                                       }

(** Feel free to change these to mind fuck others, this allows an
 added level of security against other programers who have this code **)
  UserPad       = #42;
  ProgPad       = #42;

{$I CRCTAB.INC } { The CRC Lookup Table.. You're best bet is to NOT MUCK  }
                 { WITH THIS!!  If you do, it could affect the security   }
                 { of the keys..                                          }

type
  { String for holding Keys }
  KeyString   = String[9];

  { String for holding Names }
  NameString  = String[50];

  { This is the record used to store the key in a file, to further
    confound crackers, I strongly encourage you to change the order..
    maybe add a few other fields, which could be filled with random shit
    or whatever.. As long as the names of these 2 fields remain the
    same, there should be no problem with monkeying this around to your
    hearts content. }
  rIceRecord  = record
    Name : NameString;
    Key  : KeyString;
  end;

  { This is a Record and it's associated pointer, which is used to
    "encrypt/decrypt" the IceRecord, before storage in a file...
    Note that it will adjust to any changes made to rIceRecord.. }
  aIceArray = Array[1..SizeOf(rIceRecord)] of Byte;
  pIceArray = ^aIceArray;

  { Buffer for calculating CRC values }
  CRCBuffType = ARRAY[0..70] OF BYTE;

(**************************************************************************)
(***                                                                    ***)
(*** Here it is!!!  The tIceLock Component!!                            ***)
(***                                                                    ***)
(**************************************************************************)
  tIceLock = class(TComponent)
  private
(** The following fields are available for design time modification, via
    the object inspector.  Note that they are all read directly from the
    variable, but written using the appropriate Set procedure            **)

{ Ice1/Ice2, these two are character strings used to build the
  corresponding ProgKeys, which identify the program that the key belongs
  to.  These allow you to create keys for specific application.
  Note that these keys will be truncated to 70 characters.                 }
    fIce1 : string;
    fIce2 : string;

{ Created, based on Ice1/Ice2, also the user can override these values
  via the object inspector or the corresponding Properties.  This allows
  ANOTHER level of security, in that you could define them anywhere in
  your code, multiple times...etc... BUT!!!  You must make sure that they
  are the same when you generate keys for your registered users!!
  Otherwise, you'll be giving them bogus keys!!!!                         }
    fProgKey1 : LongInt;
    fProgKey2 : LongInt;

{ Another level of security, these are the seed values, used to create
  the ProgKeys, based on Ice, you can changes these also..             }
    fSeedVal1 : LongInt;
    fSeedVal2 : LongInt;


{ Kind of obvious, this hold the file name for your keys, again allows
  different key names for different applications }
    fKeyFileName : String;


(** The following Private fields/procedure, are really private!, ie: no
    direct access at all                                                 *)
    Seed       : LongInt;    { Set in Create }
    UserName   : NameString; { Set by LoadKeyFile, or PutKey }
    UserKey    : KeyString;  { Set by LoadKeyFile, or PutKey }

    { Procedures used to set Private variables }
    procedure SetIce1(s : string);
    procedure SetIce2(s : string);
    procedure SetProgKey1(l : LongInt);
    procedure SetProgKey2(l : LongInt);
    procedure SetSeedVal1(l : LongInt);
    procedure SetSeedVal2(l : LongInt);
    procedure SetKeyFileName(fn : String);

    { Procedures used internally only ! }
    procedure EncryptRecord(p : Pointer);
    function  CalcCRCBuffer(CRC_Value: LONGINT;
                            cBuffer: CRCBuffType ): LONGINT;
    function  HexLongInt(L : LongInt) : KeyString;
    procedure InitProgramKeys;
    { End Private declarations }
  protected
    { End Protected declarations }
  public
    LastIoResult  : integer; { Holds the last ioresult from save/loadkeyfile }
    IsRegistered  : boolean; { nuff said }

    { Creates a key, based on ProgKey1/ProgKey2/Name, returns KeyString }
    function BuildUserKey(Name : NameString) : KeyString;

    { Checks a Name/Key combination, returns boolean result }
    Function CheckKey(n : NameString;k : KeyString) : boolean;

    { Get's the current value of UserName or UserKey }
    function GetKey  : KeyString;
    function GetName : NameString;

    { PutKey attempts to put Name/key into Username/Userkey, returns
      result ieOkay if successful, ieInvalidKey for invalid key,
      If the key is invalid Username/Userkey are not change          }
    function PutKey(name : NameString; Key : KeyString) : integer;

    { These two functions save/load current key to the currently selected
      fKeyFileName Property..                                             }
    function SaveKeyFile : Integer;
    function LoadKeyFile : Integer;


    { The obvious create/destroy thingies....}
    constructor Create(AOwner: TComponent); override;
    { End Public declarations }
  published
    { Note: IceString1, IceString2, IceSeed1, IceSeed2 Must be alphabetically
    less that ProgramKey1 and ProgramKey2!!  Delphi sets these values, from
    information created at design time, in the Object Inspector, in Alpha Order.
    ....anytime you set any Ice value, the component re-initializes the
    Program Keys....so if they came first (alpha-wise), any changes you
    made during design time, would not stick!!  This should keep things
    properly synchronised..}

    property IceString1  : string read fIce1 write SetIce1;
    property IceString2  : string read fIce2 write SetIce2;
    property IceSeed1    : LongInt read fSeedVal1 write SetSeedVal1;
    property IceSeed2    : LongInt read fSeedVal2 write SetSeedVal2;
    property ProgramKey1 : LongInt read fProgKey1 write SetProgKey1;
    property ProgramKey2 : LongInt read fProgKey2 write SetProgKey2;
    property KeyFile     : String read fKeyFileName write SetKeyFileName;
    { End Published declarations }
  end;

procedure Register;

implementation

{==============================

   >>  procedure Register;

    >  Description : Registers the tIceLock component, on the
                     samples palette page.

 ==============================}
procedure Register;
begin
  RegisterComponents('Samples', [tIceLock]);
end;


{==============================

   >>  procedure tIceLock.SetIce1(s : string);

    >  Description : Set's value for fIce1, then re-inits the
                     program keys based on the new value.
                     Truncates passed string to 70 Characters.

 ==============================}
procedure tIceLock.SetIce1(s : string);
begin
  if length(s) < 71 then fIce1 := s
    else fIce1 := copy(s,1,50);
  InitProgramKeys;
end;

{==============================

   >>  procedure tIceLock.SetIce2(s : string);

    >  Description : See SetIce1

 ==============================}
procedure tIceLock.SetIce2(s : string);
begin
  if length(s) < 71 then fIce2 := s
    else fIce2 := copy(s,1,50);
  InitProgramKeys;
end;

{==============================

   >>  procedure tIceLock.SetProgKey1(l : LongInt);

    >  Description : This allows the programmer to set an absolute
                     value for the Program keys.  Note, if you
                     do this, you MUST make sure to create keys
                     using this ProgramKey..otherwise you'lL be
                     creating useless keys!!

                     Also, if you change either Ice or SeedVal's
                     (which call InitProgramKeys), your changes
                     will be erased!  This may be usefull to
                     confound hackers...maybe set values a few
                     times, then change an IceString....  This
                     could be very frustrating, hacking the ASM
                     code...

 ==============================}
procedure tIceLock.SetProgKey1(l : LongInt);
begin
  fProgKey1 := l;
end;


{==============================

   >>  procedure tIceLock.SetProgKey2(l : LongInt);

    >  Description : see SetProgKey1

 ==============================}
procedure tIceLock.SetProgKey2(l : LongInt);
begin
  fProgKey2 := l;
end;

{==============================

   >>  procedure tIceLock.SetSeedVal1(l : LongInt);

    >  Description : This value is used to seed the CRC creation
                     process with a unique value.. Also re-inits
                     the ProgramKeys using the new value.

 ==============================}
procedure tIceLock.SetSeedVal1(l : LongInt);
begin
  fSeedVal1 := l;
  InitProgramKeys;
end;

{==============================

   >>  procedure tIceLock.SetSeedVal2(l : LongInt);

    >  Description : see SetSeedVal1

 ==============================}
procedure tIceLock.SetSeedVal2(l : LongInt);
begin
  fSeedVal2 := l;
  InitProgramKeys;
end;

{==============================

   >>  procedure tIceLock.SetKeyFileName(fn : string);

    >  Description : Sets the value for the KeyFileName.  Should
                     be set once at design-time... Remember when
                     you create registration keys, the filename
                     must match!

 ==============================}
procedure tIceLock.SetKeyFileName(fn : string);
begin
  fKeyFileName := fn;
end;


{==============================

   >>  procedure tIceLock.EncryptRecord(p : Pointer);

    >  Description : Encrypts (masks) the record, before saving
                     to a file.  You may very well wish to change
                     the values in MasterKey, for added security

    >  Input       : pointer to an IceArray

    >  Output      : Nothing, it directly modified the data via
                     'p'.

 ==============================}
procedure tIceLock.EncryptRecord(p : Pointer);
const
  MasterKey : array[1..8] of byte = ((89),(66),(128),(231),(18),(43),(113),(67));

var
  pr : pIceArray;
  x  : byte;
begin
  pr := p;
  for x := 1 to sizeof(rIceRecord) do
  begin
    pr^[x] := pr^[x] xor masterkey[x mod 8];
  end;
end;


(*

This procedure was used to build the file "CRCTAB.INC".. well sorta
I had to add code to actually create the file.  I wouldn't suggest
messing around with the CRCtable.....

procedure tIceLock.BuildCRCTable;
Const
  CRC_Polynomial = $EDB88320;

VAR x, y: INTEGER;
    CRC_Value: LONGINT;
BEGIN
     FOR x := 0 TO 255 DO BEGIN
         CRC_Value := x;
         FOR y := 1 TO 8 DO
             IF (CRC_Value AND 1 = 1) THEN
                CRC_Value := (CRC_Value SHR 1) XOR CRC_Polynomial
             ELSE
                CRC_Value := CRC_Value SHR 1;
        CRCtable[ x ] := CRC_Value;
     END { NEXT x }
END;

*)

{==============================

   >>  function tIceLock.CalcCRCBuffer(CRC_Value: LONGINT;

    >  Description : Calculates a CRC value, for a CRC buffer.

    >  Input       : CRC_Value - This seed value for gen. CRC's
                     cBuffer   - the buffer to calculate

    >  Output      : Returns a longint CRC value.

 ==============================}
function tIceLock.CalcCRCBuffer(CRC_Value: LONGINT;
                                cBuffer: CRCBuffType ): LONGINT;
VAR
  nTemp1, nTemp2: LONGINT;
  i: byte;
BEGIN
  FOR i := 0 TO 70 DO
  BEGIN
    nTemp1 := (CRC_Value SHR 8) AND $00FFFFFF;
    nTemp2 := CRCtable[ (CRC_Value XOR cBuffer[i]) AND $FF ];
    CRC_Value := nTemp1 XOR nTemp2;
  END;
  CalcCRCBuffer := CRC_Value;
END;


{==============================

   >>  function tIceLock.HexLongInt(L : LongInt) : KeyString;

    >  Description : Convert a longint to a KeyString

    >  Input       : LongInteger

    >  Output      : KeyString ($ABFF...etc)

 ==============================}
function tIceLock.HexLongInt(L : LongInt) : KeyString;
const
  HexDigits : ARRAY[0..15] OF Char = '0123456789ABCDEF';

VAR Temp : KeyString;
BEGIN
  Temp[0] := #9;
  Temp[1] := '$';
  Temp[2] := HexDigits[(L SHR 28) and $F];
  Temp[3] := HexDigits[(L SHR 24) AND $F];
  Temp[4] := HexDigits[(L SHR 20) AND $F];
  Temp[5] := HexDigits[(L SHR 16) AND $F];
  Temp[6] := HexDigits[(L SHR 12) AND $F];
  Temp[7] := HexDigits[(L SHR 8) AND $F];
  Temp[8] := HexDigits[(L SHR 4) AND $F];
  Temp[9] := HexDigits[L AND $F];
  HexLongInt := Temp;
END;

{==============================

   >>  function tIceLock.BuildUserKey(Name : NameString) : KeyString;

    >  Description : Creates a Key from the passed Name

    >  Input       : Name - the users name

    >  Output      : a Key

 ==============================}
function tIceLock.BuildUserKey(Name : NameString) : KeyString;
var
  Buff : CRCBuffType;
  bs   : ^String;
  x    : integer;
  temp : KeyString;
begin
  for x := Length(Name) + 1 to 50 do Name[x] := UserPad;
  bs := @Buff;
  Temp := HexLongInt(fProgKey1);
  for x := 0 to 9 do Buff[x] := ord(Temp[x]);
  for x := 0 to 50 do Buff[x + 10] := ord(Name[x]);
  Temp := HexLongInt(fProgKey2);
  for x := 0 to 9 do Buff[x + 61] := Ord(Temp[x]);
  BuildUserKey := HexLongInt(CalcCRCBuffer(Seed, Buff));
end;

{==============================

   >>  procedure tIceLock.InitProgramKeys;

    >  Description : Initializes program keys, based on the values of Ice1/
                     progkey1 and Ice2/Progkey2

    >  Input       : None works only on object properties

 ==============================}
procedure tIceLock.InitProgramKeys;
var
  x : integer;
  Buffer : CRCBuffType;
begin
  for x := Length(fIce1) + 1 to 70 do fIce1[x] := ProgPad;
  for x := 0 to 70 do Buffer[x] := ord(fIce1[x]);
  fProgKey1 := CalcCRCBuffer(fSeedVal1,Buffer);
  for x := Length(fIce2) + 1 to 70 do fIce2[x] := ProgPad;
  for x := 0 to 70 do Buffer[x] := ord(fIce2[x]);
  fProgKey2 := CalcCRCBuffer(fSeedVal2,Buffer);
end;


{==============================

   >>  Function tIceLock.CheckKey(n : NameString;k : KeyString) : boolean;

    >  Description : Verified that the key (k) is valid for name (n)

    >  Input       : a name and key

    >  Output      : Boolean result, true if good key

 ==============================}
Function tIceLock.CheckKey(n : NameString;k : KeyString) : boolean;
begin
  CheckKey := BuildUserKey(N) = k;
end;


{==============================

   >>  function tIceLock.GetKey  : KeyString;

    >  Description : Gets the current key stored in UserKey

 ==============================}
function tIceLock.GetKey  : KeyString;
begin
  GetKey := UserKey;
end;

{==============================

   >>  function tIceLock.GetName : NameString;

    >  Description : Gets the current name in UserName

 ==============================}
function tIceLock.GetName : NameString;
begin
  GetName := UserName;
end;


{==============================

   >>  function tIceLock.PutKey(name : NameString; Key : KeyString) : integer;

    >  Description : Attempts to store name and Key in UserName and Userkey

    >  Input       : a name and key..

    >  Output      : Returns error code ieOkay if successful, ieInvalid for
                     invalid keys.

 ==============================}
function tIceLock.PutKey(name : NameString; Key : KeyString) : integer;
var
  x : integer;
begin
  for x := Length(Name) + 1 to 50 do Name[x] := UserPad;
  if CheckKey(Name,Key) then
  begin
    PutKey := ieOkay;
    UserName := Name;
    UserKey  := Key;
    IsRegistered := true;
  end
    else begin
      PutKey := ieInvalidKey;
      IsRegistered := false;
    end;
end;


{==============================

   >>  function tIceLock.SaveKeyFile : Integer;

    >  Description : Attempt to save the current key to a file.

    >  Input       : none

    >  Output      : Returns ieOkay for success, ieInvalid for invalid key, or
                     ieFileError if there is some program creating/writting to
                     file.  If the result if ieFileError, your program can check
                     the value of LastIoResult to get the error code.

 ==============================}
function tIceLock.SaveKeyFile : Integer;
var
  r  : rIceRecord;
  pa : pIceArray;
  f  : file of aIceArray;
begin
  if CheckKey(UserName, UserKey) then
  begin
    assignFile(f,fKeyFileName);
    {$I-}
    rewrite(f);
    {$I+}
    LastIoResult := IoResult;
    if LastIoResult = 0 then
    begin
      r.Name := UserName;
      r.Key  := UserKey;
      pa := @r;
      EncryptRecord(@r);
      write(f,pa^);
      SaveKeyFile := ieOkay;
      closefile(f);
    end
      else SaveKeyFile := ieFileError;
  end
    else SaveKeyFile := ieInvalidKey;
end;

{==============================

   >>  function tIceLock.LoadKeyFile : Integer;

    >  Description : Attempts to load the current key to a file.

    >  Input       : none

    >  Output      : Returns ieOkay for success, ieInvalid for invalid key, or
                     ieFileError if there is some program creating/reading the
                     file.  If the result if ieFileError, your program can check
                     the value of LastIoResult to get the error code.

 ==============================}
function tIceLock.LoadKeyFile : Integer;
var
  r  : rIceRecord;
  pa : pIceArray;
  f  : file of aIceArray;
begin
  IsRegistered := false;
  AssignFile(f,fKeyFileName);
  {$I-}
  reset(f);
  {$I+}
  LastIoResult := IoResult;
  if LastIoResult = 0 then
  begin
    pa := @r;
    {$I-}
    read(f,pa^);
    {$I+}
    LastIoResult := IoResult;
    if LastIoResult = 0 then
    begin
      EncryptRecord(@r);
      if CheckKey(r.Name,r.Key) then
      begin
        UserName := r.Name;
        UserKey  := r.Key;
        LoadKeyFile := ieOkay;
        IsRegistered := true;
      end
        else LoadKeyFile := ieInvalidKey;
    end
      else LoadKeyFile := ieFileError;
    closefile(f);
  end
    else LoadKeyFile := ieFileError;
end;



{==============================

   >>  constructor tIceLock.Create(AOwner: TComponent);

    >  Description : Called when tIceLock component is created, initializes
                     variables.

 ==============================}
constructor tIceLock.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  { Initialize all variables }
  fIce1        := 'IceLock v1.0';
  fIce2        := 'IceLock !!!!!';
  fProgKey1    := 32767;
  fProgKey2    := 65535;
  fSeedVal1    := $EFCA99;
  fSeedVal2    := $CA99FF;
  fKeyFileName := 'REGISTER.KEY';
  Seed         := $ABCDEF;
  UserName     := 'UNREGISTERED';
  UserKey      := '$FFFFFFFF';
  LastIoResult := 0;
  IsRegistered := False;
(*  BuildCrcTable;*)
  InitProgramKeys;
end;


end.
