; rot-13 by bart^CrackPl
; prosta procedura sluzaca do szyfrowania/deszyfrowania bufora
; wg algorytmu ROT-13
;
; push offset lpBuffer
; push BufferLength
; call rot13
;
; alfabet:
; ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz
; rot-13 mirror:
; NOPQRSTUVWXYZABCDEFGHIJKLMnopqrstuvwxyzabcdefghijklm
;
rot13	proc near
	pop	eax			; adres powrotu
	pop	ecx			; rozmiar bufora
	pop	edx			; adres bufora
	push	eax			; zapamietaj adres powrotu

rot13_convert:
	mov	al,byte ptr[edx]	; kolejny bajt z bufora, w ROT13
					; szyfrowane sa tylko znaki alfabetu
					; (26+26) male+duze, wszystkie inne
					; sa pomijane
	cmp	al,'A'
	jb	rot13_next_char		; jesli jest < "A" pomin

	cmp	al,'z'			; jesli jest > "z" pomin
	ja	rot13_next_char

	cmp	al,'a'			; jesli miesci sie w przedziale "a-z"
	jae	rot13_convert_char	; szyfruj

	cmp	al,'Z'			; jesli jest > "Z" pomin
	ja	rot13_next_char

rot13_convert_char:
	cmp	al,'n'			; jesli bajt >= "n"
	jae	rot13_sub_13		; odejmij od niego 13

	cmp	al,'a'			; jesli bajt jest z przedzialu "a-m"
	jae	rot13_add_13		; dodaj do niego 13

	cmp	al,'N'			; jesli bajt jest >= "N"
	jae	rot13_sub_13		; odejmij 13

rot13_add_13:
	add	al,13+13		; taki trick ktory zaoszczedzi
rot13_sub_13:				; jednego jmp-a(26-13=13 czyli +13)
	sub	al,13			; odejmij 13 od al
	mov	byte ptr[edx],al	; zapisz przekonwertowany bajt do bufora
rot13_next_char:
	inc	edx			; zwieksz licznik
	loop	rot13_convert		; konwertuj wszystkie bajty

	ret				; powrot z procki

rot13	endp