#define WIN32_LEAN_AND_MEAN
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

int main (int argc, char* argv[]) {
	
	HANDLE hFileMap=0;
	HANDLE hFile=0;
	LPVOID pMappedFile=0;
	DWORD mySize=0;
	DWORD* lpdwResult=0;
	
	char* crap;
	char waste[80];
	
	if (argc!=3)
	{
		printf ("Usage:\n");
		printf ("%s <filename> <file size in bytes>\n", argv[0]);
		printf ("Example:\nsoftdump testdump.dat 20000\n");
		return 1;
	}
	
	mySize = strtol( argv[2], &crap, 16 );
	
	if (mySize < 1 || mySize > 1024*4096)
	{
		printf ("Size error. Size must be between 1 byte and 4MB.\n");
		return 0;
	}
	
	hFile = CreateFile ( (LPCTSTR) argv[1], GENERIC_READ | GENERIC_WRITE, 
		FILE_SHARE_WRITE, 0, CREATE_ALWAYS, 0, 0);
	
	if (!hFile)
	{
		printf ("Cannot open file %s.\nTerminating.", argv[1]);
		return 0;
	}
	
	hFileMap = CreateFileMapping ( hFile, 0, PAGE_READWRITE | SEC_COMMIT, 0, mySize, "softmap");
	
	if (!hFileMap)
	{
		printf("Unable to create file mapping.  Error Code: %d.  Terminating.\n", GetLastError());
		CloseHandle (hFile);
		return 0;
	}
	
	pMappedFile = MapViewOfFile ( hFileMap, FILE_MAP_WRITE, 0, 0, 0);
	
	if (!pMappedFile)
	{
		printf ("MapViewOfFile failed.  Error code: %d.  Terminating.\n", GetLastError());
		CloseHandle (hFileMap);
		CloseHandle (hFile);
		return 0;
	}
	
	// Force the pages into memory, and stick in identifier
	for (BYTE* i=(BYTE*)pMappedFile; i<(BYTE*)((DWORD)pMappedFile+mySize); i++)
		*i = 0xCC;
	strcpy((char*)pMappedFile, "mappedfile");
	
	// Write it to the disk
	FlushViewOfFile(pMappedFile,0);

	printf ("Mapping address:  \t0x%x.\n", (DWORD)pMappedFile);
	printf ("Go into SoftICE and do your thing!\n");
	printf ("Hit return when you are ready for the file to be written to disk.\n");
	gets (waste);

	// Flush file -- probably not necessary
	if (!FlushViewOfFile(pMappedFile,0))
		printf("FlushViewOfFile failed.  Check to make sure file is ok.\n");
	
	// Clean up
	UnmapViewOfFile ( pMappedFile);
	CloseHandle ( hFileMap );
	CloseHandle ( hFile );
	printf ("Done.\n");
	return 1;
	
}
