#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include <colors.h>
#include <osw.h>
#include <designat.h>
#include <freqasg.h>
#include <trunksys.h>


char *sysType = "unknown";
TrunkSys *mySys = 0;
int mySite = -1;
time_t now, nowFine;
char tempArea[512];
unsigned short nsysId = 0, sysId = 0, cwFreq = 0;
long theDelay = DELAY_ON;
BOOL Verbose = TRUE;
BOOL seekNew = FALSE;
BOOL inSync = FALSE;
BOOL showFrameSync = FALSE; 
unsigned long stackOverFlows = 0L;
unsigned long wrapArounds = 0L;
Scanner *myScanner = 0;


unsigned short actualRows;
unsigned short numIdles;

/* NOTE: this program started from an 'anonymous' post to a usenet group of some source code
   for displaying information about trunked Motorola radio systems. It has been converted to
   Visual C++ for version 1.52C, and significantly evolved. The original comments are maintained
   in the next comment block for historical purposes.
   			anon
*/
/*--------------------------------------------------------------------*/
/*                                                                    */
/*   This programs displays some of the most important data sent over */
/*   a Motorola trunked radio system control channel.                 */
/*   Right now it expects an interface described in the above text    */
/*   to sit at COM1                                                   */
/*   If you want improvements you have to do them yourself.           */
/*                                                                    */
/*   This is not be used by anyone for any monetary gain. If you do   */
/*   we hope Motorola's lawyers will crush the life out of you.       */
/*                                                                    */
/*   Complaints? Remember - you get what you paid for. And you didn't */
/*   pay a cent for this program.                                     */
/*                                                                    */
/*   Still got Complaints? Well here are our canned responses:        */
/*                                                                    */
/*       - The code is the comment                                    */
/*       - What do you expect? I work for Microsoft                   */
/*       - Cheesiest is easiest                                       */
/*       - I'll put the comments in later                             */
/*       - If it was hard to write it should be hard to read          */
/*       - Go ahead and try to find me                                */
/*       - Rember - you always have a fiend in Jesus                  */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*                                                                    */
/* port info  :  COM1                                if dlab bit =1   */
/*      0x3f8 : receive/transmit data                     baud0       */
/*      0x3f9 : interrupt enable register     - IER       baud1       */
/*      0x3fa : interrupt identifier register - IIR                   */
/*      0x3fb : line control register         - LCR                   */
/*      0x3fc : modem control register        - MCR                   */
/*      0x3fd : line status register          - LSR                   */
/*      0x3fe : modem status register         - MSR                   */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*                                                                    */
/* PORT INFO  : 8259 INTERRUPT CONTROLLER                             */
/*      0X021 : A CORRESPONDING LOW BIT ENABLES A SPECIFIC INTERRUPT  */
/*              COM1 IS IRQ4, AND THEREFORE CONTROLLED BY BIT 0X10    */
/*      0X020 : WHENEVER AN INTERRUPT IS RESOLVED, A 0X20 SHOULD BE   */
/*              PORTED OUT HERE TO GENERATE AN END OF INTERRUPT       */
/*              SIGNAL.                                               */
/*                                                                    */
/*--------------------------------------------------------------------*/

/* global variables */

char ob[100];   /* output buffer for packet before being sent to screen */
struct osw_stru{
  unsigned short cmd;
  unsigned short id;
  char grp;
};

volatile BOOL InSync = FALSE;


static enum {
	Identifying,
	GettingOldId,
	OperNewer,
	OperOlder
} osw_state = Identifying;
static Filter filterCmd(4);
static Filter filterSysId(3);
static struct osw_stru stack[5];
static int numStacked = 0;
static int numConsumed = 0;
static numOKinRow = 0;

static void
noteOlderType()
{
	if( mySys ) {
		mySys->unsafe();
		delete mySys;
		mySys = 0;
	}
	sysType = "Single Site (Old)";
	mySite = -1;
	osw_state = GettingOldId;
}

inline void 
noteIdentifier(unsigned short possibleId, BOOL isOld)
{
 	if(filterSysId.filter(possibleId) == possibleId) {
		if( possibleId != sysId && mySys) {
			mySys->unsafe();
			delete mySys;
			mySys = 0;
			sysType = "unknown";
			mySite = -1;
		}
 		if(mySys) {
 			mySys->endScan(); // take opportunity to age assignments
 		} else {
			sysId = possibleId;
			mySys = new TrunkSys(sysId, myScanner);
		 	if( !mySys ) {
				printf("cannot alloc TrunkSys objects\n");
				exit(1);
			}
			osw_state = isOld ? OperOlder : OperNewer;
		}
 	}
}
void inline
show_bad_osw()
{
	// clear out work in progress...
	
	numStacked = 0;
	numConsumed = 0;
	numOKinRow = 0;
	filterCmd.filter(0);
}
void inline
show_good_osw(register struct osw_stru* Inposw)
{
	unsigned short fcmd;
    ++nowFine;				// fine grain counter = #osw's = 90hz
	if(mySys && ! (nowFine & 15) ) {  // about 6x/sec + at scan marker
		mySys->endScan();
	}
    ++numOKinRow;
    
    // maintain a sliding stack of 5 OSWs. If previous iteration used more than one,
    // don't touch stack until all used ones have slid past.
    
    switch(numStacked)
    {
    case 5:
    case 4:
    	stack[4] = stack[3];
	case 3:
    	stack[3] = stack[2];
	case 2:
	   	stack[2] = stack[1];
	case 1:
    	stack[1] = stack[0];
    case 0:
    	stack[0] = *Inposw;
    }
    if(numStacked < 5)
    	++numStacked;
    if( numConsumed > 0) {
    	--numConsumed;
    }
    if( numConsumed || numStacked < 3 )
    	return; // at least need a window of 3 and 5 is better.
    	
    fcmd = filterCmd.filter(stack[2].cmd);
    
    // look for some larger patterns first... parts of the sequences could be
    // mis-interpreted if taken out of context.
    
	if(stack[2].cmd == 0x308) {
		if(numOKinRow > 60 && (osw_state == Identifying || osw_state == OperNewer)) {

			// long stream of non-identity data, assume un-numbered...

			noteOlderType();
		}
		if(stack[1].cmd == 0x30b)
		{
			// one of two possible identity sequences...
			if( isFrequency(stack[0].cmd) ) {
				if(((stack[0].id & 0xff00) == 0x1F00)
					&& ((stack[1].id & 0xfc00) == 0x2800)) {
				/* non-smartzone identity:
						<sysid>              x   308
						<001010><ffffffffff> x   30b
						1Fxx                 x   <freq>
				*/ 
					numOKinRow = 0; // got identifying info...
					noteIdentifier(stack[2].id,FALSE);
					if( mySys ) {
			  			mySys->noteDataChan(stack[0].cmd);
			  		} 
			  	}
		  		numConsumed = 3; // we used up all 3
		  		return;
			} else if((stack[1].id & 0xfc00) == 0x2800)  {
				/* smartzone identity:
						<sysid>              x   308
						<001010><ffffffffff> x   30b
				*/ 
				numOKinRow = 0; // got identifying info...
				noteIdentifier(stack[2].id,FALSE);
				if( mySys ) {
		  			mySys->noteDataChan(stack[1].id & 0x03ff);
		  		}			
			} else {
				// evidence of smartzone, but can't use this pair for id
				if(mySys)
					sysType = "Networkable";
			}
			numConsumed = 2;
			return; 
		}
		if(stack[1].cmd == 0x320 && stack[0].cmd == 0x30b)
		{
			// definitely smart-zone
			if( mySys)
				sysType = "Networkable";
			numConsumed = 3;
			return;		
		}
		if( mySys ) {
			if(stack[1].cmd == 0x0310) {
				mySys->note_affiliation(stack[2].id,stack[1].id);
			} else if(stack[1].cmd == 0x0319) {
				mySys->note_page(stack[2].id, stack[1].id);
			} else if(isFrequency(stack[1].cmd)) {
					// handle type II call
				mySys->note_freq_assignment(
						stack[1].cmd,
						stack[1].grp,
						stack[1].id,
						stack[2].id);
			}  // otherwise 'busy', others...
		}
		numConsumed = 2;
		return;
	}
	// another configuration seen in London, U.K. in 4-500mhz range :
	if( stack[1].cmd == 0x0320 && stack[0].cmd == 0x030b && isFrequency(stack[2].cmd)) {
		numOKinRow = 0; // got identifying info...
		noteIdentifier(stack[2].id,FALSE);
		if( osw_state == OperNewer ) {
			sysType = "Networkable";
		}
		numConsumed = 3;
		return;		
	}    
    switch( stack[2].cmd )
    {		
	case 0x3c0: // system status
	case 0x3bf:
	
		numOKinRow = 0; // not an old type one if get these
		break;
			
	case 0x32b:	// scan marker
		numOKinRow = 0; // got identifying info...
		noteIdentifier(stack[2].id,FALSE);
		if( osw_state == OperNewer ) {
			sysType = "Single or Multicast";
			mySite = -1;
		}
		break;

	case 0x2f8: // idle word - normally ignore but may indicate transition into
				// un-numbered system or out of numbered system
		if( fcmd == 0x2f8 ) { // several in row
			if( osw_state == Identifying || osw_state == OperNewer ) {
				noteOlderType();
			}
		} 
		// any other case is a don't care
		break;

	case 0x3a0: // diagnostic: cw On, Off
		if(mySys){
			cwFreq = stack[2].id & 0x3ff;
			mySys->noteCwId(cwFreq, stack[2].id & 0x1000);
		}
		break;

	default:
		if(numOKinRow > 60 &&(osw_state == Identifying || osw_state == OperNewer)) {
				// long stream of non-identity data, assume un-numbered...
			noteOlderType();
		} else {
			if(mySys) {
				
				// this is the most frequent case that actually touches things....
				
				if (isFrequency(stack[2].cmd) && numStacked > 3  ) {
					// bare assignment 
					// this is still a little iffy...
					if((stack[2].id & 0xff00) == 0x1f00) {
						if(osw_state == OperOlder) {
							noteIdentifier(stack[2].id,TRUE);
							if( mySys) 
								mySys->noteDataChan(stack[2].cmd);
						}	
					} else {
						mySys->note_freq_assignment(
							stack[2].cmd,
							stack[2].grp,
							stack[2].id,
							0);
					}
				} else if( stack[2].cmd >= 0x360 && stack[2].cmd <= 0x394 ) {
					// Site ID
					mySite = stack[2].cmd - 0x360;
					mySys->note_site(mySite);
				}
			} else if( osw_state == GettingOldId ) {
				if (isFrequency(stack[2].cmd) && ((stack[2].id & 0xff00) == 0x1f00)) { 
					noteIdentifier(stack[2].id,TRUE);
					noteIdentifier(stack[2].id,TRUE);
			    }
			}
		}
		break;
	}
	numConsumed = 1;
	return;
}

/* process de-interleaved incoming data stream */
/* inputs: -1 resets this routine in prepartion for a new OSW       */
/*         48 zero bit                                              */
/*	   49 one bit                                               */
/* once an OSW is received it will be placed into the buffer bosw[] */
/* bosw[0] is the most recent entry				    */
void inline proc_osw(int sl)
{
  static int ct,l,sr,sax,f1,f2,iid,cmd,neb=0;
  static char osw[50],gob[100];
  static struct osw_stru bosw;

  if (sl == -1) ct = 0;
  else
  {
    gob[ct] = sl;
    ct++;

      if (ct == 76)
      {
	sr = 0x036E;
	sax = 0x0393;
	neb = 0;

	/* run through convolutional error correction routine */
	/* Reference : US PATENT # 4055832		      */
	for (l=0; l<76; l+=2)
	{
	  osw[l>>1] = gob[l];   /* osw gets the DATA bits   */
	  if (gob[l] == 49)     /* gob becomes the syndrome */
	  {
	    gob[l  ] ^= 0x01;
	    gob[l+1] ^= 0x01;
	    gob[l+3] ^= 0x01;
	  }
	}
	for (l=0; l<76; l+=2)   /* now correct errors       */
	{
	  if ( (gob[l+1] == 49) && (gob[l+3] == 49) )
	  {
	    osw[l >> 1] ^= 0x01;
	    gob[l+1] ^= 0x01;
	    gob[l+3] ^= 0x01;
	  }
	}

	/* run through error detection routine */
	for (l=0; l<27; l++)
	{
	  if ((sr & 0x01) != 0 ) sr = (sr >> 1) ^ 0x0225; else sr = sr >> 1;
	  if (osw[l] == 49) sax = sax ^ sr;
	}
	for (l=0; l<10; l++)
	{
	  if (osw[36-l] == 49) f1 = 0; else f1 = 1;
	  if ((sax & 0x01) > 0) f2 = 1; else f2 = 0;
	  sax = sax >> 1;
	  if (f1 != f2) neb++;  /* neb counts # of wrong bits */
	}


	/* if no errors - OSW received properly; process it */
	if (neb == 0)
	{
	  for (l=0; l<16; l++)
	  {
	    iid = iid << 1;
	    if (osw[l] == 48) iid++;
	  }
	  iid = iid ^ 0x33C7;
	  bosw.id = iid;
	  if (osw[16] == 48) bosw.grp = 1; else bosw.grp = 0;
	  cmd = 0;
	  for (l = 17; l<27; l++)
	  {
	    cmd = cmd << 1;
	    if (osw[l] == 48) cmd++;
	  }
	  cmd = cmd ^ 0x032A;
	  bosw.cmd = cmd;
          ++goodcount;
	  show_good_osw(&bosw);

	} else {   
		++badcount;
		show_bad_osw();
	}
      }
  }
}

void inline pigout(int skipover)  /* de-interleave OSW stored in array ob[] and process */
{
  register int i1,i2,k;
    proc_osw(-1);
    for (i1=0; i1<19; i1++)
    {
      for (i2=0; i2<4; i2++)
      {
	k = (i2*19) + i1;
	proc_osw( (int) ob[k + skipover]);
      }
    }
}

/* this routine looks for the frame sync and splits off the 76 bit */
/* data frame and sends it on for further processing               */
void inline frame_sync(char gin)
{
  static int sr = 0, fs = 0xAC, bs=0;

  /* keep up 8 bit sliding register for sync checking purposes */
  sr = sr << 1;
  sr = sr & 0xff;
  if (gin == 49) sr = sr | 0x01;

  ob[bs-1] = gin;

  /* if sync seq and enough bits are found - data block */
	if ((sr == fs) && (bs > 83))
	{
  	// the original code didn't handle excess bits at beginning.
  	// not sure it will make much difference, but I send the last 84 bits
  	// out, not the first 84 bits.
  	
		pigout(bs - 84);  /* the latest frame is stored in array ob[] */
		bs = 0;
		InSync = TRUE;
	}
  	if (bs < 98) {
		++bs;
		// after lots of garbage, this will show up as a error frame,
		// but future ones will be 'in sync'
	} else {
		InSync=FALSE; // high-precision receiver status
	}
}


const char *scanEnv;

void syntax()
{
		printf("syntax:\n\ntrunker\t\tnormal mode\ntrunker /i\tinverted mode\n\nset TRACKSCAN to:\n");
		printf("\tAR8000\t\t9600bps CR mode\n\tAR2700\t\t4800 bps\n\tAR3000\t\t4800 bps\n");
		printf("\tAR3000A\t\t9600 bps\n\tKENWOOD\t\t4800 bps\n\tKENWOOD9600\t9600 bps\n");
		printf("\nhit return to exit");
		getchar();
		exit(1);
}
void vidInit()
{
	actualRows = _setvideomoderows(_DEFAULTMODE,43);
	if( actualRows == 0 ) {
		printf("failed to set video modes.\n");
		exit(1);
	}
	if( actualRows != 43 ) {
		printf("need 43 row mode!\n");
		exit(2);
	}
	_settextcursor((short)0x2000);
	_wrapon(_GWRAPOFF);
}
void scanInit()
{
  	scanEnv = getenv("TRACKSCAN");
  	if( scanEnv && *scanEnv)
  	{
  		if( !strcmp(scanEnv,"AR8000"))
  			myScanner = new AR8000;
  		else if( !strcmp(scanEnv,"AR2700") )
  			myScanner = new AR2700;
  		else if( !strcmp(scanEnv,"AR3000A"))
  			myScanner = new AR3000A;
  		else if( !strcmp(scanEnv,"AR3000"))
  			myScanner = new AR3000;
  		else if( !strcmp(scanEnv,"KENWOOD"))
  			myScanner = new Kenwood;
  		else if( !strcmp(scanEnv,"KENWOOD9600"))
  			myScanner = new Kenwood(9600.00);
  		else if( !strcmp(scanEnv,"NONE")) {
  			scanEnv = "none";
  			myScanner = new NOSCANNER;
  		} else scanEnv = "unknown";
  	}
  	if( !myScanner ) {
  		scanEnv = "AR8000";
  		myScanner = new AR8000;		// constructor should set baud rate!
  	}
  	if(!myScanner) {
  		printf("could not create scanner object");
  		exit(1);
  	}
}
void
periodic()
{
		static int winCtr = 0;
		if(mySys) {
			if( ++winCtr >= 5 ) {
				mySys->flushFreqs(); 
				winCtr = 0;
			}
			_settextcolor(WHITE);
			_settextposition(STATROW+1,19);
			_outtext(mySys->sysType());
		}
		stats(scanEnv);
}
int
main(int argc, char **argv)
{
	register unsigned int i=0,cw1=49,cw0=48;
	char s=48;
	register double dt,exc=0.0,clk=0.0,xct;
	static unsigned short t = 0;
	unsigned int ovwatch;

 	if( argc > 2 ) {
		syntax();
	}
    vidInit();                                                                             
	scanInit();
	showPrompt();
	if (argc == 2)
	{
		cw1 = 48;
		cw0 = 49;
	}


 	/* dt is the number of expected clock ticks per bit */

	dt =  1.0/(3600.0*838.8e-9);
	mySys = new TrunkSys(0x1234,myScanner);
	/*
	unsigned short jj = 1;
	register int ii,j;
	for(ii=0; ii<256; ++ii) {
		for(j=0; j<256;++j) {
			mySys->note_affiliation(jj,jj);++jj;
		}
		printf("%hu\n",(WORD)ii);
	}
	*/
	hardwareInit();	
	for(;;)
	{
		time(&now);	// per-event time
		for (ovwatch = BufLen;i != cpstn; --ovwatch)
		{
			if( ovwatch == 0 ) {
				// we never caught up to the input side during loop, drop around and
				// note that we are in trouble.
				++wrapArounds;
				break;
			}       
			s = (fdata[i] & 0x8000) ? cw0:cw1;
			/* add in new number of cycles to clock  */
			clk += (fdata[i] & 0x7fff);
			xct = exc + 0.5 * dt;  /* exc is current boundary */
			while ( clk >= xct )
			{
				frame_sync(s);   /* send raw bit stream to first processing routin */
				clk = clk - dt;
			}
			// PHASE LOCK LOOP ALGORITHM!
			/* clk now holds new boundary position. update exc slowly... */
			/* 0.005 sucks; 0.02 better; 0.06 mayber even better; 0.05 seems pretty good */
			exc = exc + 0.025*(clk - exc);
			
			if( ++i > BufLen) 
				i = 0;
		}
		if( (t++ << 1) == 0) {
			periodic();
		}
		if(showFrameSync &&  !(t&0x007)) { // every eighth time
			static BOOL syncState = FALSE;
			if(InSync != syncState) {
				if(syncState)
					syncState = FALSE;
				else
					syncState = TRUE;
				gotoxy(52,STATROW);
				_settextcolor(WHITE);
				_outtext(syncState? "@" : "_");
			}
		}		
		if( kbhit()) {
			doKeyEvt();
 		}
 	}
	return(0);
}
