#include <conio.h>
#include <dos.h>
#include <graph.h>
#include <afxcoll.h>
#include <colors.h>
#include <osw.h>
#include <designat.h>
#include <freqasg.h>
#include <trunksys.h>

unsigned long goodcount = 0;
unsigned long badcount = 0; 
unsigned short bitsAtZero;
unsigned short bitsAtOne;
volatile unsigned int cpstn = 0; /* current position in buffer */
unsigned short fdata[BufLen+1] ; /*warning don't make volatile!*/
void (__interrupt __far __cdecl *oldfuncc)(void );

void docleanup()
{
	delete mySys;
	outportb (0x21, inportb(0x21) | 0x10);
	setvect (0x0c, oldfuncc);
	_setvideomode(_DEFAULTMODE);
 }

/**********************************************************************/
/*                                this is serial com port interrupt   */
/* we assume here that it only gets called when one of the status     */
/* lines on the serial port changes (that's all you have hooked up).  */
/* All this handler does is read the system timer (which increments   */
/* every 840 nanoseconds) and stores it in the fdata array. The MSB   */
/* is set to indicate whether the status line is zero. In this way    */
/* the fdata array is continuously updated with the appropriate the   */
/* length and polarity of each data pulse for further processing by   */
/* the main program.						      */
void far interrupt com1int()
{
  static unsigned short ltick = 0;
  register unsigned short d1, d2,d3, tick, dtick;
  /* the system timer is a 16 bit counter whose value counts down     */
  /* from 65535 to zero and repeats ad nauseum. For those who really  */
  /* care, every time the count reaches zero the system timer 	      */
  /* interrupt is called (remember that thing that gets called every  */
  /* 55 milliseconds and does housekeeping such as checking the       */
  /* keyboard.                                                        */
  
  
  d3 = inportb(0x3fe);	// get modem interrupt status
    bitsAtOne |= d3;
    bitsAtZero |= ~d3;
 	// only compute data if CTS changed! other interrupts may be used some day.
	/* get difference between current, last counter reading */
 	static unsigned short lastbit = 0;
 	if( (lastbit & 0x10) != (d3 & 0x10)) // filter out impulse noise
 	{
 		// by filtering out spurious CTS interrupts, we significantly improve the
 		// noise floor.  If the bit appears unchanged because it took a long time
 		// to handle the interrupt, the missed bit will be detected by error checks.
		  outportb (0x43, 0x00);       /* latch counter until we read it      */
		  d1 = inportb (0x40);         /* get low count                       */
		  d2 = inportb (0x40);         /* get high count                      */
 		
		tick  = (d2 << 8) + d1;
		dtick = ltick - tick;
		ltick = tick;
		
		
		if (d3 & 0x10)	// read current value
			dtick = dtick & 0x7fff;	 
		else
			dtick = dtick | 0x8000; 
		
		fdata[cpstn++] = dtick;		/* put freq in fdata array             */
		if (cpstn>BufLen) cpstn=0;	/* make sure cpstn doesnt leave array  */
		lastbit = d3;
	} 
  d1 = inportb (0x03fa);		/* clear IIR                           */
  d1 = inportb (0x03fd);		/* clear LSR                           */
  d1 = inportb (0x03fe);		/* clear MSR                           */
  if( d1 & 1 ) 
  	d1 = inportb (0x03f8); // clear RX - someday may process data
  outportb (0x20, 0x20);       /* this is the END OF INTERRUPT SIGNAL */
                               /* "... that's all folks!!!!"          */
}

void set8250(double bps)       /* sets up the 8250 UART               */
{
  static  unsigned int t,dv,tp;

  dv = (int) (1843200.0/(16.0*bps));
  /* how to configure your serial port setup:          */
  /* do you want two stop bits? then make sure you set bit 2 in tp */
  /* do you want a parity bit generated? then set bit bit 3 in tp  */
  /* do you want even parity? then set bit 4 in tp                 */
  /* do you want an 8 bit word length? set bits 0 and 1 in tp      */
  /* do you want an 7 bit word length? set bit  1 in tp            */
  tp = 0x80 | 0x04 | 0x03; // 8 bits no parity 2 stop
  outportb (0x3fb, tp);  /* set line control register  */
  outportb  (0x3f8, dv);  /* output brg divisor latch   */
  tp = tp & 0x7f;        /* switch out brg divisor reg */
  outportb (0x3fb, tp);  /*  set IER on 0x03f9                  */


  /* only enable those interrupts caused by changing levels on the    */
 
  outportb (0x03f9, 0x08);     /*  enable MODEM STATUS INTERRUPT      */
  outportb (0x03fc, 0x0a);     /*  push up RTS, DOWN DTR              */
  //outportb (0x03fa, 0x07);	// enable fifo and flush its current contents
  //while( inportb(0x03fa) & 0x6)
  //	; // wait for fifo to clear
  //outportb (0x03fa, 0x1);	// enable fifo, interrupt on first char 
  
  t = inportb(0x03fd);         /*  clear LSR                          */
  t = inportb(0x03f8);         /*  clear RX                           */
  t = inportb(0x03fe);         /*  clear MSR                          */
  t = inportb(0x03fa);         /*  clear IID                          */
  t = inportb(0x03fa);         /*  clear IID - again to make sure     */
}

void set8253()                 /*  set up the 8253 timer chip         */
{                              /* NOTE: ctr zero, the one we are using*/
                               /*  is incremented every 840nSec, is   */
                               /*  main system time keeper for dos    */
  outportb (0x43, 0x34);       /* set ctr 0 to mode 2, binary         */
  outportb (0x40, 0x00);       /* this gives us the max count         */
  outportb (0x40, 0x00);
}


/* send a serial character. Vestigal code just for example purpose */
void send_char(char c)
{
  /* wait for transmit reg to empty */
  while ( (inportb(0x3fd) & 0x20) == 0x00);

  /* send character */
  outportb(0x3f8,c);
}
void
hardwareInit()
{
	oldfuncc = getvect(0x0c);    /* save COM1 Vector                    */
  	atexit(docleanup);
	setvect (0x0c, com1int);     /* Capture COM1 vector                 */
	outportb(0x21, inportb (0x21) & 0xef);
	set8253();                   /* set up 8253 timer chip              */
}