#include <Scanner.h>

class freqList {
	char *sysName;
	frequencyAssignment *aid;
	int *savenaid;

public:
	freqList(const char * fn, int& naid, const char *descr = 0 );
	frequencyAssignment *getList() { return aid; }
	const char *getSysName(){ return sysName;}
	void doSave(const char *tfn);
	virtual ~freqList(); 
};
class TrunkSys {
private:
	GroupDesigList		*groupList;	// list of group IDs and attributes (title, color, etc)
	desigList			*idList;	// list of radio IDs and attributes (title, color, etc)
	freqList			*fList;		// collection of frequencies for the system
	frequencyAssignment *aid;		// array of frequency assignments
	Scanner				*myScanner;	// points to external object for scanner control
	frequencyAssignment *cw;		// for *aid[], points to entry with CW identifier
	FILE				*pageLog;	// paging history file
	CMapPtrToWord		 newFreqs;	// used to count new frequencies before accepting them
	int					 naid;		// actual number of utilized frequencies
	BOOL				 doAuto;	// used to disable save in the 'escape' case
	char				 sysPrefix[5];// to store first 4 characters of file names
	char				 sysFn[20];	// xxxxSys.txt
	char				 idsFn[20];	// xxxxIds.txt
	char				 grpFn[20];	// xxxxGrp.txt
	char				 pageFn[20];// xxxxPage.txt
	char				 tmp[50];	// scratch pad
	char				 types[9];	// types by block
	unsigned short		 siteId;	// repeater # 
	Filter fSite;				// after 3, assume stable

	void init();					// common part of constructor 

public:

	TrunkSys(unsigned short nid, Scanner *scn);	// numbered system
	TrunkSys(const char *, Scanner *scn);       // un-numbered system
	virtual ~TrunkSys();

	void flushFreqs() { newFreqs.RemoveAll(); }
	const char *sysType() { return (const char *)&types[0]; }
	void unsafe();					// to disable auto-save on destruct	
	void note_page(unsigned short fromid, unsigned short toid); // id 'fromid' paged 'toid'
	void fixNew(designation *i, designation *g);
	void endScan();
	void note_freq_assignment(unsigned short freqnumber,
			     unsigned short grpPart,
			     unsigned short idPart,
			     unsigned short caller);
    void doSave();
    void editGroup(unsigned short theId, const char *theTitle);
    void editId(unsigned short theId, const char *theTitle);
    const char *getSysName() { return fList->getSysName(); }
	void noteCwId(unsigned short cwFreq, BOOL onoff);
	void noteDataChan(unsigned short dataFreq);
	void expandFreqs(unsigned short newF, int thresh = 10);
	void note_affiliation(unsigned short radioId, unsigned short groupId);
	void note_site(unsigned short newSite);
	void initF(const char *n = 0);
};

// Inlines: use a little space, save much time!

void inline
TrunkSys::fixNew(designation *i, designation *g)
{
	// when a user first shows up in a group, tags that user's title string with
	// the group information.
		
	if( i->title[0] == '?' && i->title[1] == '\0' && ! (g->title[0] == '?' && g->title[1]=='\0')) { 
		sprintf(tmp,"New @ G:%.4hx/%s",(WORD)(g->code),g->title);
		*i = tmp;
	}
}
void inline
TrunkSys::endScan()
{
		
	//	traverses all assigned frequencies, checking for changed or outdated entries.
	//	should be called when a dirty entry exists or at least a couple times per second.
	//	will analyze priorities and redirect scanner frequency if appropriate.
		
	register int i;						// iterator for known frequencies
	register frequencyAssignment *raid;	// for optimization, points to each object in turn
	register unsigned short prtyMax = 65535;
	register frequencyAssignment *topFreq = 0;
	for (i=0,raid = aid; i< naid; ++raid, ++i) 	// one pass over ALL objects
	{
		if( raid->fState == frequencyAssignment::FREQCALL ||
			raid->fState == frequencyAssignment::FREQHOLD ) {
			if(raid->visited ) {
				raid->freshen();
			} else {
				raid->noteInactive();
			}
		}
		if( raid->dirty )
			raid->show();
			
		// determine if this entry is 'better' than the old 'best' entry. in the case of
		// a selected channel, it should take precedence over better entries as long as
		// it is assigned to the scanner, but as soon as it goes into 'delay', 
		// priority override can occur. While this may seem to be inconsistent, it
		// does provide a smooth transition... 
		// to avoid pulling the scanner away to a frequency of better priority but
		// in a 'delay' state, don't jump to a non-selected one that is in delay mode.
				
		if(raid->selected)
		{
			// selected: pull down if better or equal priority than previous best,
			// even if in delay mode.
			
			if(raid->getPrio() <= prtyMax &&
			   (raid->fState == frequencyAssignment::FREQCALL 
			   || raid->fState == frequencyAssignment::FREQHOLD)) {
				   
				prtyMax = raid->getPrio();
				topFreq = raid;
			}
			raid->selected = FALSE;
		} else {
			// not selected: pull down if better priority and not in delay mode
			if( raid->getPrio() < prtyMax && raid->fState == frequencyAssignment::FREQCALL
			    && raid->scancmd[0] ) { // only jump here if can actually scan to it!

				prtyMax = raid->getPrio();
				topFreq = raid;
			} 
		}
		raid->visited = FALSE; 
	}
	if(prtyMax <= 50){
		topFreq->selected = TRUE;
		myScanner->topIs(topFreq);
	} else {
		myScanner->topIs(cw); // push to CW channel
	}
}
void inline
TrunkSys::note_freq_assignment(unsigned short freqnumber,
		     unsigned short grpPart,
		     unsigned short idPart,
		     unsigned short caller)
{
	register int i;	// iterator for known frequencies
	register frequencyAssignment *raid;	// for optimization, points to each object in turn
    unsigned short oldPrty = 65535;
    BOOL oldSel = FALSE;
    designation *fromDes = 0, *toDes=0;
    frequencyAssignment *newSlot = 0;
    
    if( grpPart && caller ) {		// if two-caller Icall, don't know what block... 
    	// note that is a type II...
    	types[(idPart>>13)&7] = '2';
    }
    if( !Verbose )
    	caller = 0;
	if( grpPart ) { 
		toDes = groupList->get(idPart);
		toDes->code |= GROUPBIT;
	} else {
		toDes = idList->get(idPart);
	}
	if(caller) {
		fromDes = idList->get(caller);
		if(grpPart)
			fixNew(fromDes,toDes);
	}
	for (i=0,raid = aid; i< naid; ++raid, ++i) // one pass over ALL objects
	{
	// CASE 1: the frequency object already exists: assign it
		   
		if ( raid->freqNum == freqnumber)
		{
			newSlot = raid;
			raid->assign(toDes,fromDes);
			continue;
		} 
		
		// CASE 2: this id/group had been assigned to a different
		//		   frequency, remove it from this one
		
		if(raid->fState == frequencyAssignment::FREQCALL ||
    					 raid->fState == frequencyAssignment::FREQHOLD)
		{
			// a call is on this one and may match this call
			if(grpPart) {
				// group call - match on group only
    			if(raid->destDes == toDes) {
    				if( raid->getPrio() < oldPrty )
    					oldPrty = raid->getPrio();
    				oldSel = raid->selected;
		    		raid->unassign();
		    		continue;
		    	}
		    // if this radio is now involved with a different group,
		    // remove it from this one.
				if(fromDes && raid->callingDes == fromDes) {
					raid->callingDes = 0;
					raid->dirty = TRUE;
				}
		    } else if( toDes && fromDes ) {
			// individual call - match on both
				if( (raid->destDes == toDes && raid->callingDes == fromDes)
				||  (raid->destDes == fromDes && raid->callingDes == toDes) ) {
	    				if( raid->getPrio() < oldPrty )
	    					oldPrty = raid->getPrio();
	    				oldSel = raid->selected;
			    		raid->unassign();
			    		continue;
				}
			} else {	// type-1 Individual Call
				if( toDes == raid->destDes || toDes == raid->callingDes ) {
	    				if( raid->getPrio() < oldPrty )
	    					oldPrty = raid->getPrio();
	    				oldSel = raid->selected;
			    		raid->unassign();
			    		continue;
				}
			}	
		}
	}
	if (newSlot) {
		if( oldPrty < newSlot->getPrio() )
			newSlot->setPrio(oldPrty);
		newSlot->selected = oldSel;  
	} else {
		expandFreqs(freqnumber);
	}
}
void inline
TrunkSys::noteCwId(unsigned short cwFreq, BOOL onoff) {
	
	register int i;	// iterator for known frequencies
	register frequencyAssignment *raid;	// for optimization, points to each object in turn
	BOOL foundIt = FALSE;
	for (i=0,raid = aid; i< naid; ++raid, ++i) // one pass over ALL objects
	{
		if ( raid->freqNum == cwFreq)
		{
				raid->assignCW(onoff);
				cw = raid;
				foundIt = TRUE;
				break;
		}
	}
	if( !foundIt ) {
		expandFreqs(cwFreq, 2); // can't filter much since command not repeated
	}
}
void inline
TrunkSys::noteDataChan(unsigned short dataFreq)
{
	
	register int i;	// iterator for known frequencies
	register frequencyAssignment *raid;	// for optimization, points to each object in turn
	BOOL foundIt = FALSE;
	for (i=0,raid = aid; i< naid; ++raid, ++i) // one pass over ALL objects
	{
		if ( raid->freqNum == dataFreq)
		{
			raid->assignD();
			foundIt = TRUE;
		} else if( raid->fState == frequencyAssignment::FREQDATA ) {
			raid->unassign();
		}
	}
	if(!foundIt) {
		expandFreqs(dataFreq,2);
	}
}
